/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.low.level.api.fir.compiler.based;

import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.test.AssertionsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.low.level.api.fir.compiler.based.LLFirDivergenceUtilsKt;
import org.jetbrains.kotlin.test.directives.model.RegisteredDirectives;
import org.jetbrains.kotlin.test.frontend.fir.handlers.AbstractFirIdenticalChecker;
import org.jetbrains.kotlin.test.model.TestFile;
import org.jetbrains.kotlin.test.services.SourceFileProvider;
import org.jetbrains.kotlin.test.services.SourceFileProviderKt;
import org.jetbrains.kotlin.test.services.TestServices;
import org.jetbrains.kotlin.test.utils.CustomTestDataUtilsKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J6\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\n2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\bH\u0014\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/analysis/low/level/api/fir/compiler/based/LLFirIdenticalChecker;", "Lorg/jetbrains/kotlin/test/frontend/fir/handlers/AbstractFirIdenticalChecker;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "(Lorg/jetbrains/kotlin/test/services/TestServices;)V", "assertPreprocessedTestDataAreEqual", "", "baseFile", "Ljava/io/File;", "baseContent", "", "llFile", "llContent", "message", "Lkotlin/Function0;", "checkTestDataFile", "testDataFile", "low-level-api-fir_test"})
@SourceDebugExtension(value={"SMAP\nLLFirIdenticalChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LLFirIdenticalChecker.kt\norg/jetbrains/kotlin/analysis/low/level/api/fir/compiler/based/LLFirIdenticalChecker\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,85:1\n1#2:86\n*E\n"})
public final class LLFirIdenticalChecker
extends AbstractFirIdenticalChecker {
    public LLFirIdenticalChecker(@NotNull TestServices testServices) {
        Intrinsics.checkNotNullParameter((Object)testServices, (String)"testServices");
        super(testServices);
    }

    protected void checkTestDataFile(@NotNull File testDataFile) {
        String llContent;
        String baseContent;
        File baseFile;
        File file;
        Intrinsics.checkNotNullParameter((Object)testDataFile, (String)"testDataFile");
        if (!CustomTestDataUtilsKt.isLLFirTestData((File)testDataFile)) {
            return;
        }
        File originalFile = this.getHelper().getClassicFileToCompare(testDataFile);
        File it = file = this.getHelper().getFirFileToCompare(originalFile);
        boolean bl = false;
        File file2 = it.exists() ? file : null;
        if (file2 == null) {
            file2 = baseFile = originalFile;
        }
        if (Intrinsics.areEqual((Object)(baseContent = ((Object)StringsKt.trimStart((CharSequence)this.getHelper().readContent(baseFile, true))).toString()), (Object)(llContent = LLFirDivergenceUtilsKt.removeLlFirDivergenceDirective(this.getHelper().readContent(testDataFile, false), true)))) {
            org.jetbrains.kotlin.test.services.AssertionsKt.getAssertions((TestServices)this.getTestServices()).fail((Function0)new Function0<String>(testDataFile, baseFile){
                final /* synthetic */ File $testDataFile;
                final /* synthetic */ File $baseFile;
                {
                    this.$testDataFile = $testDataFile;
                    this.$baseFile = $baseFile;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return '`' + this.$testDataFile.getName() + "` and `" + this.$baseFile.getName() + "` are identical. Remove `" + this.$testDataFile + "`.";
                }
            });
            throw null;
        }
        this.assertPreprocessedTestDataAreEqual(baseFile, baseContent, testDataFile, llContent, (Function0<String>)((Function0)new Function0<String>(baseFile, testDataFile){
            final /* synthetic */ File $baseFile;
            final /* synthetic */ File $testDataFile;
            {
                this.$baseFile = $baseFile;
                this.$testDataFile = $testDataFile;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return "When ignoring diagnostics, the contents of `" + this.$baseFile.getName() + "` (expected) and `" + this.$testDataFile.getName() + "` (actual) are not identical. `.ll.kt` test data may only differ from its base `.fir.kt` or `.kt` test data in the reported diagnostics and the `LL_FIR_DIVERGENCE` directive. Update one of these test data files.";
            }
        }));
    }

    private final void assertPreprocessedTestDataAreEqual(File baseFile, String baseContent, File llFile, String llContent, Function0<String> message2) {
        SourceFileProvider sourceFileProvider = SourceFileProviderKt.getSourceFileProvider((TestServices)this.getTestServices());
        String string = baseFile.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"baseFile.path");
        String processedBaseContent = sourceFileProvider.getContentOfSourceFile(new TestFile(string, baseContent, baseFile, 0, false, (RegisteredDirectives)RegisteredDirectives.Companion.getEmpty()));
        SourceFileProvider sourceFileProvider2 = SourceFileProviderKt.getSourceFileProvider((TestServices)this.getTestServices());
        String string2 = llFile.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"llFile.path");
        String processedLlContent = sourceFileProvider2.getContentOfSourceFile(new TestFile(string2, llContent, llFile, 0, false, (RegisteredDirectives)RegisteredDirectives.Companion.getEmpty()));
        AssertionsKt.assertEquals((Object)processedBaseContent, (Object)processedLlContent, (String)((String)message2.invoke()));
    }
}

