/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.test.framework.services.libraries;

import java.nio.file.Path;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.test.framework.services.libraries.CompiledLibrary;
import org.jetbrains.kotlin.analysis.test.framework.services.libraries.TestModuleCompiler;
import org.jetbrains.kotlin.test.model.TestModule;
import org.jetbrains.kotlin.test.services.TestService;
import org.jetbrains.kotlin.test.services.TestServices;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bR\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/analysis/test/framework/services/libraries/CompiledLibraryProvider;", "Lorg/jetbrains/kotlin/test/services/TestService;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "(Lorg/jetbrains/kotlin/test/services/TestServices;)V", "libraries", "", "", "Lorg/jetbrains/kotlin/analysis/test/framework/services/libraries/CompiledLibrary;", "compileToLibrary", "module", "Lorg/jetbrains/kotlin/test/model/TestModule;", "analysis-test-framework_test"})
@SourceDebugExtension(value={"SMAP\nCompiledLibraryProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CompiledLibraryProvider.kt\norg/jetbrains/kotlin/analysis/test/framework/services/libraries/CompiledLibraryProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,31:1\n1#2:32\n*E\n"})
public final class CompiledLibraryProvider
implements TestService {
    @NotNull
    private final TestServices testServices;
    @NotNull
    private final Map<String, CompiledLibrary> libraries;

    public CompiledLibraryProvider(@NotNull TestServices testServices) {
        Intrinsics.checkNotNullParameter((Object)testServices, (String)"testServices");
        this.testServices = testServices;
        this.libraries = new LinkedHashMap();
    }

    @NotNull
    public final CompiledLibrary compileToLibrary(@NotNull TestModule module) {
        CompiledLibrary compiledLibrary;
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        if (this.libraries.containsKey(module.getName())) {
            throw new IllegalStateException(("Library for module " + module.getName() + " is already compiled").toString());
        }
        Path libraryJar = TestModuleCompiler.INSTANCE.compileTestModuleToLibrary(module, this.testServices);
        Path librarySourcesJar = TestModuleCompiler.INSTANCE.compileTestModuleToLibrarySources(module, this.testServices);
        CompiledLibrary it = compiledLibrary = new CompiledLibrary(libraryJar, librarySourcesJar);
        boolean bl = false;
        this.libraries.put(module.getName(), it);
        return compiledLibrary;
    }
}

