/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.abi.tools.v2.klib;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.abi.tools.api.AbiFilters;
import org.jetbrains.kotlin.abi.tools.filtering.FiltersMatcher;
import org.jetbrains.kotlin.abi.tools.filtering.FiltersMatcherKt;
import org.jetbrains.kotlin.abi.tools.v2.klib.KlibReadingKt;
import org.jetbrains.kotlin.library.abi.AbiAnnotation;
import org.jetbrains.kotlin.library.abi.AbiClass;
import org.jetbrains.kotlin.library.abi.AbiDeclaration;
import org.jetbrains.kotlin.library.abi.AbiField;
import org.jetbrains.kotlin.library.abi.AbiFunction;
import org.jetbrains.kotlin.library.abi.AbiProperty;
import org.jetbrains.kotlin.library.abi.AbiReadingFilter;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f*\b\u0012\u0004\u0012\u00020\u00110\u000fH\u0002R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/abi/tools/v2/klib/Filter;", "Lorg/jetbrains/kotlin/library/abi/AbiReadingFilter;", "filters", "Lorg/jetbrains/kotlin/abi/tools/api/AbiFilters;", "<init>", "(Lorg/jetbrains/kotlin/abi/tools/api/AbiFilters;)V", "filtersMatcher", "Lorg/jetbrains/kotlin/abi/tools/filtering/FiltersMatcher;", "getFiltersMatcher", "()Lorg/jetbrains/kotlin/abi/tools/filtering/FiltersMatcher;", "isDeclarationExcluded", "", "declaration", "Lorg/jetbrains/kotlin/library/abi/AbiDeclaration;", "names", "", "", "Lorg/jetbrains/kotlin/library/abi/AbiAnnotation;", "abi-tools"})
@SourceDebugExtension(value={"SMAP\nKlibReading.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KlibReading.kt\norg/jetbrains/kotlin/abi/tools/v2/klib/Filter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,91:1\n1586#2:92\n1661#2,3:93\n*S KotlinDebug\n*F\n+ 1 KlibReading.kt\norg/jetbrains/kotlin/abi/tools/v2/klib/Filter\n*L\n79#1:92\n79#1:93,3\n*E\n"})
final class Filter
implements AbiReadingFilter {
    @NotNull
    private final FiltersMatcher filtersMatcher;

    public Filter(@NotNull AbiFilters filters) {
        Intrinsics.checkNotNullParameter((Object)filters, (String)"filters");
        this.filtersMatcher = FiltersMatcherKt.compileMatcher(filters);
    }

    @NotNull
    public final FiltersMatcher getFiltersMatcher() {
        return this.filtersMatcher;
    }

    public boolean isDeclarationExcluded(@NotNull AbiDeclaration declaration) {
        List annotationNames;
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        if (this.filtersMatcher.isEmpty()) {
            return false;
        }
        if (declaration instanceof AbiFunction || declaration instanceof AbiProperty) {
            if (this.filtersMatcher.isExcludedByName(KlibReadingKt.access$toKotlinQualifiedName(declaration.getQualifiedName()))) {
                return true;
            }
            if (this.filtersMatcher.getHasAnnotationFilters()) {
                AbiField backingField;
                annotationNames = this.names(declaration.annotatedWith());
                AbiDeclaration abiDeclaration = declaration;
                AbiProperty abiProperty = abiDeclaration instanceof AbiProperty ? (AbiProperty)abiDeclaration : null;
                Object object = backingField = abiProperty != null ? abiProperty.getBackingField() : null;
                if (backingField != null) {
                    annotationNames = CollectionsKt.plus((Collection)annotationNames, (Iterable)this.names(backingField.annotatedWith()));
                }
                if (this.filtersMatcher.isExcludedByAnnotations(annotationNames)) {
                    return true;
                }
            }
        }
        if (!(declaration instanceof AbiClass)) {
            return false;
        }
        if (this.filtersMatcher.getHasClassNameFilters() && this.filtersMatcher.isExcludedByName(KlibReadingKt.access$toKotlinQualifiedName(declaration.getQualifiedName()))) {
            return true;
        }
        return this.filtersMatcher.getHasAnnotationFilters() && this.filtersMatcher.isExcludedByAnnotations(annotationNames = this.names(declaration.annotatedWith()));
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> names(List<? extends AbiAnnotation> $this$names) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = $this$names;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void annotation;
            AbiAnnotation abiAnnotation = (AbiAnnotation)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(KlibReadingKt.access$toKotlinQualifiedName(annotation.getQualifiedName()));
        }
        return (List)destination$iv$iv;
    }
}

