/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.abi.tools.v2;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.metadata.jvm.JvmMemberSignature;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.abi.tools.v2.AccessFlags;
import org.jetbrains.kotlin.abi.tools.v2.ClassVisibility;
import org.jetbrains.kotlin.abi.tools.v2.KotlinMetadataVisibilitiesKt;
import org.jetbrains.kotlin.abi.tools.v2.MemberVisibility;
import org.jetbrains.org.objectweb.asm.tree.AnnotationNode;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b`\u0018\u00002\u00020\u0001J\u001a\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\r2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0016J\u0014\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0016R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\tR\u0012\u0010\f\u001a\u00020\rX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0012\u0010\u0010\u001a\u00020\u0011X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0012R\u0018\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0012\u0010\u001e\u001a\u00020\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\t\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006 \u00c0\u0006\u0001"}, d2={"Lorg/jetbrains/kotlin/abi/tools/v2/MemberBinarySignature;", "", "jvmMember", "Lkotlin/metadata/jvm/JvmMemberSignature;", "getJvmMember", "()Lkotlin/metadata/jvm/JvmMemberSignature;", "name", "", "getName", "()Ljava/lang/String;", "desc", "getDesc", "access", "Lorg/jetbrains/kotlin/abi/tools/v2/AccessFlags;", "getAccess", "()Lorg/jetbrains/kotlin/abi/tools/v2/AccessFlags;", "isPublishedApi", "", "()Z", "annotations", "", "Lorg/jetbrains/org/objectweb/asm/tree/AnnotationNode;", "getAnnotations", "()Ljava/util/List;", "isEffectivelyPublic", "classAccess", "classVisibility", "Lorg/jetbrains/kotlin/abi/tools/v2/ClassVisibility;", "findMemberVisibility", "Lorg/jetbrains/kotlin/abi/tools/v2/MemberVisibility;", "signature", "getSignature", "abi-tools"})
public interface MemberBinarySignature {
    @NotNull
    public JvmMemberSignature getJvmMember();

    @NotNull
    default public String getName() {
        return this.getJvmMember().getName();
    }

    @NotNull
    default public String getDesc() {
        return this.getJvmMember().getDescriptor();
    }

    @NotNull
    public AccessFlags getAccess();

    public boolean isPublishedApi();

    @NotNull
    public List<AnnotationNode> getAnnotations();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    default public boolean isEffectivelyPublic(@NotNull AccessFlags classAccess, @Nullable ClassVisibility classVisibility) {
        Intrinsics.checkNotNullParameter((Object)classAccess, (String)"classAccess");
        if (!this.getAccess().isPublic()) return false;
        if (this.getAccess().isProtected()) {
            if (classAccess.isFinal()) return false;
        }
        MemberVisibility memberVisibility = this.findMemberVisibility(classVisibility);
        if (memberVisibility == null) return true;
        boolean bl = KotlinMetadataVisibilitiesKt.isPublic(memberVisibility, this.isPublishedApi());
        if (!bl) return false;
        return true;
    }

    @Nullable
    default public MemberVisibility findMemberVisibility(@Nullable ClassVisibility classVisibility) {
        ClassVisibility classVisibility2 = classVisibility;
        return classVisibility2 != null ? KotlinMetadataVisibilitiesKt.findMember(classVisibility2, this.getJvmMember()) : null;
    }

    @NotNull
    public String getSignature();
}

