/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.abi.tools.v2;

import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.metadata.jvm.KotlinClassMetadata;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.abi.tools.v2.ClassVisibility;
import org.jetbrains.kotlin.abi.tools.v2.KotlinMetadataVisibilitiesKt;
import org.jetbrains.org.objectweb.asm.tree.AnnotationNode;
import org.jetbrains.org.objectweb.asm.tree.ClassNode;
import org.jetbrains.org.objectweb.asm.tree.InnerClassNode;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000J\n\u0000\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\b\u0007\u001a\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0000\u001a\u0010\u0010\t\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0000\u001a\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0000\u001a\u0010\u0010\u000b\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0000\u001a\u0010\u0010\f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0000\u001a\u0010\u0010\r\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0000\u001a\u0010\u0010\u000e\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0000\u001a\u0016\u0010\u000f\u001a\u00020\u0007*\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0000\u001a\f\u0010\u0017\u001a\u00020\u0007*\u00020\u0010H\u0002\u001a\f\u0010\u0018\u001a\u00020\u0007*\u00020\u0010H\u0002\u001a\f\u0010\u0019\u001a\u00020\u0007*\u00020\u0010H\u0002\u001a\f\u0010\u001a\u001a\u00020\u0007*\u00020\u0010H\u0002\u001a\f\u0010\u001b\u001a\u00020\u0007*\u00020\u0010H\u0002\u001a\f\u0010#\u001a\u00020\u0007*\u00020\u0010H\u0002\u001a\u0012\u0010#\u001a\u00020\u0007*\b\u0012\u0004\u0012\u00020%0$H\u0000\u001a\u0016\u0010'\u001a\u00020\u0007*\u00020\u00102\b\u0010(\u001a\u0004\u0018\u00010)H\u0000\u001a \u0010*\u001a\u0004\u0018\u00010%*\u00020\u00102\u0006\u0010+\u001a\u00020\u00032\b\b\u0002\u0010,\u001a\u00020\u0007H\u0000\u001a\u0017\u0010-\u001a\u0004\u0018\u00010.*\u00020%2\u0006\u0010/\u001a\u00020\u0003H\u0080\u0002\u001a\u001c\u00100\u001a\u0004\u0018\u00010.*\b\u0012\u0004\u0012\u00020.0$2\u0006\u0010/\u001a\u00020\u0003H\u0002\u001a:\u0010*\u001a\u0004\u0018\u00010%2\u0006\u0010+\u001a\u00020\u00032\u000e\u00101\u001a\n\u0012\u0004\u0012\u00020%\u0018\u00010$2\u000e\u00102\u001a\n\u0012\u0004\u0012\u00020%\u0018\u00010$2\u0006\u0010,\u001a\u00020\u0007H\u0002\u001a\u0014\u00103\u001a\u00020\u0007*\u00020%2\u0006\u00104\u001a\u00020\u0003H\u0000\" \u0010\u0000\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0005\"\u001a\u0010\u0013\u001a\u0004\u0018\u00010\u0014*\u00020\u00108BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\"\u0018\u0010\u001c\u001a\u00020\u0002*\u00020\u00108@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001e\"\u001a\u0010\u001f\u001a\u0004\u0018\u00010\u0003*\u00020\u00108@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010!\"\u000e\u0010\"\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010&\u001a\u00020\u0003X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"ACCESS_NAMES", "", "", "", "getACCESS_NAMES", "()Ljava/util/Map;", "isPublic", "", "access", "isProtected", "isStatic", "isFinal", "isSynthetic", "isAbstract", "isInterface", "isEffectivelyPublic", "Lorg/jetbrains/org/objectweb/asm/tree/ClassNode;", "classVisibility", "Lorg/jetbrains/kotlin/abi/tools/v2/ClassVisibility;", "innerClassNode", "Lorg/jetbrains/org/objectweb/asm/tree/InnerClassNode;", "getInnerClassNode", "(Lorg/jetbrains/org/objectweb/asm/tree/ClassNode;)Lorg/jetbrains/org/objectweb/asm/tree/InnerClassNode;", "isLocal", "isInner", "isWhenMappings", "isSyntheticAnnotationClass", "isEnumEntriesMappings", "effectiveAccess", "getEffectiveAccess", "(Lorg/jetbrains/org/objectweb/asm/tree/ClassNode;)I", "outerClassName", "getOuterClassName", "(Lorg/jetbrains/org/objectweb/asm/tree/ClassNode;)Ljava/lang/String;", "publishedApiAnnotationName", "isPublishedApi", "", "Lorg/jetbrains/org/objectweb/asm/tree/AnnotationNode;", "DefaultImplsNameSuffix", "isDefaultImpls", "metadata", "Lkotlin/metadata/jvm/KotlinClassMetadata;", "findAnnotation", "annotationName", "includeInvisible", "get", "", "key", "annotationValue", "visibleAnnotations", "invisibleAnnotations", "refersToName", "name", "abi-tools"})
@SourceDebugExtension(value={"SMAP\nAsmMetadataLoading.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AsmMetadataLoading.kt\norg/jetbrains/kotlin/abi/tools/v2/AsmMetadataLoadingKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,83:1\n669#2,11:84\n295#2,2:95\n295#2,2:97\n295#2,2:99\n*S KotlinDebug\n*F\n+ 1 AsmMetadataLoading.kt\norg/jetbrains/kotlin/abi/tools/v2/AsmMetadataLoadingKt\n*L\n41#1:84,11\n54#1:95,2\n78#1:97,2\n79#1:99,2\n*E\n"})
public final class AsmMetadataLoadingKt {
    @NotNull
    private static final Map<Integer, String> ACCESS_NAMES;
    @NotNull
    private static final String publishedApiAnnotationName = "kotlin/PublishedApi";
    @NotNull
    public static final String DefaultImplsNameSuffix = "$DefaultImpls";

    @NotNull
    public static final Map<Integer, String> getACCESS_NAMES() {
        return ACCESS_NAMES;
    }

    public static final boolean isPublic(int access) {
        return (access & 1) != 0 || (access & 4) != 0;
    }

    public static final boolean isProtected(int access) {
        return (access & 4) != 0;
    }

    public static final boolean isStatic(int access) {
        return (access & 8) != 0;
    }

    public static final boolean isFinal(int access) {
        return (access & 0x10) != 0;
    }

    public static final boolean isSynthetic(int access) {
        return (access & 0x1000) != 0;
    }

    public static final boolean isAbstract(int access) {
        return (access & 0x400) != 0;
    }

    public static final boolean isInterface(int access) {
        return (access & 0x200) != 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isEffectivelyPublic(@NotNull ClassNode $this$isEffectivelyPublic, @Nullable ClassVisibility classVisibility) {
        Intrinsics.checkNotNullParameter((Object)$this$isEffectivelyPublic, (String)"<this>");
        if (!AsmMetadataLoadingKt.isPublic($this$isEffectivelyPublic.access)) return false;
        if (AsmMetadataLoadingKt.isLocal($this$isEffectivelyPublic)) return false;
        if (AsmMetadataLoadingKt.isWhenMappings($this$isEffectivelyPublic)) return false;
        if (AsmMetadataLoadingKt.isSyntheticAnnotationClass($this$isEffectivelyPublic)) return false;
        if (AsmMetadataLoadingKt.isEnumEntriesMappings($this$isEffectivelyPublic)) return false;
        ClassVisibility classVisibility2 = classVisibility;
        if (classVisibility2 == null) return true;
        boolean bl = KotlinMetadataVisibilitiesKt.isPublic(classVisibility2, AsmMetadataLoadingKt.isPublishedApi($this$isEffectivelyPublic));
        if (!bl) return false;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private static final InnerClassNode getInnerClassNode(ClassNode $this$innerClassNode) {
        Object object;
        block2: {
            void var3_3;
            List list = $this$innerClassNode.innerClasses;
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"innerClasses");
            Iterable $this$singleOrNull$iv = list;
            boolean $i$f$singleOrNull = false;
            Object single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $this$singleOrNull$iv) {
                InnerClassNode it = (InnerClassNode)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.name, (Object)$this$innerClassNode.name)) continue;
                if (found$iv) {
                    object = null;
                    break block2;
                }
                single$iv = element$iv;
                found$iv = true;
            }
            object = !found$iv ? null : var3_3;
        }
        return (InnerClassNode)object;
    }

    private static final boolean isLocal(ClassNode $this$isLocal) {
        return $this$isLocal.outerMethod != null;
    }

    private static final boolean isInner(ClassNode $this$isInner) {
        return AsmMetadataLoadingKt.getInnerClassNode($this$isInner) != null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isWhenMappings(ClassNode $this$isWhenMappings) {
        if (!AsmMetadataLoadingKt.isSynthetic($this$isWhenMappings.access)) return false;
        String string = $this$isWhenMappings.name;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name");
        if (!StringsKt.endsWith$default((String)string, (String)"$WhenMappings", (boolean)false, (int)2, null)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isSyntheticAnnotationClass(ClassNode $this$isSyntheticAnnotationClass) {
        if (!AsmMetadataLoadingKt.isSynthetic($this$isSyntheticAnnotationClass.access)) return false;
        String string = $this$isSyntheticAnnotationClass.name;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name");
        if (!StringsKt.contains$default((CharSequence)string, (CharSequence)"$annotationImpl$", (boolean)false, (int)2, null)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isEnumEntriesMappings(ClassNode $this$isEnumEntriesMappings) {
        if (!AsmMetadataLoadingKt.isSynthetic($this$isEnumEntriesMappings.access)) return false;
        String string = $this$isEnumEntriesMappings.name;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name");
        if (!StringsKt.endsWith$default((String)string, (String)"$EntriesMappings", (boolean)false, (int)2, null)) return false;
        return true;
    }

    public static final int getEffectiveAccess(@NotNull ClassNode $this$effectiveAccess) {
        Intrinsics.checkNotNullParameter((Object)$this$effectiveAccess, (String)"<this>");
        InnerClassNode innerClassNode = AsmMetadataLoadingKt.getInnerClassNode($this$effectiveAccess);
        return innerClassNode != null ? innerClassNode.access : $this$effectiveAccess.access;
    }

    @Nullable
    public static final String getOuterClassName(@NotNull ClassNode $this$outerClassName) {
        Intrinsics.checkNotNullParameter((Object)$this$outerClassName, (String)"<this>");
        InnerClassNode innerClassNode = AsmMetadataLoadingKt.getInnerClassNode($this$outerClassName);
        return innerClassNode != null ? innerClassNode.outerName : null;
    }

    private static final boolean isPublishedApi(ClassNode $this$isPublishedApi) {
        return AsmMetadataLoadingKt.findAnnotation($this$isPublishedApi, publishedApiAnnotationName, true) != null;
    }

    public static final boolean isPublishedApi(@NotNull List<? extends AnnotationNode> $this$isPublishedApi) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter($this$isPublishedApi, (String)"<this>");
            Iterable $this$firstOrNull$iv = $this$isPublishedApi;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                AnnotationNode it = (AnnotationNode)element$iv;
                boolean bl = false;
                if (!AsmMetadataLoadingKt.refersToName(it, publishedApiAnnotationName)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0 != null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isDefaultImpls(@NotNull ClassNode $this$isDefaultImpls, @Nullable KotlinClassMetadata metadata) {
        Intrinsics.checkNotNullParameter((Object)$this$isDefaultImpls, (String)"<this>");
        if (!AsmMetadataLoadingKt.isInner($this$isDefaultImpls)) return false;
        String string = $this$isDefaultImpls.name;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name");
        if (!StringsKt.endsWith$default((String)string, (String)DefaultImplsNameSuffix, (boolean)false, (int)2, null)) return false;
        if (!KotlinMetadataVisibilitiesKt.isSyntheticClass(metadata)) return false;
        return true;
    }

    @Nullable
    public static final AnnotationNode findAnnotation(@NotNull ClassNode $this$findAnnotation, @NotNull String annotationName, boolean includeInvisible) {
        Intrinsics.checkNotNullParameter((Object)$this$findAnnotation, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)annotationName, (String)"annotationName");
        return AsmMetadataLoadingKt.findAnnotation(annotationName, $this$findAnnotation.visibleAnnotations, $this$findAnnotation.invisibleAnnotations, includeInvisible);
    }

    public static /* synthetic */ AnnotationNode findAnnotation$default(ClassNode classNode, String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return AsmMetadataLoadingKt.findAnnotation(classNode, string, bl);
    }

    @Nullable
    public static final Object get(@NotNull AnnotationNode $this$get, @NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)$this$get, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        List list = $this$get.values;
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"values");
        return AsmMetadataLoadingKt.annotationValue(list, key);
    }

    private static final Object annotationValue(List<? extends Object> $this$annotationValue, String key) {
        int n = $this$annotationValue.size() / 2;
        for (int index = 0; index < n; ++index) {
            if (!Intrinsics.areEqual((Object)$this$annotationValue.get(index * 2), (Object)key)) continue;
            return $this$annotationValue.get(index * 2 + 1);
        }
        return null;
    }

    private static final AnnotationNode findAnnotation(String annotationName, List<? extends AnnotationNode> visibleAnnotations, List<? extends AnnotationNode> invisibleAnnotations, boolean includeInvisible) {
        AnnotationNode annotationNode;
        block11: {
            AnnotationNode it;
            boolean $i$f$firstOrNull;
            Iterable $this$firstOrNull$iv;
            block10: {
                Object v1;
                block8: {
                    annotationNode = visibleAnnotations;
                    if (annotationNode == null) break block10;
                    $this$firstOrNull$iv = (Iterable)annotationNode;
                    $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        it = (AnnotationNode)element$iv;
                        boolean bl = false;
                        if (!AsmMetadataLoadingKt.refersToName(it, annotationName)) continue;
                        v1 = element$iv;
                        break block8;
                    }
                    v1 = null;
                }
                if ((annotationNode = (AnnotationNode)v1) != null) break block11;
            }
            if (includeInvisible) {
                List<? extends AnnotationNode> list = invisibleAnnotations;
                if (list != null) {
                    Object v3;
                    block9: {
                        $this$firstOrNull$iv = list;
                        $i$f$firstOrNull = false;
                        for (Object element$iv : $this$firstOrNull$iv) {
                            it = (AnnotationNode)element$iv;
                            boolean bl = false;
                            if (!AsmMetadataLoadingKt.refersToName(it, annotationName)) continue;
                            v3 = element$iv;
                            break block9;
                        }
                        v3 = null;
                    }
                    annotationNode = v3;
                } else {
                    annotationNode = null;
                }
            } else {
                annotationNode = null;
            }
        }
        return annotationNode;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean refersToName(@NotNull AnnotationNode $this$refersToName, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)$this$refersToName, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        String string = $this$refersToName.desc;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"desc");
        if (!StringsKt.startsWith$default((CharSequence)string, (char)'L', (boolean)false, (int)2, null)) return false;
        String string2 = $this$refersToName.desc;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"desc");
        if (!StringsKt.endsWith$default((CharSequence)string2, (char)';', (boolean)false, (int)2, null)) return false;
        String string3 = $this$refersToName.desc;
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"desc");
        if (!StringsKt.regionMatches$default((String)string3, (int)1, (String)name, (int)0, (int)name.length(), (boolean)false, (int)16, null)) return false;
        return true;
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)1, (Object)"public"), TuplesKt.to((Object)4, (Object)"protected"), TuplesKt.to((Object)2, (Object)"private"), TuplesKt.to((Object)8, (Object)"static"), TuplesKt.to((Object)16, (Object)"final"), TuplesKt.to((Object)1024, (Object)"abstract"), TuplesKt.to((Object)4096, (Object)"synthetic"), TuplesKt.to((Object)512, (Object)"interface"), TuplesKt.to((Object)8192, (Object)"annotation")};
        ACCESS_NAMES = MapsKt.mapOf((Pair[])pairArray);
    }
}

