/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.abi.tools.v2;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.abi.tools.api.AbiFilters;
import org.jetbrains.kotlin.abi.tools.api.v2.AbiToolsV2;
import org.jetbrains.kotlin.abi.tools.api.v2.KlibDump;
import org.jetbrains.kotlin.abi.tools.api.v2.KlibTarget;
import org.jetbrains.kotlin.abi.tools.filtering.FiltersMatcher;
import org.jetbrains.kotlin.abi.tools.filtering.FiltersMatcherKt;
import org.jetbrains.kotlin.abi.tools.v2.ClassBinarySignature;
import org.jetbrains.kotlin.abi.tools.v2.KotlinSignaturesLoadingKt;
import org.jetbrains.kotlin.abi.tools.v2.klib.KlibDumpImpl;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\r\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J9\u0010\u0004\u001a\u00020\u0005\"\f\b\u0000\u0010\u0006*\u00060\u0007j\u0002`\b2\u0006\u0010\t\u001a\u0002H\u00062\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a2\u0006\u0002\u0010\u000fJ\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\fH\u0016J\u0010\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J \u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/abi/tools/v2/ToolsV2;", "Lorg/jetbrains/kotlin/abi/tools/api/v2/AbiToolsV2;", "<init>", "()V", "printJvmDump", "", "T", "Ljava/lang/Appendable;", "Lkotlin/text/Appendable;", "appendable", "classfiles", "", "Ljava/io/File;", "filters", "Lorg/jetbrains/kotlin/abi/tools/api/AbiFilters;", "(Ljava/lang/Appendable;Ljava/lang/Iterable;Lorg/jetbrains/kotlin/abi/tools/api/AbiFilters;)V", "createKlibDump", "Lorg/jetbrains/kotlin/abi/tools/api/v2/KlibDump;", "loadKlibDump", "dumpFile", "dump", "", "extractKlibAbi", "klib", "target", "Lorg/jetbrains/kotlin/abi/tools/api/v2/KlibTarget;", "abi-tools"})
public final class ToolsV2
implements AbiToolsV2 {
    @NotNull
    public static final ToolsV2 INSTANCE = new ToolsV2();

    private ToolsV2() {
    }

    public <T extends Appendable> void printJvmDump(@NotNull T appendable, @NotNull Iterable<? extends File> classfiles, @NotNull AbiFilters filters) {
        Intrinsics.checkNotNullParameter(appendable, (String)"appendable");
        Intrinsics.checkNotNullParameter(classfiles, (String)"classfiles");
        Intrinsics.checkNotNullParameter((Object)filters, (String)"filters");
        FiltersMatcher filtersMatcher = FiltersMatcherKt.compileMatcher(filters);
        List<ClassBinarySignature> signatures = KotlinSignaturesLoadingKt.filterByMatcher(KotlinSignaturesLoadingKt.loadApiFromJvmClasses((Sequence<? extends InputStream>)SequencesKt.map((Sequence)CollectionsKt.asSequence(classfiles), ToolsV2::printJvmDump$lambda$0)), filtersMatcher);
        KotlinSignaturesLoadingKt.dump(signatures, appendable);
    }

    @NotNull
    public KlibDump createKlibDump() {
        return new KlibDumpImpl();
    }

    @NotNull
    public KlibDump loadKlibDump(@NotNull File dumpFile) {
        Intrinsics.checkNotNullParameter((Object)dumpFile, (String)"dumpFile");
        return KlibDumpImpl.Companion.from$abi_tools(dumpFile);
    }

    @NotNull
    public KlibDump loadKlibDump(@NotNull CharSequence dump) {
        Intrinsics.checkNotNullParameter((Object)dump, (String)"dump");
        return KlibDumpImpl.Companion.from$abi_tools(dump);
    }

    @NotNull
    public KlibDump extractKlibAbi(@NotNull File klib, @NotNull KlibTarget target, @NotNull AbiFilters filters) {
        Intrinsics.checkNotNullParameter((Object)klib, (String)"klib");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)filters, (String)"filters");
        KlibDump dump = KlibDumpImpl.Companion.fromKlib$abi_tools(klib, filters);
        dump.renameSingleTarget(target);
        return dump;
    }

    private static final FileInputStream printJvmDump$lambda$0(File classfile) {
        Intrinsics.checkNotNullParameter((Object)classfile, (String)"classfile");
        return new FileInputStream(classfile);
    }
}

