/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.abi.tools;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.abi.tools.KlibTargetKt;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\t\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\u0003J\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0096\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0003H\u0016R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/abi/tools/KlibTarget;", "Ljava/io/Serializable;", "targetName", "", "configurableName", "(Ljava/lang/String;Ljava/lang/String;)V", "getConfigurableName", "()Ljava/lang/String;", "getTargetName", "configureName", "newConfigurableName", "equals", "", "other", "", "hashCode", "", "toString", "Companion", "abi-tools-api"})
public final class KlibTarget
implements Serializable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String targetName;
    @NotNull
    private final String configurableName;

    public KlibTarget(@NotNull String targetName, @NotNull String configurableName) {
        Intrinsics.checkNotNullParameter((Object)targetName, (String)"targetName");
        Intrinsics.checkNotNullParameter((Object)configurableName, (String)"configurableName");
        this.targetName = targetName;
        this.configurableName = configurableName;
        if (!(!StringsKt.contains$default((CharSequence)this.configurableName, (CharSequence)".", (boolean)false, (int)2, null))) {
            boolean $i$a$-require-KlibTarget$32 = false;
            String $i$a$-require-KlibTarget$32 = "Configurable name can't contain the '.' character: " + this.configurableName;
            throw new IllegalArgumentException($i$a$-require-KlibTarget$32.toString());
        }
        if (!(!StringsKt.contains$default((CharSequence)this.targetName, (CharSequence)".", (boolean)false, (int)2, null))) {
            boolean bl = false;
            String string = "Target name can't contain the '.' character: " + this.targetName;
            throw new IllegalArgumentException(string.toString());
        }
    }

    @NotNull
    public final String getTargetName() {
        return this.targetName;
    }

    @NotNull
    public final String getConfigurableName() {
        return this.configurableName;
    }

    @NotNull
    public final KlibTarget configureName(@NotNull String newConfigurableName) {
        Intrinsics.checkNotNullParameter((Object)newConfigurableName, (String)"newConfigurableName");
        return new KlibTarget(this.targetName, newConfigurableName);
    }

    @NotNull
    public String toString() {
        return Intrinsics.areEqual((Object)this.configurableName, (Object)this.targetName) ? this.configurableName : this.targetName + '.' + this.configurableName;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof KlibTarget)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.configurableName, (Object)((KlibTarget)other).configurableName)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.targetName, (Object)((KlibTarget)other).targetName);
    }

    public int hashCode() {
        int result = this.configurableName.hashCode();
        result = 31 * result + this.targetName.hashCode();
        return result;
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\"\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0006J\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\n\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/abi/tools/KlibTarget$Companion;", "", "()V", "fromKonanTargetName", "Lorg/jetbrains/kotlin/abi/tools/KlibTarget;", "konanName", "", "parse", "value", "supportedKonanNames", "", "abi-tools-api"})
    @SourceDebugExtension(value={"SMAP\nKlibTarget.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KlibTarget.kt\norg/jetbrains/kotlin/abi/tools/KlibTarget$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,137:1\n1#2:138\n1761#3,3:139\n*S KotlinDebug\n*F\n+ 1 KlibTarget.kt\norg/jetbrains/kotlin/abi/tools/KlibTarget$Companion\n*L\n55#1:139,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final KlibTarget parse(@NotNull String value) {
            List parts;
            block11: {
                block10: {
                    boolean bl;
                    block9: {
                        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                        if (!(!StringsKt.isBlank((CharSequence)value))) {
                            boolean $i$a$-require-KlibTarget$Companion$parse$22 = false;
                            String $i$a$-require-KlibTarget$Companion$parse$22 = "Target name could not be blank.";
                            throw new IllegalArgumentException($i$a$-require-KlibTarget$Companion$parse$22.toString());
                        }
                        if (!StringsKt.contains$default((CharSequence)value, (char)'.', (boolean)false, (int)2, null)) {
                            return KlibTargetKt.KlibTarget(value);
                        }
                        char[] $i$a$-require-KlibTarget$Companion$parse$22 = new char[]{'.'};
                        parts = StringsKt.split$default((CharSequence)value, (char[])$i$a$-require-KlibTarget$Companion$parse$22, (boolean)false, (int)0, (int)6, null);
                        if (parts.size() != 2) break block10;
                        Iterable $this$any$iv = parts;
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl = false;
                        } else {
                            for (Object element$iv : $this$any$iv) {
                                String it = (String)element$iv;
                                boolean bl2 = false;
                                if (!StringsKt.isBlank((CharSequence)it)) continue;
                                bl = true;
                                break block9;
                            }
                            bl = false;
                        }
                    }
                    if (!bl) break block11;
                }
                throw new IllegalArgumentException("Target has illegal name format: \"" + value + "\", expected: <target name>.<underlying target name>");
            }
            return new KlibTarget((String)parts.get(0), (String)parts.get(1));
        }

        @NotNull
        public final KlibTarget fromKonanTargetName(@NotNull String konanName) {
            Intrinsics.checkNotNullParameter((Object)konanName, (String)"konanName");
            String string = KlibTargetKt.getKonanTargetNameMapping().get(konanName);
            if (string == null) {
                throw new IllegalArgumentException("Konan name '" + konanName + "' not found");
            }
            String targetName = string;
            return new KlibTarget(targetName, targetName);
        }

        @NotNull
        public final Set<String> supportedKonanNames() {
            return KlibTargetKt.getKonanTargetNameMapping().keySet();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

