/*
 * Decompiled with CFR 0.152.
 */
package org.apfloat.internal;

import org.apfloat.ApfloatRuntimeException;
import org.apfloat.internal.IntModMath;
import org.apfloat.internal.IntScramble;
import org.apfloat.spi.ArrayAccess;

public class IntTableFNT
extends IntModMath {
    public void tableFNT(ArrayAccess arrayAccess, int[] wTable, int[] permutationTable) throws ApfloatRuntimeException {
        int[] data2 = arrayAccess.getIntData();
        int offset = arrayAccess.getOffset();
        int nn = arrayAccess.getLength();
        assert (nn == (nn & -nn));
        if (nn < 2) {
            return;
        }
        int r = 1;
        for (int mmax = nn >> 1; mmax > 0; mmax >>= 1) {
            int istep = mmax << 1;
            for (int i = offset; i < offset + nn; i += istep) {
                int j = i + mmax;
                int a = data2[i];
                int b = data2[j];
                data2[i] = this.modAdd(a, b);
                data2[j] = this.modSubtract(a, b);
            }
            int t2 = r;
            for (int m4 = 1; m4 < mmax; ++m4) {
                for (int i = offset + m4; i < offset + nn; i += istep) {
                    int j = i + mmax;
                    int a = data2[i];
                    int b = data2[j];
                    data2[i] = this.modAdd(a, b);
                    data2[j] = this.modMultiply(wTable[t2], this.modSubtract(a, b));
                }
                t2 += r;
            }
            r <<= 1;
        }
        if (permutationTable != null) {
            IntScramble.scramble(data2, offset, permutationTable);
        }
    }

    public void inverseTableFNT(ArrayAccess arrayAccess, int[] wTable, int[] permutationTable) throws ApfloatRuntimeException {
        int[] data2 = arrayAccess.getIntData();
        int offset = arrayAccess.getOffset();
        int nn = arrayAccess.getLength();
        assert (nn == (nn & -nn));
        if (nn < 2) {
            return;
        }
        if (permutationTable != null) {
            IntScramble.scramble(data2, offset, permutationTable);
        }
        int r = nn;
        int mmax = 1;
        while (nn > mmax) {
            int istep = mmax << 1;
            r >>= 1;
            for (int i = offset; i < offset + nn; i += istep) {
                int j = i + mmax;
                int wTemp = data2[j];
                data2[j] = this.modSubtract(data2[i], wTemp);
                data2[i] = this.modAdd(data2[i], wTemp);
            }
            int t2 = r;
            for (int m4 = 1; m4 < mmax; ++m4) {
                for (int i = offset + m4; i < offset + nn; i += istep) {
                    int j = i + mmax;
                    int wTemp = this.modMultiply(wTable[t2], data2[j]);
                    data2[j] = this.modSubtract(data2[i], wTemp);
                    data2[i] = this.modAdd(data2[i], wTemp);
                }
                t2 += r;
            }
            mmax = istep;
        }
    }
}

