/*
 * Decompiled with CFR 0.152.
 */
package org.apfloat.internal;

import org.apfloat.internal.FloatBaseMath;
import org.apfloat.internal.FloatRadixConstants;

public class FloatCRTMath
extends FloatBaseMath {
    private static final long serialVersionUID = 2778445457339436642L;
    private static final double INVERSE_MAX_POWER_OF_TWO_BASE = 5.960464477539063E-8;
    private double base;

    public FloatCRTMath(int radix) {
        super(radix);
        this.base = FloatRadixConstants.BASE[radix];
    }

    public final void multiply(float[] src, float factor, float[] dst) {
        double tmp = (double)src[1] * (double)factor;
        float carry = (int)(tmp * 5.960464477539063E-8);
        dst[2] = (float)(tmp - (double)(carry * 1.6777216E7f));
        tmp = (double)src[0] * (double)factor + (double)carry;
        carry = (int)(tmp * 5.960464477539063E-8);
        dst[1] = (float)(tmp - (double)(carry * 1.6777216E7f));
        dst[0] = carry;
    }

    public final float compare(float[] src1, float[] src2) {
        float result2 = src1[0] - src2[0];
        if (result2 != 0.0f) {
            return result2;
        }
        result2 = src1[1] - src2[1];
        if (result2 != 0.0f) {
            return result2;
        }
        return src1[2] - src2[2];
    }

    public final float add(float[] src, float[] srcDst) {
        double result2 = (double)srcDst[2] + (double)src[2];
        float carry = result2 >= 1.6777216E7 ? 1 : 0;
        result2 = result2 >= 1.6777216E7 ? result2 - 1.6777216E7 : result2;
        srcDst[2] = (float)result2;
        result2 = (double)srcDst[1] + (double)src[1] + (double)carry;
        carry = result2 >= 1.6777216E7 ? 1 : 0;
        result2 = result2 >= 1.6777216E7 ? result2 - 1.6777216E7 : result2;
        srcDst[1] = (float)result2;
        result2 = (double)srcDst[0] + (double)src[0] + (double)carry;
        carry = result2 >= 1.6777216E7 ? 1 : 0;
        result2 = result2 >= 1.6777216E7 ? result2 - 1.6777216E7 : result2;
        srcDst[0] = (float)result2;
        return carry;
    }

    public final void subtract(float[] src, float[] srcDst) {
        float result2 = srcDst[2] - src[2];
        float carry = result2 < 0.0f ? 1 : 0;
        srcDst[2] = result2 = result2 < 0.0f ? result2 + 1.6777216E7f : result2;
        result2 = srcDst[1] - src[1] - carry;
        carry = result2 < 0.0f ? 1 : 0;
        srcDst[1] = result2 = result2 < 0.0f ? result2 + 1.6777216E7f : result2;
        result2 = srcDst[0] - src[0] - carry;
        srcDst[0] = result2 = result2 < 0.0f ? result2 + 1.6777216E7f : result2;
    }

    public final float divide(float[] srcDst) {
        double tmp = (double)srcDst[0] * 1.6777216E7 + (double)srcDst[1];
        float result2 = (int)(tmp / this.base);
        float carry = (float)(tmp - (double)result2 * this.base);
        srcDst[0] = 0.0f;
        srcDst[1] = result2;
        tmp = (double)carry * 1.6777216E7 + (double)srcDst[2];
        result2 = (int)(tmp / this.base);
        carry = (float)(tmp - (double)result2 * this.base);
        srcDst[2] = result2;
        return carry;
    }
}

