/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.pluginverifier.verifiers.clazz;

import com.jetbrains.pluginverifier.results.problems.SuperClassBecameInterfaceProblem;
import com.jetbrains.pluginverifier.verifiers.VerificationContext;
import com.jetbrains.pluginverifier.verifiers.clazz.ClassVerifier;
import com.jetbrains.pluginverifier.verifiers.resolution.ClassFile;
import com.jetbrains.pluginverifier.verifiers.resolution.ResolutionUtilKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lcom/jetbrains/pluginverifier/verifiers/clazz/SuperClassVerifier;", "Lcom/jetbrains/pluginverifier/verifiers/clazz/ClassVerifier;", "()V", "verify", "", "classFile", "Lcom/jetbrains/pluginverifier/verifiers/resolution/ClassFile;", "context", "Lcom/jetbrains/pluginverifier/verifiers/VerificationContext;", "verifier-core"})
public final class SuperClassVerifier
implements ClassVerifier {
    @Override
    public void verify(@NotNull ClassFile classFile, @NotNull VerificationContext context) {
        Intrinsics.checkNotNullParameter(classFile, "classFile");
        Intrinsics.checkNotNullParameter(context, "context");
        String string = classFile.getSuperName();
        if (string == null) {
            string = "java/lang/Object";
        }
        String superClassName = string;
        ClassFile classFile2 = ResolutionUtilKt.resolveClassChecked$default(context.getClassResolver(), superClassName, classFile, context, null, 8, null);
        if (classFile2 == null) {
            return;
        }
        ClassFile superClass = classFile2;
        if (superClass.isInterface()) {
            context.getProblemRegistrar().registerProblem(new SuperClassBecameInterfaceProblem(classFile.getLocation(), superClass.getLocation()));
        }
    }
}

