/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.pluginverifier.verifiers;

import com.jetbrains.plugin.structure.classes.resolvers.Resolver;
import com.jetbrains.pluginverifier.verifiers.resolution.ClassFile;
import com.jetbrains.pluginverifier.verifiers.resolution.ResolutionUtilKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0002\u001a\u001a\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u001a\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0006\u001a\u001a\u0010\t\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0006\u001a\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\u000b*\u00020\u00022\u0006\u0010\f\u001a\u00020\u0004H\u0002\u00a8\u0006\r"}, d2={"isSubclassOf", "", "Lcom/jetbrains/plugin/structure/classes/resolvers/Resolver;", "child", "Lcom/jetbrains/pluginverifier/verifiers/resolution/ClassFile;", "parentName", "", "childClassName", "possibleParentName", "isSubclassOrSelf", "resolveAllDirectParents", "", "classFile", "verifier-core"})
@SourceDebugExtension(value={"SMAP\nInheritanceUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InheritanceUtil.kt\ncom/jetbrains/pluginverifier/verifiers/InheritanceUtilKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,57:1\n1603#2,9:58\n1855#2:67\n1856#2:69\n1612#2:70\n1855#2,2:71\n1#3:68\n*S KotlinDebug\n*F\n+ 1 InheritanceUtil.kt\ncom/jetbrains/pluginverifier/verifiers/InheritanceUtilKt\n*L\n14#1:58,9\n14#1:67\n14#1:69\n14#1:70\n49#1:71,2\n14#1:68\n*E\n"})
public final class InheritanceUtilKt {
    /*
     * WARNING - void declaration
     */
    private static final List<ClassFile> resolveAllDirectParents(Resolver $this$resolveAllDirectParents, ClassFile classFile) {
        void $this$mapNotNullTo$iv$iv;
        List parents = CollectionsKt.plus((Collection)CollectionsKt.listOfNotNull(classFile.getSuperName()), (Iterable)classFile.getInterfaces());
        Iterable $this$mapNotNull$iv = parents;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            ClassFile it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            String it = (String)element$iv$iv;
            boolean bl2 = false;
            if (ResolutionUtilKt.resolveClassOrNull($this$resolveAllDirectParents, it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public static final boolean isSubclassOrSelf(@NotNull Resolver $this$isSubclassOrSelf, @NotNull String childClassName, @NotNull String possibleParentName) {
        Intrinsics.checkNotNullParameter($this$isSubclassOrSelf, "<this>");
        Intrinsics.checkNotNullParameter(childClassName, "childClassName");
        Intrinsics.checkNotNullParameter(possibleParentName, "possibleParentName");
        if (Intrinsics.areEqual(childClassName, possibleParentName)) {
            return true;
        }
        return InheritanceUtilKt.isSubclassOf($this$isSubclassOrSelf, childClassName, possibleParentName);
    }

    public static final boolean isSubclassOf(@NotNull Resolver $this$isSubclassOf, @NotNull String childClassName, @NotNull String possibleParentName) {
        Intrinsics.checkNotNullParameter($this$isSubclassOf, "<this>");
        Intrinsics.checkNotNullParameter(childClassName, "childClassName");
        Intrinsics.checkNotNullParameter(possibleParentName, "possibleParentName");
        if (Intrinsics.areEqual(possibleParentName, "java/lang/Object")) {
            return true;
        }
        ClassFile classFile = ResolutionUtilKt.resolveClassOrNull($this$isSubclassOf, childClassName);
        if (classFile == null) {
            return false;
        }
        ClassFile childClass = classFile;
        return InheritanceUtilKt.isSubclassOf($this$isSubclassOf, childClass, possibleParentName);
    }

    public static final boolean isSubclassOf(@NotNull Resolver $this$isSubclassOf, @NotNull ClassFile child, @NotNull String parentName) {
        Intrinsics.checkNotNullParameter($this$isSubclassOf, "<this>");
        Intrinsics.checkNotNullParameter(child, "child");
        Intrinsics.checkNotNullParameter(parentName, "parentName");
        if (Intrinsics.areEqual(parentName, "java/lang/Object")) {
            return true;
        }
        LinkedList<ClassFile> queue = new LinkedList<ClassFile>();
        HashSet<String> visited = new HashSet<String>();
        queue.add(child);
        visited.add(child.getName());
        while (!((Collection)queue).isEmpty()) {
            ClassFile node = (ClassFile)queue.poll();
            if (Intrinsics.areEqual(node.getName(), parentName)) {
                return true;
            }
            Intrinsics.checkNotNullExpressionValue(node, "node");
            Iterable $this$forEach$iv = InheritanceUtilKt.resolveAllDirectParents($this$isSubclassOf, node);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ClassFile it = (ClassFile)element$iv;
                boolean bl = false;
                if (!visited.add(it.getName())) continue;
                queue.addLast(it);
            }
        }
        return false;
    }
}

