/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.pluginverifier.usages.internal;

import com.jetbrains.plugin.structure.classes.resolvers.FileOrigin;
import com.jetbrains.plugin.structure.classes.resolvers.Resolver;
import com.jetbrains.pluginverifier.results.access.AccessType;
import com.jetbrains.pluginverifier.results.instruction.Instruction;
import com.jetbrains.pluginverifier.results.location.ClassLocation;
import com.jetbrains.pluginverifier.results.location.Location;
import com.jetbrains.pluginverifier.results.location.LocationToReferenceKt;
import com.jetbrains.pluginverifier.results.location.MethodLocation;
import com.jetbrains.pluginverifier.results.problems.CompatibilityProblem;
import com.jetbrains.pluginverifier.results.reference.ClassReference;
import com.jetbrains.pluginverifier.results.reference.FieldReference;
import com.jetbrains.pluginverifier.results.reference.MethodReference;
import com.jetbrains.pluginverifier.usages.ApiUsageProcessor;
import com.jetbrains.pluginverifier.usages.internal.InternalUsageRegistrar;
import com.jetbrains.pluginverifier.usages.util.ExtensionsKt;
import com.jetbrains.pluginverifier.verifiers.ProblemRegistrar;
import com.jetbrains.pluginverifier.verifiers.VerificationContext;
import com.jetbrains.pluginverifier.verifiers.packages.PackageFilter;
import com.jetbrains.pluginverifier.verifiers.resolution.ClassFile;
import com.jetbrains.pluginverifier.verifiers.resolution.ClassFileMember;
import com.jetbrains.pluginverifier.verifiers.resolution.ClassUsageType;
import com.jetbrains.pluginverifier.verifiers.resolution.Field;
import com.jetbrains.pluginverifier.verifiers.resolution.Method;
import com.jetbrains.pluginverifier.verifiers.resolution.MethodResolver;
import com.jetbrains.pluginverifier.warnings.CompatibilityWarning;
import com.jetbrains.pluginverifier.warnings.WarningRegistrar;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.InnerClassNode;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001:\u0002#$B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH$J0\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J(\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J0\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001c2\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/jetbrains/pluginverifier/usages/internal/BaseInternalApiUsageProcessor;", "Lcom/jetbrains/pluginverifier/usages/ApiUsageProcessor;", "internalUsageRegistrar", "Lcom/jetbrains/pluginverifier/usages/internal/InternalUsageRegistrar;", "(Lcom/jetbrains/pluginverifier/usages/internal/InternalUsageRegistrar;)V", "isInternal", "", "resolvedMember", "Lcom/jetbrains/pluginverifier/verifiers/resolution/ClassFileMember;", "context", "Lcom/jetbrains/pluginverifier/verifiers/VerificationContext;", "usageLocation", "Lcom/jetbrains/pluginverifier/results/location/Location;", "processClassReference", "", "classReference", "Lcom/jetbrains/pluginverifier/results/reference/ClassReference;", "resolvedClass", "Lcom/jetbrains/pluginverifier/verifiers/resolution/ClassFile;", "referrer", "classUsageType", "Lcom/jetbrains/pluginverifier/verifiers/resolution/ClassUsageType;", "processFieldAccess", "fieldReference", "Lcom/jetbrains/pluginverifier/results/reference/FieldReference;", "resolvedField", "Lcom/jetbrains/pluginverifier/verifiers/resolution/Field;", "callerMethod", "Lcom/jetbrains/pluginverifier/verifiers/resolution/Method;", "processMethodInvocation", "methodReference", "Lcom/jetbrains/pluginverifier/results/reference/MethodReference;", "resolvedMethod", "instructionNode", "Lorg/objectweb/asm/tree/AbstractInsnNode;", "ClassFileWithNoMethodsWrapper", "VerificationContextWithSilentProblemRegistrar", "verifier-intellij"})
public abstract class BaseInternalApiUsageProcessor
implements ApiUsageProcessor {
    @NotNull
    private final InternalUsageRegistrar internalUsageRegistrar;

    public BaseInternalApiUsageProcessor(@NotNull InternalUsageRegistrar internalUsageRegistrar) {
        Intrinsics.checkNotNullParameter(internalUsageRegistrar, "internalUsageRegistrar");
        this.internalUsageRegistrar = internalUsageRegistrar;
    }

    @Override
    public void processClassReference(@NotNull ClassReference classReference, @NotNull ClassFile resolvedClass, @NotNull VerificationContext context, @NotNull ClassFileMember referrer, @NotNull ClassUsageType classUsageType) {
        Intrinsics.checkNotNullParameter(classReference, "classReference");
        Intrinsics.checkNotNullParameter(resolvedClass, "resolvedClass");
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(referrer, "referrer");
        Intrinsics.checkNotNullParameter((Object)classUsageType, "classUsageType");
        Location usageLocation = referrer.getLocation();
        if (this.isInternal(resolvedClass, context, usageLocation) && ExtensionsKt.isFromVerifiedPlugin(context, referrer)) {
            this.internalUsageRegistrar.registerClass(classReference, resolvedClass.getLocation(), usageLocation);
        }
    }

    @Override
    public void processMethodInvocation(@NotNull MethodReference methodReference, @NotNull Method resolvedMethod, @NotNull AbstractInsnNode instructionNode, @NotNull Method callerMethod, @NotNull VerificationContext context) {
        Intrinsics.checkNotNullParameter(methodReference, "methodReference");
        Intrinsics.checkNotNullParameter(resolvedMethod, "resolvedMethod");
        Intrinsics.checkNotNullParameter(instructionNode, "instructionNode");
        Intrinsics.checkNotNullParameter(callerMethod, "callerMethod");
        Intrinsics.checkNotNullParameter(context, "context");
        MethodLocation usageLocation = callerMethod.getLocation();
        if (this.isInternal(resolvedMethod, context, usageLocation)) {
            Method overriddenMethod;
            boolean canBeOverridden;
            boolean bl = canBeOverridden = !resolvedMethod.isStatic() && !resolvedMethod.isPrivate() && !Intrinsics.areEqual(resolvedMethod.getName(), "<init>") && !Intrinsics.areEqual(resolvedMethod.getName(), "<clinit>");
            Method method = canBeOverridden ? new MethodResolver().resolveMethod(new ClassFileWithNoMethodsWrapper(resolvedMethod.getContainingClassFile()), LocationToReferenceKt.toReference(resolvedMethod.getLocation()), resolvedMethod.getContainingClassFile().isInterface() ? Instruction.INVOKE_INTERFACE : Instruction.INVOKE_VIRTUAL, resolvedMethod, new VerificationContextWithSilentProblemRegistrar(context)) : (overriddenMethod = null);
            if (overriddenMethod == null || this.isInternal(overriddenMethod, context, usageLocation)) {
                this.internalUsageRegistrar.registerMethod(methodReference, resolvedMethod.getLocation(), usageLocation);
            }
        }
    }

    @Override
    public void processFieldAccess(@NotNull FieldReference fieldReference, @NotNull Field resolvedField, @NotNull VerificationContext context, @NotNull Method callerMethod) {
        Intrinsics.checkNotNullParameter(fieldReference, "fieldReference");
        Intrinsics.checkNotNullParameter(resolvedField, "resolvedField");
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(callerMethod, "callerMethod");
        MethodLocation usageLocation = callerMethod.getLocation();
        if (this.isInternal(resolvedField, context, usageLocation)) {
            this.internalUsageRegistrar.registerField(fieldReference, resolvedField.getLocation(), usageLocation);
        }
    }

    protected abstract boolean isInternal(@NotNull ClassFileMember var1, @NotNull VerificationContext var2, @NotNull Location var3);

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u000f\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\f\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0003R\u0012\u0010\u0004\u001a\u00020\u0005X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0018\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\r\u001a\u00020\u000eX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0012\u0010\u0011\u001a\u00020\u0001X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0018\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0018\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\tX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\fR\u0018\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00150\tX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b!\u0010\fR\u0012\u0010\"\u001a\u00020#X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\"\u0010$R\u0012\u0010%\u001a\u00020#X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b%\u0010$R\u0012\u0010&\u001a\u00020#X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b&\u0010$R\u0012\u0010'\u001a\u00020#X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b'\u0010$R\u0012\u0010(\u001a\u00020#X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b(\u0010$R\u0012\u0010)\u001a\u00020#X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b)\u0010$R\u0012\u0010*\u001a\u00020#X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b*\u0010$R\u0012\u0010+\u001a\u00020#X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b+\u0010$R\u0012\u0010,\u001a\u00020#X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b,\u0010$R\u0012\u0010-\u001a\u00020#X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b-\u0010$R\u0012\u0010.\u001a\u00020#X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b.\u0010$R\u0012\u0010/\u001a\u00020#X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b/\u0010$R\u0012\u00100\u001a\u00020\u0015X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b1\u0010\u0017R\u0012\u00102\u001a\u000203X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b4\u00105R\u0012\u00106\u001a\u000207X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b8\u00109R\u001a\u0010:\u001a\b\u0012\u0004\u0012\u00020;0\u00198VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b<\u0010\u001cR\u0012\u0010=\u001a\u00020\u0015X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b>\u0010\u0017R\u0014\u0010?\u001a\u0004\u0018\u00010\u0015X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b@\u0010\u0017R\u0012\u0010A\u001a\u00020\u0015X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\bB\u0010\u0017R\u0014\u0010C\u001a\u0004\u0018\u00010\u0015X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\bD\u0010\u0017R\u0014\u0010E\u001a\u0004\u0018\u00010\u0015X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\bF\u0010\u0017\u00a8\u0006G"}, d2={"Lcom/jetbrains/pluginverifier/usages/internal/BaseInternalApiUsageProcessor$ClassFileWithNoMethodsWrapper;", "Lcom/jetbrains/pluginverifier/verifiers/resolution/ClassFile;", "classFile", "(Lcom/jetbrains/pluginverifier/verifiers/resolution/ClassFile;)V", "accessType", "Lcom/jetbrains/pluginverifier/results/access/AccessType;", "getAccessType", "()Lcom/jetbrains/pluginverifier/results/access/AccessType;", "annotations", "", "Lorg/objectweb/asm/tree/AnnotationNode;", "getAnnotations", "()Ljava/util/List;", "classFileOrigin", "Lcom/jetbrains/plugin/structure/classes/resolvers/FileOrigin;", "getClassFileOrigin", "()Lcom/jetbrains/plugin/structure/classes/resolvers/FileOrigin;", "containingClassFile", "getContainingClassFile", "()Lcom/jetbrains/pluginverifier/verifiers/resolution/ClassFile;", "enclosingClassName", "", "getEnclosingClassName", "()Ljava/lang/String;", "fields", "Lkotlin/sequences/Sequence;", "Lcom/jetbrains/pluginverifier/verifiers/resolution/Field;", "getFields", "()Lkotlin/sequences/Sequence;", "innerClasses", "Lorg/objectweb/asm/tree/InnerClassNode;", "getInnerClasses", "interfaces", "getInterfaces", "isAbstract", "", "()Z", "isDeprecated", "isEnum", "isFinal", "isInterface", "isPackagePrivate", "isPrivate", "isProtected", "isPublic", "isStatic", "isSuperFlag", "isSynthetic", "javaPackageName", "getJavaPackageName", "javaVersion", "", "getJavaVersion", "()I", "location", "Lcom/jetbrains/pluginverifier/results/location/ClassLocation;", "getLocation", "()Lcom/jetbrains/pluginverifier/results/location/ClassLocation;", "methods", "Lcom/jetbrains/pluginverifier/verifiers/resolution/Method;", "getMethods", "name", "getName", "nestHostClass", "getNestHostClass", "packageName", "getPackageName", "signature", "getSignature", "superName", "getSuperName", "verifier-intellij"})
    private static final class ClassFileWithNoMethodsWrapper
    implements ClassFile {
        @NotNull
        private final ClassFile classFile;

        public ClassFileWithNoMethodsWrapper(@NotNull ClassFile classFile) {
            Intrinsics.checkNotNullParameter(classFile, "classFile");
            this.classFile = classFile;
        }

        @Override
        @NotNull
        public AccessType getAccessType() {
            return this.classFile.getAccessType();
        }

        @Override
        @NotNull
        public List<AnnotationNode> getAnnotations() {
            return this.classFile.getAnnotations();
        }

        @Override
        @NotNull
        public FileOrigin getClassFileOrigin() {
            return this.classFile.getClassFileOrigin();
        }

        @Override
        @NotNull
        public ClassFile getContainingClassFile() {
            return this.classFile.getContainingClassFile();
        }

        @Override
        @Nullable
        public String getEnclosingClassName() {
            return this.classFile.getEnclosingClassName();
        }

        @Override
        @NotNull
        public Sequence<Field> getFields() {
            return this.classFile.getFields();
        }

        @Override
        @NotNull
        public List<InnerClassNode> getInnerClasses() {
            return this.classFile.getInnerClasses();
        }

        @Override
        @NotNull
        public List<String> getInterfaces() {
            return this.classFile.getInterfaces();
        }

        @Override
        public boolean isAbstract() {
            return this.classFile.isAbstract();
        }

        @Override
        public boolean isDeprecated() {
            return this.classFile.isDeprecated();
        }

        @Override
        public boolean isEnum() {
            return this.classFile.isEnum();
        }

        @Override
        public boolean isFinal() {
            return this.classFile.isFinal();
        }

        @Override
        public boolean isInterface() {
            return this.classFile.isInterface();
        }

        @Override
        public boolean isPackagePrivate() {
            return this.classFile.isPackagePrivate();
        }

        @Override
        public boolean isPrivate() {
            return this.classFile.isPrivate();
        }

        @Override
        public boolean isProtected() {
            return this.classFile.isProtected();
        }

        @Override
        public boolean isPublic() {
            return this.classFile.isPublic();
        }

        @Override
        public boolean isStatic() {
            return this.classFile.isStatic();
        }

        @Override
        public boolean isSuperFlag() {
            return this.classFile.isSuperFlag();
        }

        @Override
        public boolean isSynthetic() {
            return this.classFile.isSynthetic();
        }

        @Override
        @NotNull
        public String getJavaPackageName() {
            return this.classFile.getJavaPackageName();
        }

        @Override
        public int getJavaVersion() {
            return this.classFile.getJavaVersion();
        }

        @Override
        @NotNull
        public ClassLocation getLocation() {
            return this.classFile.getLocation();
        }

        @Override
        @NotNull
        public String getName() {
            return this.classFile.getName();
        }

        @Override
        @Nullable
        public String getNestHostClass() {
            return this.classFile.getNestHostClass();
        }

        @Override
        @NotNull
        public String getPackageName() {
            return this.classFile.getPackageName();
        }

        @Override
        @Nullable
        public String getSignature() {
            return this.classFile.getSignature();
        }

        @Override
        @Nullable
        public String getSuperName() {
            return this.classFile.getSuperName();
        }

        @Override
        @NotNull
        public Sequence<Method> getMethods() {
            return SequencesKt.emptySequence();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0003R\u0018\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0012\u0010\t\u001a\u00020\nX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\r\u001a\u00020\u000eX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u0012X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u0016X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006\u0019"}, d2={"Lcom/jetbrains/pluginverifier/usages/internal/BaseInternalApiUsageProcessor$VerificationContextWithSilentProblemRegistrar;", "Lcom/jetbrains/pluginverifier/verifiers/VerificationContext;", "delegate", "(Lcom/jetbrains/pluginverifier/verifiers/VerificationContext;)V", "apiUsageProcessors", "", "Lcom/jetbrains/pluginverifier/usages/ApiUsageProcessor;", "getApiUsageProcessors", "()Ljava/util/List;", "classResolver", "Lcom/jetbrains/plugin/structure/classes/resolvers/Resolver;", "getClassResolver", "()Lcom/jetbrains/plugin/structure/classes/resolvers/Resolver;", "externalClassesPackageFilter", "Lcom/jetbrains/pluginverifier/verifiers/packages/PackageFilter;", "getExternalClassesPackageFilter", "()Lcom/jetbrains/pluginverifier/verifiers/packages/PackageFilter;", "problemRegistrar", "Lcom/jetbrains/pluginverifier/verifiers/ProblemRegistrar;", "getProblemRegistrar", "()Lcom/jetbrains/pluginverifier/verifiers/ProblemRegistrar;", "warningRegistrar", "Lcom/jetbrains/pluginverifier/warnings/WarningRegistrar;", "getWarningRegistrar", "()Lcom/jetbrains/pluginverifier/warnings/WarningRegistrar;", "verifier-intellij"})
    private static final class VerificationContextWithSilentProblemRegistrar
    implements VerificationContext {
        @NotNull
        private final VerificationContext delegate;
        @NotNull
        private final ProblemRegistrar problemRegistrar;
        @NotNull
        private final WarningRegistrar warningRegistrar;

        public VerificationContextWithSilentProblemRegistrar(@NotNull VerificationContext delegate) {
            Intrinsics.checkNotNullParameter(delegate, "delegate");
            this.delegate = delegate;
            this.problemRegistrar = new ProblemRegistrar(){

                public void registerProblem(@NotNull CompatibilityProblem problem) {
                    Intrinsics.checkNotNullParameter(problem, "problem");
                }
            };
            this.warningRegistrar = new WarningRegistrar(){

                public void registerCompatibilityWarning(@NotNull CompatibilityWarning warning) {
                    Intrinsics.checkNotNullParameter(warning, "warning");
                }
            };
        }

        @Override
        @NotNull
        public List<ApiUsageProcessor> getApiUsageProcessors() {
            return this.delegate.getApiUsageProcessors();
        }

        @Override
        @NotNull
        public Resolver getClassResolver() {
            return this.delegate.getClassResolver();
        }

        @Override
        @NotNull
        public PackageFilter getExternalClassesPackageFilter() {
            return this.delegate.getExternalClassesPackageFilter();
        }

        @Override
        @NotNull
        public ProblemRegistrar getProblemRegistrar() {
            return this.problemRegistrar;
        }

        @Override
        @NotNull
        public WarningRegistrar getWarningRegistrar() {
            return this.warningRegistrar;
        }
    }
}

