/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.pluginverifier.tasks.checkTrunkApi;

import com.jetbrains.plugin.structure.base.utils.FileUtilKt;
import com.jetbrains.plugin.structure.base.utils.FormatUtilsKt;
import com.jetbrains.plugin.structure.base.utils.LanguageUtilsKt;
import com.jetbrains.plugin.structure.ide.Ide;
import com.jetbrains.plugin.structure.intellij.plugin.PluginArchiveManager;
import com.jetbrains.plugin.structure.intellij.version.IdeVersion;
import com.jetbrains.pluginverifier.PluginVerificationDescriptor;
import com.jetbrains.pluginverifier.PluginVerificationTarget;
import com.jetbrains.pluginverifier.dependencies.resolution.BundledPluginDependencyFinder;
import com.jetbrains.pluginverifier.dependencies.resolution.CompositeDependencyFinder;
import com.jetbrains.pluginverifier.dependencies.resolution.DependencyFinder;
import com.jetbrains.pluginverifier.dependencies.resolution.LastCompatibleVersionSelector;
import com.jetbrains.pluginverifier.dependencies.resolution.LastVersionSelector;
import com.jetbrains.pluginverifier.dependencies.resolution.RepositoryDependencyFinder;
import com.jetbrains.pluginverifier.filtering.ProblemsFilter;
import com.jetbrains.pluginverifier.ide.IdeDescriptor;
import com.jetbrains.pluginverifier.misc.RetryUtilKt;
import com.jetbrains.pluginverifier.options.CmdOpts;
import com.jetbrains.pluginverifier.options.OptionsParser;
import com.jetbrains.pluginverifier.options.PluginsSet;
import com.jetbrains.pluginverifier.options.filter.PluginFilter;
import com.jetbrains.pluginverifier.options.repository.LocalPluginRepositoryProvider;
import com.jetbrains.pluginverifier.plugin.PluginDetailsCache;
import com.jetbrains.pluginverifier.reporting.PluginVerificationReportage;
import com.jetbrains.pluginverifier.repository.PluginInfo;
import com.jetbrains.pluginverifier.repository.PluginRepository;
import com.jetbrains.pluginverifier.repository.files.FileLock;
import com.jetbrains.pluginverifier.repository.files.IdleFileLock;
import com.jetbrains.pluginverifier.repository.repositories.empty.EmptyPluginRepository;
import com.jetbrains.pluginverifier.resolution.DefaultClassResolverProvider;
import com.jetbrains.pluginverifier.tasks.TaskParametersBuilder;
import com.jetbrains.pluginverifier.tasks.checkTrunkApi.CheckTrunkApiOpts;
import com.jetbrains.pluginverifier.tasks.checkTrunkApi.CheckTrunkApiParams;
import com.jetbrains.pluginverifier.tasks.checkTrunkApi.CheckTrunkApiParamsBuilder;
import com.jetbrains.pluginverifier.verifiers.packages.PackageFilter;
import com.sampullara.cli.Args;
import java.io.Closeable;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002'(B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u001e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0016J \u0010\u0012\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J0\u0010\u0012\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J(\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u001a\u0010 \u001a\u00020\u00032\b\u0010!\u001a\u0004\u0018\u00010\u00112\u0006\u0010\r\u001a\u00020\u000eH\u0002J$\u0010\"\u001a\b\u0012\u0004\u0012\u00020#0\u00102\f\u0010$\u001a\b\u0012\u0004\u0012\u00020#0\u00102\u0006\u0010%\u001a\u00020&H\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/jetbrains/pluginverifier/tasks/checkTrunkApi/CheckTrunkApiParamsBuilder;", "Lcom/jetbrains/pluginverifier/tasks/TaskParametersBuilder;", "pluginRepository", "Lcom/jetbrains/pluginverifier/repository/PluginRepository;", "reportage", "Lcom/jetbrains/pluginverifier/reporting/PluginVerificationReportage;", "pluginDetailsCache", "Lcom/jetbrains/pluginverifier/plugin/PluginDetailsCache;", "archiveManager", "Lcom/jetbrains/plugin/structure/intellij/plugin/PluginArchiveManager;", "(Lcom/jetbrains/pluginverifier/repository/PluginRepository;Lcom/jetbrains/pluginverifier/reporting/PluginVerificationReportage;Lcom/jetbrains/pluginverifier/plugin/PluginDetailsCache;Lcom/jetbrains/plugin/structure/intellij/plugin/PluginArchiveManager;)V", "build", "Lcom/jetbrains/pluginverifier/tasks/checkTrunkApi/CheckTrunkApiParams;", "opts", "Lcom/jetbrains/pluginverifier/options/CmdOpts;", "freeArgs", "", "", "buildParameters", "apiOpts", "Lcom/jetbrains/pluginverifier/tasks/checkTrunkApi/CheckTrunkApiOpts;", "trunkIdeDescriptor", "Lcom/jetbrains/pluginverifier/ide/IdeDescriptor;", "releaseIdeDescriptor", "releaseIdeFileLock", "Lcom/jetbrains/pluginverifier/repository/files/FileLock;", "createDependencyFinder", "Lcom/jetbrains/pluginverifier/dependencies/resolution/DependencyFinder;", "releaseOrTrunkIde", "Lcom/jetbrains/plugin/structure/ide/Ide;", "releaseIde", "localPluginRepository", "createRepository", "repositoryRoot", "getLatestCompatibleVersions", "Lcom/jetbrains/pluginverifier/repository/PluginInfo;", "releaseCompatibleVersions", "trunkVersion", "Lcom/jetbrains/plugin/structure/intellij/version/IdeVersion;", "IgnoreBundledPluginsFilter", "IgnorePluginsAvailableInOtherRepositoryFilter", "verifier-cli"})
@SourceDebugExtension(value={"SMAP\nCheckTrunkApiParamsBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CheckTrunkApiParamsBuilder.kt\ncom/jetbrains/pluginverifier/tasks/checkTrunkApi/CheckTrunkApiParamsBuilder\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 LanguageUtils.kt\ncom/jetbrains/plugin/structure/base/utils/LanguageUtilsKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,286:1\n37#2,2:287\n1#3:289\n70#4,5:290\n70#4,2:295\n70#4,5:297\n72#4,3:302\n766#5:305\n857#5,2:306\n1549#5:308\n1620#5,3:309\n1549#5:312\n1620#5,3:313\n*S KotlinDebug\n*F\n+ 1 CheckTrunkApiParamsBuilder.kt\ncom/jetbrains/pluginverifier/tasks/checkTrunkApi/CheckTrunkApiParamsBuilder\n*L\n48#1:287,2\n53#1:290,5\n68#1:295,2\n69#1:297,5\n68#1:302,3\n134#1:305\n134#1:306,2\n151#1:308\n151#1:309,3\n162#1:312\n162#1:313,3\n*E\n"})
public final class CheckTrunkApiParamsBuilder
implements TaskParametersBuilder {
    @NotNull
    private final PluginRepository pluginRepository;
    @NotNull
    private final PluginVerificationReportage reportage;
    @NotNull
    private final PluginDetailsCache pluginDetailsCache;
    @NotNull
    private final PluginArchiveManager archiveManager;

    public CheckTrunkApiParamsBuilder(@NotNull PluginRepository pluginRepository, @NotNull PluginVerificationReportage reportage, @NotNull PluginDetailsCache pluginDetailsCache, @NotNull PluginArchiveManager archiveManager) {
        Intrinsics.checkNotNullParameter(pluginRepository, "pluginRepository");
        Intrinsics.checkNotNullParameter(reportage, "reportage");
        Intrinsics.checkNotNullParameter(pluginDetailsCache, "pluginDetailsCache");
        Intrinsics.checkNotNullParameter(archiveManager, "archiveManager");
        this.pluginRepository = pluginRepository;
        this.reportage = reportage;
        this.pluginDetailsCache = pluginDetailsCache;
        this.archiveManager = archiveManager;
    }

    @Override
    @NotNull
    public CheckTrunkApiParams build(@NotNull CmdOpts opts, @NotNull List<String> freeArgs) {
        CheckTrunkApiParams checkTrunkApiParams;
        Intrinsics.checkNotNullParameter(opts, "opts");
        Intrinsics.checkNotNullParameter(freeArgs, "freeArgs");
        CheckTrunkApiOpts apiOpts = new CheckTrunkApiOpts();
        Collection $this$toTypedArray$iv = freeArgs;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        List<String> args2 = Args.parse(apiOpts, thisCollection$iv.toArray(new String[0]), false);
        Intrinsics.checkNotNullExpressionValue(args2, "args");
        if (!(!((Collection)args2).isEmpty())) {
            boolean $i$a$-require-CheckTrunkApiParamsBuilder$build$22 = false;
            String $i$a$-require-CheckTrunkApiParamsBuilder$build$22 = "The IDE to be checked is not specified";
            throw new IllegalArgumentException($i$a$-require-CheckTrunkApiParamsBuilder$build$22.toString());
        }
        this.reportage.logVerificationStage("Preparing the trunk IDE " + args2.get(0));
        String string = args2.get(0);
        Intrinsics.checkNotNullExpressionValue(string, "args[0]");
        IdeDescriptor trunkIdeDescriptor = OptionsParser.INSTANCE.createIdeDescriptor(string, opts);
        Closeable $this$closeOnException$iv = trunkIdeDescriptor;
        boolean $i$f$closeOnException = false;
        try {
            IdeDescriptor it = (IdeDescriptor)$this$closeOnException$iv;
            boolean bl = false;
            checkTrunkApiParams = this.buildParameters(opts, apiOpts, trunkIdeDescriptor);
        }
        catch (Throwable e$iv) {
            Closeable closeable = $this$closeOnException$iv;
            if (closeable != null) {
                LanguageUtilsKt.closeLogged(closeable);
            }
            throw e$iv;
        }
        return checkTrunkApiParams;
    }

    private final CheckTrunkApiParams buildParameters(CmdOpts opts, CheckTrunkApiOpts apiOpts, IdeDescriptor trunkIdeDescriptor) {
        CheckTrunkApiParams checkTrunkApiParams;
        FileLock releaseIdeFileLock = null;
        String string = apiOpts.getMajorIdePath();
        if (string == null) {
            boolean $i$a$-requireNotNull-CheckTrunkApiParamsBuilder$buildParameters$majorIdePath$22 = false;
            String $i$a$-requireNotNull-CheckTrunkApiParamsBuilder$buildParameters$majorIdePath$22 = "-mip --major-ide-path option is not specified";
            throw new IllegalArgumentException($i$a$-requireNotNull-CheckTrunkApiParamsBuilder$buildParameters$majorIdePath$22.toString());
        }
        String majorIdePath = string;
        Path majorPath = Paths.get(majorIdePath, new String[0]);
        Intrinsics.checkNotNullExpressionValue(majorPath, "majorPath");
        if (!FileUtilKt.isDirectory(majorPath)) {
            boolean $i$a$-require-CheckTrunkApiParamsBuilder$buildParameters$22 = false;
            String $i$a$-require-CheckTrunkApiParamsBuilder$buildParameters$22 = "The specified major IDE doesn't exist: " + majorPath;
            throw new IllegalArgumentException($i$a$-require-CheckTrunkApiParamsBuilder$buildParameters$22.toString());
        }
        releaseIdeFileLock = new IdleFileLock(majorPath);
        this.reportage.logVerificationStage("Reading classes of the release IDE " + releaseIdeFileLock.getFile());
        IdeDescriptor releaseIdeDescriptor = OptionsParser.INSTANCE.createIdeDescriptor(releaseIdeFileLock.getFile(), opts);
        Closeable $this$closeOnException$iv = releaseIdeDescriptor;
        boolean $i$f$closeOnException = false;
        try {
            IdeDescriptor it = (IdeDescriptor)$this$closeOnException$iv;
            boolean bl = false;
            Closeable $this$closeOnException$iv2 = releaseIdeFileLock;
            boolean $i$f$closeOnException2 = false;
            try {
                IdleFileLock it2 = (IdleFileLock)$this$closeOnException$iv2;
                boolean bl2 = false;
                checkTrunkApiParams = this.buildParameters(opts, apiOpts, releaseIdeDescriptor, trunkIdeDescriptor, releaseIdeFileLock);
            }
            catch (Throwable e$iv) {
                LanguageUtilsKt.closeLogged($this$closeOnException$iv2);
                throw e$iv;
            }
        }
        catch (Throwable e$iv) {
            Closeable closeable = $this$closeOnException$iv;
            if (closeable != null) {
                LanguageUtilsKt.closeLogged(closeable);
            }
            throw e$iv;
        }
        return checkTrunkApiParams;
    }

    /*
     * WARNING - void declaration
     */
    private final CheckTrunkApiParams buildParameters(CmdOpts opts, CheckTrunkApiOpts apiOpts, IdeDescriptor releaseIdeDescriptor, IdeDescriptor trunkIdeDescriptor, FileLock releaseIdeFileLock) {
        Collection collection;
        void $this$mapTo$iv$iv2;
        List trunkLatestPluginsToCheck;
        void $this$filterTo$iv$iv;
        List releasePluginsToCheck2;
        List list;
        PackageFilter externalClassesPackageFilter = OptionsParser.INSTANCE.getExternalClassesPackageFilter(opts);
        List<ProblemsFilter> problemsFilters = OptionsParser.INSTANCE.getProblemsFilters(opts);
        PluginRepository releaseLocalRepository = this.createRepository(apiOpts.getReleaseLocalPluginRepositoryRoot(), opts);
        PluginRepository trunkLocalRepository = this.createRepository(apiOpts.getTrunkLocalPluginRepositoryRoot(), opts);
        String message2 = "Requesting a list of plugins compatible with the release IDE " + releaseIdeDescriptor.getIdeVersion();
        this.reportage.logVerificationStage(message2);
        List releaseCompatibleVersions2 = (List)RetryUtilKt.retry$default(this.pluginRepository, message2, null, new Function1<PluginRepository, List<? extends PluginInfo>>(releaseIdeDescriptor){
            final /* synthetic */ IdeDescriptor $releaseIdeDescriptor;
            {
                this.$releaseIdeDescriptor = $releaseIdeDescriptor;
                super(1);
            }

            @NotNull
            public final List<PluginInfo> invoke(@NotNull PluginRepository $this$retry) {
                Intrinsics.checkNotNullParameter($this$retry, "$this$retry");
                return $this$retry.getLastCompatiblePlugins(this.$releaseIdeDescriptor.getIdeVersion());
            }
        }, 2, null);
        IgnorePluginsAvailableInOtherRepositoryFilter releaseIgnoreInLocalRepositoryFilter = new IgnorePluginsAvailableInOtherRepositoryFilter(releaseLocalRepository);
        IgnoreBundledPluginsFilter releaseBundledFilter = new IgnoreBundledPluginsFilter(releaseIdeDescriptor.getIde());
        PluginsSet releasePluginsSet = new PluginsSet(null, null, 3, null);
        releasePluginsSet.addPluginFilter(releaseIgnoreInLocalRepositoryFilter);
        releasePluginsSet.addPluginFilter(releaseBundledFilter);
        this.reportage.logVerificationStage("Scheduling " + releaseCompatibleVersions2.size() + " plugins for verification against major IDE");
        releasePluginsSet.schedulePlugins(releaseCompatibleVersions2);
        IgnorePluginsAvailableInOtherRepositoryFilter trunkIgnoreInLocalRepositoryFilter = new IgnorePluginsAvailableInOtherRepositoryFilter(trunkLocalRepository);
        IgnoreBundledPluginsFilter trunkBundledFilter = new IgnoreBundledPluginsFilter(trunkIdeDescriptor.getIde());
        PluginsSet trunkPluginsSet = new PluginsSet(null, null, 3, null);
        trunkPluginsSet.addPluginFilter(trunkIgnoreInLocalRepositoryFilter);
        trunkPluginsSet.addPluginFilter(trunkBundledFilter);
        this.reportage.logVerificationStage("Scheduling " + releaseCompatibleVersions2.size() + " plugins for verification against trunk IDE");
        trunkPluginsSet.schedulePlugins(releaseCompatibleVersions2);
        List<PluginInfo> latestCompatibleVersions = this.getLatestCompatibleVersions(releaseCompatibleVersions2, trunkIdeDescriptor.getIdeVersion());
        trunkPluginsSet.schedulePlugins((Iterable<? extends PluginInfo>)latestCompatibleVersions);
        List it = list = (releasePluginsToCheck2 = CollectionsKt.sortedWith((Iterable)releasePluginsSet.getPluginsToCheck(), (arg_0, arg_1) -> CheckTrunkApiParamsBuilder.buildParameters$lambda$6(buildParameters.releasePluginsToCheck.1.INSTANCE, arg_0, arg_1)));
        boolean bl = false;
        List<Object> list2 = !((Collection)it).isEmpty() ? list : null;
        if (list2 != null) {
            it = list2;
            boolean bl2 = false;
            this.reportage.logVerificationStage("The following updates will be checked with both " + trunkIdeDescriptor.getIdeVersion() + " and #" + releaseIdeDescriptor.getIdeVersion() + ":\n" + (opts.getNeedTeamCityLog() ? CollectionsKt.joinToString$default(it, "\n\t", "\t", null, 0, null, null, 60, null) : FormatUtilsKt.listPresentationInColumns(it, 4, 60)));
        }
        Iterable $this$filter$iv = latestCompatibleVersions;
        boolean $i$f$filter = false;
        Iterable bl2 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            PluginInfo it2 = (PluginInfo)element$iv$iv;
            boolean bl3 = false;
            if (!trunkPluginsSet.shouldVerifyPlugin(it2)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List it3 = $i$f$filter = (trunkLatestPluginsToCheck = (List)destination$iv$iv);
        boolean bl4 = false;
        List list3 = !((Collection)it3).isEmpty() ? $i$f$filter : null;
        if (list3 != null) {
            List it2 = list3;
            boolean bl5 = false;
            this.reportage.logVerificationStage("The following updates will be checked with " + trunkIdeDescriptor.getIdeVersion() + " only for comparison with the release versions of the same plugins:\n" + (opts.getNeedTeamCityLog() ? CollectionsKt.joinToString$default(it2, "\n\t", "\t", null, 0, null, null, 60, null) : FormatUtilsKt.listPresentationInColumns(it2, 4, 60)));
        }
        DependencyFinder releaseFinder = this.createDependencyFinder(releaseIdeDescriptor.getIde(), releaseIdeDescriptor.getIde(), releaseLocalRepository, this.pluginDetailsCache);
        DefaultClassResolverProvider releaseResolverProvider = new DefaultClassResolverProvider(releaseFinder, releaseIdeDescriptor, externalClassesPackageFilter, null, null, this.archiveManager, 24, null);
        Iterable $this$map$iv = releasePluginsSet.getPluginsToCheck();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object t2 : $this$mapTo$iv$iv2) {
            void it4;
            PluginInfo pluginInfo = (PluginInfo)t2;
            collection = destination$iv$iv2;
            boolean bl6 = false;
            collection.add(new PluginVerificationDescriptor.IDE(releaseIdeDescriptor, releaseResolverProvider, (PluginInfo)it4));
        }
        List releaseVerificationDescriptors = (List)destination$iv$iv2;
        DependencyFinder trunkFinder = this.createDependencyFinder(trunkIdeDescriptor.getIde(), releaseIdeDescriptor.getIde(), trunkLocalRepository, this.pluginDetailsCache);
        DefaultClassResolverProvider trunkResolverProvider = new DefaultClassResolverProvider(trunkFinder, trunkIdeDescriptor, externalClassesPackageFilter, null, null, this.archiveManager, 24, null);
        Iterable $this$map$iv2 = trunkPluginsSet.getPluginsToCheck();
        boolean $i$f$map2 = false;
        Iterable iterable2 = $this$map$iv2;
        Collection collection2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv2, 10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : iterable2) {
            void it5;
            PluginInfo pluginInfo = (PluginInfo)item$iv$iv;
            collection = collection2;
            boolean bl7 = false;
            collection.add(new PluginVerificationDescriptor.IDE(trunkIdeDescriptor, trunkResolverProvider, (PluginInfo)it5));
        }
        List trunkVerificationDescriptors = (List)collection2;
        PluginVerificationTarget.IDE releaseVerificationTarget = new PluginVerificationTarget.IDE(releaseIdeDescriptor.getIdeVersion(), releaseIdeDescriptor.getJdkVersion());
        for (Map.Entry<PluginInfo, String> entry : releasePluginsSet.getIgnoredPlugins().entrySet()) {
            PluginInfo pluginInfo = entry.getKey();
            String ignoreReason = entry.getValue();
            this.reportage.logPluginVerificationIgnored(pluginInfo, releaseVerificationTarget, ignoreReason);
        }
        PluginVerificationTarget.IDE trunkVerificationTarget = new PluginVerificationTarget.IDE(trunkIdeDescriptor.getIdeVersion(), trunkIdeDescriptor.getJdkVersion());
        for (Map.Entry<PluginInfo, String> entry : trunkPluginsSet.getIgnoredPlugins().entrySet()) {
            PluginInfo pluginInfo = entry.getKey();
            String ignoreReason = entry.getValue();
            this.reportage.logPluginVerificationIgnored(pluginInfo, trunkVerificationTarget, ignoreReason);
        }
        return new CheckTrunkApiParams(trunkIdeDescriptor, releaseIdeDescriptor, releaseIdeFileLock, problemsFilters, releaseVerificationDescriptors, trunkVerificationDescriptors, releaseVerificationTarget, trunkVerificationTarget, opts.getExcludeExternalBuildClassesSelector());
    }

    private final DependencyFinder createDependencyFinder(Ide releaseOrTrunkIde, Ide releaseIde, PluginRepository localPluginRepository, PluginDetailsCache pluginDetailsCache) {
        BundledPluginDependencyFinder bundledFinder = new BundledPluginDependencyFinder(releaseOrTrunkIde);
        RepositoryDependencyFinder localRepositoryDependencyFinder = new RepositoryDependencyFinder(localPluginRepository, new LastVersionSelector(), pluginDetailsCache);
        IdeVersion ideVersion = releaseIde.getVersion();
        Intrinsics.checkNotNullExpressionValue(ideVersion, "releaseIde.version");
        RepositoryDependencyFinder releaseDependencyFinder = new RepositoryDependencyFinder(this.pluginRepository, new LastCompatibleVersionSelector(ideVersion), pluginDetailsCache);
        DependencyFinder[] dependencyFinderArray = new DependencyFinder[]{bundledFinder, localRepositoryDependencyFinder, releaseDependencyFinder};
        return new CompositeDependencyFinder(CollectionsKt.listOf(dependencyFinderArray));
    }

    private final List<PluginInfo> getLatestCompatibleVersions(List<? extends PluginInfo> releaseCompatibleVersions2, IdeVersion trunkVersion) {
        ArrayList latestCompatibleVersions = new ArrayList();
        for (PluginInfo pluginInfo : releaseCompatibleVersions2) {
            PluginInfo lastCompatibleVersion;
            Object object;
            if (pluginInfo.isCompatibleWith(trunkVersion)) continue;
            Object object2 = this;
            try {
                CheckTrunkApiParamsBuilder $this$getLatestCompatibleVersions_u24lambda_u2414 = object2;
                boolean bl = false;
                object = Result.constructor-impl($this$getLatestCompatibleVersions_u24lambda_u2414.pluginRepository.getLastCompatibleVersionOfPlugin(trunkVersion, pluginInfo.getPluginId()));
            }
            catch (Throwable throwable) {
                object = Result.constructor-impl(ResultKt.createFailure(throwable));
            }
            if ((lastCompatibleVersion = (PluginInfo)(Result.isFailure-impl(object2 = object) ? null : object2)) == null || Intrinsics.areEqual(lastCompatibleVersion, pluginInfo)) continue;
            ((Collection)latestCompatibleVersions).add(lastCompatibleVersion);
        }
        return latestCompatibleVersions;
    }

    private final PluginRepository createRepository(String repositoryRoot, CmdOpts opts) {
        PluginRepository pluginRepository;
        LocalPluginRepositoryProvider.Result provision;
        if (repositoryRoot == null) {
            return EmptyPluginRepository.INSTANCE;
        }
        Path repositoryRootPath = Path.of(repositoryRoot, new String[0]);
        Intrinsics.checkNotNullExpressionValue(repositoryRootPath, "repositoryRootPath");
        LocalPluginRepositoryProvider.Result result2 = provision = LocalPluginRepositoryProvider.INSTANCE.getLocalPluginRepository(opts, repositoryRootPath, this.archiveManager);
        if (result2 instanceof LocalPluginRepositoryProvider.Result.Provided) {
            pluginRepository = ((LocalPluginRepositoryProvider.Result.Provided)provision).getPluginRepository();
        } else if (Intrinsics.areEqual(result2, LocalPluginRepositoryProvider.Result.Unavailable.INSTANCE)) {
            pluginRepository = EmptyPluginRepository.INSTANCE;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return pluginRepository;
    }

    private static final int buildParameters$lambda$6(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        return ((Number)$tmp0.invoke(p0, p1)).intValue();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/pluginverifier/tasks/checkTrunkApi/CheckTrunkApiParamsBuilder$IgnoreBundledPluginsFilter;", "Lcom/jetbrains/pluginverifier/options/filter/PluginFilter;", "ide", "Lcom/jetbrains/plugin/structure/ide/Ide;", "(Lcom/jetbrains/plugin/structure/ide/Ide;)V", "getIde", "()Lcom/jetbrains/plugin/structure/ide/Ide;", "shouldVerifyPlugin", "Lcom/jetbrains/pluginverifier/options/filter/PluginFilter$Result;", "pluginInfo", "Lcom/jetbrains/pluginverifier/repository/PluginInfo;", "verifier-cli"})
    private static final class IgnoreBundledPluginsFilter
    implements PluginFilter {
        @NotNull
        private final Ide ide;

        public IgnoreBundledPluginsFilter(@NotNull Ide ide2) {
            Intrinsics.checkNotNullParameter(ide2, "ide");
            this.ide = ide2;
        }

        @NotNull
        public final Ide getIde() {
            return this.ide;
        }

        @Override
        @NotNull
        public PluginFilter.Result shouldVerifyPlugin(@NotNull PluginInfo pluginInfo) {
            Intrinsics.checkNotNullParameter(pluginInfo, "pluginInfo");
            if (this.ide.findPluginById(pluginInfo.getPluginId()) != null) {
                return new PluginFilter.Result.Ignore("Plugin is bundled with " + this.ide.getPresentableName());
            }
            return PluginFilter.Result.Verify.INSTANCE;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/pluginverifier/tasks/checkTrunkApi/CheckTrunkApiParamsBuilder$IgnorePluginsAvailableInOtherRepositoryFilter;", "Lcom/jetbrains/pluginverifier/options/filter/PluginFilter;", "repository", "Lcom/jetbrains/pluginverifier/repository/PluginRepository;", "(Lcom/jetbrains/pluginverifier/repository/PluginRepository;)V", "getRepository", "()Lcom/jetbrains/pluginverifier/repository/PluginRepository;", "shouldVerifyPlugin", "Lcom/jetbrains/pluginverifier/options/filter/PluginFilter$Result;", "pluginInfo", "Lcom/jetbrains/pluginverifier/repository/PluginInfo;", "verifier-cli"})
    private static final class IgnorePluginsAvailableInOtherRepositoryFilter
    implements PluginFilter {
        @NotNull
        private final PluginRepository repository;

        public IgnorePluginsAvailableInOtherRepositoryFilter(@NotNull PluginRepository repository) {
            Intrinsics.checkNotNullParameter(repository, "repository");
            this.repository = repository;
        }

        @NotNull
        public final PluginRepository getRepository() {
            return this.repository;
        }

        @Override
        @NotNull
        public PluginFilter.Result shouldVerifyPlugin(@NotNull PluginInfo pluginInfo) {
            Intrinsics.checkNotNullParameter(pluginInfo, "pluginInfo");
            if (!((Collection)this.repository.getAllVersionsOfPlugin(pluginInfo.getPluginId())).isEmpty()) {
                return new PluginFilter.Result.Ignore("Plugin is available in " + this.repository);
            }
            return PluginFilter.Result.Verify.INSTANCE;
        }
    }
}

