/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.pluginverifier.resolution;

import com.jetbrains.plugin.structure.base.utils.LanguageUtilsKt;
import com.jetbrains.plugin.structure.classes.resolvers.CompositeResolver;
import com.jetbrains.plugin.structure.classes.resolvers.NamedResolver;
import com.jetbrains.plugin.structure.classes.resolvers.Resolver;
import com.jetbrains.plugin.structure.intellij.plugin.PluginDependencyImpl;
import com.jetbrains.pluginverifier.PluginVerifierKt;
import com.jetbrains.pluginverifier.dependencies.DependenciesGraph;
import com.jetbrains.pluginverifier.dependencies.DependencyEdge;
import com.jetbrains.pluginverifier.dependencies.DependencyNode;
import com.jetbrains.pluginverifier.jdk.JdkDescriptor;
import com.jetbrains.pluginverifier.plugin.PluginDetails;
import com.jetbrains.pluginverifier.resolution.ClassResolverProvider;
import com.jetbrains.pluginverifier.verifiers.packages.NegatedPackageFilter;
import com.jetbrains.pluginverifier.verifiers.packages.PackageFilter;
import com.jetbrains.pluginverifier.verifiers.resolution.ResolutionUtilKt;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0005H\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/pluginverifier/resolution/PluginApiClassResolverProvider;", "Lcom/jetbrains/pluginverifier/resolution/ClassResolverProvider;", "jdkDescriptor", "Lcom/jetbrains/pluginverifier/jdk/JdkDescriptor;", "basePluginDetails", "Lcom/jetbrains/pluginverifier/plugin/PluginDetails;", "basePluginPackageFilter", "Lcom/jetbrains/pluginverifier/verifiers/packages/PackageFilter;", "(Lcom/jetbrains/pluginverifier/jdk/JdkDescriptor;Lcom/jetbrains/pluginverifier/plugin/PluginDetails;Lcom/jetbrains/pluginverifier/verifiers/packages/PackageFilter;)V", "provide", "Lcom/jetbrains/pluginverifier/resolution/ClassResolverProvider$Result;", "checkedPluginDetails", "provideExternalClassesPackageFilter", "Lcom/jetbrains/pluginverifier/verifiers/packages/NegatedPackageFilter;", "verifier-intellij"})
@SourceDebugExtension(value={"SMAP\nPluginApiClassResolverProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PluginApiClassResolverProvider.kt\ncom/jetbrains/pluginverifier/resolution/PluginApiClassResolverProvider\n+ 2 LanguageUtils.kt\ncom/jetbrains/plugin/structure/base/utils/LanguageUtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,83:1\n79#2,4:84\n83#2:90\n1855#3,2:88\n*S KotlinDebug\n*F\n+ 1 PluginApiClassResolverProvider.kt\ncom/jetbrains/pluginverifier/resolution/PluginApiClassResolverProvider\n*L\n29#1:84,4\n29#1:90\n29#1:88,2\n*E\n"})
public final class PluginApiClassResolverProvider
implements ClassResolverProvider {
    @NotNull
    private final JdkDescriptor jdkDescriptor;
    @NotNull
    private final PluginDetails basePluginDetails;
    @NotNull
    private final PackageFilter basePluginPackageFilter;

    public PluginApiClassResolverProvider(@NotNull JdkDescriptor jdkDescriptor, @NotNull PluginDetails basePluginDetails, @NotNull PackageFilter basePluginPackageFilter) {
        Intrinsics.checkNotNullParameter(jdkDescriptor, "jdkDescriptor");
        Intrinsics.checkNotNullParameter(basePluginDetails, "basePluginDetails");
        Intrinsics.checkNotNullParameter(basePluginPackageFilter, "basePluginPackageFilter");
        this.jdkDescriptor = jdkDescriptor;
        this.basePluginDetails = basePluginDetails;
        this.basePluginPackageFilter = basePluginPackageFilter;
    }

    @Override
    @NotNull
    public ClassResolverProvider.Result provide(@NotNull PluginDetails checkedPluginDetails) {
        Intrinsics.checkNotNullParameter(checkedPluginDetails, "checkedPluginDetails");
        ArrayList closeableResources = new ArrayList();
        List $this$closeOnException$iv = closeableResources;
        boolean $i$f$closeOnException = false;
        try {
            List it = $this$closeOnException$iv;
            boolean bl = false;
            NamedResolver checkedPluginClassResolver = PluginVerifierKt.createPluginResolver(checkedPluginDetails.getPluginClassesLocations(), checkedPluginDetails.getPluginInfo().getPluginId());
            Resolver basePluginResolver = PluginVerifierKt.createPluginResolver(this.basePluginDetails.getPluginClassesLocations());
            Resolver[] resolverArray = new Resolver[]{checkedPluginClassResolver, basePluginResolver, this.jdkDescriptor.getJdkResolver()};
            Resolver resolver = ResolutionUtilKt.caching(CompositeResolver.Companion.create(resolverArray));
            DependencyNode checkedPluginNode = new DependencyNode(checkedPluginDetails.getPluginInfo().getPluginId(), checkedPluginDetails.getPluginInfo().getVersion());
            DependencyNode basePluginNode = new DependencyNode(this.basePluginDetails.getPluginInfo().getPluginId(), this.basePluginDetails.getPluginInfo().getVersion());
            DependencyNode[] dependencyNodeArray = new DependencyNode[]{checkedPluginNode, basePluginNode};
            DependenciesGraph dependenciesGraph = new DependenciesGraph(checkedPluginNode, SetsKt.setOf(dependencyNodeArray), SetsKt.setOf(new DependencyEdge(checkedPluginNode, basePluginNode, new PluginDependencyImpl(basePluginNode.getPluginId(), false, false))), MapsKt.emptyMap());
            return new ClassResolverProvider.Result(checkedPluginClassResolver, resolver, dependenciesGraph, closeableResources);
        }
        catch (Throwable e$iv) {
            Iterable $this$forEach$iv$iv = $this$closeOnException$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv$iv : $this$forEach$iv$iv) {
                Closeable t$iv = (Closeable)element$iv$iv;
                boolean bl = false;
                Closeable closeable = t$iv;
                if (closeable == null) continue;
                LanguageUtilsKt.closeLogged(closeable);
            }
            throw e$iv;
        }
    }

    @Override
    @NotNull
    public NegatedPackageFilter provideExternalClassesPackageFilter() {
        return new NegatedPackageFilter(this.basePluginPackageFilter);
    }
}

