/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.pluginverifier.repository.resources;

import com.jetbrains.plugin.structure.base.utils.FormatUtilsKt;
import com.jetbrains.plugin.structure.base.utils.LanguageUtilsKt;
import com.jetbrains.pluginverifier.repository.cleanup.UsageStatistic;
import com.jetbrains.pluginverifier.repository.provider.ProvideResult;
import com.jetbrains.pluginverifier.repository.provider.ResourceProvider;
import com.jetbrains.pluginverifier.repository.resources.AvailableResource;
import com.jetbrains.pluginverifier.repository.resources.EvictionInfo;
import com.jetbrains.pluginverifier.repository.resources.EvictionPolicy;
import com.jetbrains.pluginverifier.repository.resources.LoggerUtilsKt;
import com.jetbrains.pluginverifier.repository.resources.ResourceInfo;
import com.jetbrains.pluginverifier.repository.resources.ResourceLock;
import com.jetbrains.pluginverifier.repository.resources.ResourceLockImpl;
import com.jetbrains.pluginverifier.repository.resources.ResourceRepository;
import com.jetbrains.pluginverifier.repository.resources.ResourceRepositoryResult;
import com.jetbrains.pluginverifier.repository.resources.ResourceWeight;
import java.io.Closeable;
import java.time.Clock;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u009e\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u000e\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u0002*\u000e\b\u0002\u0010\u0004*\b\u0012\u0004\u0012\u0002H\u00040\u00052\u0014\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u0003\u0012\u0004\u0012\u0002H\u00040\u0006:\u0004GHIJBu\u0012\u0018\u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00000\f\u0012\u0006\u0010\r\u001a\u00028\u0002\u0012\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00020\u000f\u0012\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00110\u000f\u0012\b\b\u0002\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\u0002\u0010\u0014J\u001d\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00028\u00012\u0006\u0010&\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010'J\b\u0010(\u001a\u00020\u0011H\u0016J\u0006\u0010)\u001a\u00020\u0011J\u001b\u0010*\u001a\b\u0012\u0004\u0012\u00028\u00000+2\u0006\u0010%\u001a\u00028\u0001H\u0002\u00a2\u0006\u0002\u0010,J!\u0010-\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00020.2\u0006\u0010%\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010/J\u000e\u00100\u001a\b\u0012\u0004\u0012\u00028\u000101H\u0016J \u00102\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020403H\u0016J!\u00105\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00020.2\u0006\u0010%\u001a\u00028\u0001H\u0002\u00a2\u0006\u0002\u0010/J\u0015\u00106\u001a\u00020$2\u0006\u0010%\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u00107J\u0015\u00108\u001a\u00020$2\u0006\u0010%\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u00107J\u0006\u00109\u001a\u00020$J\b\u0010:\u001a\u00020\u0011H\u0002J'\u0010;\u001a\u00020\u00112\u0018\u0010<\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020=H\u0000\u00a2\u0006\u0002\b>J\u0015\u0010?\u001a\u00020$2\u0006\u0010%\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u00107J\u001d\u0010@\u001a\u00020$2\u0006\u0010%\u001a\u00028\u00012\u0006\u0010A\u001a\u00020$H\u0002\u00a2\u0006\u0002\u0010BJ\b\u0010C\u001a\u00020\u0011H\u0016J\u001d\u0010D\u001a\u00020\u00112\u0006\u0010%\u001a\u00028\u00012\u0006\u0010&\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010EJ\b\u0010F\u001a\u00020\u0013H\u0016R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00110\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u001b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00020\u001e0\u001d0\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00000\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00020\u001e0 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010!\u001a\b\u0012\u0004\u0012\u00028\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006K"}, d2={"Lcom/jetbrains/pluginverifier/repository/resources/ResourceRepositoryImpl;", "R", "", "K", "W", "Lcom/jetbrains/pluginverifier/repository/resources/ResourceWeight;", "Lcom/jetbrains/pluginverifier/repository/resources/ResourceRepository;", "evictionPolicy", "Lcom/jetbrains/pluginverifier/repository/resources/EvictionPolicy;", "clock", "Ljava/time/Clock;", "resourceProvider", "Lcom/jetbrains/pluginverifier/repository/provider/ResourceProvider;", "initialWeight", "weigher", "Lkotlin/Function1;", "disposer", "", "presentableName", "", "(Lcom/jetbrains/pluginverifier/repository/resources/EvictionPolicy;Ljava/time/Clock;Lcom/jetbrains/pluginverifier/repository/provider/ResourceProvider;Lcom/jetbrains/pluginverifier/repository/resources/ResourceWeight;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;Ljava/lang/String;)V", "cleanupState", "Lcom/jetbrains/pluginverifier/repository/resources/ResourceRepositoryImpl$CleanupState;", "logger", "Lorg/slf4j/Logger;", "nextLockId", "Ljava/util/concurrent/atomic/AtomicLong;", "removeQueue", "", "Lkotlin/Pair;", "Lcom/jetbrains/pluginverifier/repository/resources/ResourceRepositoryImpl$StorageStatus;", "storage", "Ljava/util/concurrent/ConcurrentHashMap;", "totalWeight", "Ljava/util/concurrent/atomic/AtomicReference;", "add", "", "key", "resource", "(Ljava/lang/Object;Ljava/lang/Object;)Z", "cleanup", "doCleanup", "fetchResource", "Lcom/jetbrains/pluginverifier/repository/provider/ProvideResult;", "(Ljava/lang/Object;)Lcom/jetbrains/pluginverifier/repository/provider/ProvideResult;", "get", "Lcom/jetbrains/pluginverifier/repository/resources/ResourceRepositoryResult;", "(Ljava/lang/Object;)Lcom/jetbrains/pluginverifier/repository/resources/ResourceRepositoryResult;", "getAllExistingKeys", "", "getAvailableResources", "", "Lcom/jetbrains/pluginverifier/repository/resources/AvailableResource;", "getOrWait", "has", "(Ljava/lang/Object;)Z", "isLockedOrBeingProvided", "maybeCleanup", "refreshRemoveQueue", "releaseLock", "lock", "Lcom/jetbrains/pluginverifier/repository/resources/ResourceLockImpl;", "releaseLock$verifier_repository", "remove", "remove2", "cleanupIfRemoved", "(Ljava/lang/Object;Z)Z", "removeAll", "safeDispose", "(Ljava/lang/Object;Ljava/lang/Object;)V", "toString", "CleanupState", "Fetching", "StorageStatus", "Stored", "verifier-repository"})
@SourceDebugExtension(value={"SMAP\nResourceRepositoryImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ResourceRepositoryImpl.kt\ncom/jetbrains/pluginverifier/repository/resources/ResourceRepositoryImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 LanguageUtils.kt\ncom/jetbrains/plugin/structure/base/utils/LanguageUtilsKt\n*L\n1#1,462:1\n1557#2:463\n1628#2,3:464\n1755#2,3:467\n1611#2,9:470\n1863#2:479\n1864#2:481\n1620#2:482\n1557#2:483\n1628#2,3:484\n2669#2,7:487\n1557#2:494\n1628#2,3:495\n2669#2,7:498\n1#3:480\n70#4,5:505\n*S KotlinDebug\n*F\n+ 1 ResourceRepositoryImpl.kt\ncom/jetbrains/pluginverifier/repository/resources/ResourceRepositoryImpl\n*L\n165#1:463\n165#1:464,3\n165#1:467,3\n318#1:470,9\n318#1:479\n318#1:481\n318#1:482\n401#1:483\n401#1:484,3\n401#1:487,7\n407#1:494\n407#1:495,3\n407#1:498,7\n318#1:480\n454#1:505,5\n*E\n"})
public final class ResourceRepositoryImpl<R, K, W extends ResourceWeight<W>>
implements ResourceRepository<R, K, W> {
    @NotNull
    private final EvictionPolicy<R, K, W> evictionPolicy;
    @NotNull
    private final Clock clock;
    @NotNull
    private final ResourceProvider<K, R> resourceProvider;
    @NotNull
    private final Function1<R, W> weigher;
    @NotNull
    private final Function1<R, Unit> disposer;
    @NotNull
    private final String presentableName;
    @NotNull
    private final Logger logger;
    @NotNull
    private final AtomicLong nextLockId;
    @NotNull
    private final ConcurrentHashMap<K, StorageStatus> storage;
    @NotNull
    private final AtomicReference<W> totalWeight;
    @NotNull
    private final Set<Pair<K, StorageStatus>> removeQueue;
    @NotNull
    private final CleanupState cleanupState;

    public ResourceRepositoryImpl(@NotNull EvictionPolicy<R, K, W> evictionPolicy, @NotNull Clock clock, @NotNull ResourceProvider<? super K, ? extends R> resourceProvider, @NotNull W initialWeight, @NotNull Function1<? super R, ? extends W> weigher, @NotNull Function1<? super R, Unit> disposer, @NotNull String presentableName2) {
        Intrinsics.checkNotNullParameter(evictionPolicy, "evictionPolicy");
        Intrinsics.checkNotNullParameter(clock, "clock");
        Intrinsics.checkNotNullParameter(resourceProvider, "resourceProvider");
        Intrinsics.checkNotNullParameter(initialWeight, "initialWeight");
        Intrinsics.checkNotNullParameter(weigher, "weigher");
        Intrinsics.checkNotNullParameter(disposer, "disposer");
        Intrinsics.checkNotNullParameter(presentableName2, "presentableName");
        this.evictionPolicy = evictionPolicy;
        this.clock = clock;
        this.resourceProvider = resourceProvider;
        this.weigher = weigher;
        this.disposer = disposer;
        this.presentableName = presentableName2;
        Logger logger = LoggerFactory.getLogger(this.presentableName);
        Intrinsics.checkNotNullExpressionValue(logger, "getLogger(presentableName)");
        this.logger = logger;
        this.nextLockId = new AtomicLong();
        this.storage = new ConcurrentHashMap();
        this.totalWeight = new AtomicReference<W>(initialWeight);
        ConcurrentHashMap.KeySetView keySetView = ConcurrentHashMap.newKeySet();
        Intrinsics.checkNotNullExpressionValue(keySetView, "newKeySet()");
        this.removeQueue = keySetView;
        this.cleanupState = new CleanupState();
    }

    public /* synthetic */ ResourceRepositoryImpl(EvictionPolicy evictionPolicy, Clock clock, ResourceProvider resourceProvider, ResourceWeight resourceWeight, Function1 function1, Function1 function12, String string, int n, DefaultConstructorMarker defaultConstructorMarker2) {
        if ((n & 0x40) != 0) {
            string = "ResourceRepository";
        }
        this(evictionPolicy, clock, resourceProvider, resourceWeight, function1, function12, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(@NotNull K key, @NotNull R resource) {
        boolean bl;
        Intrinsics.checkNotNullParameter(key, "key");
        Intrinsics.checkNotNullParameter(resource, "resource");
        try {
            boolean added;
            ResourceWeight weight = (ResourceWeight)this.weigher.invoke(resource);
            ResourceInfo<R, ResourceWeight> resourceInfo = new ResourceInfo<R, ResourceWeight>(resource, weight);
            Instant instant = this.clock.instant();
            Intrinsics.checkNotNullExpressionValue(instant, "clock.instant()");
            StorageStatus previous = this.storage.putIfAbsent(key, new Stored(resourceInfo, new UsageStatistic(instant, 1L)));
            boolean bl2 = added = previous == null;
            if (added) {
                this.totalWeight.accumulateAndGet(weight, ResourceRepositoryImpl::add$lambda$0);
            }
            bl = added;
        }
        finally {
            this.maybeCleanup();
        }
        return bl;
    }

    @Override
    @NotNull
    public Set<K> getAllExistingKeys() {
        return new HashSet(this.storage.keySet());
    }

    @Override
    public boolean has(@NotNull K key) {
        Intrinsics.checkNotNullParameter(key, "key");
        return this.storage.containsKey(key);
    }

    @Override
    public boolean isLockedOrBeingProvided(@NotNull K key) {
        Intrinsics.checkNotNullParameter(key, "key");
        StorageStatus storageStatus = this.storage.get(key);
        if (storageStatus == null) {
            return false;
        }
        StorageStatus value = storageStatus;
        StorageStatus storageStatus2 = value;
        if (storageStatus2 instanceof Fetching) {
            return true;
        }
        if (storageStatus2 instanceof Stored) {
            return ((Stored)value).getLocks$verifier_repository().get() > 0;
        }
        throw new NoWhenBranchMatchedException();
    }

    @Override
    public boolean remove(@NotNull K key) {
        Intrinsics.checkNotNullParameter(key, "key");
        return this.remove2(key, true);
    }

    private final boolean remove2(K key, boolean cleanupIfRemoved) {
        StorageStatus storageStatus = this.storage.get(key);
        if (storageStatus == null) {
            return false;
        }
        StorageStatus value = storageStatus;
        StorageStatus storageStatus2 = value;
        if (storageStatus2 instanceof Fetching) {
            LoggerUtilsKt.debugMaybe(this.logger, new Function0<String>(key){
                final /* synthetic */ K $key;
                {
                    this.$key = $key;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return "remove(" + this.$key + "): the resource is being provided, enqueue for removing later";
                }
            });
            Stored stored = ((Fetching)value).getFetched();
            this.removeQueue.add(TuplesKt.to(key, stored != null ? (StorageStatus)stored : value));
            return false;
        }
        if (storageStatus2 instanceof Stored) {
            int markAsRemoved = ((Stored)value).getLocks$verifier_repository().compareAndExchange(0, -1);
            if (markAsRemoved > 0) {
                LoggerUtilsKt.debugMaybe(this.logger, new Function0<String>(key){
                    final /* synthetic */ K $key;
                    {
                        this.$key = $key;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return "remove(" + this.$key + "): the resource is locked, enqueue for removing later";
                    }
                });
                this.removeQueue.add(TuplesKt.to(key, value));
                return false;
            }
            boolean removedFromStorage = this.storage.remove(key, value);
            if (removedFromStorage) {
                LoggerUtilsKt.debugMaybe(this.logger, new Function0<String>(key){
                    final /* synthetic */ K $key;
                    {
                        this.$key = $key;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return "remove(" + this.$key + "): the resource is not locked, deleting now";
                    }
                });
                ResourceInfo resourceInfo = ((Stored)value).getInfo();
                Intrinsics.checkNotNull(resourceInfo, "null cannot be cast to non-null type com.jetbrains.pluginverifier.repository.resources.ResourceInfo<*, W of com.jetbrains.pluginverifier.repository.resources.ResourceRepositoryImpl>");
                ResourceInfo info = resourceInfo;
                this.totalWeight.accumulateAndGet(info.getWeight(), ResourceRepositoryImpl::remove2$lambda$1);
                Object r = ((Stored)value).getInfo().getResource();
                Intrinsics.checkNotNull(r, "null cannot be cast to non-null type R of com.jetbrains.pluginverifier.repository.resources.ResourceRepositoryImpl");
                this.safeDispose(key, r);
            }
            if (cleanupIfRemoved) {
                this.maybeCleanup();
            }
            return true;
        }
        throw new NoWhenBranchMatchedException();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void removeAll() {
        boolean bl;
        block5: {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = this.getAllExistingKeys();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            Iterator iterator2 = $this$mapTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                void it;
                Object item$iv$iv;
                Object t2 = item$iv$iv = iterator2.next();
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(this.remove2(it, false));
            }
            Iterable $this$any$iv = (List)destination$iv$iv;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    boolean it = (Boolean)element$iv;
                    boolean bl3 = false;
                    if (!it) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
        }
        if (bl) {
            this.cleanup();
        }
    }

    public final void releaseLock$verifier_repository(@NotNull ResourceLockImpl<R, K, W> lock2) {
        Intrinsics.checkNotNullParameter(lock2, "lock");
        LoggerUtilsKt.debugMaybe(this.logger, new Function0<String>(lock2){
            final /* synthetic */ ResourceLockImpl<R, K, W> $lock;
            {
                this.$lock = $lock;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return "releasing lock " + this.$lock;
            }
        });
        K key = lock2.getKey();
        Stored<R, K, W> value = lock2.getValue();
        Pair<K, Stored<R, K, W>> pair = TuplesKt.to(key, value);
        ResourceRepositoryImpl it = this;
        boolean bl = false;
        int value2 = value.getLocks$verifier_repository().decrementAndGet();
        boolean bl2 = value2 > 0;
        boolean hasLocks = bl2;
        if (hasLocks) {
            return;
        }
        this.refreshRemoveQueue();
        if (this.removeQueue.remove(pair)) {
            int markAsRemoved = value.getLocks$verifier_repository().compareAndExchange(0, -1);
            if (markAsRemoved > 0) {
                LoggerUtilsKt.debugMaybe(this.logger, new Function0<String>(key){
                    final /* synthetic */ K $key;
                    {
                        this.$key = $key;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return "remove(" + this.$key + "): the resource is locked, enqueue for removing later";
                    }
                });
                this.removeQueue.add(pair);
                return;
            }
            boolean removed = this.storage.remove(key, value);
            if (removed) {
                LoggerUtilsKt.debugMaybe(this.logger, new Function0<String>(key){
                    final /* synthetic */ K $key;
                    {
                        this.$key = $key;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return "remove(" + this.$key + "): the resource is not locked, deleting now";
                    }
                });
                this.totalWeight.accumulateAndGet(value.getInfo().getWeight(), ResourceRepositoryImpl::releaseLock$lambda$5);
                this.safeDispose(key, value.getInfo().getResource());
            }
        }
    }

    private final void refreshRemoveQueue() {
        for (Pair<K, StorageStatus> pair : this.removeQueue) {
            if (!(pair.getSecond() instanceof Fetching)) continue;
            StorageStatus storageStatus = pair.getSecond();
            Intrinsics.checkNotNull(storageStatus, "null cannot be cast to non-null type com.jetbrains.pluginverifier.repository.resources.ResourceRepositoryImpl.Fetching<*>");
            Stored fetched = ((Fetching)storageStatus).getFetched();
            if (fetched == null) continue;
            this.removeQueue.remove(pair);
            this.removeQueue.add(TuplesKt.to(pair.getFirst(), fetched));
        }
    }

    private final ResourceRepositoryResult<R, W> getOrWait(K key) throws InterruptedException {
        ResourceRepositoryResult resourceRepositoryResult;
        Object provideResult;
        Fetching fetchTask;
        while (true) {
            Object lock2;
            LanguageUtilsKt.checkIfInterrupted();
            StorageStatus value = this.storage.get(key);
            if (value instanceof Stored) {
                Instant now = this.clock.instant();
                long lockId = this.nextLockId.incrementAndGet();
                Intrinsics.checkNotNullExpressionValue(now, "now");
                lock2 = new ResourceLockImpl(now, key, lockId, this, (Stored)value);
                if (!((Stored)value).acquireLock()) continue;
                ((Stored)value).getStatistic().access(now);
                LoggerUtilsKt.debugMaybe(this.logger, new Function0<String>(key, lock2){
                    final /* synthetic */ K $key;
                    final /* synthetic */ ResourceLockImpl<R, K, W> $lock;
                    {
                        this.$key = $key;
                        this.$lock = $lock;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return "get(" + this.$key + "): the resource is available and a lock is registered " + this.$lock;
                    }
                });
                return new ResourceRepositoryResult.Found((ResourceLock)lock2);
            }
            fetchTask = null;
            boolean runInCurrentThread = false;
            if (value instanceof Fetching) {
                LoggerUtilsKt.debugMaybe(this.logger, new Function0<String>(key){
                    final /* synthetic */ K $key;
                    {
                        this.$key = $key;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return "get(" + this.$key + "): waiting for another thread to finish fetching the resource";
                    }
                });
                fetchTask = (Fetching)value;
                runInCurrentThread = false;
            } else {
                boolean bl;
                boolean bl2 = bl = value == null;
                if (_Assertions.ENABLED && !bl) {
                    lock2 = "Assertion failed";
                    throw new AssertionError(lock2);
                }
                LoggerUtilsKt.debugMaybe(this.logger, new Function0<String>(key){
                    final /* synthetic */ K $key;
                    {
                        this.$key = $key;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return "get(" + this.$key + "): fetching the resource in the current thread";
                    }
                });
                Fetching newTask = new Fetching(() -> ResourceRepositoryImpl.getOrWait$lambda$6(this, key));
                if (this.storage.putIfAbsent(key, newTask) != null) continue;
                fetchTask = newTask;
                runInCurrentThread = true;
            }
            if (runInCurrentThread) {
                fetchTask.run();
            }
            try {
                lock2 = (ProvideResult)fetchTask.get();
            }
            catch (CancellationException cancellationException) {
                throw new InterruptedException("Fetch task for " + key + " has been cancelled");
            }
            catch (ExecutionException e) {
                Throwable cause = e.getCause();
                if (cause != null) {
                    throw cause;
                }
                throw new RuntimeException("Failed to fetch result", e);
            }
            provideResult = lock2;
            if (!(provideResult instanceof ProvideResult.Provided)) break;
            ResourceInfo resourceInfo = new ResourceInfo(((ProvideResult.Provided)provideResult).getResource(), (ResourceWeight)this.weigher.invoke(((ProvideResult.Provided)provideResult).getResource()));
            Instant instant = this.clock.instant();
            Intrinsics.checkNotNullExpressionValue(instant, "clock.instant()");
            Stored created = new Stored(resourceInfo, new UsageStatistic(instant, 1L));
            if (!this.storage.replace(key, fetchTask, created)) continue;
            this.totalWeight.accumulateAndGet(created.getInfo().getWeight(), ResourceRepositoryImpl::getOrWait$lambda$7);
            fetchTask.setFetched(created);
            if (!this.removeQueue.remove(TuplesKt.to(key, fetchTask))) continue;
            this.removeQueue.add(TuplesKt.to(key, created));
        }
        this.storage.remove(key, fetchTask);
        Object object = provideResult;
        if (object instanceof ProvideResult.NotFound) {
            resourceRepositoryResult = new ResourceRepositoryResult.NotFound(((ProvideResult.NotFound)provideResult).getReason());
        } else if (object instanceof ProvideResult.Failed) {
            resourceRepositoryResult = new ResourceRepositoryResult.Failed(((ProvideResult.Failed)provideResult).getReason(), ((ProvideResult.Failed)provideResult).getError());
        } else {
            throw new IllegalStateException("Unexpected result type: " + (ProvideResult)provideResult);
        }
        return resourceRepositoryResult;
    }

    private final ProvideResult<R> fetchResource(K key) {
        ProvideResult<R> provideResult = this.resourceProvider.provide(key);
        return provideResult;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<AvailableResource<R, K, W>> getAvailableResources() {
        void $this$mapNotNullTo$iv$iv;
        Set<Map.Entry<K, StorageStatus>> set = this.storage.entrySet();
        Intrinsics.checkNotNullExpressionValue(set, "storage.entries");
        Iterable $this$mapNotNull$iv = set;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            AvailableResource availableResource;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            Map.Entry it = (Map.Entry)element$iv$iv;
            boolean bl2 = false;
            if (it.getValue() instanceof Fetching) {
                availableResource = null;
            } else {
                Object v = it.getValue();
                Intrinsics.checkNotNull(v, "null cannot be cast to non-null type com.jetbrains.pluginverifier.repository.resources.ResourceRepositoryImpl.Stored<R of com.jetbrains.pluginverifier.repository.resources.ResourceRepositoryImpl.getAvailableResources$lambda$8, K of com.jetbrains.pluginverifier.repository.resources.ResourceRepositoryImpl.getAvailableResources$lambda$8, W of com.jetbrains.pluginverifier.repository.resources.ResourceRepositoryImpl.getAvailableResources$lambda$8>");
                Stored value = (Stored)v;
                Pair<Boolean, UsageStatistic> pair = TuplesKt.to(value.getLocks$verifier_repository().get() > 0, UsageStatistic.copy$default(value.getStatistic(), null, 0L, 3, null));
                boolean isLocked = pair.component1();
                UsageStatistic stats = pair.component2();
                availableResource = new AvailableResource(it.getKey(), value.getInfo(), stats, isLocked);
            }
            if (availableResource == null) continue;
            AvailableResource it$iv$iv = availableResource;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cleanup() {
        boolean bl4;
        boolean stop;
        if (this.maybeCleanup()) {
            return;
        }
        int skipped = 0;
        do {
            Lock lock2 = this.cleanupState.getLock();
            lock2.lock();
            try {
                boolean bl2;
                bl4 = false;
                if (this.cleanupState.getRunning()) {
                    this.cleanupState.getCondition().await();
                }
                if (!this.cleanupState.getRunning()) {
                    this.cleanupState.setRunning(true);
                    skipped = this.cleanupState.getSkipped();
                    bl2 = true;
                } else {
                    bl2 = false;
                }
                bl4 = bl2;
            }
            finally {
                lock2.unlock();
            }
        } while (!(stop = bl4));
        try {
            this.doCleanup();
        }
        finally {
            Lock lock3 = this.cleanupState.getLock();
            lock3.lock();
            try {
                boolean bl3 = false;
                this.cleanupState.setRunning(false);
                CleanupState bl4 = this.cleanupState;
                bl4.setSkipped(bl4.getSkipped() - skipped);
                this.cleanupState.getCondition().signalAll();
                Unit unit = Unit.INSTANCE;
            }
            finally {
                lock3.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean maybeCleanup() {
        int n;
        Lock lock2 = this.cleanupState.getLock();
        lock2.lock();
        try {
            n = 0;
            if (this.cleanupState.getRunning()) {
                CleanupState cleanupState = this.cleanupState;
                int n2 = cleanupState.getSkipped();
                cleanupState.setSkipped(n2 + 1);
                boolean bl = false;
                return bl;
            }
            this.cleanupState.setRunning(true);
            n = this.cleanupState.getSkipped();
        }
        finally {
            lock2.unlock();
        }
        int skipped = n;
        try {
            this.doCleanup();
        }
        finally {
            lock2 = this.cleanupState.getLock();
            lock2.lock();
            try {
                boolean bl = false;
                this.cleanupState.setRunning(false);
                CleanupState cleanupState = this.cleanupState;
                cleanupState.setSkipped(cleanupState.getSkipped() - skipped);
                this.cleanupState.getCondition().signalAll();
                Unit unit = Unit.INSTANCE;
            }
            finally {
                lock2.unlock();
            }
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public final void doCleanup() {
        W w = this.totalWeight.get();
        Intrinsics.checkNotNullExpressionValue(w, "totalWeight.get()");
        if (this.evictionPolicy.isNecessary((ResourceWeight)w)) {
            Object acc;
            Collection collection;
            void $this$mapTo$iv$iv;
            List<AvailableResource<R, K, W>> availableResources = this.getAvailableResources();
            Iterable $this$map$iv = availableResources;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                AvailableResource availableResource = (AvailableResource)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getResourceInfo().getWeight());
            }
            Iterable $this$reduce$iv = (List)destination$iv$iv;
            boolean $i$f$reduce = false;
            Iterator iterator$iv = $this$reduce$iv.iterator();
            if (!iterator$iv.hasNext()) {
                throw new UnsupportedOperationException("Empty collection can't be reduced.");
            }
            Object accumulator$iv = iterator$iv.next();
            while (iterator$iv.hasNext()) {
                void weight;
                ResourceWeight $i$f$mapTo2 = (ResourceWeight)iterator$iv.next();
                acc = (ResourceWeight)accumulator$iv;
                boolean bl = false;
                accumulator$iv = acc.plus(weight);
            }
            ResourceWeight totalWeight = (ResourceWeight)accumulator$iv;
            EvictionInfo<R, K, ResourceWeight> evictionInfo = new EvictionInfo<R, K, ResourceWeight>(totalWeight, availableResources);
            List<AvailableResource<R, K, ResourceWeight>> resourcesForEviction = this.evictionPolicy.selectResourcesForEviction(evictionInfo);
            if (!((Collection)resourcesForEviction).isEmpty()) {
                void $this$reduce$iv2;
                void $this$mapTo$iv$iv2;
                Iterable $this$map$iv2 = resourcesForEviction;
                boolean $i$f$map2 = false;
                acc = $this$map$iv2;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv2, 10));
                boolean $i$f$mapTo32 = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                    void it;
                    AvailableResource availableResource = (AvailableResource)item$iv$iv;
                    collection = destination$iv$iv2;
                    boolean bl = false;
                    collection.add(it.getResourceInfo().getWeight());
                }
                $this$map$iv2 = (List)destination$iv$iv2;
                boolean $i$f$reduce2 = false;
                Iterator iterator$iv2 = $this$reduce$iv2.iterator();
                if (!iterator$iv2.hasNext()) {
                    throw new UnsupportedOperationException("Empty collection can't be reduced.");
                }
                Object accumulator$iv2 = iterator$iv2.next();
                while (iterator$iv2.hasNext()) {
                    void weight;
                    ResourceWeight $i$f$mapTo32 = (ResourceWeight)iterator$iv2.next();
                    ResourceWeight acc2 = (ResourceWeight)accumulator$iv2;
                    boolean bl = false;
                    accumulator$iv2 = acc2.plus(weight);
                }
                ResourceWeight disposedTotalWeight = (ResourceWeight)accumulator$iv2;
                LoggerUtilsKt.debugMaybe(this.logger, new Function0<String>(totalWeight, resourcesForEviction, disposedTotalWeight){
                    final /* synthetic */ W $totalWeight;
                    final /* synthetic */ List<AvailableResource<R, K, W>> $resourcesForEviction;
                    final /* synthetic */ W $disposedTotalWeight;
                    {
                        this.$totalWeight = $totalWeight;
                        this.$resourcesForEviction = $resourcesForEviction;
                        this.$disposedTotalWeight = $disposedTotalWeight;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return "It's time to evict unused resources. Total weight: " + this.$totalWeight + ". " + this.$resourcesForEviction.size() + " " + FormatUtilsKt.pluralize("resource", this.$resourcesForEviction.size()) + " will be evicted with total weight " + this.$disposedTotalWeight;
                    }
                });
                for (AvailableResource<R, K, ResourceWeight> resource : resourcesForEviction) {
                    this.remove2(resource.getKey(), false);
                }
            }
        }
    }

    private final void safeDispose(K key, R resource) {
        try {
            LoggerUtilsKt.debugMaybe(this.logger, new Function0<String>(key){
                final /* synthetic */ K $key;
                {
                    this.$key = $key;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return "dispose(" + this.$key + ")";
                }
            });
            this.disposer.invoke(resource);
        }
        catch (Exception e) {
            LanguageUtilsKt.rethrowIfInterrupted(e);
            this.logger.error("unable to dispose the resource " + resource, e);
        }
    }

    @Override
    @NotNull
    public ResourceRepositoryResult<R, W> get(@NotNull K key) throws InterruptedException {
        Intrinsics.checkNotNullParameter(key, "key");
        ResourceRepositoryResult<R, W> result2 = this.getOrWait(key);
        Object object = result2 instanceof ResourceRepositoryResult.Found ? (ResourceRepositoryResult.Found)result2 : null;
        if (object != null && (object = ((ResourceRepositoryResult.Found)object).getLockedResource()) != null) {
            Closeable $this$closeOnException$iv = (Closeable)object;
            boolean $i$f$closeOnException = false;
            try {
                ResourceLock it = (ResourceLock)$this$closeOnException$iv;
                boolean bl = false;
                this.maybeCleanup();
            }
            catch (Throwable e$iv) {
                LanguageUtilsKt.closeLogged($this$closeOnException$iv);
                throw e$iv;
            }
        }
        return result2;
    }

    @NotNull
    public String toString() {
        return this.presentableName;
    }

    private static final ResourceWeight add$lambda$0(ResourceWeight acc, ResourceWeight weight) {
        Intrinsics.checkNotNullExpressionValue(weight, "weight");
        return acc.plus(weight);
    }

    private static final ResourceWeight remove2$lambda$1(ResourceWeight acc, ResourceWeight weight) {
        Intrinsics.checkNotNullExpressionValue(weight, "weight");
        return acc.minus(weight);
    }

    private static final ResourceWeight releaseLock$lambda$5(ResourceWeight acc, ResourceWeight weight) {
        Intrinsics.checkNotNullExpressionValue(weight, "weight");
        return acc.minus(weight);
    }

    private static final ProvideResult getOrWait$lambda$6(ResourceRepositoryImpl this$0, Object $key) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($key, "$key");
        return this$0.fetchResource($key);
    }

    private static final ResourceWeight getOrWait$lambda$7(ResourceWeight acc, ResourceWeight weight) {
        Intrinsics.checkNotNullExpressionValue(weight, "weight");
        return acc.plus(weight);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0017"}, d2={"Lcom/jetbrains/pluginverifier/repository/resources/ResourceRepositoryImpl$CleanupState;", "", "()V", "condition", "Ljava/util/concurrent/locks/Condition;", "getCondition", "()Ljava/util/concurrent/locks/Condition;", "lock", "Ljava/util/concurrent/locks/ReentrantLock;", "getLock", "()Ljava/util/concurrent/locks/ReentrantLock;", "running", "", "getRunning", "()Z", "setRunning", "(Z)V", "skipped", "", "getSkipped", "()I", "setSkipped", "(I)V", "verifier-repository"})
    private static final class CleanupState {
        @NotNull
        private final ReentrantLock lock = new ReentrantLock();
        @NotNull
        private final Condition condition;
        private boolean running;
        private int skipped;

        public CleanupState() {
            Condition condition = this.lock.newCondition();
            Intrinsics.checkNotNullExpressionValue(condition, "lock.newCondition()");
            this.condition = condition;
        }

        @NotNull
        public final ReentrantLock getLock() {
            return this.lock;
        }

        @NotNull
        public final Condition getCondition() {
            return this.condition;
        }

        public final boolean getRunning() {
            return this.running;
        }

        public final void setRunning(boolean bl) {
            this.running = bl;
        }

        public final int getSkipped() {
            return this.skipped;
        }

        public final void setSkipped(int n) {
            this.skipped = n;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000*\b\b\u0003\u0010\u0001*\u00020\u00022\u00020\u00032\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u00050\u0004B\u0019\u0012\u0012\u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00030\u00050\u0007\u00a2\u0006\u0002\u0010\bJ\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0002H\u0096\u0002R*\u0010\t\u001a\u0012\u0012\u0004\u0012\u00028\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/pluginverifier/repository/resources/ResourceRepositoryImpl$Fetching;", "R", "", "Lcom/jetbrains/pluginverifier/repository/resources/ResourceRepositoryImpl$StorageStatus;", "Ljava/util/concurrent/FutureTask;", "Lcom/jetbrains/pluginverifier/repository/provider/ProvideResult;", "callable", "Ljava/util/concurrent/Callable;", "(Ljava/util/concurrent/Callable;)V", "fetched", "Lcom/jetbrains/pluginverifier/repository/resources/ResourceRepositoryImpl$Stored;", "getFetched", "()Lcom/jetbrains/pluginverifier/repository/resources/ResourceRepositoryImpl$Stored;", "setFetched", "(Lcom/jetbrains/pluginverifier/repository/resources/ResourceRepositoryImpl$Stored;)V", "equals", "", "other", "verifier-repository"})
    public static final class Fetching<R>
    extends FutureTask<ProvideResult<? extends R>>
    implements StorageStatus {
        @Nullable
        private volatile Stored<R, ?, ?> fetched;

        public Fetching(@NotNull Callable<ProvideResult<R>> callable) {
            Intrinsics.checkNotNullParameter(callable, "callable");
            super(callable);
        }

        @Nullable
        public final Stored<R, ?, ?> getFetched() {
            return this.fetched;
        }

        public final void setFetched(@Nullable Stored<R, ?, ?> stored) {
            this.fetched = stored;
        }

        public boolean equals(@Nullable Object other) {
            return this == other;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bv\u0018\u00002\u00020\u0001\u0082\u0001\u0002\u0002\u0003\u00a8\u0006\u0004\u00c0\u0006\u0003"}, d2={"Lcom/jetbrains/pluginverifier/repository/resources/ResourceRepositoryImpl$StorageStatus;", "", "Lcom/jetbrains/pluginverifier/repository/resources/ResourceRepositoryImpl$Fetching;", "Lcom/jetbrains/pluginverifier/repository/resources/ResourceRepositoryImpl$Stored;", "verifier-repository"})
    public static interface StorageStatus {
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000*\b\b\u0003\u0010\u0001*\u00020\u0002*\b\b\u0004\u0010\u0003*\u00020\u0002*\u000e\b\u0005\u0010\u0004*\b\u0012\u0004\u0012\u0002H\u00040\u00052\u00020\u0006B!\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00028\u0003\u0012\u0004\u0012\u00028\u00050\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0006\u0010\u0014\u001a\u00020\u0015J\u0013\u0010\u0016\u001a\u00020\u00152\b\u0010\u0017\u001a\u0004\u0018\u00010\u0002H\u0096\u0002R\u001d\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00028\u0003\u0012\u0004\u0012\u00028\u00050\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0018"}, d2={"Lcom/jetbrains/pluginverifier/repository/resources/ResourceRepositoryImpl$Stored;", "R", "", "K", "W", "Lcom/jetbrains/pluginverifier/repository/resources/ResourceWeight;", "Lcom/jetbrains/pluginverifier/repository/resources/ResourceRepositoryImpl$StorageStatus;", "info", "Lcom/jetbrains/pluginverifier/repository/resources/ResourceInfo;", "statistic", "Lcom/jetbrains/pluginverifier/repository/cleanup/UsageStatistic;", "(Lcom/jetbrains/pluginverifier/repository/resources/ResourceInfo;Lcom/jetbrains/pluginverifier/repository/cleanup/UsageStatistic;)V", "getInfo", "()Lcom/jetbrains/pluginverifier/repository/resources/ResourceInfo;", "locks", "Ljava/util/concurrent/atomic/AtomicInteger;", "getLocks$verifier_repository", "()Ljava/util/concurrent/atomic/AtomicInteger;", "getStatistic", "()Lcom/jetbrains/pluginverifier/repository/cleanup/UsageStatistic;", "acquireLock", "", "equals", "other", "verifier-repository"})
    public static final class Stored<R, K, W extends ResourceWeight<W>>
    implements StorageStatus {
        @NotNull
        private final ResourceInfo<R, W> info;
        @NotNull
        private final UsageStatistic statistic;
        @NotNull
        private final AtomicInteger locks;

        public Stored(@NotNull ResourceInfo<? extends R, W> info, @NotNull UsageStatistic statistic) {
            Intrinsics.checkNotNullParameter(info, "info");
            Intrinsics.checkNotNullParameter(statistic, "statistic");
            this.info = info;
            this.statistic = statistic;
            this.locks = new AtomicInteger();
        }

        @NotNull
        public final ResourceInfo<R, W> getInfo() {
            return this.info;
        }

        @NotNull
        public final UsageStatistic getStatistic() {
            return this.statistic;
        }

        @NotNull
        public final AtomicInteger getLocks$verifier_repository() {
            return this.locks;
        }

        public boolean equals(@Nullable Object other) {
            return this == other;
        }

        public final boolean acquireLock() {
            int count;
            do {
                if ((count = this.locks.get()) != -1) continue;
                return false;
            } while (!this.locks.compareAndSet(count, count + 1));
            return true;
        }
    }
}

