/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.pluginverifier.repository.repositories.marketplace;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.jetbrains.plugin.structure.intellij.version.IdeVersion;
import com.jetbrains.pluginverifier.repository.PluginRepository;
import com.jetbrains.pluginverifier.repository.repositories.marketplace.MarketplaceRepository;
import com.jetbrains.pluginverifier.repository.repositories.marketplace.UpdateInfo;
import com.jetbrains.pluginverifier.repository.repositories.tracing.LoggingAndTracingPluginRepositoryKt;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.intellij.pluginRepository.PluginManager;
import org.jetbrains.intellij.pluginRepository.PluginRepositoryException;
import org.jetbrains.intellij.pluginRepository.PluginRepositoryFactory;
import org.jetbrains.intellij.pluginRepository.model.IntellijUpdateMetadata;
import org.jetbrains.intellij.pluginRepository.model.PluginBean;
import org.jetbrains.intellij.pluginRepository.model.PluginUpdateBean;
import org.jetbrains.intellij.pluginRepository.model.UpdateBean;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0012\u0018\u0000 D2\u00020\u0001:\u0005DEFGHB\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010!\u001a\u00020\u000b2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020 H\u0002J\u0016\u0010%\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00102\u0006\u0010$\u001a\u00020\u0017H\u0016J\u0010\u0010&\u001a\u00020\u00032\u0006\u0010$\u001a\u00020 H\u0002J\u0012\u0010'\u001a\u0004\u0018\u00010\u000b2\u0006\u0010(\u001a\u00020\tH\u0002J\u0010\u0010)\u001a\u00020\u00032\u0006\u0010*\u001a\u00020 H\u0002J\u0016\u0010+\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00102\u0006\u0010,\u001a\u00020-H\u0016J\u001a\u0010.\u001a\u0004\u0018\u00010\u000b2\u0006\u0010,\u001a\u00020-2\u0006\u0010$\u001a\u00020\u0017H\u0016J\u0012\u0010/\u001a\u0004\u0018\u00010\u000b2\u0006\u0010(\u001a\u00020\tH\u0002J\u0012\u00100\u001a\u0004\u0018\u0001012\u0006\u0010$\u001a\u00020\u0017H\u0002J\u0014\u00102\u001a\b\u0012\u0004\u0012\u00020\u00170\u00102\u0006\u0010$\u001a\u00020\u0017J\u0010\u00103\u001a\u0004\u0018\u00010\u000b2\u0006\u0010*\u001a\u00020 J,\u00104\u001a\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020\u000b052\u0018\u00106\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020 070\u0010J \u00108\u001a\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020\u000b052\f\u00109\u001a\b\u0012\u0004\u0012\u00020 0\u0010J\u0017\u0010:\u001a\u0004\u0018\u00010 2\u0006\u0010*\u001a\u00020 H\u0002\u00a2\u0006\u0002\u0010;J \u0010<\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00102\u0006\u0010=\u001a\u00020\u00172\b\u0010,\u001a\u0004\u0018\u00010-H\u0016J\u0014\u0010>\u001a\u0004\u0018\u00010\u00032\b\u0010?\u001a\u0004\u0018\u00010\u0017H\u0002J\b\u0010@\u001a\u00020\u0017H\u0016J\u0010\u0010A\u001a\u0004\u0018\u00010\u0017*\u0004\u0018\u00010-H\u0002J\u0010\u0010B\u001a\u0004\u0018\u00010-*\u0004\u0018\u00010\u0017H\u0002J\f\u0010C\u001a\u00020\t*\u00020\u000bH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000Rf\u0010\f\u001aZ\u0012\f\u0012\n \u000f*\u0004\u0018\u00010\u000e0\u000e\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\u0011 \u000f*\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u00100\u0010 \u000f*,\u0012\f\u0012\n \u000f*\u0004\u0018\u00010\u000e0\u000e\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\u0011 \u000f*\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u00100\u0010\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000Rf\u0010\u0012\u001aZ\u0012\f\u0012\n \u000f*\u0004\u0018\u00010\u00130\u0013\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\t \u000f*\n\u0012\u0004\u0012\u00020\t\u0018\u00010\u00100\u0010 \u000f*,\u0012\f\u0012\n \u000f*\u0004\u0018\u00010\u00130\u0013\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\t \u000f*\n\u0012\u0004\u0012\u00020\t\u0018\u00010\u00100\u0010\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\u00020\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bRN\u0010\u001c\u001aB\u0012\f\u0012\n \u000f*\u0004\u0018\u00010\u00170\u0017\u0012\f\u0012\n \u000f*\u0004\u0018\u00010\u001d0\u001d \u000f* \u0012\f\u0012\n \u000f*\u0004\u0018\u00010\u00170\u0017\u0012\f\u0012\n \u000f*\u0004\u0018\u00010\u001d0\u001d\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020 0\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006I"}, d2={"Lcom/jetbrains/pluginverifier/repository/repositories/marketplace/MarketplaceRepository;", "Lcom/jetbrains/pluginverifier/repository/PluginRepository;", "repositoryURL", "Ljava/net/URL;", "(Ljava/net/URL;)V", "ideVersionInterner", "Lcom/jetbrains/pluginverifier/repository/repositories/marketplace/MarketplaceRepository$IdeVersionInterner;", "metadataCache", "Lcom/github/benmanes/caffeine/cache/LoadingCache;", "Lcom/jetbrains/pluginverifier/repository/repositories/marketplace/MarketplaceRepository$MarketplaceUpdate;", "Ljava/util/Optional;", "Lcom/jetbrains/pluginverifier/repository/repositories/marketplace/UpdateInfo;", "modulesForPluginCache", "Lcom/github/benmanes/caffeine/cache/Cache;", "Lcom/jetbrains/pluginverifier/repository/repositories/marketplace/MarketplaceRepository$ModuleAndVersion;", "kotlin.jvm.PlatformType", "", "Lorg/jetbrains/intellij/pluginRepository/model/UpdateBean;", "pluginMetadataCache", "Lcom/jetbrains/pluginverifier/repository/repositories/marketplace/MarketplaceRepository$PluginAndVersion;", "pluginRepositoryInstance", "Lorg/jetbrains/intellij/pluginRepository/PluginRepository;", "presentableName", "", "getPresentableName", "()Ljava/lang/String;", "getRepositoryURL", "()Ljava/net/URL;", "unavailablePluginIdentifiers", "", "updateIdToPluginIdMapping", "Ljava/util/concurrent/ConcurrentHashMap;", "", "createAndCacheUpdateInfo", "metadata", "Lorg/jetbrains/intellij/pluginRepository/model/IntellijUpdateMetadata;", "pluginId", "getAllVersionsOfPlugin", "getBrowserUrl", "getCachedInfo", "marketplaceUpdate", "getDownloadUrl", "updateId", "getLastCompatiblePlugins", "ideVersion", "Lcom/jetbrains/plugin/structure/intellij/version/IdeVersion;", "getLastCompatibleVersionOfPlugin", "getOrRequestInfo", "getPluginByXmlId", "Lorg/jetbrains/intellij/pluginRepository/model/PluginBean;", "getPluginChannels", "getPluginInfoByUpdateId", "getPluginInfosForManyPluginIdsAndUpdateIds", "", "pluginAndUpdateIds", "Lkotlin/Pair;", "getPluginInfosForManyUpdateIds", "updateIds", "getPluginIntIdByUpdateId", "(I)Ljava/lang/Integer;", "getPluginsDeclaringModule", "moduleId", "parseSourceCodeUrl", "url", "toString", "intern", "prepareIdeVersion", "toMarketplaceUpdate", "Companion", "IdeVersionInterner", "MarketplaceUpdate", "ModuleAndVersion", "PluginAndVersion", "verifier-repository"})
@SourceDebugExtension(value={"SMAP\nMarketplaceRepository.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MarketplaceRepository.kt\ncom/jetbrains/pluginverifier/repository/repositories/marketplace/MarketplaceRepository\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,265:1\n1557#2:266\n1628#2,3:267\n1557#2:271\n1628#2,3:272\n1557#2:275\n1628#2,3:276\n1216#2,2:279\n1246#2,4:281\n1#3:270\n*S KotlinDebug\n*F\n+ 1 MarketplaceRepository.kt\ncom/jetbrains/pluginverifier/repository/repositories/marketplace/MarketplaceRepository\n*L\n59#1:266\n59#1:267,3\n83#1:271\n83#1:272,3\n111#1:275\n111#1:276,3\n200#1:279,2\n200#1:281,4\n*E\n"})
public final class MarketplaceRepository
implements PluginRepository {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final URL repositoryURL;
    @NotNull
    private final org.jetbrains.intellij.pluginRepository.PluginRepository pluginRepositoryInstance;
    @NotNull
    private final ConcurrentHashMap<Integer, Integer> updateIdToPluginIdMapping;
    @NotNull
    private final LoadingCache<MarketplaceUpdate, Optional<UpdateInfo>> metadataCache;
    private final Cache<String, Boolean> unavailablePluginIdentifiers;
    private final Cache<PluginAndVersion, List<MarketplaceUpdate>> pluginMetadataCache;
    private final Cache<ModuleAndVersion, List<UpdateBean>> modulesForPluginCache;
    @NotNull
    private final IdeVersionInterner ideVersionInterner;
    @NotNull
    private static final URL DEFAULT_URL = new URL("https://plugins.jetbrains.com");
    private static final int MAX_AVAILABLE_PLUGINS_IN_REPOSITORY = 10000;

    public MarketplaceRepository(@NotNull URL repositoryURL) {
        Intrinsics.checkNotNullParameter(repositoryURL, "repositoryURL");
        this.repositoryURL = repositoryURL;
        String string = this.repositoryURL.toExternalForm();
        Intrinsics.checkNotNullExpressionValue(string, "repositoryURL.toExternalForm()");
        this.pluginRepositoryInstance = LoggingAndTracingPluginRepositoryKt.withLogging(PluginRepositoryFactory.create$default(string, null, null, 6, null));
        this.updateIdToPluginIdMapping = new ConcurrentHashMap();
        LoadingCache<Object, Optional> loadingCache = Caffeine.newBuilder().expireAfterWrite(5L, TimeUnit.MINUTES).build(arg_0 -> MarketplaceRepository.metadataCache$lambda$0(metadataCache.1.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue(loadingCache, "newBuilder()\n    .expire\u2026   Optional.empty()\n    }");
        this.metadataCache = loadingCache;
        this.unavailablePluginIdentifiers = Caffeine.newBuilder().build();
        this.pluginMetadataCache = Caffeine.newBuilder().maximumSize(512L).expireAfterAccess(5L, TimeUnit.MINUTES).build();
        this.modulesForPluginCache = Caffeine.newBuilder().maximumSize(512L).expireAfterAccess(5L, TimeUnit.MINUTES).build();
        this.ideVersionInterner = new IdeVersionInterner();
    }

    public /* synthetic */ MarketplaceRepository(URL uRL, int n, DefaultConstructorMarker defaultConstructorMarker2) {
        if ((n & 1) != 0) {
            uRL = DEFAULT_URL;
        }
        this(uRL);
    }

    @NotNull
    public final URL getRepositoryURL() {
        return this.repositoryURL;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<UpdateInfo> getLastCompatiblePlugins(@NotNull IdeVersion ideVersion) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(ideVersion, "ideVersion");
        PluginManager pluginManager = this.pluginRepositoryInstance.getPluginManager();
        String string = ideVersion.asString();
        Intrinsics.checkNotNullExpressionValue(string, "ideVersion.asString()");
        List pluginsXmlIds = PluginManager.DefaultImpls.getCompatiblePluginsXmlIds$default(pluginManager, string, 10000, 0, null, 8, null);
        String string2 = ideVersion.asString();
        Intrinsics.checkNotNullExpressionValue(string2, "ideVersion.asString()");
        List updates = PluginManager.DefaultImpls.searchCompatibleUpdates$default(pluginManager, pluginsXmlIds, string2, "", null, 8, null);
        Iterable $this$map$iv = updates;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            UpdateBean updateBean = (UpdateBean)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(TuplesKt.to(it.getPluginId(), it.getId()));
        }
        List pluginIdAndUpdateIds = (List)destination$iv$iv;
        return CollectionsKt.toList((Iterable)this.getPluginInfosForManyPluginIdsAndUpdateIds(pluginIdAndUpdateIds).values());
    }

    @Override
    @Nullable
    public UpdateInfo getLastCompatibleVersionOfPlugin(@NotNull IdeVersion ideVersion, @NotNull String pluginId) {
        UpdateInfo updateInfo2;
        Intrinsics.checkNotNullParameter(ideVersion, "ideVersion");
        Intrinsics.checkNotNullParameter(pluginId, "pluginId");
        PluginAndVersion pluginAndVersion = new PluginAndVersion(pluginId, this.intern(ideVersion));
        List list = this.pluginMetadataCache.get(pluginAndVersion, arg_0 -> MarketplaceRepository.getLastCompatibleVersionOfPlugin$lambda$2(new Function1<PluginAndVersion, List<? extends MarketplaceUpdate>>(this, pluginId, ideVersion){
            final /* synthetic */ MarketplaceRepository this$0;
            final /* synthetic */ String $pluginId;
            final /* synthetic */ IdeVersion $ideVersion;
            {
                this.this$0 = $receiver;
                this.$pluginId = $pluginId;
                this.$ideVersion = $ideVersion;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final List<MarketplaceUpdate> invoke(PluginAndVersion it) {
                void $this$mapTo$iv$iv;
                PluginManager pluginManager = MarketplaceRepository.access$getPluginRepositoryInstance$p(this.this$0).getPluginManager();
                List<String> list = CollectionsKt.listOf(this.$pluginId);
                String string = this.$ideVersion.asString();
                Intrinsics.checkNotNullExpressionValue(string, "ideVersion.asString()");
                Iterable $this$map$iv = PluginManager.DefaultImpls.searchCompatibleUpdates$default(pluginManager, list, string, null, null, 12, null);
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it2;
                    UpdateBean updateBean = (UpdateBean)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(new MarketplaceUpdate(it2.getPluginId(), it2.getId()));
                }
                return (List)destination$iv$iv;
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue(list, "override fun getLastComp\u2026etOrRequestInfo(it) }\n  }");
        List compatibleUpdates2 = list;
        MarketplaceUpdate marketplaceUpdate = (MarketplaceUpdate)CollectionsKt.firstOrNull(compatibleUpdates2);
        if (marketplaceUpdate != null) {
            MarketplaceUpdate it = marketplaceUpdate;
            boolean bl = false;
            updateInfo2 = this.getOrRequestInfo(it);
        } else {
            updateInfo2 = null;
        }
        return updateInfo2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<UpdateInfo> getAllVersionsOfPlugin(@NotNull String pluginId) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(pluginId, "pluginId");
        if (this.unavailablePluginIdentifiers.getIfPresent(pluginId) != null) {
            return CollectionsKt.emptyList();
        }
        PluginBean pluginBean = this.getPluginByXmlId(pluginId);
        if (pluginBean == null) {
            this.unavailablePluginIdentifiers.put(pluginId, true);
            return CollectionsKt.emptyList();
        }
        List<UpdateBean> pluginVersions = this.pluginRepositoryInstance.getPluginManager().getPluginVersions(pluginBean.getId());
        Iterable $this$map$iv = pluginVersions;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            UpdateBean updateBean = (UpdateBean)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(TuplesKt.to(pluginBean.getId(), it.getId()));
        }
        List pluginIdAndUpdateIds = (List)destination$iv$iv;
        return CollectionsKt.toList((Iterable)this.getPluginInfosForManyPluginIdsAndUpdateIds(pluginIdAndUpdateIds).values());
    }

    private final PluginBean getPluginByXmlId(String pluginId) {
        PluginBean pluginBean;
        try {
            pluginBean = PluginManager.DefaultImpls.getPluginByXmlId$default(this.pluginRepositoryInstance.getPluginManager(), pluginId, null, 2, null);
        }
        catch (PluginRepositoryException e) {
            String string = e.getMessage();
            if (!(string != null ? StringsKt.contains$default((CharSequence)string, "\"statusCode\":403", false, 2, null) : false)) {
                throw e;
            }
            pluginBean = null;
        }
        return pluginBean;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<UpdateInfo> getPluginsDeclaringModule(@NotNull String moduleId, @Nullable IdeVersion ideVersion) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(moduleId, "moduleId");
        ModuleAndVersion moduleAndVersion = new ModuleAndVersion(moduleId, this.intern(ideVersion));
        List plugins2 = this.modulesForPluginCache.get(moduleAndVersion, arg_0 -> MarketplaceRepository.getPluginsDeclaringModule$lambda$5(new Function1<ModuleAndVersion, List<? extends UpdateBean>>(this, ideVersion, moduleId){
            final /* synthetic */ MarketplaceRepository this$0;
            final /* synthetic */ IdeVersion $ideVersion;
            final /* synthetic */ String $moduleId;
            {
                this.this$0 = $receiver;
                this.$ideVersion = $ideVersion;
                this.$moduleId = $moduleId;
                super(1);
            }

            public final List<UpdateBean> invoke(ModuleAndVersion it) {
                PluginManager pluginManager = MarketplaceRepository.access$getPluginRepositoryInstance$p(this.this$0).getPluginManager();
                IdeVersion ideVersion = this.$ideVersion;
                String string = ideVersion != null ? ideVersion.asString() : null;
                if (string == null) {
                    string = "";
                }
                String string2 = string;
                return PluginManager.DefaultImpls.searchCompatibleUpdates$default(pluginManager, null, string2, null, this.$moduleId, 5, null);
            }
        }, arg_0));
        if (plugins2.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        Intrinsics.checkNotNullExpressionValue(plugins2, "plugins");
        Iterable $this$map$iv = plugins2;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            UpdateBean updateBean = (UpdateBean)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(TuplesKt.to(it.getPluginId(), it.getId()));
        }
        List pluginIdAndUpdateIds = (List)destination$iv$iv;
        return CollectionsKt.toList((Iterable)this.getPluginInfosForManyPluginIdsAndUpdateIds(pluginIdAndUpdateIds).values());
    }

    private final UpdateInfo createAndCacheUpdateInfo(IntellijUpdateMetadata metadata2, int pluginId) {
        UpdateInfo updateInfo2 = new UpdateInfo(metadata2.getXmlId(), metadata2.getName(), metadata2.getVersion(), this.prepareIdeVersion(metadata2.getSince()), this.prepareIdeVersion(metadata2.getUntil()), metadata2.getVendor(), this.parseSourceCodeUrl(metadata2.getSourceCodeUrl()), this.getDownloadUrl(metadata2.getId()), metadata2.getId(), this.getBrowserUrl(pluginId), metadata2.getTags(), pluginId);
        Integer n = pluginId;
        ((Map)this.updateIdToPluginIdMapping).put(updateInfo2.getUpdateId(), n);
        this.metadataCache.put(this.toMarketplaceUpdate(updateInfo2), Optional.of(updateInfo2));
        return updateInfo2;
    }

    private final Integer getPluginIntIdByUpdateId(int updateId) {
        Integer n = this.updateIdToPluginIdMapping.get(updateId);
        if (n != null) {
            Integer it = n;
            boolean bl = false;
            return it;
        }
        PluginUpdateBean pluginUpdateBean = this.pluginRepositoryInstance.getPluginUpdateManager().getUpdateById(updateId);
        if (pluginUpdateBean == null) {
            return null;
        }
        PluginUpdateBean pluginUpdateBean2 = pluginUpdateBean;
        int pluginId = pluginUpdateBean2.getPluginId();
        Integer n2 = updateId;
        Integer n3 = pluginId;
        ((Map)this.updateIdToPluginIdMapping).put(n2, n3);
        return pluginId;
    }

    @Nullable
    public final UpdateInfo getPluginInfoByUpdateId(int updateId) {
        Integer n = this.getPluginIntIdByUpdateId(updateId);
        if (n == null) {
            return null;
        }
        int pluginId = n;
        return this.getOrRequestInfo(new MarketplaceUpdate(pluginId, updateId));
    }

    private final UpdateInfo getCachedInfo(MarketplaceUpdate marketplaceUpdate) {
        Optional<UpdateInfo> optional = this.metadataCache.get(marketplaceUpdate);
        if (optional.isPresent()) {
            return optional.get();
        }
        return null;
    }

    private final UpdateInfo getOrRequestInfo(MarketplaceUpdate marketplaceUpdate) {
        UpdateInfo cachedInfo = this.getCachedInfo(marketplaceUpdate);
        if (cachedInfo != null) {
            return cachedInfo;
        }
        int pluginId = marketplaceUpdate.component1();
        int updateId = marketplaceUpdate.component2();
        IntellijUpdateMetadata intellijUpdateMetadata = this.pluginRepositoryInstance.getPluginUpdateManager().getIntellijUpdateMetadata(pluginId, updateId);
        if (intellijUpdateMetadata == null) {
            return null;
        }
        IntellijUpdateMetadata updateMetadata = intellijUpdateMetadata;
        return this.createAndCacheUpdateInfo(updateMetadata, pluginId);
    }

    @NotNull
    public final Map<Integer, UpdateInfo> getPluginInfosForManyUpdateIds(@NotNull List<Integer> updateIds) {
        Intrinsics.checkNotNullParameter(updateIds, "updateIds");
        ArrayList pluginAndUpdateIds = new ArrayList();
        Iterator<Integer> iterator2 = updateIds.iterator();
        while (iterator2.hasNext()) {
            int updateId = ((Number)iterator2.next()).intValue();
            Integer pluginId = this.getPluginIntIdByUpdateId(updateId);
            if (pluginId == null) continue;
            ((Collection)pluginAndUpdateIds).add(TuplesKt.to(pluginId, updateId));
        }
        return this.getPluginInfosForManyPluginIdsAndUpdateIds(pluginAndUpdateIds);
    }

    @NotNull
    public final List<String> getPluginChannels(@NotNull String pluginId) {
        Intrinsics.checkNotNullParameter(pluginId, "pluginId");
        PluginBean pluginBean = this.getPluginByXmlId(pluginId);
        if (pluginBean == null) {
            return CollectionsKt.emptyList();
        }
        PluginBean pluginBean2 = pluginBean;
        return this.pluginRepositoryInstance.getPluginManager().getPluginChannels(pluginBean2.getId());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<Integer, UpdateInfo> getPluginInfosForManyPluginIdsAndUpdateIds(@NotNull List<Pair<Integer, Integer>> pluginAndUpdateIds) {
        Intrinsics.checkNotNullParameter(pluginAndUpdateIds, "pluginAndUpdateIds");
        ArrayList toRequest = new ArrayList();
        HashMap result2 = new HashMap();
        for (Pair<Integer, Integer> pair : pluginAndUpdateIds) {
            int updateId;
            int pluginId = ((Number)pair.component1()).intValue();
            UpdateInfo cachedInfo = this.getCachedInfo(new MarketplaceUpdate(pluginId, updateId = ((Number)pair.component2()).intValue()));
            if (cachedInfo != null) {
                Integer n = updateId;
                ((Map)result2).put(n, cachedInfo);
                continue;
            }
            ((Collection)toRequest).add(TuplesKt.to(pluginId, updateId));
        }
        if (!((Collection)toRequest).isEmpty()) {
            void $this$associateByTo$iv$iv;
            Map<Integer, IntellijUpdateMetadata> metadataBatch = this.pluginRepositoryInstance.getPluginUpdateManager().getIntellijUpdateMetadataBatch(toRequest);
            Iterable $this$associateBy$iv = toRequest;
            boolean $i$f$associateBy = false;
            int capacity$iv = RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associateBy$iv, 10)), 16);
            Iterable iterable = $this$associateBy$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                Pair pair = (Pair)element$iv$iv;
                Map map = destination$iv$iv;
                boolean bl = false;
                Pair it = (Pair)element$iv$iv;
                Integer n = ((Number)it.getSecond()).intValue();
                boolean bl2 = false;
                Integer n2 = ((Number)it.getFirst()).intValue();
                map.put(n, n2);
            }
            Map updateIdToPluginId = destination$iv$iv;
            for (Map.Entry<Integer, IntellijUpdateMetadata> entry : metadataBatch.entrySet()) {
                int updateId = ((Number)entry.getKey()).intValue();
                IntellijUpdateMetadata metadata2 = entry.getValue();
                int pluginId = ((Number)MapsKt.getValue(updateIdToPluginId, updateId)).intValue();
                Integer n = updateId;
                ((Map)result2).put(n, this.createAndCacheUpdateInfo(metadata2, pluginId));
            }
        }
        return result2;
    }

    private final URL getBrowserUrl(int pluginId) {
        String string = this.repositoryURL.toExternalForm();
        Intrinsics.checkNotNullExpressionValue(string, "repositoryURL.toExternalForm()");
        char[] cArray = new char[]{'/'};
        return new URL(StringsKt.trimEnd(string, cArray) + "/plugin/" + pluginId);
    }

    private final URL getDownloadUrl(int updateId) {
        String string = this.repositoryURL.toExternalForm();
        Intrinsics.checkNotNullExpressionValue(string, "repositoryURL.toExternalForm()");
        char[] cArray = new char[]{'/'};
        return new URL(StringsKt.trimEnd(string, cArray) + "/plugin/download/?noStatistic=true&updateId=" + updateId);
    }

    private final IdeVersion prepareIdeVersion(String $this$prepareIdeVersion) {
        return $this$prepareIdeVersion == null || Intrinsics.areEqual($this$prepareIdeVersion, "") || Intrinsics.areEqual($this$prepareIdeVersion, "0.0") ? null : IdeVersion.createIdeVersionIfValid($this$prepareIdeVersion);
    }

    private final URL parseSourceCodeUrl(String url) {
        Object object = url;
        if (object == null || StringsKt.isBlank((CharSequence)object)) {
            return null;
        }
        try {
            object = new URL(url);
        }
        catch (MalformedURLException malformedURLException) {
            object = null;
        }
        return object;
    }

    private final MarketplaceUpdate toMarketplaceUpdate(UpdateInfo $this$toMarketplaceUpdate) {
        return new MarketplaceUpdate($this$toMarketplaceUpdate.getPluginIntId(), $this$toMarketplaceUpdate.getUpdateId());
    }

    @Override
    @NotNull
    public String getPresentableName() {
        return "JetBrains Marketplace " + this.repositoryURL.toExternalForm();
    }

    @NotNull
    public String toString() {
        return this.getPresentableName();
    }

    private final String intern(IdeVersion $this$intern) {
        return this.ideVersionInterner.intern($this$intern);
    }

    private static final Optional metadataCache$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        return (Optional)$tmp0.invoke(p0);
    }

    private static final List getLastCompatibleVersionOfPlugin$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        return (List)$tmp0.invoke(p0);
    }

    private static final List getPluginsDeclaringModule$lambda$5(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        return (List)$tmp0.invoke(p0);
    }

    public MarketplaceRepository() {
        this(null, 1, null);
    }

    public static final /* synthetic */ org.jetbrains.intellij.pluginRepository.PluginRepository access$getPluginRepositoryInstance$p(MarketplaceRepository $this) {
        return $this.pluginRepositoryInstance;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/pluginverifier/repository/repositories/marketplace/MarketplaceRepository$Companion;", "", "()V", "DEFAULT_URL", "Ljava/net/URL;", "MAX_AVAILABLE_PLUGINS_IN_REPOSITORY", "", "verifier-repository"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\u00062\b\u0010\b\u001a\u0004\u0018\u00010\u0005R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/jetbrains/pluginverifier/repository/repositories/marketplace/MarketplaceRepository$IdeVersionInterner;", "", "()V", "pool", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/jetbrains/plugin/structure/intellij/version/IdeVersion;", "", "intern", "version", "verifier-repository"})
    private static final class IdeVersionInterner {
        @NotNull
        private final ConcurrentHashMap<IdeVersion, String> pool = new ConcurrentHashMap();

        @Nullable
        public final String intern(@Nullable IdeVersion version) {
            String string;
            IdeVersion ideVersion = version;
            if (ideVersion != null) {
                IdeVersion it = ideVersion;
                boolean bl = false;
                string = this.pool.computeIfAbsent(version, arg_0 -> IdeVersionInterner.intern$lambda$1$lambda$0(intern.1.1.INSTANCE, arg_0));
            } else {
                string = null;
            }
            return string;
        }

        private static final String intern$lambda$1$lambda$0(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
            return (String)$tmp0.invoke(p0);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/pluginverifier/repository/repositories/marketplace/MarketplaceRepository$MarketplaceUpdate;", "", "pluginId", "", "updateId", "(II)V", "getPluginId", "()I", "getUpdateId", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "", "verifier-repository"})
    private static final class MarketplaceUpdate {
        private final int pluginId;
        private final int updateId;

        public MarketplaceUpdate(int pluginId, int updateId) {
            this.pluginId = pluginId;
            this.updateId = updateId;
        }

        public final int getPluginId() {
            return this.pluginId;
        }

        public final int getUpdateId() {
            return this.updateId;
        }

        public final int component1() {
            return this.pluginId;
        }

        public final int component2() {
            return this.updateId;
        }

        @NotNull
        public final MarketplaceUpdate copy(int pluginId, int updateId) {
            return new MarketplaceUpdate(pluginId, updateId);
        }

        public static /* synthetic */ MarketplaceUpdate copy$default(MarketplaceUpdate marketplaceUpdate, int n, int n2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                n = marketplaceUpdate.pluginId;
            }
            if ((n3 & 2) != 0) {
                n2 = marketplaceUpdate.updateId;
            }
            return marketplaceUpdate.copy(n, n2);
        }

        @NotNull
        public String toString() {
            return "MarketplaceUpdate(pluginId=" + this.pluginId + ", updateId=" + this.updateId + ")";
        }

        public int hashCode() {
            int result2 = Integer.hashCode(this.pluginId);
            result2 = result2 * 31 + Integer.hashCode(this.updateId);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof MarketplaceUpdate)) {
                return false;
            }
            MarketplaceUpdate marketplaceUpdate = (MarketplaceUpdate)other;
            if (this.pluginId != marketplaceUpdate.pluginId) {
                return false;
            }
            return this.updateId == marketplaceUpdate.updateId;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\n\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u001f\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/pluginverifier/repository/repositories/marketplace/MarketplaceRepository$ModuleAndVersion;", "", "id", "", "ideVersion", "(Ljava/lang/String;Ljava/lang/String;)V", "getId", "()Ljava/lang/String;", "getIdeVersion", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "verifier-repository"})
    private static final class ModuleAndVersion {
        @NotNull
        private final String id;
        @Nullable
        private final String ideVersion;

        public ModuleAndVersion(@NotNull String id, @Nullable String ideVersion) {
            Intrinsics.checkNotNullParameter(id, "id");
            this.id = id;
            this.ideVersion = ideVersion;
        }

        @NotNull
        public final String getId() {
            return this.id;
        }

        @Nullable
        public final String getIdeVersion() {
            return this.ideVersion;
        }

        @NotNull
        public final String component1() {
            return this.id;
        }

        @Nullable
        public final String component2() {
            return this.ideVersion;
        }

        @NotNull
        public final ModuleAndVersion copy(@NotNull String id, @Nullable String ideVersion) {
            Intrinsics.checkNotNullParameter(id, "id");
            return new ModuleAndVersion(id, ideVersion);
        }

        public static /* synthetic */ ModuleAndVersion copy$default(ModuleAndVersion moduleAndVersion, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = moduleAndVersion.id;
            }
            if ((n & 2) != 0) {
                string2 = moduleAndVersion.ideVersion;
            }
            return moduleAndVersion.copy(string, string2);
        }

        @NotNull
        public String toString() {
            return "ModuleAndVersion(id=" + this.id + ", ideVersion=" + this.ideVersion + ")";
        }

        public int hashCode() {
            int result2 = this.id.hashCode();
            result2 = result2 * 31 + (this.ideVersion == null ? 0 : this.ideVersion.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ModuleAndVersion)) {
                return false;
            }
            ModuleAndVersion moduleAndVersion = (ModuleAndVersion)other;
            if (!Intrinsics.areEqual(this.id, moduleAndVersion.id)) {
                return false;
            }
            return Intrinsics.areEqual(this.ideVersion, moduleAndVersion.ideVersion);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u001b\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0006J\r\u0010\n\u001a\u00060\u0003j\u0002`\u0004H\u00c6\u0003J\u000b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J#\u0010\f\u001a\u00020\u00002\f\b\u0002\u0010\u0002\u001a\u00060\u0003j\u0002`\u00042\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0003H\u00d6\u0001R\u0015\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/pluginverifier/repository/repositories/marketplace/MarketplaceRepository$PluginAndVersion;", "", "id", "", "Lorg/jetbrains/intellij/pluginRepository/model/StringPluginId;", "ideVersion", "(Ljava/lang/String;Ljava/lang/String;)V", "getId", "()Ljava/lang/String;", "getIdeVersion", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "verifier-repository"})
    private static final class PluginAndVersion {
        @NotNull
        private final String id;
        @Nullable
        private final String ideVersion;

        public PluginAndVersion(@NotNull String id, @Nullable String ideVersion) {
            Intrinsics.checkNotNullParameter(id, "id");
            this.id = id;
            this.ideVersion = ideVersion;
        }

        @NotNull
        public final String getId() {
            return this.id;
        }

        @Nullable
        public final String getIdeVersion() {
            return this.ideVersion;
        }

        @NotNull
        public final String component1() {
            return this.id;
        }

        @Nullable
        public final String component2() {
            return this.ideVersion;
        }

        @NotNull
        public final PluginAndVersion copy(@NotNull String id, @Nullable String ideVersion) {
            Intrinsics.checkNotNullParameter(id, "id");
            return new PluginAndVersion(id, ideVersion);
        }

        public static /* synthetic */ PluginAndVersion copy$default(PluginAndVersion pluginAndVersion, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = pluginAndVersion.id;
            }
            if ((n & 2) != 0) {
                string2 = pluginAndVersion.ideVersion;
            }
            return pluginAndVersion.copy(string, string2);
        }

        @NotNull
        public String toString() {
            return "PluginAndVersion(id=" + this.id + ", ideVersion=" + this.ideVersion + ")";
        }

        public int hashCode() {
            int result2 = this.id.hashCode();
            result2 = result2 * 31 + (this.ideVersion == null ? 0 : this.ideVersion.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof PluginAndVersion)) {
                return false;
            }
            PluginAndVersion pluginAndVersion = (PluginAndVersion)other;
            if (!Intrinsics.areEqual(this.id, pluginAndVersion.id)) {
                return false;
            }
            return Intrinsics.areEqual(this.ideVersion, pluginAndVersion.ideVersion);
        }
    }
}

