/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.pluginverifier.repository.downloader;

import com.jetbrains.pluginverifier.repository.cleanup.SpaceAmount;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0002\u0011\u0012B\u0005\u00a2\u0006\u0002\u0010\u0002J\n\u0010\b\u001a\u00060\tR\u00020\u0000J\u0006\u0010\n\u001a\u00020\u000bJ\u0006\u0010\f\u001a\u00020\rJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0005H\u0002R2\u0010\u0003\u001a&\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005 \u0006*\u0012\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0018\u00010\u00070\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/pluginverifier/repository/downloader/DownloadStatistics;", "", "()V", "events", "", "Lcom/jetbrains/pluginverifier/repository/downloader/DownloadStatistics$FinishedDownloadEvent;", "kotlin.jvm.PlatformType", "", "downloadStarted", "Lcom/jetbrains/pluginverifier/repository/downloader/DownloadStatistics$DownloadEvent;", "getTotalAstronomicalDownloadDuration", "Ljava/time/Duration;", "getTotalDownloadedAmount", "Lcom/jetbrains/pluginverifier/repository/cleanup/SpaceAmount;", "reportEvent", "", "downloadEvent", "DownloadEvent", "FinishedDownloadEvent", "verifier-repository"})
@SourceDebugExtension(value={"SMAP\nDownloadStatistics.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DownloadStatistics.kt\ncom/jetbrains/pluginverifier/repository/downloader/DownloadStatistics\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,64:1\n1797#2,3:65\n1485#2:68\n1510#2,3:69\n1513#2,3:79\n1485#2:82\n1510#2,3:83\n1513#2,3:93\n1557#2:96\n1628#2,3:97\n1557#2:100\n1628#2,3:101\n381#3,7:72\n381#3,7:86\n*S KotlinDebug\n*F\n+ 1 DownloadStatistics.kt\ncom/jetbrains/pluginverifier/repository/downloader/DownloadStatistics\n*L\n24#1:65,3\n30#1:68\n30#1:69,3\n30#1:79,3\n31#1:82\n31#1:83,3\n31#1:93,3\n32#1:96\n32#1:97,3\n32#1:100\n32#1:101,3\n30#1:72,7\n31#1:86,7\n*E\n"})
public final class DownloadStatistics {
    private final List<FinishedDownloadEvent> events = Collections.synchronizedList(new ArrayList());

    private final void reportEvent(FinishedDownloadEvent downloadEvent) {
        this.events.add(downloadEvent);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final SpaceAmount getTotalDownloadedAmount() {
        void $this$fold$iv;
        List<FinishedDownloadEvent> list = this.events;
        Intrinsics.checkNotNullExpressionValue(list, "events");
        Iterable iterable = list;
        SpaceAmount initial$iv = SpaceAmount.Companion.getZERO_SPACE();
        boolean $i$f$fold = false;
        SpaceAmount accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void event;
            FinishedDownloadEvent finishedDownloadEvent = (FinishedDownloadEvent)element$iv;
            SpaceAmount acc = accumulator$iv;
            boolean bl = false;
            accumulator$iv = acc.plus(event.getDownloadedAmount$verifier_repository());
        }
        return accumulator$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Duration getTotalAstronomicalDownloadDuration() {
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        void $this$groupByTo$iv$iv;
        void $this$groupByTo$iv$iv2;
        List<FinishedDownloadEvent> list = this.events;
        Intrinsics.checkNotNullExpressionValue(list, "events");
        Iterable $this$groupBy$iv = list;
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Object destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv2) {
            Object object;
            FinishedDownloadEvent it = (FinishedDownloadEvent)element$iv$iv;
            boolean bl = false;
            Instant key$iv$iv = it.getStartInstant$verifier_repository();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Map startEvents = destination$iv$iv;
        List<FinishedDownloadEvent> list2 = this.events;
        Intrinsics.checkNotNullExpressionValue(list2, "events");
        Iterable $this$groupBy$iv2 = list2;
        boolean $i$f$groupBy2 = false;
        destination$iv$iv = $this$groupBy$iv2;
        Object destination$iv$iv2 = new LinkedHashMap();
        boolean $i$f$groupByTo2 = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            FinishedDownloadEvent it = (FinishedDownloadEvent)element$iv$iv;
            boolean bl = false;
            Instant key$iv$iv = it.getEndInstant$verifier_repository();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv2;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl3 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Map endEvents = destination$iv$iv2;
        List<FinishedDownloadEvent> list3 = this.events;
        Intrinsics.checkNotNullExpressionValue(list3, "events");
        Iterable $this$map$iv = list3;
        boolean $i$f$map = false;
        destination$iv$iv2 = $this$map$iv;
        Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            FinishedDownloadEvent bl = (FinishedDownloadEvent)item$iv$iv;
            collection = destination$iv$iv3;
            boolean bl4 = false;
            collection.add(it.getStartInstant$verifier_repository());
        }
        Collection collection2 = (List)destination$iv$iv3;
        List<FinishedDownloadEvent> list4 = this.events;
        Intrinsics.checkNotNullExpressionValue(list4, "events");
        $this$map$iv = list4;
        collection = collection2;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            FinishedDownloadEvent it = (FinishedDownloadEvent)item$iv$iv;
            Collection collection3 = destination$iv$iv3;
            boolean bl = false;
            collection3.add(it.getEndInstant$verifier_repository());
        }
        List allInstants = CollectionsKt.sorted(CollectionsKt.plus(collection, (Iterable)((List)destination$iv$iv3)));
        Duration totalDuration = Duration.ZERO;
        HashSet activeEvents = new HashSet();
        int n = allInstants.size() - 1;
        for (int i = 0; i < n; ++i) {
            Instant segmentStart = (Instant)allInstants.get(i);
            Instant segmentEnd = (Instant)allInstants.get(i + 1);
            Collection collection4 = activeEvents;
            List list5 = (List)endEvents.get(segmentStart);
            if (list5 == null) {
                list5 = CollectionsKt.emptyList();
            }
            CollectionsKt.removeAll(collection4, list5);
            Collection collection5 = activeEvents;
            List list6 = (List)startEvents.get(segmentStart);
            if (list6 == null) {
                list6 = CollectionsKt.emptyList();
            }
            CollectionsKt.addAll(collection5, list6);
            if (!(!((Collection)activeEvents).isEmpty())) continue;
            totalDuration = totalDuration.plus(Duration.between(segmentStart, segmentEnd));
        }
        Duration duration = totalDuration;
        Intrinsics.checkNotNullExpressionValue(duration, "totalDuration");
        return duration;
    }

    @NotNull
    public final DownloadEvent downloadStarted() {
        Instant instant = Instant.now();
        Intrinsics.checkNotNullExpressionValue(instant, "now()");
        return new DownloadEvent(instant);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nR\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/pluginverifier/repository/downloader/DownloadStatistics$DownloadEvent;", "", "startInstant", "Ljava/time/Instant;", "(Lcom/jetbrains/pluginverifier/repository/downloader/DownloadStatistics;Ljava/time/Instant;)V", "getStartInstant$verifier_repository", "()Ljava/time/Instant;", "downloadEnded", "", "downloadedAmount", "Lcom/jetbrains/pluginverifier/repository/cleanup/SpaceAmount;", "verifier-repository"})
    public final class DownloadEvent {
        @NotNull
        private final Instant startInstant;

        public DownloadEvent(Instant startInstant) {
            Intrinsics.checkNotNullParameter(startInstant, "startInstant");
            this.startInstant = startInstant;
        }

        @NotNull
        public final Instant getStartInstant$verifier_repository() {
            return this.startInstant;
        }

        public final void downloadEnded(@NotNull SpaceAmount downloadedAmount) {
            Intrinsics.checkNotNullParameter(downloadedAmount, "downloadedAmount");
            Instant instant = Instant.now();
            Intrinsics.checkNotNullExpressionValue(instant, "now()");
            DownloadStatistics.this.reportEvent(new FinishedDownloadEvent(this.startInstant, instant, downloadedAmount));
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\r\u001a\u00020\u0003H\u00c0\u0003\u00a2\u0006\u0002\b\u000eJ\u000e\u0010\u000f\u001a\u00020\u0003H\u00c0\u0003\u00a2\u0006\u0002\b\u0010J\u000e\u0010\u0011\u001a\u00020\u0006H\u00c0\u0003\u00a2\u0006\u0002\b\u0012J'\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001R\u0014\u0010\u0005\u001a\u00020\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0004\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000b\u00a8\u0006\u001b"}, d2={"Lcom/jetbrains/pluginverifier/repository/downloader/DownloadStatistics$FinishedDownloadEvent;", "", "startInstant", "Ljava/time/Instant;", "endInstant", "downloadedAmount", "Lcom/jetbrains/pluginverifier/repository/cleanup/SpaceAmount;", "(Ljava/time/Instant;Ljava/time/Instant;Lcom/jetbrains/pluginverifier/repository/cleanup/SpaceAmount;)V", "getDownloadedAmount$verifier_repository", "()Lcom/jetbrains/pluginverifier/repository/cleanup/SpaceAmount;", "getEndInstant$verifier_repository", "()Ljava/time/Instant;", "getStartInstant$verifier_repository", "component1", "component1$verifier_repository", "component2", "component2$verifier_repository", "component3", "component3$verifier_repository", "copy", "equals", "", "other", "hashCode", "", "toString", "", "verifier-repository"})
    public static final class FinishedDownloadEvent {
        @NotNull
        private final Instant startInstant;
        @NotNull
        private final Instant endInstant;
        @NotNull
        private final SpaceAmount downloadedAmount;

        public FinishedDownloadEvent(@NotNull Instant startInstant, @NotNull Instant endInstant, @NotNull SpaceAmount downloadedAmount) {
            Intrinsics.checkNotNullParameter(startInstant, "startInstant");
            Intrinsics.checkNotNullParameter(endInstant, "endInstant");
            Intrinsics.checkNotNullParameter(downloadedAmount, "downloadedAmount");
            this.startInstant = startInstant;
            this.endInstant = endInstant;
            this.downloadedAmount = downloadedAmount;
        }

        @NotNull
        public final Instant getStartInstant$verifier_repository() {
            return this.startInstant;
        }

        @NotNull
        public final Instant getEndInstant$verifier_repository() {
            return this.endInstant;
        }

        @NotNull
        public final SpaceAmount getDownloadedAmount$verifier_repository() {
            return this.downloadedAmount;
        }

        @NotNull
        public final Instant component1$verifier_repository() {
            return this.startInstant;
        }

        @NotNull
        public final Instant component2$verifier_repository() {
            return this.endInstant;
        }

        @NotNull
        public final SpaceAmount component3$verifier_repository() {
            return this.downloadedAmount;
        }

        @NotNull
        public final FinishedDownloadEvent copy(@NotNull Instant startInstant, @NotNull Instant endInstant, @NotNull SpaceAmount downloadedAmount) {
            Intrinsics.checkNotNullParameter(startInstant, "startInstant");
            Intrinsics.checkNotNullParameter(endInstant, "endInstant");
            Intrinsics.checkNotNullParameter(downloadedAmount, "downloadedAmount");
            return new FinishedDownloadEvent(startInstant, endInstant, downloadedAmount);
        }

        public static /* synthetic */ FinishedDownloadEvent copy$default(FinishedDownloadEvent finishedDownloadEvent, Instant instant, Instant instant2, SpaceAmount spaceAmount, int n, Object object) {
            if ((n & 1) != 0) {
                instant = finishedDownloadEvent.startInstant;
            }
            if ((n & 2) != 0) {
                instant2 = finishedDownloadEvent.endInstant;
            }
            if ((n & 4) != 0) {
                spaceAmount = finishedDownloadEvent.downloadedAmount;
            }
            return finishedDownloadEvent.copy(instant, instant2, spaceAmount);
        }

        @NotNull
        public String toString() {
            return "FinishedDownloadEvent(startInstant=" + this.startInstant + ", endInstant=" + this.endInstant + ", downloadedAmount=" + this.downloadedAmount + ")";
        }

        public int hashCode() {
            int result2 = this.startInstant.hashCode();
            result2 = result2 * 31 + this.endInstant.hashCode();
            result2 = result2 * 31 + this.downloadedAmount.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof FinishedDownloadEvent)) {
                return false;
            }
            FinishedDownloadEvent finishedDownloadEvent = (FinishedDownloadEvent)other;
            if (!Intrinsics.areEqual(this.startInstant, finishedDownloadEvent.startInstant)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.endInstant, finishedDownloadEvent.endInstant)) {
                return false;
            }
            return Intrinsics.areEqual(this.downloadedAmount, finishedDownloadEvent.downloadedAmount);
        }
    }
}

