/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.pluginverifier.repository.downloader;

import com.jetbrains.plugin.structure.base.utils.FileUtilKt;
import com.jetbrains.plugin.structure.base.utils.LanguageUtilsKt;
import com.jetbrains.plugin.structure.base.utils.Striped;
import com.jetbrains.pluginverifier.UtilKt;
import com.jetbrains.pluginverifier.repository.cleanup.SpaceAmountKt;
import com.jetbrains.pluginverifier.repository.downloader.DownloadResult;
import com.jetbrains.pluginverifier.repository.downloader.DownloadStatistics;
import com.jetbrains.pluginverifier.repository.downloader.Downloader;
import com.jetbrains.pluginverifier.repository.provider.ProvideResult;
import com.jetbrains.pluginverifier.repository.provider.ResourceProvider;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.locks.Lock;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.apache.commons.io.FileUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 **\n\b\u0000\u0010\u0001 \u0000*\u00020\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u00020\u00040\u0003:\u0002*+B/\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0002\u0010\u000bJ\u001d\u0010\u0015\u001a\n \r*\u0004\u0018\u00010\u00040\u00042\u0006\u0010\u0016\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010\u0017J\u0010\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J%\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u0016\u001a\u00028\u00002\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\nH\u0002\u00a2\u0006\u0002\u0010\u001fJ\u0018\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u00042\u0006\u0010#\u001a\u00020\u0004H\u0002J\u001b\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00040%2\u0006\u0010\u0016\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010&J3\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00040%2\u0006\u0010\u0016\u001a\u00028\u00002\u0006\u0010(\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002\u00a2\u0006\u0002\u0010)R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n \r*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/jetbrains/pluginverifier/repository/downloader/DownloadProvider;", "K", "", "Lcom/jetbrains/pluginverifier/repository/provider/ResourceProvider;", "Ljava/nio/file/Path;", "destinationDirectory", "downloader", "Lcom/jetbrains/pluginverifier/repository/downloader/Downloader;", "fileNameWithoutExtensionMapper", "Lkotlin/Function1;", "", "(Ljava/nio/file/Path;Lcom/jetbrains/pluginverifier/repository/downloader/Downloader;Lkotlin/jvm/functions/Function1;)V", "downloadDirectory", "kotlin.jvm.PlatformType", "downloadStatistics", "Lcom/jetbrains/pluginverifier/repository/downloader/DownloadStatistics;", "getDownloadStatistics", "()Lcom/jetbrains/pluginverifier/repository/downloader/DownloadStatistics;", "nameGenerationLocks", "Lcom/jetbrains/plugin/structure/base/utils/Striped;", "Ljava/util/concurrent/locks/Lock;", "createTempDirectoryForDownload", "key", "(Ljava/lang/Object;)Ljava/nio/file/Path;", "getDestinationFile", "name", "Lcom/jetbrains/pluginverifier/repository/downloader/DownloadProvider$PrefixAndSuffix;", "getDestinationPrefixAndSuffix", "isDirectory", "", "extension", "(Ljava/lang/Object;ZLjava/lang/String;)Lcom/jetbrains/pluginverifier/repository/downloader/DownloadProvider$PrefixAndSuffix;", "moveFileOrDirectory", "", "fileOrDirectory", "destination", "provide", "Lcom/jetbrains/pluginverifier/repository/provider/ProvideResult;", "(Ljava/lang/Object;)Lcom/jetbrains/pluginverifier/repository/provider/ProvideResult;", "saveDownloadedFileToFinalDestination", "tempDownloadedFile", "(Ljava/lang/Object;Ljava/nio/file/Path;Ljava/lang/String;Z)Lcom/jetbrains/pluginverifier/repository/provider/ProvideResult;", "Companion", "PrefixAndSuffix", "verifier-repository"})
@SourceDebugExtension(value={"SMAP\nDownloadProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DownloadProvider.kt\ncom/jetbrains/pluginverifier/repository/downloader/DownloadProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,125:1\n1#2:126\n*E\n"})
public final class DownloadProvider<K>
implements ResourceProvider<K, Path> {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final Path destinationDirectory;
    @NotNull
    private final Downloader<K> downloader;
    @NotNull
    private final Function1<K, String> fileNameWithoutExtensionMapper;
    private final Path downloadDirectory;
    @NotNull
    private final DownloadStatistics downloadStatistics;
    @NotNull
    private final Striped<Lock> nameGenerationLocks;
    @Deprecated
    @NotNull
    public static final String DOWNLOADS_DIRECTORY = ".downloads";

    public DownloadProvider(@NotNull Path destinationDirectory, @NotNull Downloader<? super K> downloader, @NotNull Function1<? super K, String> fileNameWithoutExtensionMapper) {
        Intrinsics.checkNotNullParameter(destinationDirectory, "destinationDirectory");
        Intrinsics.checkNotNullParameter(downloader, "downloader");
        Intrinsics.checkNotNullParameter(fileNameWithoutExtensionMapper, "fileNameWithoutExtensionMapper");
        this.destinationDirectory = destinationDirectory;
        this.downloader = downloader;
        this.fileNameWithoutExtensionMapper = fileNameWithoutExtensionMapper;
        this.downloadDirectory = this.destinationDirectory.resolve(DOWNLOADS_DIRECTORY);
        this.downloadStatistics = new DownloadStatistics();
        FileUtilKt.createDir(this.destinationDirectory);
        Path path = this.downloadDirectory;
        Intrinsics.checkNotNullExpressionValue(path, "downloadDirectory");
        FileUtilKt.forceDeleteIfExists(path);
        this.nameGenerationLocks = Striped.Companion.lock(RangesKt.coerceAtLeast(UtilKt.getConcurrencyLevel(), 1));
    }

    @NotNull
    public final DownloadStatistics getDownloadStatistics() {
        return this.downloadStatistics;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public ProvideResult<Path> provide(@NotNull K key) throws InterruptedException {
        ProvideResult<Path> provideResult;
        Intrinsics.checkNotNullParameter(key, "key");
        DownloadStatistics.DownloadEvent downloadEvent = this.downloadStatistics.downloadStarted();
        Path tempDirectory = this.createTempDirectoryForDownload(key);
        try {
            ProvideResult<Path> provideResult2;
            Intrinsics.checkNotNullExpressionValue(tempDirectory, "tempDirectory");
            DownloadResult $this$provide_u24lambda_u240 = this.downloader.download(key, tempDirectory);
            boolean bl = false;
            DownloadResult downloadResult = $this$provide_u24lambda_u240;
            if (downloadResult instanceof DownloadResult.Downloaded) {
                downloadEvent.downloadEnded(SpaceAmountKt.getFileSize(((DownloadResult.Downloaded)$this$provide_u24lambda_u240).getDownloadedFileOrDirectory()));
                provideResult2 = this.saveDownloadedFileToFinalDestination(key, ((DownloadResult.Downloaded)$this$provide_u24lambda_u240).getDownloadedFileOrDirectory(), ((DownloadResult.Downloaded)$this$provide_u24lambda_u240).getExtension(), ((DownloadResult.Downloaded)$this$provide_u24lambda_u240).isDirectory());
            } else if (downloadResult instanceof DownloadResult.NotFound) {
                provideResult2 = new ProvideResult.NotFound(((DownloadResult.NotFound)$this$provide_u24lambda_u240).getReason());
            } else if (downloadResult instanceof DownloadResult.FailedToDownload) {
                provideResult2 = new ProvideResult.Failed(((DownloadResult.FailedToDownload)$this$provide_u24lambda_u240).getReason(), ((DownloadResult.FailedToDownload)$this$provide_u24lambda_u240).getError());
            } else {
                throw new NoWhenBranchMatchedException();
            }
            provideResult = provideResult2;
        }
        catch (Throwable throwable) {
            Intrinsics.checkNotNullExpressionValue(tempDirectory, "tempDirectory");
            FileUtilKt.deleteLogged(tempDirectory);
            throw throwable;
        }
        FileUtilKt.deleteLogged(tempDirectory);
        return provideResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final ProvideResult<Path> saveDownloadedFileToFinalDestination(K key, Path tempDownloadedFile, String extension, boolean isDirectory) {
        PrefixAndSuffix prefixAndSuffix = this.getDestinationPrefixAndSuffix(key, isDirectory, extension);
        Lock lock2 = this.nameGenerationLocks.get(prefixAndSuffix);
        synchronized (lock2) {
            boolean bl = false;
            Path destination = this.getDestinationFile(prefixAndSuffix);
            try {
                this.moveFileOrDirectory(tempDownloadedFile, destination);
            }
            catch (Exception e) {
                LanguageUtilsKt.rethrowIfInterrupted(e);
                ProvideResult provideResult = new ProvideResult.Failed("Unable to download " + key, e);
                return provideResult;
            }
            ProvideResult provideResult = new ProvideResult.Provided<Path>(destination);
            return provideResult;
        }
    }

    private final PrefixAndSuffix getDestinationPrefixAndSuffix(K key, boolean isDirectory, String extension) {
        if (!Intrinsics.areEqual(extension, FileUtilKt.replaceInvalidFileNameCharacters(extension))) {
            boolean $i$a$-check-DownloadProvider$getDestinationPrefixAndSuffix$22 = false;
            String $i$a$-check-DownloadProvider$getDestinationPrefixAndSuffix$22 = "Extension must not contain invalid characters: " + extension;
            throw new IllegalStateException($i$a$-check-DownloadProvider$getDestinationPrefixAndSuffix$22.toString());
        }
        String nameWithoutExtension = FileUtilKt.replaceInvalidFileNameCharacters(this.fileNameWithoutExtensionMapper.invoke(key));
        String extensionSuffix = isDirectory || ((CharSequence)extension).length() == 0 ? "" : "." + extension;
        return new PrefixAndSuffix(nameWithoutExtension, extensionSuffix);
    }

    private final Path getDestinationFile(PrefixAndSuffix name) {
        Path destination = this.destinationDirectory.resolve(name.getNameWithoutExtension() + name.getExtensionSuffix());
        int nextSuffix = 1;
        while (Files.exists(destination, new LinkOption[0])) {
            String newName = name.getNameWithoutExtension() + " (" + nextSuffix + ")" + name.getExtensionSuffix();
            destination = this.destinationDirectory.resolve(newName);
            ++nextSuffix;
        }
        Path path = destination;
        Intrinsics.checkNotNullExpressionValue(path, "destination");
        return path;
    }

    private final Path createTempDirectoryForDownload(K key) {
        Path path;
        try {
            Path path2 = this.downloadDirectory;
            Intrinsics.checkNotNullExpressionValue(path2, "downloadDirectory");
            path = Files.createTempDirectory(FileUtilKt.createDir(path2), "download-" + FileUtilKt.replaceInvalidFileNameCharacters(this.fileNameWithoutExtensionMapper.invoke(key)) + "-", new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return path;
    }

    private final void moveFileOrDirectory(Path fileOrDirectory, Path destination) {
        if (FileUtilKt.exists(destination)) {
            FileUtilKt.deleteLogged(destination);
        }
        if (FileUtilKt.isDirectory(fileOrDirectory)) {
            FileUtils.moveDirectory(fileOrDirectory.toFile(), destination.toFile());
        } else {
            FileUtils.moveFile(fileOrDirectory.toFile(), destination.toFile());
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/jetbrains/pluginverifier/repository/downloader/DownloadProvider$Companion;", "", "()V", "DOWNLOADS_DIRECTORY", "", "verifier-repository"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/pluginverifier/repository/downloader/DownloadProvider$PrefixAndSuffix;", "", "nameWithoutExtension", "", "extensionSuffix", "(Ljava/lang/String;Ljava/lang/String;)V", "getExtensionSuffix", "()Ljava/lang/String;", "getNameWithoutExtension", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "verifier-repository"})
    private static final class PrefixAndSuffix {
        @NotNull
        private final String nameWithoutExtension;
        @NotNull
        private final String extensionSuffix;

        public PrefixAndSuffix(@NotNull String nameWithoutExtension, @NotNull String extensionSuffix) {
            Intrinsics.checkNotNullParameter(nameWithoutExtension, "nameWithoutExtension");
            Intrinsics.checkNotNullParameter(extensionSuffix, "extensionSuffix");
            this.nameWithoutExtension = nameWithoutExtension;
            this.extensionSuffix = extensionSuffix;
        }

        @NotNull
        public final String getNameWithoutExtension() {
            return this.nameWithoutExtension;
        }

        @NotNull
        public final String getExtensionSuffix() {
            return this.extensionSuffix;
        }

        @NotNull
        public final String component1() {
            return this.nameWithoutExtension;
        }

        @NotNull
        public final String component2() {
            return this.extensionSuffix;
        }

        @NotNull
        public final PrefixAndSuffix copy(@NotNull String nameWithoutExtension, @NotNull String extensionSuffix) {
            Intrinsics.checkNotNullParameter(nameWithoutExtension, "nameWithoutExtension");
            Intrinsics.checkNotNullParameter(extensionSuffix, "extensionSuffix");
            return new PrefixAndSuffix(nameWithoutExtension, extensionSuffix);
        }

        public static /* synthetic */ PrefixAndSuffix copy$default(PrefixAndSuffix prefixAndSuffix, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = prefixAndSuffix.nameWithoutExtension;
            }
            if ((n & 2) != 0) {
                string2 = prefixAndSuffix.extensionSuffix;
            }
            return prefixAndSuffix.copy(string, string2);
        }

        @NotNull
        public String toString() {
            return "PrefixAndSuffix(nameWithoutExtension=" + this.nameWithoutExtension + ", extensionSuffix=" + this.extensionSuffix + ")";
        }

        public int hashCode() {
            int result2 = this.nameWithoutExtension.hashCode();
            result2 = result2 * 31 + this.extensionSuffix.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof PrefixAndSuffix)) {
                return false;
            }
            PrefixAndSuffix prefixAndSuffix = (PrefixAndSuffix)other;
            if (!Intrinsics.areEqual(this.nameWithoutExtension, prefixAndSuffix.nameWithoutExtension)) {
                return false;
            }
            return Intrinsics.areEqual(this.extensionSuffix, prefixAndSuffix.extensionSuffix);
        }
    }
}

