/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.pluginverifier.repository.cache;

import com.jetbrains.plugin.structure.base.utils.LanguageUtilsKt;
import com.jetbrains.pluginverifier.repository.cache.ResourceCacheEntry;
import com.jetbrains.pluginverifier.repository.cache.ResourceCacheEntryResult;
import com.jetbrains.pluginverifier.repository.provider.ResourceProvider;
import com.jetbrains.pluginverifier.repository.resources.EvictionPolicy;
import com.jetbrains.pluginverifier.repository.resources.ResourceLock;
import com.jetbrains.pluginverifier.repository.resources.ResourceRepositoryImpl;
import com.jetbrains.pluginverifier.repository.resources.ResourceRepositoryResult;
import com.jetbrains.pluginverifier.repository.resources.ResourceWeight;
import java.io.Closeable;
import java.time.Clock;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 \u001e*\b\b\u0000\u0010\u0001*\u00020\u0002*\n\b\u0001\u0010\u0003 \u0000*\u00020\u0002*\u000e\b\u0002\u0010\u0004*\b\u0012\u0004\u0012\u0002H\u00040\u00052\u00020\u0006:\u0001\u001eBk\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00000\b\u0012\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u000b0\n\u0012\u0018\u0010\f\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\r\u0012\u0006\u0010\u000e\u001a\u00028\u0002\u0012\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00020\n\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0012J\b\u0010\u0017\u001a\u00020\u000bH\u0016J\u001f\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00020\u00192\u0006\u0010\u001a\u001a\u00028\u0001\u00a2\u0006\u0002\u0010\u001bJ\u0013\u0010\u001c\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00028\u0001\u00a2\u0006\u0002\u0010\u001dR\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0015\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0016X\u0088\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/jetbrains/pluginverifier/repository/cache/ResourceCache;", "R", "", "K", "W", "Lcom/jetbrains/pluginverifier/repository/resources/ResourceWeight;", "Ljava/io/Closeable;", "resourceProvider", "Lcom/jetbrains/pluginverifier/repository/provider/ResourceProvider;", "disposer", "Lkotlin/Function1;", "", "evictionPolicy", "Lcom/jetbrains/pluginverifier/repository/resources/EvictionPolicy;", "initialWeight", "weigher", "presentableName", "", "(Lcom/jetbrains/pluginverifier/repository/provider/ResourceProvider;Lkotlin/jvm/functions/Function1;Lcom/jetbrains/pluginverifier/repository/resources/EvictionPolicy;Lcom/jetbrains/pluginverifier/repository/resources/ResourceWeight;Lkotlin/jvm/functions/Function1;Ljava/lang/String;)V", "isClosed", "Ljava/util/concurrent/atomic/AtomicBoolean;", "resourceRepository", "Lcom/jetbrains/pluginverifier/repository/resources/ResourceRepositoryImpl;", "close", "getResourceCacheEntry", "Lcom/jetbrains/pluginverifier/repository/cache/ResourceCacheEntryResult;", "key", "(Ljava/lang/Object;)Lcom/jetbrains/pluginverifier/repository/cache/ResourceCacheEntryResult;", "remove", "(Ljava/lang/Object;)V", "Companion", "verifier-repository"})
@SourceDebugExtension(value={"SMAP\nResourceCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ResourceCache.kt\ncom/jetbrains/pluginverifier/repository/cache/ResourceCache\n+ 2 LanguageUtils.kt\ncom/jetbrains/plugin/structure/base/utils/LanguageUtilsKt\n*L\n1#1,187:1\n70#2,5:188\n*S KotlinDebug\n*F\n+ 1 ResourceCache.kt\ncom/jetbrains/pluginverifier/repository/cache/ResourceCache\n*L\n161#1:188,5\n*E\n"})
public final class ResourceCache<R, K, W extends ResourceWeight<W>>
implements Closeable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String presentableName;
    @NotNull
    private final ResourceRepositoryImpl<R, K, W> resourceRepository;
    @NotNull
    private final AtomicBoolean isClosed;
    @NotNull
    private static final Logger LOG;

    public ResourceCache(@NotNull ResourceProvider<? super K, ? extends R> resourceProvider, @NotNull Function1<? super R, Unit> disposer, @NotNull EvictionPolicy<R, K, W> evictionPolicy, @NotNull W initialWeight, @NotNull Function1<? super R, ? extends W> weigher, @NotNull String presentableName2) {
        Intrinsics.checkNotNullParameter(resourceProvider, "resourceProvider");
        Intrinsics.checkNotNullParameter(disposer, "disposer");
        Intrinsics.checkNotNullParameter(evictionPolicy, "evictionPolicy");
        Intrinsics.checkNotNullParameter(initialWeight, "initialWeight");
        Intrinsics.checkNotNullParameter(weigher, "weigher");
        Intrinsics.checkNotNullParameter(presentableName2, "presentableName");
        this.presentableName = presentableName2;
        Clock clock = Clock.systemUTC();
        Intrinsics.checkNotNullExpressionValue(clock, "systemUTC()");
        this.resourceRepository = new ResourceRepositoryImpl<R, K, W>(evictionPolicy, clock, resourceProvider, initialWeight, weigher, disposer, this.presentableName);
        this.isClosed = new AtomicBoolean(false);
    }

    @Override
    public void close() {
        LOG.debug("Closing the " + this.presentableName);
        if (this.isClosed.compareAndSet(false, true)) {
            this.resourceRepository.removeAll();
        }
    }

    @NotNull
    public final ResourceCacheEntryResult<R, W> getResourceCacheEntry(@NotNull K key) throws InterruptedException {
        ResourceCacheEntryResult.Found found;
        ResourceRepositoryResult<R, W> repositoryResult;
        Intrinsics.checkNotNullParameter(key, "key");
        if (this.isClosed.get()) {
            throw new InterruptedException();
        }
        ResourceRepositoryResult<R, W> $this$getResourceCacheEntry_u24lambda_u240 = repositoryResult = this.resourceRepository.get(key);
        boolean bl = false;
        ResourceRepositoryResult<R, W> resourceRepositoryResult = $this$getResourceCacheEntry_u24lambda_u240;
        if (!(resourceRepositoryResult instanceof ResourceRepositoryResult.Found)) {
            if (resourceRepositoryResult instanceof ResourceRepositoryResult.Failed) {
                return new ResourceCacheEntryResult.Failed(((ResourceRepositoryResult.Failed)$this$getResourceCacheEntry_u24lambda_u240).getReason(), ((ResourceRepositoryResult.Failed)$this$getResourceCacheEntry_u24lambda_u240).getError());
            }
            if (resourceRepositoryResult instanceof ResourceRepositoryResult.NotFound) {
                return new ResourceCacheEntryResult.NotFound(((ResourceRepositoryResult.NotFound)$this$getResourceCacheEntry_u24lambda_u240).getReason());
            }
            throw new NoWhenBranchMatchedException();
        }
        ResourceLock lockedResource = ((ResourceRepositoryResult.Found)$this$getResourceCacheEntry_u24lambda_u240).getLockedResource();
        if (this.isClosed.get()) {
            lockedResource.release();
            this.resourceRepository.remove(key);
            throw new InterruptedException();
        }
        Closeable $this$closeOnException$iv = lockedResource;
        boolean $i$f$closeOnException = false;
        try {
            ResourceLock it = (ResourceLock)$this$closeOnException$iv;
            boolean bl2 = false;
            found = new ResourceCacheEntryResult.Found(new ResourceCacheEntry(lockedResource));
        }
        catch (Throwable e$iv) {
            Closeable closeable = $this$closeOnException$iv;
            if (closeable != null) {
                LanguageUtilsKt.closeLogged(closeable);
            }
            throw e$iv;
        }
        return found;
    }

    public final void remove(@NotNull K key) {
        Intrinsics.checkNotNullParameter(key, "key");
        this.resourceRepository.remove(key);
    }

    static {
        Logger logger = LoggerFactory.getLogger(ResourceCache.class);
        Intrinsics.checkNotNullExpressionValue(logger, "getLogger(ResourceCache::class.java)");
        LOG = logger;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/jetbrains/pluginverifier/repository/cache/ResourceCache$Companion;", "", "()V", "LOG", "Lorg/slf4j/Logger;", "verifier-repository"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

