/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.pluginverifier.plugin;

import com.jetbrains.plugin.structure.base.plugin.PluginCreationResult;
import com.jetbrains.plugin.structure.base.plugin.PluginCreationSuccess;
import com.jetbrains.plugin.structure.base.utils.LanguageUtilsKt;
import com.jetbrains.plugin.structure.base.utils.Striped;
import com.jetbrains.plugin.structure.intellij.classes.locator.CompileServerExtensionKey;
import com.jetbrains.plugin.structure.intellij.classes.plugin.BundledPluginClassesFinder;
import com.jetbrains.plugin.structure.intellij.classes.plugin.ClassSearchContext;
import com.jetbrains.plugin.structure.intellij.classes.plugin.IdePluginClassesLocations;
import com.jetbrains.plugin.structure.intellij.plugin.IdePlugin;
import com.jetbrains.plugin.structure.intellij.plugin.IdePluginManager;
import com.jetbrains.plugin.structure.intellij.plugin.PluginArchiveManager;
import com.jetbrains.plugin.structure.intellij.problems.IntelliJPluginCreationResultResolver;
import com.jetbrains.plugin.structure.intellij.problems.JetBrainsPluginCreationResultResolver;
import com.jetbrains.plugin.structure.intellij.problems.PluginCreationResultResolver;
import com.jetbrains.plugin.structure.intellij.resources.PluginArchiveResource;
import com.jetbrains.plugin.structure.intellij.utils.DeletableOnClose;
import com.jetbrains.pluginverifier.UtilKt;
import com.jetbrains.pluginverifier.plugin.AbstractPluginDetailsProvider;
import com.jetbrains.pluginverifier.plugin.DependencyDetailsProvider;
import com.jetbrains.pluginverifier.plugin.PluginDetailsProviderImpl;
import com.jetbrains.pluginverifier.repository.PluginInfo;
import com.jetbrains.pluginverifier.repository.files.FileLock;
import com.jetbrains.pluginverifier.repository.repositories.bundled.BundledPluginInfo;
import com.jetbrains.pluginverifier.repository.repositories.dependency.DependencyPluginInfo;
import java.io.Closeable;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import kotlin.Metadata;
import kotlin.collections.AbstractList;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u00012\u00020\u0002:\u0001,B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u001f\u001a\u00020 H\u0016J\u001e\u0010!\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0014J\u0018\u0010&\u001a\u00020'2\u0006\u0010\"\u001a\u00020#2\u0006\u0010(\u001a\u00020\u001cH\u0016J \u0010)\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b*\b\u0012\u0004\u0012\u00020\u001c0\u001b2\u0006\u0010*\u001a\u00020\u001aH\u0002J\u0018\u0010+\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b*\b\u0012\u0004\u0012\u00020\u001c0\u001bH\u0002R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R \u0010\u0018\u001a\u0014\u0012\u0004\u0012\u00020\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001c0\u001b0\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lcom/jetbrains/pluginverifier/plugin/DefaultPluginDetailsProvider;", "Lcom/jetbrains/pluginverifier/plugin/AbstractPluginDetailsProvider;", "Ljava/lang/AutoCloseable;", "archiveManager", "Lcom/jetbrains/plugin/structure/intellij/plugin/PluginArchiveManager;", "(Lcom/jetbrains/plugin/structure/intellij/plugin/PluginArchiveManager;)V", "closeableResources", "", "Ljava/io/Closeable;", "closeableResourcesSize", "", "getCloseableResourcesSize", "()I", "createPluginLocks", "Lcom/jetbrains/plugin/structure/base/utils/Striped;", "Ljava/util/concurrent/locks/Lock;", "dependencyDetailsProvider", "Lcom/jetbrains/pluginverifier/plugin/DependencyDetailsProvider;", "dependencyProblemResolver", "Lcom/jetbrains/plugin/structure/intellij/problems/PluginCreationResultResolver;", "eventLog", "Lcom/jetbrains/pluginverifier/plugin/DefaultPluginDetailsProvider$EventLog;", "getEventLog", "()Lcom/jetbrains/pluginverifier/plugin/DefaultPluginDetailsProvider$EventLog;", "extractedPluginLocationCache", "Ljava/util/concurrent/ConcurrentHashMap;", "Ljava/nio/file/Path;", "Lcom/jetbrains/plugin/structure/base/plugin/PluginCreationResult;", "Lcom/jetbrains/plugin/structure/intellij/plugin/IdePlugin;", "nonBundledPluginDetailsProvider", "Lcom/jetbrains/pluginverifier/plugin/PluginDetailsProviderImpl;", "close", "", "createPlugin", "pluginInfo", "Lcom/jetbrains/pluginverifier/repository/PluginInfo;", "pluginFileLock", "Lcom/jetbrains/pluginverifier/repository/files/FileLock;", "readPluginClasses", "Lcom/jetbrains/plugin/structure/intellij/classes/plugin/IdePluginClassesLocations;", "idePlugin", "cacheExtractedDirectory", "artifactPath", "registerCloseableResources", "EventLog", "verifier-repository"})
@SourceDebugExtension(value={"SMAP\nDefaultPluginDetailsProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultPluginDetailsProvider.kt\ncom/jetbrains/pluginverifier/plugin/DefaultPluginDetailsProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,148:1\n1863#2,2:149\n*S KotlinDebug\n*F\n+ 1 DefaultPluginDetailsProvider.kt\ncom/jetbrains/pluginverifier/plugin/DefaultPluginDetailsProvider\n*L\n100#1:149,2\n*E\n"})
public final class DefaultPluginDetailsProvider
extends AbstractPluginDetailsProvider
implements AutoCloseable {
    @NotNull
    private final PluginDetailsProviderImpl nonBundledPluginDetailsProvider;
    @NotNull
    private final DependencyDetailsProvider dependencyDetailsProvider;
    @NotNull
    private final PluginCreationResultResolver dependencyProblemResolver;
    @NotNull
    private final ConcurrentHashMap<Path, PluginCreationResult<IdePlugin>> extractedPluginLocationCache;
    @NotNull
    private final List<Closeable> closeableResources;
    @NotNull
    private final Striped<Lock> createPluginLocks;
    @NotNull
    private final EventLog eventLog;

    public DefaultPluginDetailsProvider(@NotNull PluginArchiveManager archiveManager) {
        Intrinsics.checkNotNullParameter(archiveManager, "archiveManager");
        super(archiveManager);
        this.nonBundledPluginDetailsProvider = new PluginDetailsProviderImpl(archiveManager);
        this.dependencyDetailsProvider = new DependencyDetailsProvider(archiveManager);
        this.dependencyProblemResolver = JetBrainsPluginCreationResultResolver.Companion.fromClassPathJson(new IntelliJPluginCreationResultResolver());
        this.extractedPluginLocationCache = new ConcurrentHashMap();
        this.closeableResources = new ArrayList();
        this.createPluginLocks = Striped.Companion.lock(RangesKt.coerceAtLeast(UtilKt.getConcurrencyLevel(), 1));
        this.eventLog = new EventLog();
    }

    @Override
    @NotNull
    public IdePluginClassesLocations readPluginClasses(@NotNull PluginInfo pluginInfo, @NotNull IdePlugin idePlugin) {
        Intrinsics.checkNotNullParameter(pluginInfo, "pluginInfo");
        Intrinsics.checkNotNullParameter(idePlugin, "idePlugin");
        PluginInfo pluginInfo2 = pluginInfo;
        return pluginInfo2 instanceof BundledPluginInfo ? BundledPluginClassesFinder.Companion.findPluginClasses(idePlugin, CollectionsKt.listOf(CompileServerExtensionKey.INSTANCE), new ClassSearchContext(this.getArchiveManager())) : (pluginInfo2 instanceof DependencyPluginInfo ? this.dependencyDetailsProvider.readPluginClasses(pluginInfo, idePlugin) : this.nonBundledPluginDetailsProvider.readPluginClasses(pluginInfo, idePlugin));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    protected PluginCreationResult<IdePlugin> createPlugin(@NotNull PluginInfo pluginInfo, @NotNull FileLock pluginFileLock) {
        PluginCreationResult pluginCreationResult;
        Intrinsics.checkNotNullParameter(pluginInfo, "pluginInfo");
        Intrinsics.checkNotNullParameter(pluginFileLock, "pluginFileLock");
        if (pluginInfo instanceof DependencyPluginInfo) {
            Path pluginArtifactPath = pluginFileLock.getFile();
            PluginCreationResult<IdePlugin> result2 = this.extractedPluginLocationCache.get(pluginArtifactPath);
            if (result2 != null) {
                this.eventLog.logCached(pluginArtifactPath);
                return result2;
            }
            Lock lock2 = this.createPluginLocks.get(((Object)pluginArtifactPath.toAbsolutePath()).toString());
            synchronized (lock2) {
                PluginCreationResult pluginCreationResult2;
                block6: {
                    boolean bl = false;
                    PluginCreationResult<IdePlugin> result3 = this.extractedPluginLocationCache.get(pluginArtifactPath);
                    if (result3 == null) break block6;
                    this.eventLog.logCached(pluginArtifactPath);
                    PluginCreationResult<IdePlugin> pluginCreationResult3 = result3;
                    return pluginCreationResult3;
                }
                PluginCreationResult it = pluginCreationResult2 = IdePluginManager.createPlugin$default(this.getIdePluginManager(), pluginArtifactPath, false, null, this.dependencyProblemResolver, 4, null);
                boolean bl = false;
                this.eventLog.logExtracted(pluginArtifactPath);
                this.cacheExtractedDirectory(this.registerCloseableResources(it), pluginArtifactPath);
                PluginCreationResult pluginCreationResult4 = pluginCreationResult2;
                // MONITOREXIT @DISABLED, blocks:[1, 2, 5] lbl29 : MonitorExitStatement: MONITOREXIT : var5_5
                pluginCreationResult = pluginCreationResult4;
            }
        }
        pluginCreationResult = super.createPlugin(pluginInfo, pluginFileLock);
        return pluginCreationResult;
    }

    private final PluginCreationResult<IdePlugin> registerCloseableResources(PluginCreationResult<? extends IdePlugin> $this$registerCloseableResources) {
        PluginCreationResult<IdePlugin> pluginCreationResult;
        PluginCreationResult<IdePlugin> $this$registerCloseableResources_u24lambda_u243 = pluginCreationResult = $this$registerCloseableResources;
        boolean bl = false;
        if ($this$registerCloseableResources_u24lambda_u243 instanceof PluginCreationSuccess) {
            Iterable $this$forEach$iv = ((PluginCreationSuccess)$this$registerCloseableResources_u24lambda_u243).getResources();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Closeable it = (Closeable)element$iv;
                boolean bl2 = false;
                if (it instanceof PluginArchiveResource) continue;
                ((Collection)this.closeableResources).add(DeletableOnClose.Companion.of(it));
            }
        }
        return pluginCreationResult;
    }

    private final PluginCreationResult<IdePlugin> cacheExtractedDirectory(PluginCreationResult<? extends IdePlugin> $this$cacheExtractedDirectory, Path artifactPath) {
        PluginCreationResult<IdePlugin> pluginCreationResult;
        PluginCreationResult<IdePlugin> $this$cacheExtractedDirectory_u24lambda_u244 = pluginCreationResult = $this$cacheExtractedDirectory;
        boolean bl = false;
        if ($this$cacheExtractedDirectory_u24lambda_u244 instanceof PluginCreationSuccess) {
            ((Map)this.extractedPluginLocationCache).put(artifactPath, $this$cacheExtractedDirectory_u24lambda_u244);
        }
        return pluginCreationResult;
    }

    @Override
    public void close() {
        this.getArchiveManager().delete();
        this.eventLog.clear();
        LanguageUtilsKt.closeAll(this.closeableResources);
    }

    public final int getCloseableResourcesSize() {
        return this.closeableResources.size();
    }

    @NotNull
    public final EventLog getEventLog() {
        return this.eventLog;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010%\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0006\u0010\f\u001a\u00020\rJ\u0011\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\tH\u0096\u0002J\u0016\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0017"}, d2={"Lcom/jetbrains/pluginverifier/plugin/DefaultPluginDetailsProvider$EventLog;", "Lkotlin/collections/AbstractList;", "", "()V", "cache", "", "events", "", "size", "", "getSize", "()I", "clear", "", "get", "index", "log", "path", "Ljava/nio/file/Path;", "isCached", "", "logCached", "logExtracted", "verifier-repository"})
    @SourceDebugExtension(value={"SMAP\nDefaultPluginDetailsProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultPluginDetailsProvider.kt\ncom/jetbrains/pluginverifier/plugin/DefaultPluginDetailsProvider$EventLog\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,148:1\n381#2,7:149\n*S KotlinDebug\n*F\n+ 1 DefaultPluginDetailsProvider.kt\ncom/jetbrains/pluginverifier/plugin/DefaultPluginDetailsProvider$EventLog\n*L\n135#1:149,7\n*E\n"})
    public static final class EventLog
    extends AbstractList<String> {
        @NotNull
        private final List<String> events = new ArrayList();
        @NotNull
        private final Map<String, String> cache = new HashMap();

        public final void logCached(@NotNull Path path) {
            Intrinsics.checkNotNullParameter(path, "path");
            this.log(path, true);
        }

        public final void logExtracted(@NotNull Path path) {
            Intrinsics.checkNotNullParameter(path, "path");
            this.log(path, false);
        }

        public final void log(@NotNull Path path, boolean isCached) {
            Object object;
            Intrinsics.checkNotNullParameter(path, "path");
            String event = (isCached ? "cached " : "extracted ") + path;
            Collection collection = this.events;
            Map<String, String> $this$getOrPut$iv = this.cache;
            boolean $i$f$getOrPut = false;
            String value$iv = $this$getOrPut$iv.get(event);
            if (value$iv == null) {
                boolean bl = false;
                String answer$iv = event;
                $this$getOrPut$iv.put(event, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            String string = object;
            collection.add(string);
        }

        @Override
        public int getSize() {
            return this.events.size();
        }

        @Override
        @NotNull
        public String get(int index) {
            return this.events.get(index);
        }

        @Override
        public final void clear() {
            this.cache.clear();
            this.events.clear();
        }
    }
}

