/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.pluginverifier.output.teamcity;

import java.io.Closeable;
import java.io.PrintStream;
import java.io.PrintWriter;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u0004\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0003+,-B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\r\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0012\u0010\b\u001a\u00060\tR\u00020\u00002\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000bJ\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u000bJ\u0016\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u000bJ\u000e\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u000bJ\u000e\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u000bJ\u0010\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u000bH\u0002J\u000e\u0010\u001a\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u000bJ\u000e\u0010\u001b\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u000bJ\u0016\u0010\u001b\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u000bJ\u000e\u0010\u001d\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u000bJ\u001e\u0010\u001e\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\u001f\u001a\u00020\u000bJ\u0016\u0010 \u001a\u00020\r2\u0006\u0010!\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u000bJ\u0012\u0010\"\u001a\u00060#R\u00020\u00002\u0006\u0010!\u001a\u00020\u000bJ\u0016\u0010$\u001a\u00020\r2\u0006\u0010!\u001a\u00020\u000b2\u0006\u0010%\u001a\u00020\u000bJ\u0016\u0010&\u001a\u00020\r2\u0006\u0010!\u001a\u00020\u000b2\u0006\u0010'\u001a\u00020\u000bJ\u0012\u0010(\u001a\u00060)R\u00020\u00002\u0006\u0010*\u001a\u00020\u000bR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lcom/jetbrains/pluginverifier/output/teamcity/TeamCityLog;", "", "printStream", "Ljava/io/PrintStream;", "(Ljava/io/PrintStream;)V", "out", "Ljava/io/PrintWriter;", "(Ljava/io/PrintWriter;)V", "blockOpen", "Lcom/jetbrains/pluginverifier/output/teamcity/TeamCityLog$Block;", "name", "", "buildProblem", "", "description", "identity", "buildStatisticValue", "key", "value", "", "buildStatus", "text", "buildStatusFailure", "buildStatusSuccess", "escape", "s", "message", "messageError", "errorDetails", "messageWarn", "testFailed", "details", "testIgnored", "testName", "testStarted", "Lcom/jetbrains/pluginverifier/output/teamcity/TeamCityLog$Test;", "testStdErr", "errText", "testStdOut", "outText", "testSuiteStarted", "Lcom/jetbrains/pluginverifier/output/teamcity/TeamCityLog$TestSuite;", "suiteName", "Block", "Test", "TestSuite", "verifier-cli"})
public final class TeamCityLog {
    @NotNull
    private final PrintWriter out;

    public TeamCityLog(@NotNull PrintWriter out) {
        Intrinsics.checkNotNullParameter(out, "out");
        this.out = out;
    }

    public TeamCityLog(@NotNull PrintStream printStream) {
        Intrinsics.checkNotNullParameter(printStream, "printStream");
        this(new PrintWriter(printStream, true));
    }

    public final void messageError(@NotNull String text) {
        Intrinsics.checkNotNullParameter(text, "text");
        Object[] objectArray = new Object[]{this.escape(text)};
        this.out.printf("##teamcity[message text='%s' status='ERROR']\n", objectArray);
    }

    public final void messageError(@NotNull String text, @NotNull String errorDetails) {
        Intrinsics.checkNotNullParameter(text, "text");
        Intrinsics.checkNotNullParameter(errorDetails, "errorDetails");
        Object[] objectArray = new Object[]{this.escape(text), this.escape(errorDetails)};
        this.out.printf("##teamcity[message text='%s' errorDetails='%s' status='ERROR']\n", objectArray);
    }

    public final void message(@NotNull String text) {
        Intrinsics.checkNotNullParameter(text, "text");
        Object[] objectArray = new Object[]{this.escape(text)};
        this.out.printf("##teamcity[message text='%s']\n", objectArray);
    }

    public final void messageWarn(@NotNull String text) {
        Intrinsics.checkNotNullParameter(text, "text");
        Object[] objectArray = new Object[]{this.escape(text)};
        this.out.printf("##teamcity[message text='%s' status='WARNING']\n", objectArray);
    }

    public final void buildProblem(@NotNull String description2) {
        Intrinsics.checkNotNullParameter(description2, "description");
        Object[] objectArray = new Object[]{this.escape(description2)};
        this.out.printf("##teamcity[buildProblem description='%s']\n", objectArray);
    }

    public final void buildProblem(@NotNull String description2, @NotNull String identity) {
        Intrinsics.checkNotNullParameter(description2, "description");
        Intrinsics.checkNotNullParameter(identity, "identity");
        Object[] objectArray = new Object[]{this.escape(description2), this.escape(identity)};
        this.out.printf("##teamcity[buildProblem description='%s' identity='%s']\n", objectArray);
    }

    public final void buildStatus(@NotNull String text) {
        Intrinsics.checkNotNullParameter(text, "text");
        Object[] objectArray = new Object[]{this.escape(text)};
        this.out.printf("##teamcity[buildStatus text='%s']\n", objectArray);
    }

    public final void buildStatusSuccess(@NotNull String text) {
        Intrinsics.checkNotNullParameter(text, "text");
        Object[] objectArray = new Object[]{this.escape(text)};
        this.out.printf("##teamcity[buildStatus status='SUCCESS' text='%s']\n", objectArray);
    }

    public final void buildStatusFailure(@NotNull String text) {
        Intrinsics.checkNotNullParameter(text, "text");
        Object[] objectArray = new Object[]{this.escape(text)};
        this.out.printf("##teamcity[buildStatus status='FAILURE' text='%s']\n", objectArray);
    }

    public final void testIgnored(@NotNull String testName, @NotNull String message2) {
        Intrinsics.checkNotNullParameter(testName, "testName");
        Intrinsics.checkNotNullParameter(message2, "message");
        Object[] objectArray = new Object[]{this.escape(testName), this.escape(message2)};
        this.out.printf("##teamcity[testIgnored name='%s' message='%s']\n", objectArray);
    }

    public final void testStdOut(@NotNull String testName, @NotNull String outText) {
        Intrinsics.checkNotNullParameter(testName, "testName");
        Intrinsics.checkNotNullParameter(outText, "outText");
        Object[] objectArray = new Object[]{this.escape(testName), this.escape(outText)};
        this.out.printf("##teamcity[testStdOut name='%s' out='%s']\n", objectArray);
    }

    public final void testStdErr(@NotNull String testName, @NotNull String errText) {
        Intrinsics.checkNotNullParameter(testName, "testName");
        Intrinsics.checkNotNullParameter(errText, "errText");
        Object[] objectArray = new Object[]{this.escape(testName), this.escape(errText)};
        this.out.printf("##teamcity[testStdErr name='%s' out='%s']\n", objectArray);
    }

    public final void testFailed(@NotNull String name, @NotNull String message2, @NotNull String details) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(message2, "message");
        Intrinsics.checkNotNullParameter(details, "details");
        Object[] objectArray = new Object[]{this.escape(name), this.escape(message2), this.escape(details)};
        this.out.printf("##teamcity[testFailed name='%s' message='%s' details='%s']\n", objectArray);
    }

    @NotNull
    public final Block blockOpen(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        Object[] objectArray = new Object[]{this.escape(name)};
        this.out.printf("##teamcity[blockOpened name='%s']\n", objectArray);
        return new Block(name);
    }

    @NotNull
    public final TestSuite testSuiteStarted(@NotNull String suiteName) {
        Intrinsics.checkNotNullParameter(suiteName, "suiteName");
        Object[] objectArray = new Object[]{this.escape(suiteName)};
        this.out.printf("##teamcity[testSuiteStarted name='%s']\n", objectArray);
        return new TestSuite(suiteName);
    }

    @NotNull
    public final Test testStarted(@NotNull String testName) {
        Intrinsics.checkNotNullParameter(testName, "testName");
        Object[] objectArray = new Object[]{this.escape(testName)};
        this.out.printf("##teamcity[testStarted name='%s']\n", objectArray);
        return new Test(testName);
    }

    public final void buildStatisticValue(@NotNull String key, @NotNull Number value) {
        Intrinsics.checkNotNullParameter(key, "key");
        Intrinsics.checkNotNullParameter(value, "value");
        this.out.printf("##teamcity[buildStatisticValue key='" + this.escape(key) + "' value='" + value + "']\n", new Object[0]);
    }

    private final String escape(String s2) {
        CharSequence charSequence = s2;
        Regex regex = new Regex("[\\|'\\[\\]]");
        String string = "\\|$0";
        charSequence = regex.replace(charSequence, string);
        regex = new Regex("\n");
        string = "|n";
        charSequence = regex.replace(charSequence, string);
        regex = new Regex("\r");
        string = "|r";
        return regex.replace(charSequence, string);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/pluginverifier/output/teamcity/TeamCityLog$Block;", "Ljava/io/Closeable;", "name", "", "(Lcom/jetbrains/pluginverifier/output/teamcity/TeamCityLog;Ljava/lang/String;)V", "close", "", "verifier-cli"})
    public final class Block
    implements Closeable {
        @NotNull
        private final String name;

        public Block(String name) {
            Intrinsics.checkNotNullParameter(name, "name");
            this.name = name;
        }

        @Override
        public void close() {
            Object[] objectArray = new Object[]{TeamCityLog.this.escape(this.name)};
            TeamCityLog.this.out.printf("##teamcity[blockClosed name='%s']\n", objectArray);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/pluginverifier/output/teamcity/TeamCityLog$Test;", "Ljava/io/Closeable;", "testName", "", "(Lcom/jetbrains/pluginverifier/output/teamcity/TeamCityLog;Ljava/lang/String;)V", "close", "", "verifier-cli"})
    public final class Test
    implements Closeable {
        @NotNull
        private final String testName;

        public Test(String testName) {
            Intrinsics.checkNotNullParameter(testName, "testName");
            this.testName = testName;
        }

        @Override
        public void close() {
            Object[] objectArray = new Object[]{TeamCityLog.this.escape(this.testName)};
            TeamCityLog.this.out.printf("##teamcity[testFinished name='%s']\n", objectArray);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/pluginverifier/output/teamcity/TeamCityLog$TestSuite;", "Ljava/io/Closeable;", "suiteName", "", "(Lcom/jetbrains/pluginverifier/output/teamcity/TeamCityLog;Ljava/lang/String;)V", "close", "", "verifier-cli"})
    public final class TestSuite
    implements Closeable {
        @NotNull
        private final String suiteName;

        public TestSuite(String suiteName) {
            Intrinsics.checkNotNullParameter(suiteName, "suiteName");
            this.suiteName = suiteName;
        }

        @Override
        public void close() {
            Object[] objectArray = new Object[]{TeamCityLog.this.escape(this.suiteName)};
            TeamCityLog.this.out.printf("##teamcity[testSuiteFinished name='%s']\n", objectArray);
        }
    }
}

