/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.pluginverifier.jdk;

import com.jetbrains.plugin.structure.base.utils.FileUtilKt;
import com.jetbrains.plugin.structure.ide.Ide;
import com.jetbrains.pluginverifier.jdk.JdkDescriptor;
import com.jetbrains.pluginverifier.jdk.JdkDescriptorCreator;
import com.jetbrains.pluginverifier.jdk.JdkDescriptorProvider;
import com.jetbrains.pluginverifier.jdk.JdkDescriptorProvidersKt;
import java.nio.file.Path;
import java.nio.file.Paths;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\n\u0010\u0003\u001a\u0004\u0018\u00010\u0004H\u0002J\u0014\u0010\u0005\u001a\u0004\u0018\u00010\u00042\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0002J\u0012\u0010\b\u001a\u0004\u0018\u00010\u00042\u0006\u0010\t\u001a\u00020\nH\u0002J\n\u0010\u000b\u001a\u0004\u0018\u00010\u0004H\u0002J\u001a\u0010\f\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0007H\u0016\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/pluginverifier/jdk/DefaultJdkDescriptorProvider;", "Lcom/jetbrains/pluginverifier/jdk/JdkDescriptorProvider;", "()V", "fromCurrentJvm", "Lcom/jetbrains/pluginverifier/jdk/JdkDescriptor;", "fromExplicitPath", "javaHome", "Ljava/nio/file/Path;", "fromIdeBundled", "ide", "Lcom/jetbrains/plugin/structure/ide/Ide;", "fromJavaHome", "getJdkDescriptor", "Lcom/jetbrains/pluginverifier/jdk/JdkDescriptorProvider$Result;", "defaultJdkPath", "verifier-intellij"})
public final class DefaultJdkDescriptorProvider
implements JdkDescriptorProvider {
    @Override
    @NotNull
    public JdkDescriptorProvider.Result getJdkDescriptor(@NotNull Ide ide2, @Nullable Path defaultJdkPath) {
        Intrinsics.checkNotNullParameter(ide2, "ide");
        JdkDescriptor jdkDescriptor = this.fromExplicitPath(defaultJdkPath);
        if (jdkDescriptor == null && (jdkDescriptor = this.fromIdeBundled(ide2)) == null && (jdkDescriptor = this.fromJavaHome()) == null) {
            jdkDescriptor = this.fromCurrentJvm();
        }
        JdkDescriptor jdkDescriptor2 = jdkDescriptor;
        return JdkDescriptorProvidersKt.access$toResult(jdkDescriptor2);
    }

    private final JdkDescriptor fromIdeBundled(Ide ide2) {
        return JdkDescriptorCreator.createBundledJdkDescriptor$default(JdkDescriptorCreator.INSTANCE, ide2, null, 2, null);
    }

    private final JdkDescriptor fromExplicitPath(Path javaHome) {
        Path path = javaHome;
        return (path != null ? FileUtilKt.isDirectory(path) : false) ? JdkDescriptorCreator.createJdkDescriptor$default(JdkDescriptorCreator.INSTANCE, javaHome, null, 2, null) : null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final JdkDescriptor fromJavaHome() {
        Object javaHome;
        Object object;
        try {
            object = System.getenv("JAVA_HOME");
        }
        catch (SecurityException securityException) {
            return null;
        }
        String string = object;
        if (string == null) return null;
        Object it = string;
        boolean bl = false;
        object = Paths.get((String)it, new String[0]);
        if (object == null) return null;
        it = securityException = object;
        boolean bl2 = false;
        if (!FileUtilKt.isDirectory((Path)it)) return null;
        Object object2 = securityException;
        Object object3 = javaHome = object2;
        if (object3 == null) return null;
        Object it2 = object3;
        boolean bl3 = false;
        JdkDescriptor jdkDescriptor = JdkDescriptorCreator.createJdkDescriptor$default(JdkDescriptorCreator.INSTANCE, it2, null, 2, null);
        return jdkDescriptor;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final JdkDescriptor fromCurrentJvm() {
        Object javaHome;
        Object object;
        try {
            object = System.getProperty("java.home");
        }
        catch (SecurityException securityException) {
            return null;
        }
        String string = object;
        if (string == null) return null;
        Object it = string;
        boolean bl = false;
        object = Paths.get((String)it, new String[0]);
        if (object == null) return null;
        it = securityException = object;
        boolean bl2 = false;
        if (!FileUtilKt.isDirectory((Path)it)) return null;
        Object object2 = securityException;
        Object object3 = javaHome = object2;
        if (object3 == null) return null;
        Object it2 = object3;
        boolean bl3 = false;
        JdkDescriptor jdkDescriptor = JdkDescriptorCreator.createJdkDescriptor$default(JdkDescriptorCreator.INSTANCE, it2, null, 2, null);
        return jdkDescriptor;
    }
}

