/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.pluginverifier.filtering;

import com.jetbrains.pluginverifier.filtering.KeepOnlyCondition;
import com.jetbrains.pluginverifier.filtering.KeepOnlyProblemsFilter;
import com.jetbrains.pluginverifier.filtering.ProblemsFilter;
import com.jetbrains.pluginverifier.results.problems.CompatibilityProblem;
import com.jetbrains.pluginverifier.verifiers.PluginVerificationContext;
import com.jetbrains.pluginverifier.verifiers.VerificationContext;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/pluginverifier/filtering/KeepOnlyProblemsFilter;", "Lcom/jetbrains/pluginverifier/filtering/ProblemsFilter;", "keepOnlyConditions", "", "Lcom/jetbrains/pluginverifier/filtering/KeepOnlyCondition;", "(Ljava/util/List;)V", "getKeepOnlyConditions", "()Ljava/util/List;", "shouldReportProblem", "Lcom/jetbrains/pluginverifier/filtering/ProblemsFilter$Result;", "problem", "Lcom/jetbrains/pluginverifier/results/problems/CompatibilityProblem;", "context", "Lcom/jetbrains/pluginverifier/verifiers/VerificationContext;", "verifier-intellij"})
@SourceDebugExtension(value={"SMAP\nKeepOnlyProblemsFilter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KeepOnlyProblemsFilter.kt\ncom/jetbrains/pluginverifier/filtering/KeepOnlyProblemsFilter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,41:1\n1855#2,2:42\n*S KotlinDebug\n*F\n+ 1 KeepOnlyProblemsFilter.kt\ncom/jetbrains/pluginverifier/filtering/KeepOnlyProblemsFilter\n*L\n27#1:42,2\n*E\n"})
public final class KeepOnlyProblemsFilter
implements ProblemsFilter {
    @NotNull
    private final List<KeepOnlyCondition> keepOnlyConditions;

    public KeepOnlyProblemsFilter(@NotNull List<KeepOnlyCondition> keepOnlyConditions) {
        Intrinsics.checkNotNullParameter(keepOnlyConditions, "keepOnlyConditions");
        this.keepOnlyConditions = keepOnlyConditions;
    }

    @NotNull
    public final List<KeepOnlyCondition> getKeepOnlyConditions() {
        return this.keepOnlyConditions;
    }

    @Override
    @NotNull
    public ProblemsFilter.Result shouldReportProblem(@NotNull CompatibilityProblem problem, @NotNull VerificationContext context) {
        Intrinsics.checkNotNullParameter(problem, "problem");
        Intrinsics.checkNotNullParameter(context, "context");
        if (!(context instanceof PluginVerificationContext)) {
            return ProblemsFilter.Result.Report.INSTANCE;
        }
        String currentId = ((PluginVerificationContext)context).getIdePlugin().getPluginId();
        String currentVersion = ((PluginVerificationContext)context).getIdePlugin().getPluginVersion();
        Function2 isNullOrMatch2 = shouldReportProblem.isNullOrMatch.1.INSTANCE;
        Iterable $this$forEach$iv = this.keepOnlyConditions;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KeepOnlyCondition keepOnlyCondition = (KeepOnlyCondition)element$iv;
            boolean bl = false;
            Regex pluginIdPattern = keepOnlyCondition.component1();
            Regex versionPattern = keepOnlyCondition.component2();
            Regex problemPattern = keepOnlyCondition.component3();
            if (!((Boolean)isNullOrMatch2.invoke(currentId, pluginIdPattern)).booleanValue() || !((Boolean)isNullOrMatch2.invoke(currentVersion, versionPattern)).booleanValue() || problemPattern.matches(problem.getShortDescription())) continue;
            return new ProblemsFilter.Result.Ignore("the problem is ignored as it's not matching any pattern for keeping problems : \"" + keepOnlyCondition.serializeCondition());
        }
        return ProblemsFilter.Result.Report.INSTANCE;
    }
}

