/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.pluginverifier.filtering;

import com.jetbrains.pluginverifier.filtering.IgnoreCondition;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\b\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B!\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u000b\u0010\r\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u000e\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0006H\u00c6\u0003J+\u0010\u0010\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u0006\u0010\u0016\u001a\u00020\u0003J\t\u0010\u0017\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000b\u00a8\u0006\u0019"}, d2={"Lcom/jetbrains/pluginverifier/filtering/IgnoreCondition;", "", "pluginId", "", "version", "pattern", "Lkotlin/text/Regex;", "(Ljava/lang/String;Ljava/lang/String;Lkotlin/text/Regex;)V", "getPattern", "()Lkotlin/text/Regex;", "getPluginId", "()Ljava/lang/String;", "getVersion", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "serializeCondition", "toString", "Companion", "verifier-intellij"})
public final class IgnoreCondition {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final String pluginId;
    @Nullable
    private final String version;
    @NotNull
    private final Regex pattern;
    @NotNull
    private static final String USAGE = "  Ignoring line must be in the form: [<plugin_xml_id>[:<plugin_version>]:]<problem_description_regexp_pattern>\nExamples:\norg.some.plugin:3.4.0:access to unresolved class org.foo.Foo.*                    --- ignore for plugin 'org.some.plugin' of version 3.4.0\norg.jetbrains.kotlin::access to unresolved class org.jetbrains.kotlin.compiler.*  --- ignore for all versions of Kotlin plugin\naccess to unresolved class org.jetbrains.kotlin.compiler.*                        --- ignore for all plugins";

    public IgnoreCondition(@Nullable String pluginId, @Nullable String version, @NotNull Regex pattern) {
        Intrinsics.checkNotNullParameter(pattern, "pattern");
        this.pluginId = pluginId;
        this.version = version;
        this.pattern = pattern;
    }

    @Nullable
    public final String getPluginId() {
        return this.pluginId;
    }

    @Nullable
    public final String getVersion() {
        return this.version;
    }

    @NotNull
    public final Regex getPattern() {
        return this.pattern;
    }

    @NotNull
    public final String serializeCondition() {
        StringBuilder stringBuilder;
        StringBuilder $this$serializeCondition_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        if (this.pluginId != null) {
            $this$serializeCondition_u24lambda_u240.append(this.pluginId).append(":");
        }
        if (this.version != null) {
            $this$serializeCondition_u24lambda_u240.append(this.version).append(":");
        }
        $this$serializeCondition_u24lambda_u240.append(this.pattern.getPattern());
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        return string;
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof IgnoreCondition && Intrinsics.areEqual(this.pluginId, ((IgnoreCondition)other).pluginId) && Intrinsics.areEqual(this.version, ((IgnoreCondition)other).version) && Intrinsics.areEqual(this.pattern.getPattern(), ((IgnoreCondition)other).pattern.getPattern());
    }

    public int hashCode() {
        Object[] objectArray = new Object[]{this.pluginId, this.version, this.pattern.getPattern()};
        return Objects.hash(objectArray);
    }

    @Nullable
    public final String component1() {
        return this.pluginId;
    }

    @Nullable
    public final String component2() {
        return this.version;
    }

    @NotNull
    public final Regex component3() {
        return this.pattern;
    }

    @NotNull
    public final IgnoreCondition copy(@Nullable String pluginId, @Nullable String version, @NotNull Regex pattern) {
        Intrinsics.checkNotNullParameter(pattern, "pattern");
        return new IgnoreCondition(pluginId, version, pattern);
    }

    public static /* synthetic */ IgnoreCondition copy$default(IgnoreCondition ignoreCondition, String string, String string2, Regex regex, int n, Object object) {
        if ((n & 1) != 0) {
            string = ignoreCondition.pluginId;
        }
        if ((n & 2) != 0) {
            string2 = ignoreCondition.version;
        }
        if ((n & 4) != 0) {
            regex = ignoreCondition.pattern;
        }
        return ignoreCondition.copy(string, string2, regex);
    }

    @NotNull
    public String toString() {
        return "IgnoreCondition(pluginId=" + this.pluginId + ", version=" + this.version + ", pattern=" + this.pattern + ")";
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/jetbrains/pluginverifier/filtering/IgnoreCondition$Companion;", "", "()V", "USAGE", "", "parseCondition", "Lcom/jetbrains/pluginverifier/filtering/IgnoreCondition;", "line", "verifier-intellij"})
    @SourceDebugExtension(value={"SMAP\nIgnoreCondition.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IgnoreCondition.kt\ncom/jetbrains/pluginverifier/filtering/IgnoreCondition$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,67:1\n1549#2:68\n1620#2,3:69\n1#3:72\n*S KotlinDebug\n*F\n+ 1 IgnoreCondition.kt\ncom/jetbrains/pluginverifier/filtering/IgnoreCondition$Companion\n*L\n36#1:68\n36#1:69,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final IgnoreCondition parseCondition(@NotNull String line) {
            IgnoreCondition ignoreCondition;
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter(line, "line");
            String[] stringArray = new String[]{":"};
            Iterable $this$map$iv = StringsKt.split$default((CharSequence)line, stringArray, false, 0, 6, null);
            boolean $i$f$map = false;
            Iterable<Object> iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(((Object)StringsKt.trim((CharSequence)it)).toString());
            }
            List tokens = (List)destination$iv$iv;
            Function1 parseRegexp2 = parseCondition.parseRegexp.1.INSTANCE;
            switch (tokens.size()) {
                case 1: {
                    ignoreCondition = new IgnoreCondition(null, null, (Regex)parseRegexp2.invoke(tokens.get(0)));
                    break;
                }
                case 2: {
                    ignoreCondition = new IgnoreCondition((String)tokens.get(0), null, (Regex)parseRegexp2.invoke(tokens.get(1)));
                    break;
                }
                case 3: {
                    iterable = tokens.get(0);
                    String p0 = (String)((Object)iterable);
                    boolean bl = false;
                    Iterable<Object> iterable2 = ((CharSequence)p0).length() > 0 ? iterable : null;
                    iterable = tokens.get(1);
                    p0 = (String)((Object)iterable);
                    String string = (String)((Object)iterable2);
                    boolean bl2 = false;
                    boolean bl3 = ((CharSequence)p0).length() > 0;
                    Regex regex = (Regex)parseRegexp2.invoke(tokens.get(2));
                    String string2 = (String)((Object)(bl3 ? iterable : null));
                    String string3 = string;
                    ignoreCondition = new IgnoreCondition(string3, string2, regex);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Incorrect problem ignoring line\n" + line + "\n" + USAGE);
                }
            }
            return ignoreCondition;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

