/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.pluginverifier.dependencies.resolution;

import com.jetbrains.plugin.structure.intellij.version.IdeVersion;
import com.jetbrains.pluginverifier.dependencies.resolution.PluginVersionSelector;
import com.jetbrains.pluginverifier.repository.PluginInfo;
import com.jetbrains.pluginverifier.repository.PluginRepository;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/pluginverifier/dependencies/resolution/LastCompatibleVersionSelector;", "Lcom/jetbrains/pluginverifier/dependencies/resolution/PluginVersionSelector;", "ideVersion", "Lcom/jetbrains/plugin/structure/intellij/version/IdeVersion;", "(Lcom/jetbrains/plugin/structure/intellij/version/IdeVersion;)V", "getIdeVersion", "()Lcom/jetbrains/plugin/structure/intellij/version/IdeVersion;", "selectPluginByModuleId", "Lcom/jetbrains/pluginverifier/dependencies/resolution/PluginVersionSelector$Result;", "moduleId", "", "pluginRepository", "Lcom/jetbrains/pluginverifier/repository/PluginRepository;", "selectPluginVersion", "pluginId", "verifier-intellij"})
public final class LastCompatibleVersionSelector
implements PluginVersionSelector {
    @NotNull
    private final IdeVersion ideVersion;

    public LastCompatibleVersionSelector(@NotNull IdeVersion ideVersion) {
        Intrinsics.checkNotNullParameter(ideVersion, "ideVersion");
        this.ideVersion = ideVersion;
    }

    @NotNull
    public final IdeVersion getIdeVersion() {
        return this.ideVersion;
    }

    @Override
    @NotNull
    public PluginVersionSelector.Result selectPluginVersion(@NotNull String pluginId, @NotNull PluginRepository pluginRepository) {
        Intrinsics.checkNotNullParameter(pluginId, "pluginId");
        Intrinsics.checkNotNullParameter(pluginRepository, "pluginRepository");
        PluginInfo pluginInfo = pluginRepository.getLastCompatibleVersionOfPlugin(this.ideVersion, pluginId);
        if (pluginInfo != null) {
            return new PluginVersionSelector.Result.Selected(pluginInfo);
        }
        List<PluginInfo> allVersions = pluginRepository.getAllVersionsOfPlugin(pluginId);
        if (allVersions.isEmpty()) {
            return new PluginVersionSelector.Result.NotFound("Plugin " + pluginId + " is not available in " + pluginRepository.getPresentableName());
        }
        return new PluginVersionSelector.Result.NotFound("Plugin " + pluginId + " doesn't have a build compatible with " + this.ideVersion + " in " + pluginRepository.getPresentableName());
    }

    @Override
    @NotNull
    public PluginVersionSelector.Result selectPluginByModuleId(@NotNull String moduleId, @NotNull PluginRepository pluginRepository) {
        Intrinsics.checkNotNullParameter(moduleId, "moduleId");
        Intrinsics.checkNotNullParameter(pluginRepository, "pluginRepository");
        List<PluginInfo> plugins2 = pluginRepository.getPluginsDeclaringModule(moduleId, this.ideVersion);
        PluginInfo somePlugin = CollectionsKt.firstOrNull(plugins2);
        if (somePlugin != null) {
            return new PluginVersionSelector.Result.Selected(somePlugin);
        }
        return new PluginVersionSelector.Result.NotFound("Plugins declaring module '" + moduleId + "' are not found in " + pluginRepository.getPresentableName());
    }
}

