/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.jar;

import com.jetbrains.plugin.structure.fs.FsHandlerFileSystemProvider;
import com.jetbrains.plugin.structure.fs.FsHandlerPath;
import com.jetbrains.plugin.structure.jar.FsHandleFileSystemKt;
import com.jetbrains.plugin.structure.jar.JarFileSystemProvider;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.WatchService;
import java.nio.file.attribute.UserPrincipalLookupService;
import java.nio.file.spi.FileSystemProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0006\u0010\u0011\u001a\u00020\u0010J\u000e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0016J\b\u0010\u0015\u001a\u00020\u0001H\u0002J-\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u00182\u0016\u0010\u0019\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00180\u001a\"\u0004\u0018\u00010\u0018H\u0016\u00a2\u0006\u0002\u0010\u001bJ\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0018H\u0016J\u000e\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00060\u0013H\u0016J\b\u0010 \u001a\u00020\u0018H\u0016J\b\u0010!\u001a\u00020\"H\u0016J\u000e\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u0001J\u0006\u0010&\u001a\u00020$J\u000e\u0010&\u001a\u00020$2\u0006\u0010'\u001a\u00020(J\b\u0010)\u001a\u00020$H\u0016J\b\u0010*\u001a\u00020$H\u0016J\b\u0010+\u001a\u00020,H\u0016J\b\u0010\u0003\u001a\u00020-H\u0016J\u000e\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00180/H\u0016R\u000e\u0010\b\u001a\u00020\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lcom/jetbrains/plugin/structure/jar/FsHandleFileSystem;", "Ljava/nio/file/FileSystem;", "initialDelegateFileSystem", "provider", "Lcom/jetbrains/plugin/structure/jar/JarFileSystemProvider;", "path", "Ljava/nio/file/Path;", "(Ljava/nio/file/FileSystem;Lcom/jetbrains/plugin/structure/jar/JarFileSystemProvider;Ljava/nio/file/Path;)V", "_delegateFileSystem", "delegateFileSystem", "getDelegateFileSystem", "()Ljava/nio/file/FileSystem;", "getInitialDelegateFileSystem", "referenceCount", "Ljava/util/concurrent/atomic/AtomicInteger;", "close", "", "closeDelegate", "getFileStores", "", "Ljava/nio/file/FileStore;", "getOrReopenDelegateFileSystem", "getPath", "first", "", "more", "", "(Ljava/lang/String;[Ljava/lang/String;)Ljava/nio/file/Path;", "getPathMatcher", "Ljava/nio/file/PathMatcher;", "syntaxAndPattern", "getRootDirectories", "getSeparator", "getUserPrincipalLookupService", "Ljava/nio/file/attribute/UserPrincipalLookupService;", "hasSameDelegate", "", "fs", "increment", "amount", "", "isOpen", "isReadOnly", "newWatchService", "Ljava/nio/file/WatchService;", "Ljava/nio/file/spi/FileSystemProvider;", "supportedFileAttributeViews", "", "structure-base"})
@SourceDebugExtension(value={"SMAP\nFsHandleFileSystem.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FsHandleFileSystem.kt\ncom/jetbrains/plugin/structure/jar/FsHandleFileSystem\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,151:1\n1#2:152\n1549#3:153\n1620#3,3:154\n*E\n*S KotlinDebug\n*F\n+ 1 FsHandleFileSystem.kt\ncom/jetbrains/plugin/structure/jar/FsHandleFileSystem\n*L\n132#1:153\n132#1,3:154\n*E\n"})
public final class FsHandleFileSystem
extends FileSystem {
    @NotNull
    private final FileSystem initialDelegateFileSystem;
    @NotNull
    private final JarFileSystemProvider provider;
    @NotNull
    private final Path path;
    @NotNull
    private final AtomicInteger referenceCount;
    @NotNull
    private FileSystem _delegateFileSystem;

    public FsHandleFileSystem(@NotNull FileSystem initialDelegateFileSystem, @NotNull JarFileSystemProvider provider, @NotNull Path path) {
        Intrinsics.checkNotNullParameter(initialDelegateFileSystem, "initialDelegateFileSystem");
        Intrinsics.checkNotNullParameter(provider, "provider");
        Intrinsics.checkNotNullParameter(path, "path");
        this.initialDelegateFileSystem = initialDelegateFileSystem;
        this.provider = provider;
        this.path = path;
        this.referenceCount = new AtomicInteger(1);
        this._delegateFileSystem = this.initialDelegateFileSystem;
    }

    @NotNull
    public final FileSystem getInitialDelegateFileSystem() {
        return this.initialDelegateFileSystem;
    }

    @NotNull
    public final FileSystem getDelegateFileSystem() {
        return this.getOrReopenDelegateFileSystem();
    }

    public final boolean increment() {
        return this.increment(1);
    }

    public final boolean increment(int amount) {
        int updated;
        int current;
        do {
            if ((current = this.referenceCount.get()) < 0) {
                return false;
            }
            if (this.getDelegateFileSystem().isOpen()) continue;
            return false;
        } while (!this.referenceCount.compareAndSet(current, updated = current + amount));
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final FileSystem getOrReopenDelegateFileSystem() {
        FileSystem $i$a$-synchronized-FsHandleFileSystem$getOrReopenDelegateFileSystem$fs$22;
        FileSystem fs = null;
        FsHandleFileSystem fsHandleFileSystem = this;
        synchronized (fsHandleFileSystem) {
            boolean $i$a$-synchronized-FsHandleFileSystem$getOrReopenDelegateFileSystem$fs$22 = false;
            $i$a$-synchronized-FsHandleFileSystem$getOrReopenDelegateFileSystem$fs$22 = this._delegateFileSystem;
        }
        fs = $i$a$-synchronized-FsHandleFileSystem$getOrReopenDelegateFileSystem$fs$22;
        if (fs.isOpen()) {
            return fs;
        }
        fsHandleFileSystem = this;
        synchronized (fsHandleFileSystem) {
            block8: {
                boolean bl = false;
                fs = this._delegateFileSystem;
                if (!fs.isOpen()) break block8;
                FileSystem fileSystem = fs;
                return fileSystem;
            }
            FsHandleFileSystemKt.access$getLOG$p().debug("Reopening filesystem delegate for <{}>", (Object)this.path);
            this._delegateFileSystem = fs = this.provider.getFileSystem(this.path);
            FileSystem fileSystem = fs;
            return fileSystem;
        }
    }

    @Override
    public void close() {
        int current;
        do {
            if ((current = this.referenceCount.get()) > 0) continue;
            return;
        } while (!this.referenceCount.compareAndSet(current, current - 1));
        if (current == 1) {
            this.closeDelegate();
            this.referenceCount.set(-1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void closeDelegate() {
        FileSystem fileSystem;
        FsHandleFileSystem fsHandleFileSystem = this;
        synchronized (fsHandleFileSystem) {
            boolean bl = false;
            fileSystem = this._delegateFileSystem;
        }
        FileSystem fs = fileSystem;
        try {
            if (fs.isOpen()) {
                fs.close();
            }
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            FsHandleFileSystemKt.access$getLOG$p().info("Cannot close due to an interruption for [{}]", (Object)fs);
        }
        catch (kotlin.io.NoSuchFileException noSuchFileException) {
            FsHandleFileSystemKt.access$getLOG$p().debug("Cannot close as the file no longer exists for [{}]", (Object)fs);
        }
        catch (NoSuchFileException noSuchFileException) {
            FsHandleFileSystemKt.access$getLOG$p().debug("Cannot close as the file no longer exists for [{}]", (Object)fs);
        }
        catch (Exception e) {
            FsHandleFileSystemKt.access$getLOG$p().error("Unable to close [{}]", (Object)fs, (Object)e);
        }
    }

    @Override
    public boolean isOpen() {
        return this.referenceCount.get() >= 0 && this.getDelegateFileSystem().isOpen();
    }

    @Override
    public boolean isReadOnly() {
        return this.getDelegateFileSystem().isReadOnly();
    }

    @Override
    @NotNull
    public String getSeparator() {
        String string = this.getDelegateFileSystem().getSeparator();
        Intrinsics.checkNotNullExpressionValue(string, "delegateFileSystem.separator");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Iterable<Path> getRootDirectories() {
        void $this$mapTo$iv$iv;
        Iterable<Path> iterable = this.getDelegateFileSystem().getRootDirectories();
        Intrinsics.checkNotNullExpressionValue(iterable, "delegateFileSystem.rootDirectories");
        Iterable<Path> $this$map$iv = iterable;
        boolean $i$f$map = false;
        Iterable<Path> iterable2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Path path = (Path)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            FileSystem fileSystem = this;
            Intrinsics.checkNotNullExpressionValue(it, "it");
            collection.add(new FsHandlerPath(fileSystem, (Path)it));
        }
        return (List)destination$iv$iv;
    }

    @Override
    @NotNull
    public Iterable<FileStore> getFileStores() {
        Iterable<FileStore> iterable = this.getDelegateFileSystem().getFileStores();
        Intrinsics.checkNotNullExpressionValue(iterable, "delegateFileSystem.fileStores");
        return iterable;
    }

    @Override
    @NotNull
    public Set<String> supportedFileAttributeViews() {
        Set<String> set = this.getDelegateFileSystem().supportedFileAttributeViews();
        Intrinsics.checkNotNullExpressionValue(set, "delegateFileSystem.supportedFileAttributeViews()");
        return set;
    }

    @Override
    @NotNull
    public Path getPath(@NotNull String first, String ... more) {
        Intrinsics.checkNotNullParameter(first, "first");
        Intrinsics.checkNotNullParameter(more, "more");
        FileSystem fileSystem = this;
        Path path = this.getDelegateFileSystem().getPath(first, Arrays.copyOf(more, more.length));
        Intrinsics.checkNotNullExpressionValue(path, "delegateFileSystem.getPath(first, *more)");
        return new FsHandlerPath(fileSystem, path);
    }

    @Override
    @NotNull
    public PathMatcher getPathMatcher(@NotNull String syntaxAndPattern) {
        Intrinsics.checkNotNullParameter(syntaxAndPattern, "syntaxAndPattern");
        PathMatcher pathMatcher = this.getDelegateFileSystem().getPathMatcher(syntaxAndPattern);
        Intrinsics.checkNotNullExpressionValue(pathMatcher, "delegateFileSystem.getPa\u2026Matcher(syntaxAndPattern)");
        return pathMatcher;
    }

    @Override
    @NotNull
    public UserPrincipalLookupService getUserPrincipalLookupService() {
        UserPrincipalLookupService userPrincipalLookupService = this.getDelegateFileSystem().getUserPrincipalLookupService();
        Intrinsics.checkNotNullExpressionValue(userPrincipalLookupService, "delegateFileSystem.userPrincipalLookupService");
        return userPrincipalLookupService;
    }

    @Override
    @NotNull
    public WatchService newWatchService() {
        WatchService watchService = this.getDelegateFileSystem().newWatchService();
        Intrinsics.checkNotNullExpressionValue(watchService, "delegateFileSystem.newWatchService()");
        return watchService;
    }

    @Override
    @NotNull
    public FileSystemProvider provider() {
        FileSystemProvider fileSystemProvider = this.getDelegateFileSystem().provider();
        Intrinsics.checkNotNullExpressionValue(fileSystemProvider, "delegateFileSystem.provider()");
        return new FsHandlerFileSystemProvider(fileSystemProvider, this.provider);
    }

    public final boolean hasSameDelegate(@NotNull FileSystem fs) {
        Intrinsics.checkNotNullParameter(fs, "fs");
        return fs instanceof FsHandleFileSystem ? Intrinsics.areEqual(this.getDelegateFileSystem(), ((FsHandleFileSystem)fs).getDelegateFileSystem()) : false;
    }
}

