/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.intellij.plugin.loaders;

import com.jetbrains.plugin.structure.base.problems.PluginDescriptorIsNotFound;
import com.jetbrains.plugin.structure.base.problems.PluginProblem;
import com.jetbrains.plugin.structure.base.problems.UnableToExtractZip;
import com.jetbrains.plugin.structure.base.problems.UnableToReadDescriptor;
import com.jetbrains.plugin.structure.base.utils.FileUtilKt;
import com.jetbrains.plugin.structure.base.utils.LanguageUtilsKt;
import com.jetbrains.plugin.structure.intellij.plugin.PluginCreator;
import com.jetbrains.plugin.structure.intellij.plugin.loaders.JarPluginLoaderKt;
import com.jetbrains.plugin.structure.intellij.plugin.loaders.PluginLoader;
import com.jetbrains.plugin.structure.intellij.plugin.loaders.PluginLoadersKt;
import com.jetbrains.plugin.structure.intellij.plugin.loaders.PluginLoadingContext;
import com.jetbrains.plugin.structure.intellij.problems.PluginCreationResultResolver;
import com.jetbrains.plugin.structure.intellij.resources.ResourceResolver;
import com.jetbrains.plugin.structure.jar.JarArchiveCannotBeOpenException;
import com.jetbrains.plugin.structure.jar.JarFileSystemProvider;
import com.jetbrains.plugin.structure.jar.PluginDescriptorResult;
import com.jetbrains.plugin.structure.jar.PluginJar;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jdom2.Document;
import org.jdom2.input.JDOMParseException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\tB\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/jetbrains/plugin/structure/intellij/plugin/loaders/JarPluginLoader;", "Lcom/jetbrains/plugin/structure/intellij/plugin/loaders/PluginLoader;", "Lcom/jetbrains/plugin/structure/intellij/plugin/loaders/JarPluginLoader$Context;", "fileSystemProvider", "Lcom/jetbrains/plugin/structure/jar/JarFileSystemProvider;", "(Lcom/jetbrains/plugin/structure/jar/JarFileSystemProvider;)V", "loadPlugin", "Lcom/jetbrains/plugin/structure/intellij/plugin/PluginCreator;", "pluginLoadingContext", "Context", "structure-intellij"})
public final class JarPluginLoader
implements PluginLoader<Context> {
    @NotNull
    private final JarFileSystemProvider fileSystemProvider;

    public JarPluginLoader(@NotNull JarFileSystemProvider fileSystemProvider) {
        Intrinsics.checkNotNullParameter(fileSystemProvider, "fileSystemProvider");
        this.fileSystemProvider = fileSystemProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public PluginCreator loadPlugin(@NotNull Context pluginLoadingContext) {
        Object object;
        Intrinsics.checkNotNullParameter(pluginLoadingContext, "pluginLoadingContext");
        Context $this$loadPlugin_u24lambda_u244 = pluginLoadingContext;
        boolean bl = false;
        try {
            PluginCreator pluginCreator;
            object = new PluginJar($this$loadPlugin_u24lambda_u244.getJarPath(), this.fileSystemProvider);
            Throwable throwable = null;
            try {
                PluginCreator pluginCreator2;
                PluginJar jar2 = (PluginJar)object;
                boolean bl2 = false;
                PluginDescriptorResult descriptor2 = jar2.getPluginDescriptor("META-INF/" + $this$loadPlugin_u24lambda_u244.getDescriptorPath());
                if (descriptor2 instanceof PluginDescriptorResult.Found) {
                    PluginCreator pluginCreator3;
                    try {
                        PluginCreator pluginCreator4;
                        Document descriptorXml = PluginLoadersKt.loadXml((PluginDescriptorResult.Found)descriptor2);
                        PluginCreator $this$loadPlugin_u24lambda_u244_u24lambda_u243_u24lambda_u240 = pluginCreator4 = PluginCreator.Companion.createPlugin(FileUtilKt.getSimpleName($this$loadPlugin_u24lambda_u244.getJarPath()), $this$loadPlugin_u24lambda_u244.getDescriptorPath(), $this$loadPlugin_u24lambda_u244.getParentPlugin(), $this$loadPlugin_u24lambda_u244.getValidateDescriptor(), descriptorXml, ((PluginDescriptorResult.Found)descriptor2).getPath(), $this$loadPlugin_u24lambda_u244.getResourceResolver(), $this$loadPlugin_u24lambda_u244.getProblemResolver());
                        boolean bl3 = false;
                        $this$loadPlugin_u24lambda_u244_u24lambda_u243_u24lambda_u240.setIcons(jar2.getIcons());
                        $this$loadPlugin_u24lambda_u244_u24lambda_u243_u24lambda_u240.setThirdPartyDependencies(jar2.getThirdPartyDependencies());
                        $this$loadPlugin_u24lambda_u244_u24lambda_u243_u24lambda_u240.setHasDotNetPart($this$loadPlugin_u24lambda_u244.getHasDotNetDirectory());
                        pluginCreator3 = pluginCreator4;
                    }
                    catch (JDOMParseException e) {
                        String message2 = e.getLocalizedMessage();
                        JarPluginLoaderKt.access$getLOG$p().warn("Unable to read descriptor [" + $this$loadPlugin_u24lambda_u244.getDescriptorPath() + "] from [" + $this$loadPlugin_u24lambda_u244.getJarPath() + "]: " + message2);
                        pluginCreator3 = PluginCreator.Companion.createInvalidPlugin($this$loadPlugin_u24lambda_u244.getJarPath(), $this$loadPlugin_u24lambda_u244.getDescriptorPath(), (PluginProblem)new UnableToReadDescriptor($this$loadPlugin_u24lambda_u244.getDescriptorPath(), message2));
                    }
                    catch (Exception e) {
                        JarPluginLoaderKt.access$getLOG$p().warn("Unable to read descriptor [" + $this$loadPlugin_u24lambda_u244.getDescriptorPath() + "] from [" + $this$loadPlugin_u24lambda_u244.getJarPath() + "]", e);
                        String message3 = e.getLocalizedMessage();
                        pluginCreator3 = PluginCreator.Companion.createInvalidPlugin($this$loadPlugin_u24lambda_u244.getJarPath(), $this$loadPlugin_u24lambda_u244.getDescriptorPath(), (PluginProblem)new UnableToReadDescriptor($this$loadPlugin_u24lambda_u244.getDescriptorPath(), message3));
                    }
                    pluginCreator2 = pluginCreator3;
                } else if (Intrinsics.areEqual(descriptor2, PluginDescriptorResult.NotFound.INSTANCE)) {
                    PluginCreator pluginCreator5;
                    PluginCreator it = pluginCreator5 = PluginCreator.Companion.createInvalidPlugin($this$loadPlugin_u24lambda_u244.getJarPath(), $this$loadPlugin_u24lambda_u244.getDescriptorPath(), (PluginProblem)new PluginDescriptorIsNotFound($this$loadPlugin_u24lambda_u244.getDescriptorPath()));
                    boolean bl4 = false;
                    JarPluginLoaderKt.access$getLOG$p().debug("Descriptor [{}] not found in [{}]", (Object)$this$loadPlugin_u24lambda_u244.getDescriptorPath(), (Object)$this$loadPlugin_u24lambda_u244.getJarPath());
                    pluginCreator2 = pluginCreator5;
                } else if (descriptor2 instanceof PluginDescriptorResult.Failed) {
                    PluginCreator pluginCreator6;
                    PluginCreator it = pluginCreator6 = PluginCreator.Companion.createInvalidPlugin($this$loadPlugin_u24lambda_u244.getJarPath(), $this$loadPlugin_u24lambda_u244.getDescriptorPath(), (PluginProblem)new PluginDescriptorIsNotFound($this$loadPlugin_u24lambda_u244.getDescriptorPath()));
                    boolean bl5 = false;
                    Object[] objectArray = new Object[]{$this$loadPlugin_u24lambda_u244.getDescriptorPath(), $this$loadPlugin_u24lambda_u244.getJarPath(), descriptor2};
                    JarPluginLoaderKt.access$getLOG$p().debug("Unable to resolve descriptor [{}] from [{}] ({})", objectArray);
                    pluginCreator2 = pluginCreator6;
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                pluginCreator = pluginCreator2;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)object, throwable);
            }
            object = pluginCreator;
        }
        catch (JarArchiveCannotBeOpenException e) {
            Object[] objectArray = new Object[]{$this$loadPlugin_u24lambda_u244.getJarPath(), $this$loadPlugin_u24lambda_u244.getDescriptorPath(), LanguageUtilsKt.getShortExceptionMessage(e)};
            JarPluginLoaderKt.access$getLOG$p().warn("Unable to extract {} (searching for {}): {}", objectArray);
            object = PluginCreator.Companion.createInvalidPlugin($this$loadPlugin_u24lambda_u244.getJarPath(), $this$loadPlugin_u24lambda_u244.getDescriptorPath(), (PluginProblem)new UnableToExtractZip(null, 1, null));
        }
        return object;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0019\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0080\b\u0018\u00002\u00020\u0001BA\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\u000fJ\t\u0010\u001d\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001f\u001a\u00020\u0007H\u00c6\u0003J\t\u0010 \u001a\u00020\tH\u00c6\u0003J\u000b\u0010!\u001a\u0004\u0018\u00010\u000bH\u00c6\u0003J\t\u0010\"\u001a\u00020\rH\u00c6\u0003J\t\u0010#\u001a\u00020\u0007H\u00c6\u0003JQ\u0010$\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\b\u0002\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010%\u001a\u00020\u00072\b\u0010&\u001a\u0004\u0018\u00010'H\u00d6\u0003J\t\u0010(\u001a\u00020)H\u00d6\u0001J\t\u0010*\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u000e\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0013\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0013\u00a8\u0006+"}, d2={"Lcom/jetbrains/plugin/structure/intellij/plugin/loaders/JarPluginLoader$Context;", "Lcom/jetbrains/plugin/structure/intellij/plugin/loaders/PluginLoadingContext;", "jarPath", "Ljava/nio/file/Path;", "descriptorPath", "", "validateDescriptor", "", "resourceResolver", "Lcom/jetbrains/plugin/structure/intellij/resources/ResourceResolver;", "parentPlugin", "Lcom/jetbrains/plugin/structure/intellij/plugin/PluginCreator;", "problemResolver", "Lcom/jetbrains/plugin/structure/intellij/problems/PluginCreationResultResolver;", "hasDotNetDirectory", "(Ljava/nio/file/Path;Ljava/lang/String;ZLcom/jetbrains/plugin/structure/intellij/resources/ResourceResolver;Lcom/jetbrains/plugin/structure/intellij/plugin/PluginCreator;Lcom/jetbrains/plugin/structure/intellij/problems/PluginCreationResultResolver;Z)V", "getDescriptorPath", "()Ljava/lang/String;", "getHasDotNetDirectory", "()Z", "getJarPath", "()Ljava/nio/file/Path;", "getParentPlugin", "()Lcom/jetbrains/plugin/structure/intellij/plugin/PluginCreator;", "getProblemResolver", "()Lcom/jetbrains/plugin/structure/intellij/problems/PluginCreationResultResolver;", "getResourceResolver", "()Lcom/jetbrains/plugin/structure/intellij/resources/ResourceResolver;", "getValidateDescriptor", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "copy", "equals", "other", "", "hashCode", "", "toString", "structure-intellij"})
    public static final class Context
    extends PluginLoadingContext {
        @NotNull
        private final Path jarPath;
        @NotNull
        private final String descriptorPath;
        private final boolean validateDescriptor;
        @NotNull
        private final ResourceResolver resourceResolver;
        @Nullable
        private final PluginCreator parentPlugin;
        @NotNull
        private final PluginCreationResultResolver problemResolver;
        private final boolean hasDotNetDirectory;

        public Context(@NotNull Path jarPath, @NotNull String descriptorPath, boolean validateDescriptor, @NotNull ResourceResolver resourceResolver, @Nullable PluginCreator parentPlugin, @NotNull PluginCreationResultResolver problemResolver, boolean hasDotNetDirectory) {
            Intrinsics.checkNotNullParameter(jarPath, "jarPath");
            Intrinsics.checkNotNullParameter(descriptorPath, "descriptorPath");
            Intrinsics.checkNotNullParameter(resourceResolver, "resourceResolver");
            Intrinsics.checkNotNullParameter(problemResolver, "problemResolver");
            super(resourceResolver, problemResolver);
            this.jarPath = jarPath;
            this.descriptorPath = descriptorPath;
            this.validateDescriptor = validateDescriptor;
            this.resourceResolver = resourceResolver;
            this.parentPlugin = parentPlugin;
            this.problemResolver = problemResolver;
            this.hasDotNetDirectory = hasDotNetDirectory;
        }

        public /* synthetic */ Context(Path path, String string, boolean bl, ResourceResolver resourceResolver, PluginCreator pluginCreator, PluginCreationResultResolver pluginCreationResultResolver, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker2) {
            if ((n & 0x40) != 0) {
                bl2 = false;
            }
            this(path, string, bl, resourceResolver, pluginCreator, pluginCreationResultResolver, bl2);
        }

        @NotNull
        public final Path getJarPath() {
            return this.jarPath;
        }

        @NotNull
        public final String getDescriptorPath() {
            return this.descriptorPath;
        }

        public final boolean getValidateDescriptor() {
            return this.validateDescriptor;
        }

        @Override
        @NotNull
        public ResourceResolver getResourceResolver() {
            return this.resourceResolver;
        }

        @Nullable
        public final PluginCreator getParentPlugin() {
            return this.parentPlugin;
        }

        @Override
        @NotNull
        public PluginCreationResultResolver getProblemResolver() {
            return this.problemResolver;
        }

        public final boolean getHasDotNetDirectory() {
            return this.hasDotNetDirectory;
        }

        @NotNull
        public final Path component1() {
            return this.jarPath;
        }

        @NotNull
        public final String component2() {
            return this.descriptorPath;
        }

        public final boolean component3() {
            return this.validateDescriptor;
        }

        @NotNull
        public final ResourceResolver component4() {
            return this.resourceResolver;
        }

        @Nullable
        public final PluginCreator component5() {
            return this.parentPlugin;
        }

        @NotNull
        public final PluginCreationResultResolver component6() {
            return this.problemResolver;
        }

        public final boolean component7() {
            return this.hasDotNetDirectory;
        }

        @NotNull
        public final Context copy(@NotNull Path jarPath, @NotNull String descriptorPath, boolean validateDescriptor, @NotNull ResourceResolver resourceResolver, @Nullable PluginCreator parentPlugin, @NotNull PluginCreationResultResolver problemResolver, boolean hasDotNetDirectory) {
            Intrinsics.checkNotNullParameter(jarPath, "jarPath");
            Intrinsics.checkNotNullParameter(descriptorPath, "descriptorPath");
            Intrinsics.checkNotNullParameter(resourceResolver, "resourceResolver");
            Intrinsics.checkNotNullParameter(problemResolver, "problemResolver");
            return new Context(jarPath, descriptorPath, validateDescriptor, resourceResolver, parentPlugin, problemResolver, hasDotNetDirectory);
        }

        public static /* synthetic */ Context copy$default(Context context, Path path, String string, boolean bl, ResourceResolver resourceResolver, PluginCreator pluginCreator, PluginCreationResultResolver pluginCreationResultResolver, boolean bl2, int n, Object object) {
            if ((n & 1) != 0) {
                path = context.jarPath;
            }
            if ((n & 2) != 0) {
                string = context.descriptorPath;
            }
            if ((n & 4) != 0) {
                bl = context.validateDescriptor;
            }
            if ((n & 8) != 0) {
                resourceResolver = context.resourceResolver;
            }
            if ((n & 0x10) != 0) {
                pluginCreator = context.parentPlugin;
            }
            if ((n & 0x20) != 0) {
                pluginCreationResultResolver = context.problemResolver;
            }
            if ((n & 0x40) != 0) {
                bl2 = context.hasDotNetDirectory;
            }
            return context.copy(path, string, bl, resourceResolver, pluginCreator, pluginCreationResultResolver, bl2);
        }

        @NotNull
        public String toString() {
            return "Context(jarPath=" + this.jarPath + ", descriptorPath=" + this.descriptorPath + ", validateDescriptor=" + this.validateDescriptor + ", resourceResolver=" + this.resourceResolver + ", parentPlugin=" + this.parentPlugin + ", problemResolver=" + this.problemResolver + ", hasDotNetDirectory=" + this.hasDotNetDirectory + ")";
        }

        public int hashCode() {
            int result2 = ((Object)this.jarPath).hashCode();
            result2 = result2 * 31 + this.descriptorPath.hashCode();
            result2 = result2 * 31 + Boolean.hashCode(this.validateDescriptor);
            result2 = result2 * 31 + this.resourceResolver.hashCode();
            result2 = result2 * 31 + (this.parentPlugin == null ? 0 : this.parentPlugin.hashCode());
            result2 = result2 * 31 + this.problemResolver.hashCode();
            result2 = result2 * 31 + Boolean.hashCode(this.hasDotNetDirectory);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Context)) {
                return false;
            }
            Context context = (Context)other;
            if (!Intrinsics.areEqual(this.jarPath, context.jarPath)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.descriptorPath, context.descriptorPath)) {
                return false;
            }
            if (this.validateDescriptor != context.validateDescriptor) {
                return false;
            }
            if (!Intrinsics.areEqual(this.resourceResolver, context.resourceResolver)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.parentPlugin, context.parentPlugin)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.problemResolver, context.problemResolver)) {
                return false;
            }
            return this.hasDotNetDirectory == context.hasDotNetDirectory;
        }
    }
}

