/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.intellij.plugin.dependencies.legacy;

import com.jetbrains.plugin.structure.intellij.plugin.DependenciesModifier;
import com.jetbrains.plugin.structure.intellij.plugin.IdePlugin;
import com.jetbrains.plugin.structure.intellij.plugin.PluginDependency;
import com.jetbrains.plugin.structure.intellij.plugin.PluginProvider;
import com.jetbrains.plugin.structure.intellij.plugin.dependencies.legacy.LegacyPluginDependencyContributorKt;
import com.jetbrains.plugin.structure.intellij.verifiers.LegacyIntelliJIdeaPluginVerifier;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0003H\u0016J\f\u0010\r\u001a\u00020\u000e*\u00020\u000bH\u0002J\u0014\u0010\u000f\u001a\u00020\u000e*\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0003H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/plugin/structure/intellij/plugin/dependencies/legacy/LegacyPluginDependencyContributor;", "Lcom/jetbrains/plugin/structure/intellij/plugin/DependenciesModifier;", "ide", "Lcom/jetbrains/plugin/structure/intellij/plugin/PluginProvider;", "legacyPluginVerifier", "Lcom/jetbrains/plugin/structure/intellij/verifiers/LegacyIntelliJIdeaPluginVerifier;", "(Lcom/jetbrains/plugin/structure/intellij/plugin/PluginProvider;Lcom/jetbrains/plugin/structure/intellij/verifiers/LegacyIntelliJIdeaPluginVerifier;)V", "apply", "", "Lcom/jetbrains/plugin/structure/intellij/plugin/PluginDependency;", "plugin", "Lcom/jetbrains/plugin/structure/intellij/plugin/IdePlugin;", "pluginProvider", "isLegacy", "", "isNonBundled", "structure-intellij"})
public final class LegacyPluginDependencyContributor
implements DependenciesModifier {
    @NotNull
    private final PluginProvider ide;
    @NotNull
    private final LegacyIntelliJIdeaPluginVerifier legacyPluginVerifier;

    public LegacyPluginDependencyContributor(@NotNull PluginProvider ide2, @NotNull LegacyIntelliJIdeaPluginVerifier legacyPluginVerifier) {
        Intrinsics.checkNotNullParameter(ide2, "ide");
        Intrinsics.checkNotNullParameter(legacyPluginVerifier, "legacyPluginVerifier");
        this.ide = ide2;
        this.legacyPluginVerifier = legacyPluginVerifier;
    }

    @Override
    @NotNull
    public List<PluginDependency> apply(@NotNull IdePlugin plugin, @NotNull PluginProvider pluginProvider) {
        IdePlugin javaModule;
        Intrinsics.checkNotNullParameter(plugin, "plugin");
        Intrinsics.checkNotNullParameter(pluginProvider, "pluginProvider");
        if (Intrinsics.areEqual(plugin.getPluginId(), "com.intellij")) {
            return plugin.getDependencies();
        }
        if (this.ide.findPluginByModule("com.intellij.modules.all") == null) {
            return plugin.getDependencies();
        }
        boolean isNonBundledPlugin = this.isNonBundled(plugin, this.ide);
        if (isNonBundledPlugin && this.isLegacy(plugin) && (javaModule = this.ide.findPluginByModule("com.intellij.modules.java")) != null) {
            return CollectionsKt.plus((Collection)plugin.getDependencies(), LegacyPluginDependencyContributorKt.access$getJAVA_MODULE_DEPENDENCY$p());
        }
        return plugin.getDependencies();
    }

    private final boolean isLegacy(IdePlugin $this$isLegacy) {
        return !Intrinsics.areEqual(this.legacyPluginVerifier.verify($this$isLegacy), LegacyIntelliJIdeaPluginVerifier.VerificationResult.NotLegacyPlugin.INSTANCE);
    }

    private final boolean isNonBundled(IdePlugin $this$isNonBundled, PluginProvider pluginProvider) {
        boolean bl;
        String string = $this$isNonBundled.getPluginId();
        if (string != null) {
            String id = string;
            boolean bl2 = false;
            bl = !pluginProvider.containsPlugin(id);
        } else {
            bl = false;
        }
        return bl;
    }
}

