/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.intellij.plugin;

import org.jetbrains.annotations.NotNull;

public class PluginQuery {
    private String identifier;
    private boolean searchId;
    private boolean searchName;
    private boolean searchPluginAliases;
    private boolean searchContentModuleId;

    @NotNull
    public String getIdentifier() {
        return this.identifier;
    }

    public boolean searchId() {
        return this.searchId;
    }

    public boolean searchName() {
        return this.searchName;
    }

    public boolean searchPluginAliases() {
        return this.searchPluginAliases;
    }

    public boolean searchContentModuleId() {
        return this.searchContentModuleId;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Searching for '").append(this.identifier).append("'");
        boolean hasField = false;
        if (this.searchId) {
            sb.append(" in plugin ID");
            hasField = true;
        }
        if (this.searchName) {
            if (hasField) {
                sb.append(",");
            }
            sb.append(" in plugin name");
            hasField = true;
        }
        if (this.searchPluginAliases) {
            if (hasField) {
                sb.append(",");
            }
            sb.append(" in plugin aliases");
            hasField = true;
        }
        if (this.searchContentModuleId()) {
            if (hasField) {
                sb.append(",");
            }
            sb.append(" in content module identifiers");
            hasField = true;
        }
        return sb.toString();
    }

    public static class Builder {
        private final PluginQuery query = new PluginQuery();

        @NotNull
        public static Builder of(@NotNull String identifier) {
            return new Builder().setIdentifier(identifier);
        }

        @NotNull
        public Builder setIdentifier(@NotNull String identifier) {
            this.query.identifier = identifier;
            return this;
        }

        @NotNull
        public Builder inId() {
            this.query.searchId = true;
            return this;
        }

        @NotNull
        public Builder inName() {
            this.query.searchName = true;
            return this;
        }

        @NotNull
        public Builder inPluginAliases() {
            this.query.searchPluginAliases = true;
            return this;
        }

        @NotNull
        public Builder inContentModuleId() {
            this.query.searchContentModuleId = true;
            return this;
        }

        @NotNull
        public PluginQuery build() {
            return this.query;
        }
    }
}

