/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.intellij.plugin;

import com.jetbrains.plugin.structure.base.decompress.DecompressorException;
import com.jetbrains.plugin.structure.base.problems.PluginProblem;
import com.jetbrains.plugin.structure.base.problems.UnableToExtractZip;
import com.jetbrains.plugin.structure.base.utils.Deletable;
import com.jetbrains.plugin.structure.base.utils.FileUtilKt;
import com.jetbrains.plugin.structure.base.utils.Striped;
import com.jetbrains.plugin.structure.intellij.extractor.DefaultPluginExtractor;
import com.jetbrains.plugin.structure.intellij.extractor.ExtractedPlugin;
import com.jetbrains.plugin.structure.intellij.extractor.ExtractorResult;
import com.jetbrains.plugin.structure.intellij.plugin.PluginArchiveManagerKt;
import java.io.Closeable;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\u0018\u00002\u00020\u00012\u00020\u0002:\u0002$%B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0006\u0010\u0016\u001a\u00020\u0017J\b\u0010\u0018\u001a\u00020\u0017H\u0016J\b\u0010\u0019\u001a\u00020\u0017H\u0016J\u0010\u0010\u001a\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\u0004H\u0002J\u000e\u0010\u001c\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\u0004J\u0012\u0010\u001e\u001a\u0004\u0018\u00010\n2\u0006\u0010\u001d\u001a\u00020\u0004H\u0002J\u0014\u0010\b\u001a\u00020\u0017*\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0002J\f\u0010\"\u001a\u00020\u0017*\u00020\nH\u0002J\u0014\u0010#\u001a\u00020\u0017*\u00020\n2\u0006\u0010 \u001a\u00020!H\u0002R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0012\u001a\u0004\u0018\u00010\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006&"}, d2={"Lcom/jetbrains/plugin/structure/intellij/plugin/PluginArchiveManager;", "Lcom/jetbrains/plugin/structure/base/utils/Deletable;", "Ljava/io/Closeable;", "extractDirectory", "Ljava/nio/file/Path;", "isCollectingStats", "", "(Ljava/nio/file/Path;Z)V", "cache", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/jetbrains/plugin/structure/intellij/plugin/PluginArchiveManager$Result;", "locks", "Lcom/jetbrains/plugin/structure/base/utils/Striped;", "Ljava/util/concurrent/locks/Lock;", "getLocks", "()Lcom/jetbrains/plugin/structure/base/utils/Striped;", "pluginExtractor", "Lcom/jetbrains/plugin/structure/intellij/extractor/DefaultPluginExtractor;", "stats", "Lcom/jetbrains/plugin/structure/intellij/plugin/PluginArchiveManager$Stats;", "getStats", "()Lcom/jetbrains/plugin/structure/intellij/plugin/PluginArchiveManager$Stats;", "clear", "", "close", "delete", "doExtractArchive", "pluginFile", "extractArchive", "path", "getCached", "Lcom/jetbrains/plugin/structure/intellij/plugin/PluginArchiveManager$Result$Extracted;", "extractionDuration", "", "logCached", "logCreated", "Result", "Stats", "structure-intellij"})
@SourceDebugExtension(value={"SMAP\nPluginArchiveManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PluginArchiveManager.kt\ncom/jetbrains/plugin/structure/intellij/plugin/PluginArchiveManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Timing.kt\nkotlin/system/TimingKt\n*L\n1#1,140:1\n1#2:141\n17#3,6:142\n*E\n*S KotlinDebug\n*F\n+ 1 PluginArchiveManager.kt\ncom/jetbrains/plugin/structure/intellij/plugin/PluginArchiveManager\n*L\n58#1,6:142\n*E\n"})
public final class PluginArchiveManager
implements Deletable,
Closeable {
    @NotNull
    private final Path extractDirectory;
    private final boolean isCollectingStats;
    @NotNull
    private final ConcurrentHashMap<Path, Result> cache;
    @NotNull
    private final DefaultPluginExtractor pluginExtractor;
    @Nullable
    private final Stats stats;
    @NotNull
    private final Striped<Lock> locks;

    public PluginArchiveManager(@NotNull Path extractDirectory, boolean isCollectingStats) {
        Intrinsics.checkNotNullParameter(extractDirectory, "extractDirectory");
        this.extractDirectory = extractDirectory;
        this.isCollectingStats = isCollectingStats;
        this.cache = new ConcurrentHashMap();
        this.pluginExtractor = new DefaultPluginExtractor();
        this.stats = this.isCollectingStats ? new Stats() : null;
        this.locks = Striped.Companion.lock(RangesKt.coerceIn(Runtime.getRuntime().availableProcessors(), new IntRange(4, 32)));
    }

    public /* synthetic */ PluginArchiveManager(Path path, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker2) {
        if ((n & 2) != 0) {
            bl = true;
        }
        this(path, bl);
    }

    @Nullable
    public final Stats getStats() {
        return this.stats;
    }

    @NotNull
    public final Striped<Lock> getLocks() {
        return this.locks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final Result extractArchive(@NotNull Path path) {
        Intrinsics.checkNotNullParameter(path, "path");
        Result cached = this.getCached(path);
        if (cached != null) {
            return cached;
        }
        Lock lock2 = this.locks.get(((Object)path.toAbsolutePath()).toString());
        synchronized (lock2) {
            block5: {
                Result cached2;
                boolean bl = false;
                Result result2 = cached2 = this.getCached(path);
                if (result2 == null) break block5;
                Result result3 = result2;
                return result3;
            }
            Result result4 = this.doExtractArchive(path);
            return result4;
        }
    }

    private final Result getCached(Path path) {
        Result result2;
        Result result3;
        Result result4;
        Result it = result4 = this.cache.get(path);
        boolean bl = false;
        Result result5 = result3 = it instanceof Result.Extracted && FileUtilKt.exists(((Result.Extracted)it).getResourceToClose().getPluginFile()) ? result4 : null;
        if (result3 != null) {
            it = result4 = result3;
            boolean bl2 = false;
            this.logCached(it);
            result2 = result4;
        } else {
            result2 = null;
        }
        Result cached = result2;
        return cached;
    }

    /*
     * WARNING - void declaration
     */
    private final Result doExtractArchive(Path pluginFile) {
        ExtractorResult extraction;
        ExtractorResult extractorResult;
        Object object;
        Object $this$doExtractArchive_u24lambda_u245_u24lambda_u243;
        Ref.ObjectRef extractorResult2 = new Ref.ObjectRef();
        boolean $i$f$measureTimeMillis = false;
        long start$iv = System.currentTimeMillis();
        boolean bl = false;
        Object object2 = this;
        Ref.ObjectRef objectRef = extractorResult2;
        try {
            $this$doExtractArchive_u24lambda_u245_u24lambda_u243 = object2;
            boolean bl2 = false;
            $this$doExtractArchive_u24lambda_u245_u24lambda_u243 = kotlin.Result.constructor-impl(((PluginArchiveManager)$this$doExtractArchive_u24lambda_u245_u24lambda_u243).pluginExtractor.extractPlugin(pluginFile, ((PluginArchiveManager)$this$doExtractArchive_u24lambda_u245_u24lambda_u243).extractDirectory));
        }
        catch (Throwable bl2) {
            $this$doExtractArchive_u24lambda_u245_u24lambda_u243 = kotlin.Result.constructor-impl(ResultKt.createFailure(bl2));
        }
        Ref.ObjectRef objectRef2 = objectRef;
        object2 = $this$doExtractArchive_u24lambda_u245_u24lambda_u243;
        Throwable throwable = kotlin.Result.exceptionOrNull-impl(object2);
        if (throwable == null) {
            object = object2;
        } else {
            void it;
            $this$doExtractArchive_u24lambda_u245_u24lambda_u243 = throwable;
            objectRef = objectRef2;
            boolean bl3 = false;
            PluginArchiveManagerKt.access$getLOG$p().info("Unable to extract plugin zip " + FileUtilKt.getSimpleName(pluginFile), (Throwable)it);
            object = it instanceof DecompressorException ? new ExtractorResult.Fail(new UnableToExtractZip(((DecompressorException)it).getMessage())) : new ExtractorResult.Fail(new UnableToExtractZip(null, 1, null));
            objectRef2 = objectRef;
        }
        objectRef2.element = object;
        long extractionDuration = System.currentTimeMillis() - start$iv;
        if (extractorResult2.element == null) {
            Intrinsics.throwUninitializedPropertyAccessException("extractorResult");
            extractorResult = null;
        } else {
            extractorResult = extraction = (ExtractorResult)extractorResult2.element;
        }
        if (extraction instanceof ExtractorResult.Success) {
            Result.Extracted extracted;
            ExtractedPlugin extractedPlugin = ((ExtractorResult.Success)extraction).getExtractedPlugin();
            Result.Extracted it = extracted = new Result.Extracted(pluginFile, extractedPlugin.getPluginFile(), extractedPlugin);
            boolean bl4 = false;
            this.cache(it, extractionDuration);
            return extracted;
        }
        if (!(extraction instanceof ExtractorResult.Fail)) {
            throw new NoWhenBranchMatchedException();
        }
        return new Result.Failed(pluginFile, ((ExtractorResult.Fail)extraction).getPluginProblem());
    }

    private final void cache(Result.Extracted $this$cache, long extractionDuration) {
        ((Map)this.cache).put($this$cache.getArtifactPath(), $this$cache);
        this.logCreated($this$cache, extractionDuration);
    }

    private final void logCached(Result $this$logCached) {
        block0: {
            Stats stats = this.stats;
            if (stats == null) break block0;
            Stats $this$logCached_u24lambda_u247 = stats;
            boolean bl = false;
            $this$logCached_u24lambda_u247.logCached($this$logCached.getArtifactPath());
        }
    }

    private final void logCreated(Result $this$logCreated, long extractionDuration) {
        block0: {
            Stats stats = this.stats;
            if (stats == null) break block0;
            Stats $this$logCreated_u24lambda_u248 = stats;
            boolean bl = false;
            $this$logCreated_u24lambda_u248.logCreated($this$logCreated.getArtifactPath(), extractionDuration);
        }
    }

    public final void clear() {
        int removed;
        do {
            removed = 0;
            Iterator<Map.Entry<Path, Result>> iterator2 = this.cache.entrySet().iterator();
            while (iterator2.hasNext()) {
                Result result2;
                Map.Entry<Path, Result> entry;
                Intrinsics.checkNotNullExpressionValue(iterator2.next(), "iterator.next()");
                Intrinsics.checkNotNullExpressionValue(entry.getValue(), "entry.value");
                if (result2 instanceof Result.Extracted) {
                    ((Result.Extracted)result2).getResourceToClose().close();
                }
                iterator2.remove();
                ++removed;
            }
        } while (removed > 0);
    }

    @Override
    public void delete() {
        this.clear();
    }

    @Override
    public void close() {
        this.clear();
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0002\u0007\bB\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u0082\u0001\u0002\t\n\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/plugin/structure/intellij/plugin/PluginArchiveManager$Result;", "", "artifactPath", "Ljava/nio/file/Path;", "(Ljava/nio/file/Path;)V", "getArtifactPath", "()Ljava/nio/file/Path;", "Extracted", "Failed", "Lcom/jetbrains/plugin/structure/intellij/plugin/PluginArchiveManager$Result$Extracted;", "Lcom/jetbrains/plugin/structure/intellij/plugin/PluginArchiveManager$Result$Failed;", "structure-intellij"})
    public static abstract class Result {
        @NotNull
        private final Path artifactPath;

        private Result(Path artifactPath) {
            this.artifactPath = artifactPath;
        }

        @NotNull
        public Path getArtifactPath() {
            return this.artifactPath;
        }

        public /* synthetic */ Result(Path artifactPath, DefaultConstructorMarker $constructor_marker) {
            this(artifactPath);
        }

        @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0006H\u00c6\u0003J'\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0019"}, d2={"Lcom/jetbrains/plugin/structure/intellij/plugin/PluginArchiveManager$Result$Extracted;", "Lcom/jetbrains/plugin/structure/intellij/plugin/PluginArchiveManager$Result;", "artifactPath", "Ljava/nio/file/Path;", "extractedPath", "resourceToClose", "Lcom/jetbrains/plugin/structure/intellij/extractor/ExtractedPlugin;", "(Ljava/nio/file/Path;Ljava/nio/file/Path;Lcom/jetbrains/plugin/structure/intellij/extractor/ExtractedPlugin;)V", "getArtifactPath", "()Ljava/nio/file/Path;", "getExtractedPath", "getResourceToClose", "()Lcom/jetbrains/plugin/structure/intellij/extractor/ExtractedPlugin;", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "structure-intellij"})
        public static final class Extracted
        extends Result {
            @NotNull
            private final Path artifactPath;
            @NotNull
            private final Path extractedPath;
            @NotNull
            private final ExtractedPlugin resourceToClose;

            public Extracted(@NotNull Path artifactPath, @NotNull Path extractedPath, @NotNull ExtractedPlugin resourceToClose) {
                Intrinsics.checkNotNullParameter(artifactPath, "artifactPath");
                Intrinsics.checkNotNullParameter(extractedPath, "extractedPath");
                Intrinsics.checkNotNullParameter(resourceToClose, "resourceToClose");
                super(artifactPath, null);
                this.artifactPath = artifactPath;
                this.extractedPath = extractedPath;
                this.resourceToClose = resourceToClose;
            }

            @Override
            @NotNull
            public Path getArtifactPath() {
                return this.artifactPath;
            }

            @NotNull
            public final Path getExtractedPath() {
                return this.extractedPath;
            }

            @NotNull
            public final ExtractedPlugin getResourceToClose() {
                return this.resourceToClose;
            }

            @NotNull
            public final Path component1() {
                return this.artifactPath;
            }

            @NotNull
            public final Path component2() {
                return this.extractedPath;
            }

            @NotNull
            public final ExtractedPlugin component3() {
                return this.resourceToClose;
            }

            @NotNull
            public final Extracted copy(@NotNull Path artifactPath, @NotNull Path extractedPath, @NotNull ExtractedPlugin resourceToClose) {
                Intrinsics.checkNotNullParameter(artifactPath, "artifactPath");
                Intrinsics.checkNotNullParameter(extractedPath, "extractedPath");
                Intrinsics.checkNotNullParameter(resourceToClose, "resourceToClose");
                return new Extracted(artifactPath, extractedPath, resourceToClose);
            }

            public static /* synthetic */ Extracted copy$default(Extracted extracted, Path path, Path path2, ExtractedPlugin extractedPlugin, int n, Object object) {
                if ((n & 1) != 0) {
                    path = extracted.artifactPath;
                }
                if ((n & 2) != 0) {
                    path2 = extracted.extractedPath;
                }
                if ((n & 4) != 0) {
                    extractedPlugin = extracted.resourceToClose;
                }
                return extracted.copy(path, path2, extractedPlugin);
            }

            @NotNull
            public String toString() {
                return "Extracted(artifactPath=" + this.artifactPath + ", extractedPath=" + this.extractedPath + ", resourceToClose=" + this.resourceToClose + ")";
            }

            public int hashCode() {
                int result2 = ((Object)this.artifactPath).hashCode();
                result2 = result2 * 31 + ((Object)this.extractedPath).hashCode();
                result2 = result2 * 31 + this.resourceToClose.hashCode();
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Extracted)) {
                    return false;
                }
                Extracted extracted = (Extracted)other;
                if (!Intrinsics.areEqual(this.artifactPath, extracted.artifactPath)) {
                    return false;
                }
                if (!Intrinsics.areEqual(this.extractedPath, extracted.extractedPath)) {
                    return false;
                }
                return Intrinsics.areEqual(this.resourceToClose, extracted.resourceToClose);
            }
        }

        @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/plugin/structure/intellij/plugin/PluginArchiveManager$Result$Failed;", "Lcom/jetbrains/plugin/structure/intellij/plugin/PluginArchiveManager$Result;", "artifactPath", "Ljava/nio/file/Path;", "problem", "Lcom/jetbrains/plugin/structure/base/problems/PluginProblem;", "(Ljava/nio/file/Path;Lcom/jetbrains/plugin/structure/base/problems/PluginProblem;)V", "getArtifactPath", "()Ljava/nio/file/Path;", "getProblem", "()Lcom/jetbrains/plugin/structure/base/problems/PluginProblem;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "structure-intellij"})
        public static final class Failed
        extends Result {
            @NotNull
            private final Path artifactPath;
            @NotNull
            private final PluginProblem problem;

            public Failed(@NotNull Path artifactPath, @NotNull PluginProblem problem) {
                Intrinsics.checkNotNullParameter(artifactPath, "artifactPath");
                Intrinsics.checkNotNullParameter(problem, "problem");
                super(artifactPath, null);
                this.artifactPath = artifactPath;
                this.problem = problem;
            }

            @Override
            @NotNull
            public Path getArtifactPath() {
                return this.artifactPath;
            }

            @NotNull
            public final PluginProblem getProblem() {
                return this.problem;
            }

            @NotNull
            public final Path component1() {
                return this.artifactPath;
            }

            @NotNull
            public final PluginProblem component2() {
                return this.problem;
            }

            @NotNull
            public final Failed copy(@NotNull Path artifactPath, @NotNull PluginProblem problem) {
                Intrinsics.checkNotNullParameter(artifactPath, "artifactPath");
                Intrinsics.checkNotNullParameter(problem, "problem");
                return new Failed(artifactPath, problem);
            }

            public static /* synthetic */ Failed copy$default(Failed failed, Path path, PluginProblem pluginProblem, int n, Object object) {
                if ((n & 1) != 0) {
                    path = failed.artifactPath;
                }
                if ((n & 2) != 0) {
                    pluginProblem = failed.problem;
                }
                return failed.copy(path, pluginProblem);
            }

            @NotNull
            public String toString() {
                return "Failed(artifactPath=" + this.artifactPath + ", problem=" + this.problem + ")";
            }

            public int hashCode() {
                int result2 = ((Object)this.artifactPath).hashCode();
                result2 = result2 * 31 + this.problem.hashCode();
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Failed)) {
                    return false;
                }
                Failed failed = (Failed)other;
                if (!Intrinsics.areEqual(this.artifactPath, failed.artifactPath)) {
                    return false;
                }
                return Intrinsics.areEqual(this.problem, failed.problem);
            }
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u000fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0005J\u0016\u0010\f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000eR\u001d\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/plugin/structure/intellij/plugin/PluginArchiveManager$Stats;", "", "()V", "events", "Ljava/util/concurrent/ConcurrentHashMap;", "Ljava/nio/file/Path;", "Lcom/jetbrains/plugin/structure/intellij/plugin/PluginArchiveManager$Stats$Event;", "getEvents", "()Ljava/util/concurrent/ConcurrentHashMap;", "logCached", "", "path", "logCreated", "extractionDuration", "", "Event", "structure-intellij"})
    public static final class Stats {
        @NotNull
        private final ConcurrentHashMap<Path, Event> events = new ConcurrentHashMap();

        @NotNull
        public final ConcurrentHashMap<Path, Event> getEvents() {
            return this.events;
        }

        public final void logCreated(@NotNull Path path, long extractionDuration) {
            Intrinsics.checkNotNullParameter(path, "path");
            Function1 function1 = new Function1<Path, Event>(path, extractionDuration){
                final /* synthetic */ Path $path;
                final /* synthetic */ long $extractionDuration;
                {
                    this.$path = $path;
                    this.$extractionDuration = $extractionDuration;
                    super(1);
                }

                @NotNull
                public final Event invoke(@NotNull Path it) {
                    Intrinsics.checkNotNullParameter(it, "it");
                    return new Event(this.$path, 0, 0, this.$extractionDuration, 6, null);
                }
            };
            Event event = this.events.computeIfAbsent(path, new Function(function1){
                private final /* synthetic */ Function1 function;
                {
                    Intrinsics.checkNotNullParameter(function, "function");
                    this.function = function;
                }

                public final /* synthetic */ Object apply(Object p0) {
                    return this.function.invoke(p0);
                }
            });
            int n = event.getCreatedCount();
            event.setCreatedCount(n + 1);
        }

        public final void logCached(@NotNull Path path) {
            Intrinsics.checkNotNullParameter(path, "path");
            Function1 function1 = new Function1<Path, Event>(path){
                final /* synthetic */ Path $path;
                {
                    this.$path = $path;
                    super(1);
                }

                @NotNull
                public final Event invoke(@NotNull Path it) {
                    Intrinsics.checkNotNullParameter(it, "it");
                    return new Event(this.$path, 0, 0, 0L, 6, null);
                }
            };
            Event event = this.events.computeIfAbsent(path, new /* invalid duplicate definition of identical inner class */);
            int n = event.getCacheHit();
            event.setCacheHit(n + 1);
        }

        @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\f\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\u0014\u001a\u00020\u0015H\u0016R\u001a\u0010\u0006\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000b\"\u0004\b\u000f\u0010\rR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/plugin/structure/intellij/plugin/PluginArchiveManager$Stats$Event;", "", "path", "Ljava/nio/file/Path;", "createdCount", "", "cacheHit", "duration", "", "(Ljava/nio/file/Path;IIJ)V", "getCacheHit", "()I", "setCacheHit", "(I)V", "getCreatedCount", "setCreatedCount", "getDuration", "()J", "getPath", "()Ljava/nio/file/Path;", "toString", "", "structure-intellij"})
        public static final class Event {
            @NotNull
            private final Path path;
            private int createdCount;
            private int cacheHit;
            private final long duration;

            public Event(@NotNull Path path, int createdCount, int cacheHit, long duration) {
                Intrinsics.checkNotNullParameter(path, "path");
                this.path = path;
                this.createdCount = createdCount;
                this.cacheHit = cacheHit;
                this.duration = duration;
            }

            public /* synthetic */ Event(Path path, int n, int n2, long l, int n3, DefaultConstructorMarker defaultConstructorMarker2) {
                if ((n3 & 2) != 0) {
                    n = 0;
                }
                if ((n3 & 4) != 0) {
                    n2 = 0;
                }
                this(path, n, n2, l);
            }

            @NotNull
            public final Path getPath() {
                return this.path;
            }

            public final int getCreatedCount() {
                return this.createdCount;
            }

            public final void setCreatedCount(int n) {
                this.createdCount = n;
            }

            public final int getCacheHit() {
                return this.cacheHit;
            }

            public final void setCacheHit(int n) {
                this.cacheHit = n;
            }

            public final long getDuration() {
                return this.duration;
            }

            @NotNull
            public String toString() {
                return this.path + " hit cache: " + this.cacheHit + ", created: " + this.createdCount + " in " + this.duration + " ms";
            }
        }
    }
}

