/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.classes.resolvers;

import com.jetbrains.plugin.structure.base.utils.BinaryClassesKt;
import com.jetbrains.plugin.structure.base.utils.LanguageUtilsKt;
import com.jetbrains.plugin.structure.classes.resolvers.EmptyResolver;
import com.jetbrains.plugin.structure.classes.resolvers.NamedResolver;
import com.jetbrains.plugin.structure.classes.resolvers.ResolutionResult;
import com.jetbrains.plugin.structure.classes.resolvers.Resolver;
import com.jetbrains.plugin.structure.classes.resolvers.ResourceBundleNameSet;
import com.jetbrains.plugin.structure.classes.resolvers.SimpleCompositeResolver;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.PropertyResourceBundle;
import java.util.Set;
import java.util.function.BiFunction;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.tree.ClassNode;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\r\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u0000 9*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003:\u00019B#\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010$\u001a\u00020%H\u0016J\u0014\u0010&\u001a\u00020'2\n\u0010(\u001a\u00060\u0011j\u0002`\u0012H\u0016J\u0010\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\tH\u0017J\u0010\u0010)\u001a\u00020'2\u0006\u0010*\u001a\u00020\tH\u0016J\"\u0010+\u001a\u00020'2\u0018\u0010,\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020/0.\u0012\u0004\u0012\u00020'0-H\u0016J\u001a\u00100\u001a\b\u0012\u0004\u0012\u00020/0.2\n\u0010(\u001a\u00060\u0011j\u0002`\u0012H\u0016J\u0016\u00100\u001a\b\u0012\u0004\u0012\u00020/0.2\u0006\u0010(\u001a\u00020\tH\u0017J\u001e\u00101\u001a\b\u0012\u0004\u0012\u0002020.2\u0006\u00103\u001a\u00020\t2\u0006\u00104\u001a\u000205H\u0016J\b\u00106\u001a\u00020\tH\u0016J\u0014\u00107\u001a\u00020\f*\u00020\f2\u0006\u00108\u001a\u00020\fH\u0002R\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u001e\u0010\u000f\u001a\f\u0012\b\u0012\u00060\u0011j\u0002`\u00120\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R \u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\t0\u00108VX\u0097\u0004\u00a2\u0006\f\u0012\u0004\b\u0016\u0010\u0017\u001a\u0004\b\u0018\u0010\u0014R \u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\t0\u00108VX\u0097\u0004\u00a2\u0006\f\u0012\u0004\b\u001a\u0010\u0017\u001a\u0004\b\u001b\u0010\u0014R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u001a\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\t0\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u0014R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#\u00a8\u0006:"}, d2={"Lcom/jetbrains/plugin/structure/classes/resolvers/SimpleCompositeResolver;", "R", "Lcom/jetbrains/plugin/structure/classes/resolvers/Resolver;", "Lcom/jetbrains/plugin/structure/classes/resolvers/NamedResolver;", "resolvers", "", "readMode", "Lcom/jetbrains/plugin/structure/classes/resolvers/Resolver$ReadMode;", "name", "", "(Ljava/util/List;Lcom/jetbrains/plugin/structure/classes/resolvers/Resolver$ReadMode;Ljava/lang/String;)V", "allBundleNameSet", "Lcom/jetbrains/plugin/structure/classes/resolvers/ResourceBundleNameSet;", "getAllBundleNameSet", "()Lcom/jetbrains/plugin/structure/classes/resolvers/ResourceBundleNameSet;", "allClassNames", "", "", "Lcom/jetbrains/plugin/structure/base/BinaryClassName;", "getAllClassNames", "()Ljava/util/Set;", "allClasses", "getAllClasses$annotations", "()V", "getAllClasses", "allPackages", "getAllPackages$annotations", "getAllPackages", "getName", "()Ljava/lang/String;", "packages", "getPackages", "getReadMode", "()Lcom/jetbrains/plugin/structure/classes/resolvers/Resolver$ReadMode;", "getResolvers", "()Ljava/util/List;", "close", "", "containsClass", "", "className", "containsPackage", "packageName", "processAllClasses", "processor", "Lkotlin/Function1;", "Lcom/jetbrains/plugin/structure/classes/resolvers/ResolutionResult;", "Lorg/objectweb/asm/tree/ClassNode;", "resolveClass", "resolveExactPropertyResourceBundle", "Ljava/util/PropertyResourceBundle;", "baseName", "locale", "Ljava/util/Locale;", "toString", "merge", "resourceBundleNameSet", "Companion", "structure-classes"})
@SourceDebugExtension(value={"SMAP\nSimpleCompositeResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SimpleCompositeResolver.kt\ncom/jetbrains/plugin/structure/classes/resolvers/SimpleCompositeResolver\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,128:1\n1446#2,5:129\n1446#2,5:134\n1446#2,5:139\n1446#2,5:144\n1549#2:149\n1620#2,3:150\n2661#2,7:153\n1747#2,3:160\n1747#2,3:163\n1747#2,3:166\n1726#2,3:169\n215#3,2:172\n*E\n*S KotlinDebug\n*F\n+ 1 SimpleCompositeResolver.kt\ncom/jetbrains/plugin/structure/classes/resolvers/SimpleCompositeResolver\n*L\n21#1,5:129\n24#1,5:134\n28#1,5:139\n31#1,5:144\n35#1:149\n35#1,3:150\n39#1,7:153\n79#1,3:160\n83#1,3:163\n87#1,3:166\n91#1,3:169\n104#1,2:172\n*E\n"})
public class SimpleCompositeResolver<R extends Resolver>
extends NamedResolver {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<R> resolvers;
    @NotNull
    private final Resolver.ReadMode readMode;
    @NotNull
    private final String name;

    public SimpleCompositeResolver(@NotNull List<? extends R> resolvers, @NotNull Resolver.ReadMode readMode, @NotNull String name) {
        Intrinsics.checkNotNullParameter(resolvers, "resolvers");
        Intrinsics.checkNotNullParameter((Object)readMode, "readMode");
        Intrinsics.checkNotNullParameter(name, "name");
        super(name);
        this.resolvers = resolvers;
        this.readMode = readMode;
        this.name = name;
    }

    @NotNull
    public List<R> getResolvers() {
        return this.resolvers;
    }

    @Override
    @NotNull
    public Resolver.ReadMode getReadMode() {
        return this.readMode;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Set<String> getAllClasses() {
        void var2_2;
        void $this$flatMapTo$iv;
        Iterable iterable = this.getResolvers();
        Collection destination$iv = new HashSet();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv : $this$flatMapTo$iv) {
            Resolver it = (Resolver)element$iv;
            boolean bl = false;
            Iterable list$iv = it.getAllClasses();
            CollectionsKt.addAll(destination$iv, list$iv);
        }
        return (Set)var2_2;
    }

    @Deprecated(message="Use 'allClassNames' property instead which is more efficient")
    public static /* synthetic */ void getAllClasses$annotations() {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Set<CharSequence> getAllClassNames() {
        void var2_2;
        void $this$flatMapTo$iv;
        Iterable iterable = this.getResolvers();
        Collection destination$iv = BinaryClassesKt.binaryClassNames();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv : $this$flatMapTo$iv) {
            Resolver it = (Resolver)element$iv;
            boolean bl = false;
            Iterable list$iv = it.getAllClassNames();
            CollectionsKt.addAll(destination$iv, list$iv);
        }
        return (Set)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Set<String> getAllPackages() {
        void var2_2;
        void $this$flatMapTo$iv;
        Iterable iterable = this.getResolvers();
        Collection destination$iv = new HashSet();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv : $this$flatMapTo$iv) {
            Resolver it = (Resolver)element$iv;
            boolean bl = false;
            Iterable list$iv = it.getAllPackages();
            CollectionsKt.addAll(destination$iv, list$iv);
        }
        return (Set)var2_2;
    }

    @Deprecated(message="Use 'packages' property instead. This property may be slow on some file systems.")
    public static /* synthetic */ void getAllPackages$annotations() {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Set<String> getPackages() {
        void var2_2;
        void $this$flatMapTo$iv;
        Iterable iterable = this.getResolvers();
        Collection destination$iv = new HashSet();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv : $this$flatMapTo$iv) {
            Resolver it = (Resolver)element$iv;
            boolean bl = false;
            Iterable list$iv = it.getPackages();
            CollectionsKt.addAll(destination$iv, list$iv);
        }
        return (Set)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public ResourceBundleNameSet getAllBundleNameSet() {
        ResourceBundleNameSet resourceBundleNameSet;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.getResolvers();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Resolver resolver = (Resolver)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getAllBundleNameSet());
        }
        List bundleSets = (List)destination$iv$iv;
        if (bundleSets.isEmpty()) {
            resourceBundleNameSet = ResourceBundleNameSet.Companion.getEMPTY();
        } else {
            Iterable $this$reduce$iv = bundleSets;
            boolean $i$f$reduce = false;
            Iterator iterator$iv = $this$reduce$iv.iterator();
            if (!iterator$iv.hasNext()) {
                throw new UnsupportedOperationException("Empty collection can't be reduced.");
            }
            Object accumulator$iv = iterator$iv.next();
            while (iterator$iv.hasNext()) {
                void bundleNames;
                ResourceBundleNameSet $i$f$mapTo2 = (ResourceBundleNameSet)iterator$iv.next();
                ResourceBundleNameSet acc = (ResourceBundleNameSet)accumulator$iv;
                boolean bl = false;
                accumulator$iv = this.merge(acc, (ResourceBundleNameSet)bundleNames);
            }
            resourceBundleNameSet = (ResourceBundleNameSet)accumulator$iv;
        }
        return resourceBundleNameSet;
    }

    @Override
    @Deprecated(message="Use 'resolveClass(BinaryClassName)' instead")
    @NotNull
    public ResolutionResult<ClassNode> resolveClass(@NotNull String className) {
        Intrinsics.checkNotNullParameter(className, "className");
        for (Resolver resolver : this.getResolvers()) {
            ResolutionResult<ClassNode> resolutionResult = resolver.resolveClass(className);
            if (resolutionResult instanceof ResolutionResult.NotFound) continue;
            return resolutionResult;
        }
        return ResolutionResult.NotFound.INSTANCE;
    }

    @Override
    @NotNull
    public ResolutionResult<ClassNode> resolveClass(@NotNull CharSequence className) {
        Intrinsics.checkNotNullParameter(className, "className");
        for (Resolver resolver : this.getResolvers()) {
            ResolutionResult<ClassNode> resolutionResult = resolver.resolveClass(className);
            if (resolutionResult instanceof ResolutionResult.NotFound) continue;
            return resolutionResult;
        }
        return ResolutionResult.NotFound.INSTANCE;
    }

    @Override
    @NotNull
    public ResolutionResult<PropertyResourceBundle> resolveExactPropertyResourceBundle(@NotNull String baseName, @NotNull Locale locale) {
        Intrinsics.checkNotNullParameter(baseName, "baseName");
        Intrinsics.checkNotNullParameter(locale, "locale");
        for (Resolver resolver : this.getResolvers()) {
            ResolutionResult<PropertyResourceBundle> resolutionResult = resolver.resolveExactPropertyResourceBundle(baseName, locale);
            if (resolutionResult instanceof ResolutionResult.NotFound) continue;
            return resolutionResult;
        }
        return ResolutionResult.NotFound.INSTANCE;
    }

    @Override
    @Deprecated(message="Use 'containsClass(BinaryClassName)' instead")
    public boolean containsClass(@NotNull String className) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter(className, "className");
            Iterable $this$any$iv = this.getResolvers();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Resolver it = (Resolver)element$iv;
                    boolean bl2 = false;
                    if (!it.containsClass(className)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @Override
    public boolean containsClass(@NotNull CharSequence className) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter(className, "className");
            Iterable $this$any$iv = this.getResolvers();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Resolver it = (Resolver)element$iv;
                    boolean bl2 = false;
                    if (!it.containsClass(className)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @Override
    public boolean containsPackage(@NotNull String packageName) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter(packageName, "packageName");
            Iterable $this$any$iv = this.getResolvers();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Resolver it = (Resolver)element$iv;
                    boolean bl2 = false;
                    if (!it.containsPackage(packageName)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @Override
    public boolean processAllClasses(@NotNull Function1<? super ResolutionResult<? extends ClassNode>, Boolean> processor) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter(processor, "processor");
            Iterable $this$all$iv = this.getResolvers();
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    Resolver it = (Resolver)element$iv;
                    boolean bl2 = false;
                    if (it.processAllClasses(processor)) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    @Override
    public void close() {
        LanguageUtilsKt.closeAll(this.getResolvers());
    }

    @NotNull
    public String toString() {
        return this.getName() + " is a composite of " + this.getResolvers().size() + " resolver" + (this.getResolvers().size() != 1 ? "s" : "");
    }

    private final ResourceBundleNameSet merge(ResourceBundleNameSet $this$merge, ResourceBundleNameSet resourceBundleNameSet) {
        HashMap<String, Set<String>> mergedBundles = new HashMap<String, Set<String>>($this$merge.getBundleNames$structure_classes());
        Map<String, Set<String>> $this$forEach$iv = resourceBundleNameSet.getBundleNames$structure_classes();
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, Set<String>>> iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<String, Set<String>> element$iv;
            Map.Entry<String, Set<String>> entry = element$iv = iterator2.next();
            boolean bl = false;
            String baseName = entry.getKey();
            Set<String> localeSpecificNames = entry.getValue();
            Function2 function2 = merge.1.1.INSTANCE;
            mergedBundles.merge(baseName, localeSpecificNames, new BiFunction(function2){
                private final /* synthetic */ Function2 function;
                {
                    Intrinsics.checkNotNullParameter(function, "function");
                    this.function = function;
                }

                public final /* synthetic */ Object apply(Object p0, Object p1) {
                    return this.function.invoke(p0, p1);
                }
            });
        }
        return new ResourceBundleNameSet((Map<String, ? extends Set<String>>)mergedBundles);
    }

    @JvmStatic
    @NotNull
    public static final Resolver create(@NotNull Iterable<? extends Resolver> resolvers, @NotNull String resolverName) {
        return Companion.create(resolvers, resolverName);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007\u00a8\u0006\t"}, d2={"Lcom/jetbrains/plugin/structure/classes/resolvers/SimpleCompositeResolver$Companion;", "", "()V", "create", "Lcom/jetbrains/plugin/structure/classes/resolvers/Resolver;", "resolvers", "", "resolverName", "", "structure-classes"})
    @SourceDebugExtension(value={"SMAP\nSimpleCompositeResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SimpleCompositeResolver.kt\ncom/jetbrains/plugin/structure/classes/resolvers/SimpleCompositeResolver$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,128:1\n1726#2,3:129\n*E\n*S KotlinDebug\n*F\n+ 1 SimpleCompositeResolver.kt\ncom/jetbrains/plugin/structure/classes/resolvers/SimpleCompositeResolver$Companion\n*L\n118#1,3:129\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * Enabled aggressive block sorting
         */
        @JvmStatic
        @NotNull
        public final Resolver create(@NotNull Iterable<? extends Resolver> resolvers, @NotNull String resolverName) {
            boolean bl;
            Resolver resolver;
            List<? extends Resolver> list;
            block7: {
                Intrinsics.checkNotNullParameter(resolvers, "resolvers");
                Intrinsics.checkNotNullParameter(resolverName, "resolverName");
                list = CollectionsKt.toList(resolvers);
                switch (list.size()) {
                    case 0: {
                        resolver = new EmptyResolver(resolverName);
                        return resolver;
                    }
                    case 1: {
                        resolver = CollectionsKt.first(list);
                        return resolver;
                    }
                }
                Iterable $this$all$iv = list;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        Resolver it = (Resolver)element$iv;
                        boolean bl2 = false;
                        if (it.getReadMode() == Resolver.ReadMode.FULL) continue;
                        bl = false;
                        break block7;
                    }
                    bl = true;
                }
            }
            Resolver.ReadMode readMode = bl ? Resolver.ReadMode.FULL : Resolver.ReadMode.SIGNATURES;
            resolver = new SimpleCompositeResolver<Resolver>(list, readMode, resolverName);
            return resolver;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

