/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.classes.resolvers;

import com.jetbrains.plugin.structure.base.utils.FileUtilKt;
import com.jetbrains.plugin.structure.base.utils.LanguageUtilsKt;
import java.io.Closeable;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.time.Clock;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Deprecated(message="Use 'JarFileSystemProvider' implementations")
@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c1\u0002\u0018\u00002\u00020\u0001:\u0001\u001bB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000bJ\u000e\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000bJ\u0010\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u000bH\u0002J-\u0010\u0013\u001a\u0002H\u0014\"\u0004\b\u0000\u0010\u00142\u0006\u0010\u0010\u001a\u00020\u000b2\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u0002H\u00140\u0016\u00a2\u0006\u0002\u0010\u0018J\u0010\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\fH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\t\u001a\u001e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nj\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f`\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/jetbrains/plugin/structure/classes/resolvers/JarFileSystemsPool;", "", "()V", "MAX_OPEN_JAR_FILE_SYSTEMS", "", "UNUSED_JAR_FILE_SYSTEMS_TO_CLOSE", "clock", "Ljava/time/Clock;", "kotlin.jvm.PlatformType", "openJarFileSystems", "Ljava/util/HashMap;", "Ljava/nio/file/Path;", "Lcom/jetbrains/plugin/structure/classes/resolvers/JarFileSystemsPool$FSHandler;", "Lkotlin/collections/HashMap;", "checkIsJar", "", "jarPath", "close", "getOrOpenFsHandler", "perform", "T", "action", "Lkotlin/Function1;", "Ljava/nio/file/FileSystem;", "(Ljava/nio/file/Path;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "release", "fsHandler", "FSHandler", "structure-classes"})
@SourceDebugExtension(value={"SMAP\nJarFileSystemsPool.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JarFileSystemsPool.kt\ncom/jetbrains/plugin/structure/classes/resolvers/JarFileSystemsPool\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,87:1\n1#2:88\n372#3,7:89\n766#4:96\n857#4,2:97\n1045#4:99\n1855#4,2:100\n*E\n*S KotlinDebug\n*F\n+ 1 JarFileSystemsPool.kt\ncom/jetbrains/plugin/structure/classes/resolvers/JarFileSystemsPool\n*L\n46#1,7:89\n56#1:96\n56#1,2:97\n57#1:99\n59#1,2:100\n*E\n"})
public final class JarFileSystemsPool {
    @NotNull
    public static final JarFileSystemsPool INSTANCE = new JarFileSystemsPool();
    private static final int MAX_OPEN_JAR_FILE_SYSTEMS = 256;
    private static final int UNUSED_JAR_FILE_SYSTEMS_TO_CLOSE = 64;
    @NotNull
    private static final HashMap<Path, FSHandler> openJarFileSystems = new HashMap();
    private static final Clock clock = Clock.systemUTC();

    private JarFileSystemsPool() {
    }

    public final void checkIsJar(@NotNull Path jarPath) {
        Intrinsics.checkNotNullParameter(jarPath, "jarPath");
        if (!FileUtilKt.exists(jarPath)) {
            boolean $i$a$-require-JarFileSystemsPool$checkIsJar$32 = false;
            String $i$a$-require-JarFileSystemsPool$checkIsJar$32 = "File does not exist: " + jarPath;
            throw new IllegalArgumentException($i$a$-require-JarFileSystemsPool$checkIsJar$32.toString());
        }
        if (!(StringsKt.endsWith$default(FileUtilKt.getSimpleName(jarPath), ".jar", false, 2, null) || StringsKt.endsWith$default(FileUtilKt.getSimpleName(jarPath), ".zip", false, 2, null))) {
            boolean bl = false;
            String string = "File is neither a .jar nor .zip archive: " + jarPath;
            throw new IllegalArgumentException(string.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T> T perform(@NotNull Path jarPath, @NotNull Function1<? super FileSystem, ? extends T> action) {
        Intrinsics.checkNotNullParameter(jarPath, "jarPath");
        Intrinsics.checkNotNullParameter(action, "action");
        this.checkIsJar(jarPath);
        FSHandler fsHandler = this.getOrOpenFsHandler(jarPath);
        if (!fsHandler.getJarFs().isOpen()) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        try {
            T t2 = action.invoke(fsHandler.getJarFs());
            return t2;
        }
        finally {
            this.release(fsHandler);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final synchronized FSHandler getOrOpenFsHandler(Path jarPath) {
        Object object;
        FSHandler answer$iv;
        Map $this$getOrPut$iv22 = openJarFileSystems;
        boolean $i$f$getOrPut2 = false;
        Object value$iv = $this$getOrPut$iv22.get(jarPath);
        if (value$iv == null) {
            boolean bl = false;
            FileSystem jarFs = FileSystems.newFileSystem(jarPath, JarFileSystemsPool.class.getClassLoader());
            Intrinsics.checkNotNullExpressionValue(jarFs, "jarFs");
            Instant instant = clock.instant();
            Intrinsics.checkNotNullExpressionValue(instant, "clock.instant()");
            answer$iv = new FSHandler(jarFs, instant, 0);
            $this$getOrPut$iv22.put(jarPath, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        FSHandler fsHandler = (FSHandler)object;
        int $this$getOrPut$iv22 = fsHandler.getUsers();
        fsHandler.setUsers($this$getOrPut$iv22 + 1);
        Instant instant = clock.instant();
        Intrinsics.checkNotNullExpressionValue(instant, "clock.instant()");
        fsHandler.setLastAccessTime(instant);
        if (openJarFileSystems.size() > 256) {
            void $this$sortedBy$iv;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            Set<Map.Entry<Path, FSHandler>> set = openJarFileSystems.entrySet();
            Intrinsics.checkNotNullExpressionValue(set, "openJarFileSystems.entries");
            Iterable $i$f$getOrPut2 = set;
            boolean $i$f$filter = false;
            answer$iv = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Map.Entry it = (Map.Entry)element$iv$iv;
                boolean bl = false;
                if (!(((FSHandler)it.getValue()).getUsers() == 0)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$sortedBy = false;
            List toCloseEntries = CollectionsKt.take(CollectionsKt.sortedWith($this$sortedBy$iv, new Comparator(){

                public final int compare(T a, T b) {
                    Map.Entry it = (Map.Entry)a;
                    boolean bl = false;
                    Comparable comparable = ((FSHandler)it.getValue()).getLastAccessTime();
                    it = (Map.Entry)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues(comparable2, (Comparable)((FSHandler)it.getValue()).getLastAccessTime());
                }
            }), 64);
            Iterable $this$forEach$iv = toCloseEntries;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Map.Entry entry = (Map.Entry)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue(entry, "(path, fsHandler)");
                Path path = (Path)entry.getKey();
                FSHandler fsHandler2 = (FSHandler)entry.getValue();
                LanguageUtilsKt.closeLogged((Closeable)fsHandler2.getJarFs());
                openJarFileSystems.remove(path);
            }
        }
        return fsHandler;
    }

    public final synchronized void close(@NotNull Path jarPath) {
        Intrinsics.checkNotNullParameter(jarPath, "jarPath");
        FSHandler fSHandler = openJarFileSystems.get(jarPath);
        if (fSHandler == null) {
            return;
        }
        FSHandler fsHandler = fSHandler;
        if (fsHandler.getUsers() == 0) {
            LanguageUtilsKt.closeLogged((Closeable)fsHandler.getJarFs());
            openJarFileSystems.remove(jarPath);
        }
    }

    private final synchronized void release(FSHandler fsHandler) {
        int n = fsHandler.getUsers();
        fsHandler.setUsers(n + -1);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u0007H\u00d6\u0001J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001d"}, d2={"Lcom/jetbrains/plugin/structure/classes/resolvers/JarFileSystemsPool$FSHandler;", "", "jarFs", "Ljava/nio/file/FileSystem;", "lastAccessTime", "Ljava/time/Instant;", "users", "", "(Ljava/nio/file/FileSystem;Ljava/time/Instant;I)V", "getJarFs", "()Ljava/nio/file/FileSystem;", "getLastAccessTime", "()Ljava/time/Instant;", "setLastAccessTime", "(Ljava/time/Instant;)V", "getUsers", "()I", "setUsers", "(I)V", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "", "structure-classes"})
    private static final class FSHandler {
        @NotNull
        private final FileSystem jarFs;
        @NotNull
        private Instant lastAccessTime;
        private int users;

        public FSHandler(@NotNull FileSystem jarFs, @NotNull Instant lastAccessTime, int users) {
            Intrinsics.checkNotNullParameter(jarFs, "jarFs");
            Intrinsics.checkNotNullParameter(lastAccessTime, "lastAccessTime");
            this.jarFs = jarFs;
            this.lastAccessTime = lastAccessTime;
            this.users = users;
        }

        @NotNull
        public final FileSystem getJarFs() {
            return this.jarFs;
        }

        @NotNull
        public final Instant getLastAccessTime() {
            return this.lastAccessTime;
        }

        public final void setLastAccessTime(@NotNull Instant instant) {
            Intrinsics.checkNotNullParameter(instant, "<set-?>");
            this.lastAccessTime = instant;
        }

        public final int getUsers() {
            return this.users;
        }

        public final void setUsers(int n) {
            this.users = n;
        }

        @NotNull
        public final FileSystem component1() {
            return this.jarFs;
        }

        @NotNull
        public final Instant component2() {
            return this.lastAccessTime;
        }

        public final int component3() {
            return this.users;
        }

        @NotNull
        public final FSHandler copy(@NotNull FileSystem jarFs, @NotNull Instant lastAccessTime, int users) {
            Intrinsics.checkNotNullParameter(jarFs, "jarFs");
            Intrinsics.checkNotNullParameter(lastAccessTime, "lastAccessTime");
            return new FSHandler(jarFs, lastAccessTime, users);
        }

        public static /* synthetic */ FSHandler copy$default(FSHandler fSHandler, FileSystem fileSystem, Instant instant, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                fileSystem = fSHandler.jarFs;
            }
            if ((n2 & 2) != 0) {
                instant = fSHandler.lastAccessTime;
            }
            if ((n2 & 4) != 0) {
                n = fSHandler.users;
            }
            return fSHandler.copy(fileSystem, instant, n);
        }

        @NotNull
        public String toString() {
            return "FSHandler(jarFs=" + this.jarFs + ", lastAccessTime=" + this.lastAccessTime + ", users=" + this.users + ")";
        }

        public int hashCode() {
            int result2 = this.jarFs.hashCode();
            result2 = result2 * 31 + this.lastAccessTime.hashCode();
            result2 = result2 * 31 + Integer.hashCode(this.users);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof FSHandler)) {
                return false;
            }
            FSHandler fSHandler = (FSHandler)other;
            if (!Intrinsics.areEqual(this.jarFs, fSHandler.jarFs)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.lastAccessTime, fSHandler.lastAccessTime)) {
                return false;
            }
            return this.users == fSHandler.users;
        }
    }
}

