/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.classes.resolvers;

import com.jetbrains.plugin.structure.base.utils.FileUtilKt;
import com.jetbrains.plugin.structure.base.utils.LanguageUtilsKt;
import com.jetbrains.plugin.structure.classes.resolvers.AbstractJarResolver;
import com.jetbrains.plugin.structure.classes.resolvers.FileOrigin;
import com.jetbrains.plugin.structure.classes.resolvers.JarFileResolver;
import com.jetbrains.plugin.structure.classes.resolvers.JarFileSystemsPool;
import com.jetbrains.plugin.structure.classes.resolvers.ResolutionResult;
import com.jetbrains.plugin.structure.classes.resolvers.Resolver;
import com.jetbrains.plugin.structure.classes.resolvers.ResourceBundleNameSet;
import com.jetbrains.plugin.structure.classes.utils.PropertyBundleUtilsKt;
import com.jetbrains.plugin.structure.jar.Packages;
import java.io.Closeable;
import java.io.InputStream;
import java.nio.file.FileSystem;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import java.util.stream.Stream;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.tree.ClassNode;

@Deprecated(message="Replaced with LazyJarResolver", replaceWith=@ReplaceWith(expression="LazyJarResolver", imports={"com.jetbrains.plugin.structure.classes.resolvers.LazyJarResolver"}))
@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u00a8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\r\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 R2\u00020\u0001:\u0001RB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u00103\u001a\u000204H\u0002J\b\u00105\u001a\u000204H\u0016J\u0014\u00106\u001a\u0002072\n\u00108\u001a\u000609j\u0002`:H\u0016J\u0010\u00106\u001a\u0002072\u0006\u00108\u001a\u00020\u000fH\u0017J\u0010\u0010;\u001a\u0002072\u0006\u0010<\u001a\u00020\u000fH\u0016J\u0010\u0010=\u001a\u00020\u000f2\u0006\u0010>\u001a\u00020\u0003H\u0002J\"\u0010?\u001a\u0002072\u0018\u0010@\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020C0B\u0012\u0004\u0012\u0002070AH\u0016J\u0010\u0010D\u001a\u0002042\u0006\u0010E\u001a\u00020FH\u0002J\u0012\u0010G\u001a\u0004\u0018\u00010H2\u0006\u0010I\u001a\u00020\u000fH\u0014J\u001e\u0010J\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00172\u0006\u0010K\u001a\u00020\u000f2\u0006\u0010E\u001a\u00020FH\u0002J\u001a\u0010L\u001a\b\u0012\u0004\u0012\u00020C0B2\n\u00108\u001a\u000609j\u0002`:H\u0016J\u0016\u0010L\u001a\b\u0012\u0004\u0012\u00020C0B2\u0006\u00108\u001a\u00020\u000fH\u0017J\u001e\u0010M\u001a\b\u0012\u0004\u0012\u00020H0B2\u0006\u0010N\u001a\u00020\u000f2\u0006\u0010O\u001a\u00020PH\u0016J\b\u0010Q\u001a\u00020\u000fH\u0016R\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R \u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e8VX\u0097\u0004\u00a2\u0006\f\u0012\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0015\u0010\u0011R$\u0010\u0016\u001a\f\u0012\b\u0012\u00060\u000fj\u0002`\u00180\u00178VX\u0097\u0004\u00a2\u0006\f\u0012\u0004\b\u0019\u0010\u0014\u001a\u0004\b\u001a\u0010\u0011R<\u0010\u001b\u001a*\u0012\u0004\u0012\u00020\u000f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\u001cj\u0014\u0012\u0004\u0012\u00020\u000f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e`\u001dX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0014\u0010 \u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u00078TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R&\u0010#\u001a\u0014\u0012\u0004\u0012\u00020\u000f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u00170$8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010&R\u000e\u0010'\u001a\u00020(X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u00038TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010*R\u000e\u0010+\u001a\u00020,X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010-\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b.\u0010\u0011R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b/\u00100R \u00101\u001a\u0014\u0012\u0004\u0012\u00020\u000f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u001702X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006S"}, d2={"Lcom/jetbrains/plugin/structure/classes/resolvers/JarFileResolver;", "Lcom/jetbrains/plugin/structure/classes/resolvers/AbstractJarResolver;", "jarPath", "Ljava/nio/file/Path;", "readMode", "Lcom/jetbrains/plugin/structure/classes/resolvers/Resolver$ReadMode;", "fileOrigin", "Lcom/jetbrains/plugin/structure/classes/resolvers/FileOrigin;", "(Ljava/nio/file/Path;Lcom/jetbrains/plugin/structure/classes/resolvers/Resolver$ReadMode;Lcom/jetbrains/plugin/structure/classes/resolvers/FileOrigin;)V", "allBundleNameSet", "Lcom/jetbrains/plugin/structure/classes/resolvers/ResourceBundleNameSet;", "getAllBundleNameSet", "()Lcom/jetbrains/plugin/structure/classes/resolvers/ResourceBundleNameSet;", "allClassNames", "", "", "getAllClassNames", "()Ljava/util/Set;", "allClasses", "getAllClasses$annotations", "()V", "getAllClasses", "allPackages", "", "Lcom/jetbrains/plugin/structure/jar/BinaryPackageName;", "getAllPackages$annotations", "getAllPackages", "bundleNames", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "getBundleNames", "()Ljava/util/HashMap;", "classes", "getFileOrigin", "()Lcom/jetbrains/plugin/structure/classes/resolvers/FileOrigin;", "implementedServiceProviders", "", "getImplementedServiceProviders", "()Ljava/util/Map;", "isClosed", "Ljava/util/concurrent/atomic/AtomicBoolean;", "getJarPath", "()Ljava/nio/file/Path;", "packageSet", "Lcom/jetbrains/plugin/structure/jar/Packages;", "packages", "getPackages", "getReadMode", "()Lcom/jetbrains/plugin/structure/classes/resolvers/Resolver$ReadMode;", "serviceProviders", "", "checkIsOpen", "", "close", "containsClass", "", "className", "", "Lcom/jetbrains/plugin/structure/base/BinaryClassName;", "containsPackage", "packageName", "getPathInJar", "entry", "processAllClasses", "processor", "Lkotlin/Function1;", "Lcom/jetbrains/plugin/structure/classes/resolvers/ResolutionResult;", "Lorg/objectweb/asm/tree/ClassNode;", "readClassNamesAndServiceProviders", "jarFs", "Ljava/nio/file/FileSystem;", "readPropertyResourceBundle", "Ljava/util/PropertyResourceBundle;", "bundleResourceName", "readServiceImplementationNames", "serviceProvider", "resolveClass", "resolveExactPropertyResourceBundle", "baseName", "locale", "Ljava/util/Locale;", "toString", "Companion", "structure-classes"})
@SourceDebugExtension(value={"SMAP\nJarFileResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JarFileResolver.kt\ncom/jetbrains/plugin/structure/classes/resolvers/JarFileResolver\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,238:1\n1549#2:239\n1620#2,3:240\n847#2,2:243\n1#3:245\n*E\n*S KotlinDebug\n*F\n+ 1 JarFileResolver.kt\ncom/jetbrains/plugin/structure/classes/resolvers/JarFileResolver\n*L\n108#1:239\n108#1,3:240\n108#1,2:243\n*E\n"})
public final class JarFileResolver
extends AbstractJarResolver {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final Set<String> classes;
    @NotNull
    private final Packages packageSet;
    @NotNull
    private final HashMap<String, Set<String>> bundleNames;
    @NotNull
    private final Map<String, Set<String>> serviceProviders;
    @NotNull
    private final AtomicBoolean isClosed;
    @NotNull
    private static final String CLASS_SUFFIX = ".class";
    @NotNull
    private static final String PROPERTIES_SUFFIX = ".properties";
    @NotNull
    private static final String SERVICE_PROVIDERS_PREFIX = "META-INF/services/";

    public JarFileResolver(@NotNull Path jarPath, @NotNull Resolver.ReadMode readMode, @NotNull FileOrigin fileOrigin) {
        Intrinsics.checkNotNullParameter(jarPath, "jarPath");
        Intrinsics.checkNotNullParameter((Object)readMode, "readMode");
        Intrinsics.checkNotNullParameter(fileOrigin, "fileOrigin");
        super(jarPath, readMode, fileOrigin, null, 8, null);
        this.classes = new HashSet();
        this.packageSet = new Packages();
        this.bundleNames = new HashMap();
        this.serviceProviders = new HashMap();
        this.isClosed = new AtomicBoolean();
        JarFileSystemsPool.INSTANCE.checkIsJar(jarPath);
        JarFileSystemsPool.INSTANCE.perform(jarPath, (Function1)new Function1<FileSystem, Unit>(){

            @Override
            public final void invoke(@NotNull FileSystem jarFs) {
                Intrinsics.checkNotNullParameter(jarFs, "jarFs");
                this.readClassNamesAndServiceProviders(jarFs);
            }
        });
    }

    @Override
    @NotNull
    protected Path getJarPath() {
        return super.getJarPath();
    }

    @Override
    @NotNull
    public Resolver.ReadMode getReadMode() {
        return super.getReadMode();
    }

    @Override
    @NotNull
    protected FileOrigin getFileOrigin() {
        return super.getFileOrigin();
    }

    @NotNull
    protected HashMap<String, Set<String>> getBundleNames() {
        return this.bundleNames;
    }

    private final void readClassNamesAndServiceProviders(FileSystem jarFs) {
        Iterable<Path> iterable = jarFs.getRootDirectories();
        Intrinsics.checkNotNullExpressionValue(iterable, "jarFs.rootDirectories");
        Path jarRoot = CollectionsKt.single(iterable);
        HashSet<Path> visitedDirs = new HashSet<Path>();
        Files.walkFileTree(jarRoot, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(visitedDirs, this, jarFs){
            final /* synthetic */ HashSet<Path> $visitedDirs;
            final /* synthetic */ JarFileResolver this$0;
            final /* synthetic */ FileSystem $jarFs;
            {
                this.$visitedDirs = $visitedDirs;
                this.this$0 = $receiver;
                this.$jarFs = $jarFs;
            }

            @NotNull
            public FileVisitResult preVisitDirectory(@NotNull Path dir2, @NotNull BasicFileAttributes attrs) {
                Intrinsics.checkNotNullParameter(dir2, "dir");
                Intrinsics.checkNotNullParameter(attrs, "attrs");
                if (!this.$visitedDirs.add(dir2)) {
                    return FileVisitResult.SKIP_SUBTREE;
                }
                return FileVisitResult.CONTINUE;
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public FileVisitResult visitFile(@NotNull Path file, @NotNull BasicFileAttributes attrs) {
                Intrinsics.checkNotNullParameter(file, "file");
                Intrinsics.checkNotNullParameter(attrs, "attrs");
                String entryName = JarFileResolver.access$getPathInJar(this.this$0, file);
                if (StringsKt.endsWith$default(entryName, ".class", false, 2, null)) {
                    String className = StringsKt.substringBeforeLast$default(entryName, ".class", null, 2, null);
                    JarFileResolver.access$getClasses$p(this.this$0).add(className);
                    JarFileResolver.access$getPackageSet$p(this.this$0).addClass(className);
                } else if (StringsKt.endsWith$default(entryName, ".properties", false, 2, null)) {
                    Object object;
                    void $this$getOrPut$iv;
                    String fullBundleName = PropertyBundleUtilsKt.getBundleNameByBundlePath(entryName);
                    Map map = this.this$0.getBundleNames();
                    String key$iv = PropertyBundleUtilsKt.getBundleBaseName(fullBundleName);
                    boolean $i$f$getOrPut = false;
                    V value$iv = $this$getOrPut$iv.get(key$iv);
                    if (value$iv == null) {
                        boolean bl = false;
                        Set answer$iv = new HashSet<E>();
                        $this$getOrPut$iv.put(key$iv, answer$iv);
                        object = answer$iv;
                    } else {
                        object = value$iv;
                    }
                    ((Collection)object).add(fullBundleName);
                } else if (StringsKt.startsWith$default(entryName, "META-INF/services/", false, 2, null)) {
                    CharSequence $this$count$iv = entryName;
                    boolean $i$f$count = false;
                    int count$iv = 0;
                    for (int i = 0; i < $this$count$iv.length(); ++i) {
                        char element$iv;
                        char it = element$iv = $this$count$iv.charAt(i);
                        boolean bl = false;
                        if (!(it == '/')) continue;
                        ++count$iv;
                    }
                    if (count$iv == 2) {
                        String serviceProvider = StringsKt.substringAfter$default(entryName, "META-INF/services/", null, 2, null);
                        JarFileResolver.access$getServiceProviders$p(this.this$0).put(serviceProvider, JarFileResolver.access$readServiceImplementationNames(this.this$0, serviceProvider, this.$jarFs));
                    }
                }
                return FileVisitResult.CONTINUE;
            }
        });
    }

    private final String getPathInJar(Path entry) {
        char[] cArray = new char[]{'/'};
        return FileUtilKt.toSystemIndependentName(StringsKt.trimStart(((Object)entry).toString(), cArray));
    }

    /*
     * WARNING - void declaration
     */
    private final Set<String> readServiceImplementationNames(String serviceProvider, FileSystem jarFs) {
        void destination$iv;
        void $this$filterNotTo$iv;
        void $this$mapTo$iv$iv;
        String entry = SERVICE_PROVIDERS_PREFIX + serviceProvider;
        Path entryPath = jarFs.getPath(entry, new String[0]);
        Intrinsics.checkNotNullExpressionValue(entryPath, "entryPath");
        if (!FileUtilKt.exists(entryPath)) {
            return SetsKt.emptySet();
        }
        Iterable $this$map$iv = FileUtilKt.readLines$default(entryPath, null, 1, null);
        boolean $i$f$map22 = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((Object)StringsKt.trim((CharSequence)StringsKt.substringBefore$default((String)it, "#", null, 2, null))).toString());
        }
        $this$map$iv = (List)destination$iv$iv;
        Collection $i$f$map22 = new HashSet();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv : $this$filterNotTo$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            if (((CharSequence)it).length() == 0) continue;
            destination$iv.add(element$iv);
        }
        return (Set)destination$iv;
    }

    @Override
    @NotNull
    public Map<String, Set<String>> getImplementedServiceProviders() {
        return this.serviceProviders;
    }

    @Override
    @NotNull
    public Set<String> getAllPackages() {
        return this.packageSet.getAll();
    }

    @Deprecated(message="Use 'packages' property instead. This property may be slow on some file systems.")
    public static /* synthetic */ void getAllPackages$annotations() {
    }

    @Override
    @NotNull
    public Set<String> getPackages() {
        return this.packageSet.getEntries();
    }

    @Override
    @NotNull
    public ResourceBundleNameSet getAllBundleNameSet() {
        return new ResourceBundleNameSet(this.getBundleNames());
    }

    @Override
    @NotNull
    public Set<String> getAllClasses() {
        return this.classes;
    }

    @Deprecated(message="Use 'allClassNames' property instead which is more efficient")
    public static /* synthetic */ void getAllClasses$annotations() {
    }

    @NotNull
    public Set<String> getAllClassNames() {
        return this.classes;
    }

    @Override
    public boolean processAllClasses(@NotNull Function1<? super ResolutionResult<? extends ClassNode>, Boolean> processor) {
        Intrinsics.checkNotNullParameter(processor, "processor");
        this.checkIsOpen();
        return (Boolean)JarFileSystemsPool.INSTANCE.perform(this.getJarPath(), (Function1)new Function1<FileSystem, Boolean>(this, processor){
            final /* synthetic */ JarFileResolver this$0;
            final /* synthetic */ Function1<ResolutionResult<? extends ClassNode>, Boolean> $processor;
            {
                this.this$0 = $receiver;
                this.$processor = $processor;
                super(1);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @NotNull
            public final Boolean invoke(@NotNull FileSystem jarFs) {
                Boolean bl;
                Intrinsics.checkNotNullParameter(jarFs, "jarFs");
                Iterable<Path> iterable = jarFs.getRootDirectories();
                Intrinsics.checkNotNullExpressionValue(iterable, "jarFs.rootDirectories");
                AutoCloseable autoCloseable = Files.walk(CollectionsKt.single(iterable), new FileVisitOption[0]);
                JarFileResolver jarFileResolver = this.this$0;
                Function1<ResolutionResult<? extends ClassNode>, Boolean> function1 = this.$processor;
                Throwable throwable = null;
                try {
                    boolean bl2;
                    block6: {
                        Stream stream = (Stream)autoCloseable;
                        boolean bl3 = false;
                        Function1 function12 = processAllClasses.1.1.INSTANCE;
                        Iterator<T> iterator2 = stream.filter(new Predicate(function12){
                            private final /* synthetic */ Function1 function;
                            {
                                Intrinsics.checkNotNullParameter(function, "function");
                                this.function = function;
                            }

                            public final /* synthetic */ boolean test(Object p0) {
                                return (Boolean)this.function.invoke(p0);
                            }
                        }).iterator();
                        while (iterator2.hasNext()) {
                            Path jarEntry = (Path)iterator2.next();
                            Intrinsics.checkNotNullExpressionValue(jarEntry, "jarEntry");
                            String className = StringsKt.removeSuffix(JarFileResolver.access$getPathInJar(jarFileResolver, jarEntry), (CharSequence)".class");
                            ResolutionResult<ClassNode> result2 = jarFileResolver.readClass(className, jarEntry);
                            if (function1.invoke(result2).booleanValue()) continue;
                            bl2 = false;
                            break block6;
                        }
                        bl2 = true;
                    }
                    bl = bl2;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    AutoCloseableKt.closeFinally(autoCloseable, throwable);
                }
                return bl;
            }
        });
    }

    @Override
    @Deprecated(message="Use 'containsClass(BinaryClassName)' instead")
    public boolean containsClass(@NotNull String className) {
        Intrinsics.checkNotNullParameter(className, "className");
        return this.classes.contains(className);
    }

    @Override
    public boolean containsClass(@NotNull CharSequence className) {
        Intrinsics.checkNotNullParameter(className, "className");
        return this.containsClass(((Object)className).toString());
    }

    @Override
    public boolean containsPackage(@NotNull String packageName) {
        Intrinsics.checkNotNullParameter(packageName, "packageName");
        return this.packageSet.contains(packageName);
    }

    @Override
    @Deprecated(message="Use 'resolveClass(BinaryClassName)' instead")
    @NotNull
    public ResolutionResult<ClassNode> resolveClass(@NotNull String className) {
        Intrinsics.checkNotNullParameter(className, "className");
        this.checkIsOpen();
        if (!this.classes.contains(className)) {
            return ResolutionResult.NotFound.INSTANCE;
        }
        return (ResolutionResult)JarFileSystemsPool.INSTANCE.perform(this.getJarPath(), (Function1)new Function1<FileSystem, ResolutionResult<? extends ClassNode>>(className, this){
            final /* synthetic */ String $className;
            final /* synthetic */ JarFileResolver this$0;
            {
                this.$className = $className;
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final ResolutionResult<ClassNode> invoke(@NotNull FileSystem jarFs) {
                Intrinsics.checkNotNullParameter(jarFs, "jarFs");
                Path classPath = jarFs.getPath(this.$className + ".class", new String[0]);
                Intrinsics.checkNotNullExpressionValue(classPath, "classPath");
                return FileUtilKt.exists(classPath) ? this.this$0.readClass(this.$className, classPath) : (ResolutionResult<ClassNode>)ResolutionResult.NotFound.INSTANCE;
            }
        });
    }

    @Override
    @NotNull
    public ResolutionResult<ClassNode> resolveClass(@NotNull CharSequence className) {
        Intrinsics.checkNotNullParameter(className, "className");
        return this.resolveClass(((Object)className).toString());
    }

    @Override
    @NotNull
    public ResolutionResult<PropertyResourceBundle> resolveExactPropertyResourceBundle(@NotNull String baseName, @NotNull Locale locale) {
        PropertyResourceBundle propertyResourceBundle;
        Intrinsics.checkNotNullParameter(baseName, "baseName");
        Intrinsics.checkNotNullParameter(locale, "locale");
        if (!this.getBundleNames().containsKey(baseName)) {
            return ResolutionResult.NotFound.INSTANCE;
        }
        ResourceBundle.Control control = ResourceBundle.Control.getControl(ResourceBundle.Control.FORMAT_PROPERTIES);
        String bundleName = control.toBundleName(baseName, locale);
        String resourceName = control.toResourceName(bundleName, "properties");
        try {
            Intrinsics.checkNotNullExpressionValue(resourceName, "resourceName");
            propertyResourceBundle = this.readPropertyResourceBundle(resourceName);
        }
        catch (IllegalArgumentException e) {
            String string = e.getMessage();
            if (string == null) {
                string = e.getClass().getName();
            }
            Intrinsics.checkNotNullExpressionValue(string, "e.message ?: e.javaClass.name");
            return new ResolutionResult.Invalid(string);
        }
        catch (Exception e) {
            LanguageUtilsKt.rethrowIfInterrupted(e);
            String string = e.getMessage();
            if (string == null) {
                string = e.getClass().getName();
            }
            Intrinsics.checkNotNullExpressionValue(string, "e.message ?: e.javaClass.name");
            return new ResolutionResult.FailedToRead(string);
        }
        PropertyResourceBundle propertyResourceBundle2 = propertyResourceBundle;
        if (propertyResourceBundle2 != null) {
            return new ResolutionResult.Found<PropertyResourceBundle>(propertyResourceBundle2, this.getFileOrigin());
        }
        return ResolutionResult.NotFound.INSTANCE;
    }

    @Override
    @Nullable
    protected PropertyResourceBundle readPropertyResourceBundle(@NotNull String bundleResourceName) {
        Intrinsics.checkNotNullParameter(bundleResourceName, "bundleResourceName");
        this.checkIsOpen();
        return (PropertyResourceBundle)JarFileSystemsPool.INSTANCE.perform(this.getJarPath(), (Function1)new Function1<FileSystem, PropertyResourceBundle>(bundleResourceName){
            final /* synthetic */ String $bundleResourceName;
            {
                this.$bundleResourceName = $bundleResourceName;
                super(1);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Nullable
            public final PropertyResourceBundle invoke(@NotNull FileSystem jarFs) {
                PropertyResourceBundle propertyResourceBundle;
                Intrinsics.checkNotNullParameter(jarFs, "jarFs");
                Path path = jarFs.getPath(this.$bundleResourceName, new String[0]);
                Intrinsics.checkNotNullExpressionValue(path, "path");
                if (FileUtilKt.exists(path)) {
                    Closeable closeable = FileUtilKt.inputStream(path);
                    Throwable throwable = null;
                    try {
                        InputStream it = (InputStream)closeable;
                        boolean bl = false;
                        PropertyResourceBundle propertyResourceBundle2 = new PropertyResourceBundle(it);
                        propertyResourceBundle = propertyResourceBundle2;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        CloseableKt.closeFinally(closeable, throwable);
                    }
                } else {
                    propertyResourceBundle = null;
                }
                return propertyResourceBundle;
            }
        });
    }

    private final void checkIsOpen() {
        if (!(!this.isClosed.get())) {
            boolean bl = false;
            String string = "Jar file system must be open for " + this;
            throw new IllegalStateException(string.toString());
        }
    }

    @Override
    public void close() {
        if (this.isClosed.compareAndSet(false, true)) {
            JarFileSystemsPool.INSTANCE.close(this.getJarPath());
        }
    }

    @NotNull
    public String toString() {
        return ((Object)this.getJarPath().toAbsolutePath()).toString();
    }

    public static final /* synthetic */ String access$getPathInJar(JarFileResolver $this, Path entry) {
        return $this.getPathInJar(entry);
    }

    public static final /* synthetic */ Set access$getClasses$p(JarFileResolver $this) {
        return $this.classes;
    }

    public static final /* synthetic */ Packages access$getPackageSet$p(JarFileResolver $this) {
        return $this.packageSet;
    }

    public static final /* synthetic */ Map access$getServiceProviders$p(JarFileResolver $this) {
        return $this.serviceProviders;
    }

    public static final /* synthetic */ Set access$readServiceImplementationNames(JarFileResolver $this, String serviceProvider, FileSystem jarFs) {
        return $this.readServiceImplementationNames(serviceProvider, jarFs);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/plugin/structure/classes/resolvers/JarFileResolver$Companion;", "", "()V", "CLASS_SUFFIX", "", "PROPERTIES_SUFFIX", "SERVICE_PROVIDERS_PREFIX", "structure-classes"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

