/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.classes.resolvers;

import com.jetbrains.plugin.structure.base.utils.BinaryClassesKt;
import com.jetbrains.plugin.structure.base.utils.LanguageUtilsKt;
import com.jetbrains.plugin.structure.classes.resolvers.EmptyResolver;
import com.jetbrains.plugin.structure.classes.resolvers.NamedResolver;
import com.jetbrains.plugin.structure.classes.resolvers.ResolutionResult;
import com.jetbrains.plugin.structure.classes.resolvers.Resolver;
import com.jetbrains.plugin.structure.classes.resolvers.ResourceBundleNameSet;
import com.jetbrains.plugin.structure.classes.resolvers.SimpleCompositeResolver;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.PropertyResourceBundle;
import java.util.Set;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.tree.ClassNode;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\r\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010#\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 A2\u00020\u0001:\u0001AB%\b\u0002\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010,\u001a\u00020-H\u0002J\b\u0010.\u001a\u00020-H\u0016J\u0014\u0010/\u001a\u0002002\n\u00101\u001a\u00060\u0010j\u0002`\u0011H\u0016J\u0010\u0010/\u001a\u0002002\u0006\u00101\u001a\u00020\bH\u0017J\u0010\u00102\u001a\u0002002\u0006\u00103\u001a\u00020\bH\u0016J\u0010\u00104\u001a\u00020\b2\u0006\u00101\u001a\u00020\bH\u0002J\"\u00105\u001a\u0002002\u0018\u00106\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020908\u0012\u0004\u0012\u00020007H\u0016J\u001a\u0010:\u001a\b\u0012\u0004\u0012\u000209082\n\u00101\u001a\u00060\u0010j\u0002`\u0011H\u0016J\u0016\u0010:\u001a\b\u0012\u0004\u0012\u000209082\u0006\u00101\u001a\u00020\bH\u0017J\u001e\u0010;\u001a\b\u0012\u0004\u0012\u00020<082\u0006\u0010=\u001a\u00020\b2\u0006\u0010>\u001a\u00020?H\u0016J\b\u0010@\u001a\u00020\bH\u0016R\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u001e\u0010\u000e\u001a\f\u0012\b\u0012\u00060\u0010j\u0002`\u00110\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R*\u0010\u0014\u001a\u0012\u0012\u0004\u0012\u00020\b0\u0015j\b\u0012\u0004\u0012\u00020\b`\u00168VX\u0097\u0004\u00a2\u0006\f\u0012\u0004\b\u0017\u0010\u0018\u001a\u0004\b\u0019\u0010\u001aR \u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\b0\u001c8VX\u0097\u0004\u00a2\u0006\f\u0012\u0004\b\u001d\u0010\u0018\u001a\u0004\b\u001e\u0010\u0013R \u0010\u001f\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040!0 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R6\u0010\"\u001a*\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u001c0#j\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u001c`$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R \u0010'\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040!0 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010(\u001a\b\u0012\u0004\u0012\u00020\b0\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010\u0013R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006B"}, d2={"Lcom/jetbrains/plugin/structure/classes/resolvers/CompositeResolver;", "Lcom/jetbrains/plugin/structure/classes/resolvers/NamedResolver;", "resolvers", "", "Lcom/jetbrains/plugin/structure/classes/resolvers/Resolver;", "readMode", "Lcom/jetbrains/plugin/structure/classes/resolvers/Resolver$ReadMode;", "name", "", "(Ljava/util/List;Lcom/jetbrains/plugin/structure/classes/resolvers/Resolver$ReadMode;Ljava/lang/String;)V", "allBundleNameSet", "Lcom/jetbrains/plugin/structure/classes/resolvers/ResourceBundleNameSet;", "getAllBundleNameSet", "()Lcom/jetbrains/plugin/structure/classes/resolvers/ResourceBundleNameSet;", "allClassNames", "", "", "Lcom/jetbrains/plugin/structure/base/BinaryClassName;", "getAllClassNames", "()Ljava/util/Set;", "allClasses", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "getAllClasses$annotations", "()V", "getAllClasses", "()Ljava/util/HashSet;", "allPackages", "", "getAllPackages$annotations", "getAllPackages", "baseBundleNameToResolvers", "", "", "fullBundleNames", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "getName", "()Ljava/lang/String;", "packageToResolvers", "packages", "getPackages", "getReadMode", "()Lcom/jetbrains/plugin/structure/classes/resolvers/Resolver$ReadMode;", "buildIndex", "", "close", "containsClass", "", "className", "containsPackage", "packageName", "getPackageName", "processAllClasses", "processor", "Lkotlin/Function1;", "Lcom/jetbrains/plugin/structure/classes/resolvers/ResolutionResult;", "Lorg/objectweb/asm/tree/ClassNode;", "resolveClass", "resolveExactPropertyResourceBundle", "Ljava/util/PropertyResourceBundle;", "baseName", "locale", "Ljava/util/Locale;", "toString", "Companion", "structure-classes"})
@SourceDebugExtension(value={"SMAP\nCompositeResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CompositeResolver.kt\ncom/jetbrains/plugin/structure/classes/resolvers/CompositeResolver\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,147:1\n372#2,7:148\n372#2,7:155\n372#2,7:162\n1446#3,5:169\n1446#3,5:174\n1446#3,5:179\n1726#3,3:184\n1747#3,3:187\n*E\n*S KotlinDebug\n*F\n+ 1 CompositeResolver.kt\ncom/jetbrains/plugin/structure/classes/resolvers/CompositeResolver\n*L\n37#1,7:148\n42#1,7:155\n46#1,7:162\n54#1,5:169\n57#1,5:174\n67#1,5:179\n70#1,3:184\n78#1,3:187\n*E\n"})
public final class CompositeResolver
extends NamedResolver {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<Resolver> resolvers;
    @NotNull
    private final Resolver.ReadMode readMode;
    @NotNull
    private final String name;
    @NotNull
    private final Map<String, List<Resolver>> packageToResolvers;
    @NotNull
    private final HashMap<String, Set<String>> fullBundleNames;
    @NotNull
    private final Map<String, List<Resolver>> baseBundleNameToResolvers;

    private CompositeResolver(List<? extends Resolver> resolvers, Resolver.ReadMode readMode, String name) {
        super(name);
        this.resolvers = resolvers;
        this.readMode = readMode;
        this.name = name;
        this.packageToResolvers = new HashMap();
        this.fullBundleNames = new HashMap();
        this.baseBundleNameToResolvers = new HashMap();
        this.buildIndex();
    }

    @Override
    @NotNull
    public Resolver.ReadMode getReadMode() {
        return this.readMode;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    private final void buildIndex() {
        for (Resolver resolver : this.resolvers) {
            for (String packageName : resolver.getAllPackages()) {
                List list;
                Map<String, List<Resolver>> $this$getOrPut$iv = this.packageToResolvers;
                boolean $i$f$getOrPut = false;
                List value$iv = $this$getOrPut$iv.get(packageName);
                if (value$iv == null) {
                    boolean bl = false;
                    List answer$iv = new ArrayList();
                    $this$getOrPut$iv.put(packageName, answer$iv);
                    list = answer$iv;
                } else {
                    list = value$iv;
                }
                ((Collection)list).add(resolver);
            }
            ResourceBundleNameSet bundleNameSet = resolver.getAllBundleNameSet();
            for (String baseBundleName : bundleNameSet.getBaseBundleNames()) {
                Object object;
                List list;
                Map<String, List<Resolver>> $this$getOrPut$iv = this.baseBundleNameToResolvers;
                boolean $i$f$getOrPut = false;
                List value$iv = $this$getOrPut$iv.get(baseBundleName);
                if (value$iv == null) {
                    boolean bl = false;
                    List answer$iv = new ArrayList();
                    $this$getOrPut$iv.put(baseBundleName, answer$iv);
                    list = answer$iv;
                } else {
                    list = value$iv;
                }
                ((Collection)list).add(resolver);
                Set<String> resolverAllNames = bundleNameSet.get(baseBundleName);
                if (!(!((Collection)resolverAllNames).isEmpty())) continue;
                Map $this$getOrPut$iv2 = this.fullBundleNames;
                boolean $i$f$getOrPut2 = false;
                Object value$iv2 = $this$getOrPut$iv2.get(baseBundleName);
                if (value$iv2 == null) {
                    boolean bl = false;
                    Set answer$iv = new HashSet();
                    $this$getOrPut$iv2.put(baseBundleName, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv2;
                }
                CollectionsKt.addAll((Collection)object, (Iterable)resolverAllNames);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public HashSet<String> getAllClasses() {
        void var2_2;
        void $this$flatMapTo$iv;
        Iterable iterable = this.resolvers;
        Collection destination$iv = new HashSet();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv : $this$flatMapTo$iv) {
            Resolver it = (Resolver)element$iv;
            boolean bl = false;
            Iterable list$iv = it.getAllClasses();
            CollectionsKt.addAll(destination$iv, list$iv);
        }
        return (HashSet)var2_2;
    }

    @Deprecated(message="Use 'allClassNames' property instead which is more efficient")
    public static /* synthetic */ void getAllClasses$annotations() {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Set<CharSequence> getAllClassNames() {
        void var2_2;
        void $this$flatMapTo$iv;
        Iterable iterable = this.resolvers;
        Collection destination$iv = BinaryClassesKt.binaryClassNames();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv : $this$flatMapTo$iv) {
            Resolver it = (Resolver)element$iv;
            boolean bl = false;
            Iterable list$iv = it.getAllClassNames();
            CollectionsKt.addAll(destination$iv, list$iv);
        }
        return (Set)var2_2;
    }

    @Override
    @NotNull
    public ResourceBundleNameSet getAllBundleNameSet() {
        return new ResourceBundleNameSet((Map<String, ? extends Set<String>>)this.fullBundleNames);
    }

    @Override
    @NotNull
    public Set<String> getAllPackages() {
        return this.packageToResolvers.keySet();
    }

    @Deprecated(message="Use 'packages' property instead. This property may be slow on some file systems.")
    public static /* synthetic */ void getAllPackages$annotations() {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Set<String> getPackages() {
        void var2_2;
        void $this$flatMapTo$iv;
        Iterable iterable = this.resolvers;
        Collection destination$iv = new HashSet();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv : $this$flatMapTo$iv) {
            Resolver it = (Resolver)element$iv;
            boolean bl = false;
            Iterable list$iv = it.getPackages();
            CollectionsKt.addAll(destination$iv, list$iv);
        }
        return (Set)var2_2;
    }

    @Override
    public boolean processAllClasses(@NotNull Function1<? super ResolutionResult<? extends ClassNode>, Boolean> processor) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter(processor, "processor");
            Iterable $this$all$iv = this.resolvers;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    Resolver it = (Resolver)element$iv;
                    boolean bl2 = false;
                    if (it.processAllClasses(processor)) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    private final String getPackageName(String className) {
        return StringsKt.substringBeforeLast(className, '/', "");
    }

    @Override
    @Deprecated(message="Use 'containsClass(BinaryClassName)' instead")
    public boolean containsClass(@NotNull String className) {
        boolean bl;
        block4: {
            Intrinsics.checkNotNullParameter(className, "className");
            String packageName = this.getPackageName(className);
            List<Resolver> list = this.packageToResolvers.get(packageName);
            if (list == null) {
                list = CollectionsKt.emptyList();
            }
            List<Resolver> resolvers = list;
            Iterable $this$any$iv = resolvers;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Resolver it = (Resolver)element$iv;
                    boolean bl2 = false;
                    if (!it.containsClass(className)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    @Override
    public boolean containsClass(@NotNull CharSequence className) {
        Intrinsics.checkNotNullParameter(className, "className");
        return this.containsClass(((Object)className).toString());
    }

    @Override
    public boolean containsPackage(@NotNull String packageName) {
        Intrinsics.checkNotNullParameter(packageName, "packageName");
        return this.packageToResolvers.containsKey(packageName);
    }

    @Override
    @Deprecated(message="Use 'resolveClass(BinaryClassName)' instead")
    @NotNull
    public ResolutionResult<ClassNode> resolveClass(@NotNull String className) {
        Intrinsics.checkNotNullParameter(className, "className");
        String packageName = this.getPackageName(className);
        List<Resolver> list = this.packageToResolvers.get(packageName);
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        List<Resolver> resolvers = list;
        for (Resolver resolver : resolvers) {
            ResolutionResult<ClassNode> resolutionResult = resolver.resolveClass(className);
            if (resolutionResult instanceof ResolutionResult.NotFound) continue;
            return resolutionResult;
        }
        return ResolutionResult.NotFound.INSTANCE;
    }

    @Override
    @NotNull
    public ResolutionResult<ClassNode> resolveClass(@NotNull CharSequence className) {
        Intrinsics.checkNotNullParameter(className, "className");
        return this.resolveClass(((Object)className).toString());
    }

    @Override
    @NotNull
    public ResolutionResult<PropertyResourceBundle> resolveExactPropertyResourceBundle(@NotNull String baseName, @NotNull Locale locale) {
        Intrinsics.checkNotNullParameter(baseName, "baseName");
        Intrinsics.checkNotNullParameter(locale, "locale");
        List<Resolver> list = this.baseBundleNameToResolvers.get(baseName);
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        List<Resolver> resolvers = list;
        for (Resolver resolver : resolvers) {
            ResolutionResult<PropertyResourceBundle> resolutionResult = resolver.resolveExactPropertyResourceBundle(baseName, locale);
            if (resolutionResult instanceof ResolutionResult.NotFound) continue;
            return resolutionResult;
        }
        return ResolutionResult.NotFound.INSTANCE;
    }

    @Override
    public void close() {
        LanguageUtilsKt.closeAll(this.resolvers);
    }

    @NotNull
    public String toString() {
        return this.getName() + " is a union of " + this.resolvers.size() + " resolver" + (this.resolvers.size() != 1 ? "s" : "");
    }

    @JvmStatic
    @NotNull
    public static final Resolver create(Resolver ... resolvers) {
        return Companion.create(resolvers);
    }

    @JvmStatic
    @NotNull
    public static final Resolver create(@NotNull Iterable<? extends Resolver> resolvers) {
        return Companion.create(resolvers);
    }

    @JvmStatic
    @NotNull
    public static final NamedResolver create(@NotNull Iterable<? extends Resolver> resolvers, @NotNull String resolverName) {
        return Companion.create(resolvers, resolverName);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J!\u0010\u0003\u001a\u00020\u00042\u0012\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0006\"\u00020\u0004H\u0007\u00a2\u0006\u0002\u0010\u0007J\u0016\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\bH\u0007J\u001e\u0010\u0003\u001a\u00020\t2\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\b2\u0006\u0010\n\u001a\u00020\u000bH\u0007\u00a8\u0006\f"}, d2={"Lcom/jetbrains/plugin/structure/classes/resolvers/CompositeResolver$Companion;", "", "()V", "create", "Lcom/jetbrains/plugin/structure/classes/resolvers/Resolver;", "resolvers", "", "([Lcom/jetbrains/plugin/structure/classes/resolvers/Resolver;)Lcom/jetbrains/plugin/structure/classes/resolvers/Resolver;", "", "Lcom/jetbrains/plugin/structure/classes/resolvers/NamedResolver;", "resolverName", "", "structure-classes"})
    @SourceDebugExtension(value={"SMAP\nCompositeResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CompositeResolver.kt\ncom/jetbrains/plugin/structure/classes/resolvers/CompositeResolver$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,147:1\n1726#2,3:148\n*E\n*S KotlinDebug\n*F\n+ 1 CompositeResolver.kt\ncom/jetbrains/plugin/structure/classes/resolvers/CompositeResolver$Companion\n*L\n136#1,3:148\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final Resolver create(Resolver ... resolvers) {
            Intrinsics.checkNotNullParameter(resolvers, "resolvers");
            return this.create(ArraysKt.asIterable(resolvers));
        }

        @JvmStatic
        @NotNull
        public final Resolver create(@NotNull Iterable<? extends Resolver> resolvers) {
            Intrinsics.checkNotNullParameter(resolvers, "resolvers");
            return this.create(resolvers, "Unnamed Composite Resolver");
        }

        /*
         * Enabled aggressive block sorting
         */
        @JvmStatic
        @NotNull
        public final NamedResolver create(@NotNull Iterable<? extends Resolver> resolvers, @NotNull String resolverName) {
            boolean bl;
            NamedResolver namedResolver;
            List<? extends Resolver> list;
            block7: {
                Intrinsics.checkNotNullParameter(resolvers, "resolvers");
                Intrinsics.checkNotNullParameter(resolverName, "resolverName");
                list = CollectionsKt.toList(resolvers);
                switch (list.size()) {
                    case 0: {
                        namedResolver = new EmptyResolver(resolverName);
                        return namedResolver;
                    }
                    case 1: {
                        namedResolver = new SimpleCompositeResolver<Resolver>(list, CollectionsKt.first(list).getReadMode(), resolverName);
                        return namedResolver;
                    }
                }
                Iterable $this$all$iv = list;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        Resolver it = (Resolver)element$iv;
                        boolean bl2 = false;
                        if (it.getReadMode() == Resolver.ReadMode.FULL) continue;
                        bl = false;
                        break block7;
                    }
                    bl = true;
                }
            }
            Resolver.ReadMode readMode = bl ? Resolver.ReadMode.FULL : Resolver.ReadMode.SIGNATURES;
            namedResolver = new SimpleCompositeResolver<Resolver>(list, readMode, resolverName);
            return namedResolver;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

