/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.base.zip;

import com.jetbrains.plugin.structure.base.zip.MalformedZipArchiveException;
import com.jetbrains.plugin.structure.base.zip.ZipArchiveException;
import com.jetbrains.plugin.structure.base.zip.ZipArchiveIOException;
import com.jetbrains.plugin.structure.base.zip.ZipFileHolder;
import com.jetbrains.plugin.structure.base.zip.ZipHandler;
import com.jetbrains.plugin.structure.base.zip.ZipResource;
import java.io.File;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000  2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001 B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B\r\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u001a\u0010\u0010\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\u0011H\u0002J9\u0010\u0012\u001a\u0004\u0018\u0001H\u0013\"\u0004\b\u0000\u0010\u00132\u0006\u0010\u000e\u001a\u00020\u000f2\u001a\u0010\u0014\u001a\u0016\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u0002\u0012\u0006\u0012\u0004\u0018\u0001H\u00130\u0015H\u0016\u00a2\u0006\u0002\u0010\u0017J0\u0010\u0018\u001a\b\u0012\u0004\u0012\u0002H\u00130\u0019\"\u0004\b\u0000\u0010\u00132\u001a\u0010\u0014\u001a\u0016\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u0002\u0012\u0006\u0012\u0004\u0018\u0001H\u00130\u0015H\u0016J(\u0010\u001a\u001a\u0002H\u001b\"\u0004\b\u0000\u0010\u001b2\u0012\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u0002H\u001b0\u001dH\u0082\b\u00a2\u0006\u0002\u0010\u001fR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/jetbrains/plugin/structure/base/zip/ZipFileHandler;", "Lcom/jetbrains/plugin/structure/base/zip/ZipHandler;", "Lcom/jetbrains/plugin/structure/base/zip/ZipResource$ZipFileResource;", "zipPath", "Ljava/nio/file/Path;", "(Ljava/nio/file/Path;)V", "zipFile", "Ljava/io/File;", "(Ljava/io/File;)V", "zipFileHolderRef", "Ljava/lang/ref/Reference;", "Lcom/jetbrains/plugin/structure/base/zip/ZipFileHolder;", "containsEntry", "", "entryName", "", "getActiveHolder", "Lkotlin/Pair;", "handleEntry", "T", "handler", "Lkotlin/Function2;", "Ljava/util/zip/ZipEntry;", "(Ljava/lang/CharSequence;Lkotlin/jvm/functions/Function2;)Ljava/lang/Object;", "iterate", "", "withZip", "R", "block", "Lkotlin/Function1;", "Ljava/util/zip/ZipFile;", "(Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "Companion", "structure-base"})
@SourceDebugExtension(value={"SMAP\nZipFileHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ZipFileHandler.kt\ncom/jetbrains/plugin/structure/base/zip/ZipFileHandler\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,147:1\n99#1,3:148\n106#1,14:152\n99#1,21:166\n99#1,21:187\n1#2:151\n*E\n*S KotlinDebug\n*F\n+ 1 ZipFileHandler.kt\ncom/jetbrains/plugin/structure/base/zip/ZipFileHandler\n*L\n24#1,3:148\n24#1,14:152\n38#1,21:166\n45#1,21:187\n*E\n"})
public final class ZipFileHandler
implements ZipHandler<ZipResource.ZipFileResource> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final File zipFile;
    @Nullable
    private Reference<ZipFileHolder> zipFileHolderRef;
    private static final String refType = System.getProperty("intellij.structure.zip.handler.references", "weak");

    public ZipFileHandler(@NotNull File zipFile) {
        Intrinsics.checkNotNullParameter(zipFile, "zipFile");
        this.zipFile = zipFile;
    }

    public ZipFileHandler(@NotNull Path zipPath) {
        Intrinsics.checkNotNullParameter(zipPath, "zipPath");
        File file = zipPath.toFile();
        Intrinsics.checkNotNullExpressionValue(file, "zipPath.toFile()");
        this(file);
    }

    @Override
    @NotNull
    public <T> List<T> iterate(@NotNull Function2<? super ZipEntry, ? super ZipResource.ZipFileResource, ? extends T> handler) throws ZipArchiveException {
        Intrinsics.checkNotNullParameter(handler, "handler");
        List results = new ArrayList();
        ZipFileHandler this_$iv = this;
        boolean $i$f$withZip = false;
        try {
            ZipFileHolder holder2$iv;
            Object object = this_$iv.getActiveHolder();
            ZipFileHolder holder$iv = ((Pair)object).component1();
            Reference<ZipFileHolder> ref$iv = ((Pair)object).component2();
            ZipFile zip2 = holder$iv.getZipFile();
            boolean bl = false;
            Enumeration<? extends ZipEntry> entries = zip2.entries();
            ZipResource.ZipFileResource zipResource = new ZipResource.ZipFileResource(zip2);
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if (entry == null) continue;
                ZipEntry it = entry;
                boolean bl2 = false;
                T t2 = handler.invoke(entry, zipResource);
                if (t2 == null) continue;
                it = t2;
                boolean bl3 = false;
                ((Collection)results).add(it);
            }
            Unit result$iv = Unit.INSTANCE;
            if (ref$iv != this_$iv.zipFileHolderRef) {
                throw new IllegalStateException("Reference to ZipFileHolder was changed mid-execution");
            }
            Reference<ZipFileHolder> reference = this_$iv.zipFileHolderRef;
            ZipFileHolder zipFileHolder = holder2$iv = reference != null ? reference.get() : null;
            if (holder2$iv != holder$iv) {
                throw new IllegalStateException("ZipFileHolder was changed mid-execution");
            }
            object = result$iv;
        }
        catch (ZipException e$iv) {
            throw new MalformedZipArchiveException(this_$iv.zipFile, (Throwable)e$iv);
        }
        catch (IOException e$iv) {
            throw new ZipArchiveIOException(this_$iv.zipFile, (Throwable)e$iv);
        }
        return results;
    }

    @Override
    @Nullable
    public <T> T handleEntry(@NotNull CharSequence entryName, @NotNull Function2<? super ZipEntry, ? super ZipResource.ZipFileResource, ? extends T> handler) throws ZipArchiveException {
        Pair<ZipFileHolder, Reference<ZipFileHolder>> pair;
        Intrinsics.checkNotNullParameter(entryName, "entryName");
        Intrinsics.checkNotNullParameter(handler, "handler");
        ZipFileHandler this_$iv = this;
        boolean $i$f$withZip = false;
        try {
            ZipFileHolder holder2$iv;
            Object result$iv;
            Object v1;
            ZipEntry entry;
            pair = this_$iv.getActiveHolder();
            ZipFileHolder holder$iv = pair.component1();
            Reference<ZipFileHolder> ref$iv = pair.component2();
            ZipFile zip2 = holder$iv.getZipFile();
            boolean bl = false;
            ZipResource.ZipFileResource zipResource = new ZipResource.ZipFileResource(zip2);
            ZipEntry zipEntry = entry = zip2.getEntry(((Object)entryName).toString());
            if (zipEntry != null) {
                ZipEntry it = zipEntry;
                boolean bl2 = false;
                v1 = handler.invoke(entry, zipResource);
            } else {
                v1 = result$iv = null;
            }
            if (ref$iv != this_$iv.zipFileHolderRef) {
                throw new IllegalStateException("Reference to ZipFileHolder was changed mid-execution");
            }
            Reference<ZipFileHolder> reference = this_$iv.zipFileHolderRef;
            ZipFileHolder zipFileHolder = holder2$iv = reference != null ? reference.get() : null;
            if (holder2$iv != holder$iv) {
                throw new IllegalStateException("ZipFileHolder was changed mid-execution");
            }
            pair = result$iv;
        }
        catch (ZipException e$iv) {
            throw new MalformedZipArchiveException(this_$iv.zipFile, (Throwable)e$iv);
        }
        catch (IOException e$iv) {
            throw new ZipArchiveIOException(this_$iv.zipFile, (Throwable)e$iv);
        }
        return (T)pair;
    }

    @Override
    public boolean containsEntry(@NotNull CharSequence entryName) {
        boolean bl;
        Intrinsics.checkNotNullParameter(entryName, "entryName");
        ZipFileHandler this_$iv = this;
        boolean $i$f$withZip = false;
        try {
            ZipFileHolder holder2$iv;
            boolean result$iv;
            Pair<ZipFileHolder, Reference<ZipFileHolder>> pair = this_$iv.getActiveHolder();
            ZipFileHolder holder$iv = pair.component1();
            Reference<ZipFileHolder> ref$iv = pair.component2();
            ZipFile zip2 = holder$iv.getZipFile();
            boolean bl2 = false;
            boolean bl3 = result$iv = zip2.getEntry(((Object)entryName).toString()) != null;
            if (ref$iv != this_$iv.zipFileHolderRef) {
                throw new IllegalStateException("Reference to ZipFileHolder was changed mid-execution");
            }
            Reference<ZipFileHolder> reference = this_$iv.zipFileHolderRef;
            ZipFileHolder zipFileHolder = holder2$iv = reference != null ? reference.get() : null;
            if (holder2$iv != holder$iv) {
                throw new IllegalStateException("ZipFileHolder was changed mid-execution");
            }
            bl = result$iv;
        }
        catch (ZipException e$iv) {
            throw new MalformedZipArchiveException(this_$iv.zipFile, (Throwable)e$iv);
        }
        catch (IOException e$iv) {
            throw new ZipArchiveIOException(this_$iv.zipFile, (Throwable)e$iv);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Pair<ZipFileHolder, Reference<ZipFileHolder>> getActiveHolder() throws ZipException, IOException {
        Pair<Object, Object> $i$a$-synchronized-ZipFileHandler$getActiveHolder$32;
        ZipFileHandler zipFileHandler = this;
        synchronized (zipFileHandler) {
            boolean $i$a$-synchronized-ZipFileHandler$getActiveHolder$32 = false;
            Reference<ZipFileHolder> ref = this.zipFileHolderRef;
            $i$a$-synchronized-ZipFileHandler$getActiveHolder$32 = ref == null ? TuplesKt.to(null, null) : TuplesKt.to(ref.get(), ref);
        }
        Pair<Object, Object> pair = $i$a$-synchronized-ZipFileHandler$getActiveHolder$32;
        ZipFileHolder holder = (ZipFileHolder)pair.component1();
        Reference ref = (Reference)pair.component2();
        if (holder != null) {
            Reference reference = ref;
            Intrinsics.checkNotNull(reference);
            return TuplesKt.to(holder, reference);
        }
        ZipFileHandler zipFileHandler2 = this;
        synchronized (zipFileHandler2) {
            ZipFileHolder holder2;
            Reference ref2;
            block8: {
                boolean bl = false;
                Reference reference = ref2 = this.zipFileHolderRef;
                ZipFileHolder zipFileHolder = holder2 = reference != null ? reference.get() : null;
                if (holder2 == null) break block8;
                Reference reference2 = ref2;
                Intrinsics.checkNotNull(reference2);
                Pair<ZipFileHolder, Reference<ZipFileHolder>> pair2 = TuplesKt.to(holder2, reference2);
                return pair2;
            }
            holder2 = new ZipFileHolder(new ZipFile(this.zipFile));
            this.zipFileHolderRef = ref2 = ZipFileHandler.Companion.createReference(holder2);
            Pair<ZipFileHolder, Reference<ZipFileHolder>> pair3 = TuplesKt.to(holder2, ref2);
            return pair3;
        }
    }

    private final <R> R withZip(Function1<? super ZipFile, ? extends R> block) {
        Pair<ZipFileHolder, Reference<ZipFileHolder>> pair;
        boolean $i$f$withZip = false;
        try {
            ZipFileHolder holder2;
            pair = this.getActiveHolder();
            ZipFileHolder holder = pair.component1();
            Reference<ZipFileHolder> ref = pair.component2();
            R result2 = block.invoke(holder.getZipFile());
            if (ref != this.zipFileHolderRef) {
                throw new IllegalStateException("Reference to ZipFileHolder was changed mid-execution");
            }
            Reference<ZipFileHolder> reference = this.zipFileHolderRef;
            ZipFileHolder zipFileHolder = holder2 = reference != null ? reference.get() : null;
            if (holder2 != holder) {
                throw new IllegalStateException("ZipFileHolder was changed mid-execution");
            }
            pair = result2;
        }
        catch (ZipException e) {
            throw new MalformedZipArchiveException(this.zipFile, (Throwable)e);
        }
        catch (IOException e) {
            throw new ZipArchiveIOException(this.zipFile, (Throwable)e);
        }
        return (R)pair;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\bH\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/jetbrains/plugin/structure/base/zip/ZipFileHandler$Companion;", "", "()V", "refType", "", "kotlin.jvm.PlatformType", "createReference", "Ljava/lang/ref/Reference;", "Lcom/jetbrains/plugin/structure/base/zip/ZipFileHolder;", "holder", "structure-base"})
    public static final class Companion {
        private Companion() {
        }

        private final Reference<ZipFileHolder> createReference(ZipFileHolder holder) {
            String string = refType;
            return Intrinsics.areEqual(string, "weak") ? (Reference)new WeakReference<ZipFileHolder>(holder) : (Intrinsics.areEqual(string, "soft") ? (Reference)new SoftReference<ZipFileHolder>(holder) : (Reference)new WeakReference<ZipFileHolder>(holder));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

