/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.base.utils.trie;

import com.jetbrains.plugin.structure.base.utils.trie.Trie;
import com.jetbrains.plugin.structure.base.utils.trie.TrieTraversals;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\t\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0012B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\"\u0004\b\u0000\u0010\u0006*\b\u0012\u0004\u0012\u0002H\u00060\u0007J\u001c\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\"\u0004\b\u0000\u0010\u0006*\b\u0012\u0004\u0012\u0002H\u00060\u0007J\u0018\u0010\t\u001a\u00020\n\"\u0004\b\u0000\u0010\u0006*\b\u0012\u0004\u0012\u0002H\u00060\u0007H\u0007J\u0018\u0010\u000b\u001a\u00020\n\"\u0004\b\u0000\u0010\u0006*\b\u0012\u0004\u0012\u0002H\u00060\u0007H\u0007J%\u0010\f\u001a\u00020\n\"\u0004\b\u0000\u0010\u0006*\b\u0012\u0004\u0012\u0002H\u00060\u00072\u0006\u0010\r\u001a\u0002H\u0006H\u0007\u00a2\u0006\u0002\u0010\u000eJ\u001c\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\"\u0004\b\u0000\u0010\u0006*\b\u0012\u0004\u0012\u0002H\u00060\u0007J+\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\"\u0004\b\u0000\u0010\u0006*\b\u0012\u0004\u0012\u0002H\u00060\u00072\b\u0010\r\u001a\u0004\u0018\u0001H\u0006\u00a2\u0006\u0002\u0010\u0011\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/plugin/structure/base/utils/trie/TrieTraversals;", "", "()V", "getAllNodes", "", "", "V", "Lcom/jetbrains/plugin/structure/base/utils/trie/Trie;", "getInsertions", "leafCount", "", "nodeCount", "valueCount", "expectedValue", "(Lcom/jetbrains/plugin/structure/base/utils/trie/Trie;Ljava/lang/Object;)I", "withNonNullValues", "withValue", "(Lcom/jetbrains/plugin/structure/base/utils/trie/Trie;Ljava/lang/Object;)Ljava/util/Set;", "Leaves", "structure-base"})
public final class TrieTraversals {
    @NotNull
    public static final TrieTraversals INSTANCE = new TrieTraversals();

    private TrieTraversals() {
    }

    @TestOnly
    public final <V> int leafCount(@NotNull Trie<V> $this$leafCount) {
        Intrinsics.checkNotNullParameter($this$leafCount, "<this>");
        return CollectionsKt.sumOfInt($this$leafCount.visit(leafCount.1.INSTANCE));
    }

    @TestOnly
    public final <V> int nodeCount(@NotNull Trie<V> $this$nodeCount) {
        Intrinsics.checkNotNullParameter($this$nodeCount, "<this>");
        return CollectionsKt.sumOfInt($this$nodeCount.visit(nodeCount.1.INSTANCE));
    }

    @TestOnly
    public final <V> int valueCount(@NotNull Trie<V> $this$valueCount, V expectedValue) {
        Intrinsics.checkNotNullParameter($this$valueCount, "<this>");
        return CollectionsKt.sumOfInt($this$valueCount.visit(new Trie.NodeVisitor(expectedValue){
            final /* synthetic */ V $expectedValue;
            {
                this.$expectedValue = $expectedValue;
            }

            @NotNull
            public final Integer visit(@NotNull CharSequence charSequence, @Nullable V value, boolean bl, boolean bl2) {
                Intrinsics.checkNotNullParameter(charSequence, "<anonymous parameter 0>");
                return Intrinsics.areEqual(this.$expectedValue, value) ? 1 : 0;
            }
        }));
    }

    @NotNull
    public final <V> Set<String> withNonNullValues(@NotNull Trie<V> $this$withNonNullValues) {
        Intrinsics.checkNotNullParameter($this$withNonNullValues, "<this>");
        return (Set)CollectionsKt.filterNotNullTo($this$withNonNullValues.visit(withNonNullValues.1.INSTANCE), (Collection)new LinkedHashSet());
    }

    @NotNull
    public final <V> Set<String> withValue(@NotNull Trie<V> $this$withValue, @Nullable V expectedValue) {
        Intrinsics.checkNotNullParameter($this$withValue, "<this>");
        return (Set)CollectionsKt.filterNotNullTo($this$withValue.visit(new Trie.NodeVisitor(expectedValue){
            final /* synthetic */ V $expectedValue;
            {
                this.$expectedValue = $expectedValue;
            }

            @Nullable
            public final String visit(@NotNull CharSequence prefix, @Nullable V value, boolean bl, boolean bl2) {
                Intrinsics.checkNotNullParameter(prefix, "prefix");
                CharSequence charSequence = prefix;
                V v = this.$expectedValue;
                CharSequence it = charSequence;
                boolean bl3 = false;
                CharSequence charSequence2 = Intrinsics.areEqual(value, v) ? charSequence : null;
                return charSequence2 != null ? ((Object)charSequence2).toString() : null;
            }
        }), (Collection)new LinkedHashSet());
    }

    @NotNull
    public final <V> Set<String> getInsertions(@NotNull Trie<V> $this$getInsertions) {
        Set set;
        Intrinsics.checkNotNullParameter($this$getInsertions, "<this>");
        Set $this$getInsertions_u24lambda_u240 = set = (Set)new LinkedHashSet();
        boolean bl = false;
        $this$getInsertions.visit(new Trie.NodeVisitor($this$getInsertions_u24lambda_u240){
            final /* synthetic */ Set<String> $this_apply;
            {
                this.$this_apply = $receiver;
            }

            public final void visit(@NotNull CharSequence prefix, @Nullable V v, boolean bl, boolean isTerminal) {
                Intrinsics.checkNotNullParameter(prefix, "prefix");
                if (isTerminal) {
                    this.$this_apply.add(((Object)prefix).toString());
                }
            }
        });
        return set;
    }

    @NotNull
    public final <V> Set<String> getAllNodes(@NotNull Trie<V> $this$getAllNodes) {
        Intrinsics.checkNotNullParameter($this$getAllNodes, "<this>");
        Set results = new LinkedHashSet();
        $this$getAllNodes.visit(new Trie.NodeVisitor(results){
            final /* synthetic */ Set<String> $results;
            {
                this.$results = $results;
            }

            public final void visit(@NotNull CharSequence prefix, @Nullable V v, boolean bl, boolean isTerminal) {
                Intrinsics.checkNotNullParameter(prefix, "prefix");
                if (isTerminal || prefix.length() > 0) {
                    this.$results.add(((Object)prefix).toString());
                }
            }
        });
        return results;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0010\r\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000*\u0004\b\u0000\u0010\u00012\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u00020\u00030\u0002B\u0005\u00a2\u0006\u0002\u0010\u0004J/\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u00072\b\u0010\f\u001a\u0004\u0018\u00018\u00002\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0016\u00a2\u0006\u0002\u0010\u0010R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/plugin/structure/base/utils/trie/TrieTraversals$Leaves;", "V", "Lcom/jetbrains/plugin/structure/base/utils/trie/Trie$NodeVisitor;", "", "()V", "result", "", "", "getResult", "()Ljava/util/Set;", "visit", "word", "value", "isLeaf", "", "isTerminal", "(Ljava/lang/CharSequence;Ljava/lang/Object;ZZ)V", "structure-base"})
    public static final class Leaves<V>
    implements Trie.NodeVisitor<V, Unit> {
        @NotNull
        private final Set<CharSequence> result = new LinkedHashSet();

        @NotNull
        public final Set<CharSequence> getResult() {
            return this.result;
        }

        @Override
        public void visit(@NotNull CharSequence word, @Nullable V value, boolean isLeaf, boolean isTerminal) {
            Intrinsics.checkNotNullParameter(word, "word");
            if (isLeaf) {
                ((Collection)this.result).add(((Object)word).toString());
            }
        }
    }
}

