/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.base.utils.trie;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\r\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0004\u0018\u0000 !*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0003!\"#B\u0005\u00a2\u0006\u0002\u0010\u0003J\u000e\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00000\bH\u0002J\u0018\u0010\u000f\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0015\u0010\u0010\u001a\u0004\u0018\u00018\u00002\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u0011J\u001f\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\r2\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0002\u0010\u0015JJ\u0010\u0016\u001a\u00020\u0017\"\u0004\b\u0001\u0010\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00028\u00000\b2\n\u0010\f\u001a\u00060\u001aj\u0002`\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u0002H\u00180\u001d2\u0012\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u0002H\u00180\u001fH\u0002J&\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\u00180 \"\u0004\b\u0001\u0010\u00182\u0012\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u0002H\u00180\u001fR\u0011\u0010\u0004\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0006R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\t\u001a\u00020\u0005*\b\u0012\u0004\u0012\u00028\u00000\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006$"}, d2={"Lcom/jetbrains/plugin/structure/base/utils/trie/Trie;", "V", "", "()V", "isEmpty", "", "()Z", "root", "Lcom/jetbrains/plugin/structure/base/utils/trie/Trie$Node;", "isChildless", "(Lcom/jetbrains/plugin/structure/base/utils/trie/Trie$Node;)Z", "contains", "prefix", "", "empty", "findNode", "findValue", "(Ljava/lang/CharSequence;)Ljava/lang/Object;", "insert", "key", "value", "(Ljava/lang/CharSequence;Ljava/lang/Object;)Z", "visit", "", "R", "node", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "result", "", "visitor", "Lcom/jetbrains/plugin/structure/base/utils/trie/Trie$NodeVisitor;", "", "Companion", "Node", "NodeVisitor", "structure-base"})
@SourceDebugExtension(value={"SMAP\nTrie.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Trie.kt\ncom/jetbrains/plugin/structure/base/utils/trie/Trie\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,119:1\n372#2,3:120\n375#2,4:124\n1#3:123\n*E\n*S KotlinDebug\n*F\n+ 1 Trie.kt\ncom/jetbrains/plugin/structure/base/utils/trie/Trie\n*L\n44#1,3:120\n44#1,4:124\n*E\n"})
public final class Trie<V> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Node<V> root = this.empty();

    private final Node<V> empty() {
        return new Node(null, null, null, false, 15, null);
    }

    public final boolean isEmpty() {
        return this.isChildless(this.root) && !this.root.isTerminal();
    }

    private final boolean isChildless(Node<V> $this$isChildless) {
        return $this$isChildless.getChildren().isEmpty();
    }

    public final boolean contains(@NotNull CharSequence prefix) {
        Intrinsics.checkNotNullParameter(prefix, "prefix");
        return this.findNode(prefix) != null;
    }

    @Nullable
    public final V findValue(@NotNull CharSequence prefix) {
        Intrinsics.checkNotNullParameter(prefix, "prefix");
        Node<V> node = this.findNode(prefix);
        return (V)(node != null ? node.getValue() : null);
    }

    private final Node<V> findNode(CharSequence prefix) {
        Node<V> n = this.root;
        for (Pair<Character, String> pair : Companion.split(prefix)) {
            if (!Intrinsics.areEqual(n.getChildrenSeparator(), pair.getFirst())) {
                return null;
            }
            if (n.getChildren().get(pair.getSecond()) != null) continue;
            return null;
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean insert(@NotNull CharSequence key, @Nullable V value) {
        Intrinsics.checkNotNullParameter(key, "key");
        boolean isInserted = false;
        Node currentNode = this.root;
        for (Pair<Character, String> pair : Companion.split(key)) {
            Object object;
            void $this$getOrPut$iv;
            if (this.isChildless(currentNode)) {
                currentNode.setChildrenSeparator(pair.getFirst());
            } else if (!Intrinsics.areEqual(currentNode.getChildrenSeparator(), pair.getFirst())) {
                throw new IllegalArgumentException("Node '" + currentNode + "' has separator '" + currentNode.getChildrenSeparator() + "' but trying to insert child '" + pair.getSecond() + "' with separator '" + pair.getFirst() + "'");
            }
            Map<String, Node<V>> map = currentNode.getChildren();
            String key$iv = pair.getSecond();
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                Node<V> node;
                boolean bl = false;
                Node<V> it = node = this.empty();
                boolean bl2 = false;
                isInserted = true;
                Node<V> answer$iv = node;
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            currentNode = (Node)object;
        }
        currentNode.setValue(value);
        currentNode.setTerminal(true);
        return isInserted;
    }

    public static /* synthetic */ boolean insert$default(Trie trie, CharSequence charSequence, Object object, int n, Object object2) {
        if ((n & 2) != 0) {
            object = null;
        }
        return trie.insert(charSequence, object);
    }

    @NotNull
    public final <R> List<R> visit(@NotNull NodeVisitor<V, R> visitor2) {
        Intrinsics.checkNotNullParameter(visitor2, "visitor");
        if (this.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        List result2 = new ArrayList();
        this.visit(this.root, new StringBuilder(), result2, visitor2);
        return result2;
    }

    private final <R> void visit(Node<V> node, StringBuilder prefix, List<R> result2, NodeVisitor<V, R> visitor2) {
        if (this.isChildless(node)) {
            ((Collection)result2).add(visitor2.visit(prefix, node.getValue(), true, node.isTerminal()));
        } else {
            ((Collection)result2).add(visitor2.visit(prefix, node.getValue(), false, node.isTerminal()));
            for (Map.Entry<String, Node<V>> entry : node.getChildren().entrySet()) {
                String edge = entry.getKey();
                Node<V> child = entry.getValue();
                StringBuilder $this$visit_u24lambda_u242 = prefix;
                boolean bl = false;
                int mark = $this$visit_u24lambda_u242.length();
                if (((CharSequence)$this$visit_u24lambda_u242).length() > 0) {
                    $this$visit_u24lambda_u242.append(node.getChildrenSeparator());
                }
                $this$visit_u24lambda_u242.append(edge);
                this.visit(child, $this$visit_u24lambda_u242, result2, visitor2);
                $this$visit_u24lambda_u242.delete(mark, $this$visit_u24lambda_u242.length());
            }
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\f\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\r\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0006\u0012\u0004\u0012\u00020\u00070\u00050\u00042\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Lcom/jetbrains/plugin/structure/base/utils/trie/Trie$Companion;", "", "()V", "split", "", "Lkotlin/Pair;", "", "", "str", "", "structure-base"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<Pair<Character, String>> split(@NotNull CharSequence str) {
            Intrinsics.checkNotNullParameter(str, "str");
            if (str.length() == 0) {
                return CollectionsKt.emptyList();
            }
            ArrayList<Pair<Character, String>> result2 = new ArrayList<Pair<Character, String>>();
            Character separator = null;
            int i = 0;
            while (str.charAt(i) == '/' || str.charAt(i) == '.' || str.charAt(i) == '$') {
                ++i;
            }
            int startIndex = i;
            while (i < str.length()) {
                char c = str.charAt(i);
                if (c == '/' || c == '.' || c == '$') {
                    if (startIndex != i) {
                        result2.add(new Pair<Character, String>(separator, ((Object)str.subSequence(startIndex, i)).toString()));
                    } else if (startIndex != 0) {
                        ++i;
                        continue;
                    }
                    separator = Character.valueOf(c);
                    startIndex = i + 1;
                }
                ++i;
            }
            if (startIndex < str.length()) {
                result2.add(new Pair<Character, String>(separator, ((Object)str.subSequence(startIndex, str.length())).toString()));
            }
            if (!((Collection)result2).isEmpty()) {
                boolean bl;
                boolean bl2 = bl = ((Pair)CollectionsKt.first((List)result2)).getFirst() == null;
                if (_Assertions.ENABLED && !bl) {
                    String string = "Assertion failed";
                    throw new AssertionError((Object)string);
                }
            }
            return result2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0019\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u0000*\u0004\b\u0001\u0010\u00012\u00020\u0002BC\u0012\u001a\b\u0002\u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u00000\u0004\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00018\u0001\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u001b\u0010\u001b\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u00000\u0004H\u00c6\u0003J\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003\u00a2\u0006\u0002\u0010\u000fJ\u0010\u0010\u001d\u001a\u0004\u0018\u00018\u0001H\u00c6\u0003\u00a2\u0006\u0002\u0010\u0017J\t\u0010\u001e\u001a\u00020\nH\u00c6\u0003JR\u0010\u001f\u001a\b\u0012\u0004\u0012\u00028\u00010\u00002\u001a\b\u0002\u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u00000\u00042\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00018\u00012\b\b\u0002\u0010\t\u001a\u00020\nH\u00c6\u0001\u00a2\u0006\u0002\u0010 J\u0013\u0010!\u001a\u00020\n2\b\u0010\"\u001a\u0004\u0018\u00010\u0002H\u00d6\u0003J\t\u0010#\u001a\u00020$H\u00d6\u0001J\t\u0010%\u001a\u00020\u0005H\u00d6\u0001R#\u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u00000\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001e\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0012\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001e\u0010\b\u001a\u0004\u0018\u00018\u0001X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u001a\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019\u00a8\u0006&"}, d2={"Lcom/jetbrains/plugin/structure/base/utils/trie/Trie$Node;", "V", "", "children", "", "", "childrenSeparator", "", "value", "isTerminal", "", "(Ljava/util/Map;Ljava/lang/Character;Ljava/lang/Object;Z)V", "getChildren", "()Ljava/util/Map;", "getChildrenSeparator", "()Ljava/lang/Character;", "setChildrenSeparator", "(Ljava/lang/Character;)V", "Ljava/lang/Character;", "()Z", "setTerminal", "(Z)V", "getValue", "()Ljava/lang/Object;", "setValue", "(Ljava/lang/Object;)V", "Ljava/lang/Object;", "component1", "component2", "component3", "component4", "copy", "(Ljava/util/Map;Ljava/lang/Character;Ljava/lang/Object;Z)Lcom/jetbrains/plugin/structure/base/utils/trie/Trie$Node;", "equals", "other", "hashCode", "", "toString", "structure-base"})
    private static final class Node<V> {
        @NotNull
        private final Map<String, Node<V>> children;
        @Nullable
        private Character childrenSeparator;
        @Nullable
        private V value;
        private boolean isTerminal;

        public Node(@NotNull Map<String, Node<V>> children, @Nullable Character childrenSeparator, @Nullable V value, boolean isTerminal) {
            Intrinsics.checkNotNullParameter(children, "children");
            this.children = children;
            this.childrenSeparator = childrenSeparator;
            this.value = value;
            this.isTerminal = isTerminal;
        }

        public /* synthetic */ Node(Map map, Character c, Object object, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker2) {
            if ((n & 1) != 0) {
                map = new HashMap();
            }
            if ((n & 2) != 0) {
                c = null;
            }
            if ((n & 4) != 0) {
                object = null;
            }
            if ((n & 8) != 0) {
                bl = false;
            }
            this(map, c, object, bl);
        }

        @NotNull
        public final Map<String, Node<V>> getChildren() {
            return this.children;
        }

        @Nullable
        public final Character getChildrenSeparator() {
            return this.childrenSeparator;
        }

        public final void setChildrenSeparator(@Nullable Character c) {
            this.childrenSeparator = c;
        }

        @Nullable
        public final V getValue() {
            return this.value;
        }

        public final void setValue(@Nullable V v) {
            this.value = v;
        }

        public final boolean isTerminal() {
            return this.isTerminal;
        }

        public final void setTerminal(boolean bl) {
            this.isTerminal = bl;
        }

        @NotNull
        public final Map<String, Node<V>> component1() {
            return this.children;
        }

        @Nullable
        public final Character component2() {
            return this.childrenSeparator;
        }

        @Nullable
        public final V component3() {
            return this.value;
        }

        public final boolean component4() {
            return this.isTerminal;
        }

        @NotNull
        public final Node<V> copy(@NotNull Map<String, Node<V>> children, @Nullable Character childrenSeparator, @Nullable V value, boolean isTerminal) {
            Intrinsics.checkNotNullParameter(children, "children");
            return new Node<V>(children, childrenSeparator, value, isTerminal);
        }

        public static /* synthetic */ Node copy$default(Node node, Map map, Character c, Object object, boolean bl, int n, Object object2) {
            if ((n & 1) != 0) {
                map = node.children;
            }
            if ((n & 2) != 0) {
                c = node.childrenSeparator;
            }
            if ((n & 4) != 0) {
                object = node.value;
            }
            if ((n & 8) != 0) {
                bl = node.isTerminal;
            }
            return node.copy(map, c, object, bl);
        }

        @NotNull
        public String toString() {
            return "Node(children=" + this.children + ", childrenSeparator=" + this.childrenSeparator + ", value=" + this.value + ", isTerminal=" + this.isTerminal + ")";
        }

        public int hashCode() {
            int result2 = ((Object)this.children).hashCode();
            result2 = result2 * 31 + (this.childrenSeparator == null ? 0 : ((Object)this.childrenSeparator).hashCode());
            result2 = result2 * 31 + (this.value == null ? 0 : this.value.hashCode());
            result2 = result2 * 31 + Boolean.hashCode(this.isTerminal);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Node)) {
                return false;
            }
            Node node = (Node)other;
            if (!Intrinsics.areEqual(this.children, node.children)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.childrenSeparator, node.childrenSeparator)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.value, node.value)) {
                return false;
            }
            return this.isTerminal == node.isTerminal;
        }

        public Node() {
            this(null, null, null, false, 15, null);
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u00e6\u0080\u0001\u0018\u0000*\u0004\b\u0001\u0010\u0001*\u0004\b\u0002\u0010\u00022\u00020\u0003J/\u0010\u0004\u001a\u00028\u00022\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00018\u00012\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH&\u00a2\u0006\u0002\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/jetbrains/plugin/structure/base/utils/trie/Trie$NodeVisitor;", "V", "R", "", "visit", "word", "", "value", "isLeaf", "", "isTerminal", "(Ljava/lang/CharSequence;Ljava/lang/Object;ZZ)Ljava/lang/Object;", "structure-base"})
    public static interface NodeVisitor<V, R> {
        public R visit(@NotNull CharSequence var1, @Nullable V var2, boolean var3, boolean var4);
    }
}

