/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.base.utils.charseq;

import com.jetbrains.plugin.structure.base.utils.charseq.SpecialCharSequence;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\f\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0011\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0007H\u0096\u0002J\u0018\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0007H\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/plugin/structure/base/utils/charseq/ConcatenatedCharSequence;", "Lcom/jetbrains/plugin/structure/base/utils/charseq/SpecialCharSequence;", "first", "", "second", "(Ljava/lang/CharSequence;Ljava/lang/CharSequence;)V", "length", "", "getLength", "()I", "get", "", "index", "subSequence", "startIndex", "endIndex", "toString", "", "structure-base"})
public final class ConcatenatedCharSequence
extends SpecialCharSequence {
    @NotNull
    private final CharSequence first;
    @NotNull
    private final CharSequence second;

    public ConcatenatedCharSequence(@NotNull CharSequence first, @NotNull CharSequence second) {
        Intrinsics.checkNotNullParameter(first, "first");
        Intrinsics.checkNotNullParameter(second, "second");
        this.first = first;
        this.second = second;
    }

    @Override
    public int getLength() {
        return this.first.length() + this.second.length();
    }

    @Override
    public char get(int index) {
        if (!(0 <= index ? index < this.length() : false)) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Length: " + this.length());
        }
        return index < this.first.length() ? this.first.charAt(index) : this.second.charAt(index - this.first.length());
    }

    @Override
    @NotNull
    public CharSequence subSequence(int startIndex, int endIndex) {
        CharSequence charSequence;
        if (startIndex < 0 || endIndex > this.length() || startIndex > endIndex) {
            throw new IndexOutOfBoundsException("startIndex: " + startIndex + ", endIndex: " + endIndex + ", Length: " + this.length());
        }
        int firstLen = this.first.length();
        if (endIndex <= firstLen) {
            charSequence = this.first.subSequence(startIndex, endIndex);
        } else if (startIndex >= firstLen) {
            charSequence = this.second.subSequence(startIndex - firstLen, endIndex - firstLen);
        } else {
            CharSequence firstPart = this.first.subSequence(startIndex, firstLen);
            CharSequence secondPart = this.second.subSequence(0, endIndex - firstLen);
            charSequence = new ConcatenatedCharSequence(firstPart, secondPart);
        }
        return charSequence;
    }

    @Override
    @NotNull
    public String toString() {
        return "" + this.first + this.second;
    }
}

