/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.base.utils.charseq;

import com.jetbrains.plugin.structure.base.utils.charseq.SpecialCharSequence;
import java.nio.CharBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0010\f\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\u0011\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\tH\u0096\u0002J\u0018\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\tH\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/plugin/structure/base/utils/charseq/CharReplacingCharSequence;", "Lcom/jetbrains/plugin/structure/base/utils/charseq/SpecialCharSequence;", "characters", "", "oldChar", "", "replacement", "(Ljava/lang/CharSequence;CC)V", "length", "", "getLength", "()I", "get", "index", "subSequence", "startIndex", "endIndex", "toString", "", "structure-base"})
public final class CharReplacingCharSequence
extends SpecialCharSequence {
    @NotNull
    private final CharSequence characters;
    private final char oldChar;
    private final char replacement;

    public CharReplacingCharSequence(@NotNull CharSequence characters, char oldChar, char replacement) {
        Intrinsics.checkNotNullParameter(characters, "characters");
        this.characters = characters;
        this.oldChar = oldChar;
        this.replacement = replacement;
    }

    @Override
    public int getLength() {
        return this.characters.length();
    }

    @Override
    public char get(int index) {
        char c = this.characters.charAt(index);
        if (this.oldChar == this.replacement) {
            return c;
        }
        return c == this.oldChar ? this.replacement : c;
    }

    @Override
    @NotNull
    public CharSequence subSequence(int startIndex, int endIndex) {
        CharSequence subSequence = this.characters.subSequence(startIndex, endIndex);
        if (this.oldChar == this.replacement) {
            return subSequence;
        }
        return new CharReplacingCharSequence(subSequence, this.oldChar, this.replacement);
    }

    @Override
    @NotNull
    public String toString() {
        if (this.oldChar == this.replacement) {
            return ((Object)this.characters).toString();
        }
        CharBuffer newBuf = CharBuffer.allocate(this.length());
        int n = this.length();
        for (int i = 0; i < n; ++i) {
            newBuf.put(i, this.charAt(i));
        }
        String string = newBuf.toString();
        Intrinsics.checkNotNullExpressionValue(string, "newBuf.toString()");
        return string;
    }
}

