/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.base.utils;

import com.jetbrains.plugin.structure.base.utils.Striped;
import java.util.concurrent.locks.Lock;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\b'\u0018\u0000 \n*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0002:\u0002\t\nB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0015\u0010\u0004\u001a\u00028\u00002\u0006\u0010\u0005\u001a\u00020\u0002H&\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH&\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/plugin/structure/base/utils/Striped;", "L", "", "()V", "get", "key", "(Ljava/lang/Object;)Ljava/lang/Object;", "size", "", "CompactStriped", "Companion", "structure-base"})
@ApiStatus.Internal
public abstract class Striped<L> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final int MAX_POWER_OF_TWO = 0x40000000;

    private Striped() {
    }

    @NotNull
    public abstract L get(@NotNull Object var1);

    public abstract int size();

    public /* synthetic */ Striped(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0007\b\u0002\u0018\u0000*\b\b\u0001\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u001b\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\u0015\u0010\r\u001a\u00028\u00012\u0006\u0010\u000e\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010\u000fJ\b\u0010\u0010\u001a\u00020\u0005H\u0016R\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00020\nX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u000e\u0010\f\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/plugin/structure/base/utils/Striped$CompactStriped;", "L", "", "Lcom/jetbrains/plugin/structure/base/utils/Striped;", "stripes", "", "supplier", "Ljava/util/function/Supplier;", "(ILjava/util/function/Supplier;)V", "array", "", "[Ljava/lang/Object;", "mask", "get", "key", "(Ljava/lang/Object;)Ljava/lang/Object;", "size", "structure-base"})
    @SourceDebugExtension(value={"SMAP\nStriped.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Striped.kt\ncom/jetbrains/plugin/structure/base/utils/Striped$CompactStriped\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,114:1\n1#2:115\n*E\n"})
    private static final class CompactStriped<L>
    extends Striped<L> {
        private final int mask;
        @NotNull
        private final Object[] array;

        public CompactStriped(int stripes, @NotNull Supplier<L> supplier) {
            Intrinsics.checkNotNullParameter(supplier, "supplier");
            super(null);
            if (!(stripes > 0)) {
                boolean $i$a$-require-Striped$CompactStriped$32 = false;
                String $i$a$-require-Striped$CompactStriped$32 = "Stripes must be positive";
                throw new IllegalArgumentException($i$a$-require-Striped$CompactStriped$32.toString());
            }
            if (!(stripes <= 0x40000000)) {
                boolean bl = false;
                String string = "Stripes must be <= 2^30)";
                throw new IllegalArgumentException(string.toString());
            }
            this.mask = Companion.ceilToPowerOfTwo(stripes) - 1;
            int n = 0;
            int n2 = this.mask + 1;
            Object[] objectArray = new Object[n2];
            CompactStriped compactStriped = this;
            while (n < n2) {
                int n3 = n++;
                Intrinsics.checkNotNull(supplier.get(), "null cannot be cast to non-null type kotlin.Any");
            }
            compactStriped.array = objectArray;
        }

        @Override
        @NotNull
        public L get(@NotNull Object key) {
            Intrinsics.checkNotNullParameter(key, "key");
            int hash = Companion.smear(key.hashCode());
            int index = hash & this.mask;
            Object object = this.array[index];
            Intrinsics.checkNotNull(object, "null cannot be cast to non-null type L of com.jetbrains.plugin.structure.base.utils.Striped.CompactStriped");
            return (L)object;
        }

        @Override
        public int size() {
            return this.array.length;
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004H\u0002J\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u0004J\u0010\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/jetbrains/plugin/structure/base/utils/Striped$Companion;", "", "()V", "MAX_POWER_OF_TWO", "", "ceilToPowerOfTwo", "x", "lock", "Lcom/jetbrains/plugin/structure/base/utils/Striped;", "Ljava/util/concurrent/locks/Lock;", "stripes", "smear", "hashCode", "structure-base"})
    @SourceDebugExtension(value={"SMAP\nStriped.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Striped.kt\ncom/jetbrains/plugin/structure/base/utils/Striped$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,114:1\n1#2:115\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Striped<Lock> lock(int stripes) {
            return new CompactStriped(stripes, lock.1.INSTANCE);
        }

        private final int ceilToPowerOfTwo(int x) {
            if (!(x > 0)) {
                boolean bl = false;
                String string = "x (" + x + ") must be > 0";
                throw new IllegalArgumentException(string.toString());
            }
            int result2 = 32 - Integer.numberOfLeadingZeros(x - 1);
            return 1 << result2;
        }

        private final int smear(int hashCode2) {
            int hashCode3 = hashCode2;
            hashCode3 ^= hashCode3 >>> 20 ^ hashCode3 >>> 12;
            return hashCode3 ^ hashCode3 >>> 7 ^ hashCode3 >>> 4;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

