/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.base.decompress;

import com.jetbrains.plugin.structure.base.decompress.Decompressor;
import com.jetbrains.plugin.structure.base.decompress.DecompressorException;
import com.jetbrains.plugin.structure.base.decompress.EmptyEntryNameException;
import com.jetbrains.plugin.structure.base.decompress.EntryNameTooLongException;
import com.jetbrains.plugin.structure.base.decompress.InvalidRelativeEntryNameException;
import com.jetbrains.plugin.structure.base.utils.FileUtilKt;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, xi=48, d1={"\u0000\u001c\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004H\u0002\u001a\u001e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u00042\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\bH\u0002\u00a8\u0006\t"}, d2={"getEntryFile", "Ljava/nio/file/Path;", "outputDir", "entry", "Lcom/jetbrains/plugin/structure/base/decompress/Decompressor$Entry;", "normalizePathTraversal", "", "pathElements", "", "structure-base"})
@SourceDebugExtension(value={"SMAP\nDecompressor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Decompressor.kt\ncom/jetbrains/plugin/structure/base/decompress/DecompressorKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,181:1\n766#2:182\n857#2,2:183\n1747#2,3:185\n*E\n*S KotlinDebug\n*F\n+ 1 Decompressor.kt\ncom/jetbrains/plugin/structure/base/decompress/DecompressorKt\n*L\n87#1:182\n87#1,2:183\n89#1,3:185\n*E\n"})
public final class DecompressorKt {
    /*
     * WARNING - void declaration
     */
    private static final Path getEntryFile(Path outputDir, Decompressor.Entry entry) throws DecompressorException {
        boolean bl;
        String normalizedEntryName;
        block5: {
            void $this$filterTo$iv$iv;
            String independentEntryName = FileUtilKt.toSystemIndependentName(entry.getName());
            String[] stringArray = new String[]{"/"};
            Iterable $this$filter$iv = StringsKt.split$default((CharSequence)independentEntryName, stringArray, false, 0, 6, null);
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                String it = (String)element$iv$iv;
                boolean bl2 = false;
                boolean bl3 = ((CharSequence)it).length() > 0;
                if (!bl3) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List pathElements = (List)destination$iv$iv;
            normalizedEntryName = DecompressorKt.normalizePathTraversal(entry, pathElements);
            Iterable $this$any$iv = pathElements;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl4 = false;
                    if (!(it.length() > 255)) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
        }
        if (bl) {
            throw EntryNameTooLongException.Companion.ofEntry(entry.getName());
        }
        Path path = outputDir.resolve(normalizedEntryName);
        Intrinsics.checkNotNullExpressionValue(path, "outputDir.resolve(normalizedEntryName)");
        return path;
    }

    private static final String normalizePathTraversal(Decompressor.Entry entry, List<String> pathElements) throws DecompressorException {
        List normalized = new ArrayList();
        for (String element : pathElements) {
            String string = element;
            if (Intrinsics.areEqual(string, ".")) continue;
            if (Intrinsics.areEqual(string, "..")) {
                if (normalized.isEmpty()) {
                    throw InvalidRelativeEntryNameException.Companion.ofEntry(entry.getName());
                }
                normalized.remove(CollectionsKt.getLastIndex(normalized));
                continue;
            }
            ((Collection)normalized).add(element);
        }
        if (normalized.isEmpty()) {
            throw EmptyEntryNameException.Companion.ofEntry(entry.getName());
        }
        return CollectionsKt.joinToString$default(normalized, "/", null, null, 0, null, null, 62, null);
    }

    public static final /* synthetic */ Path access$getEntryFile(Path outputDir, Decompressor.Entry entry) {
        return DecompressorKt.getEntryFile(outputDir, entry);
    }
}

