/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.pluginverifier.usages.properties;

import com.jetbrains.plugin.structure.classes.resolvers.ResolutionResult;
import com.jetbrains.plugin.structure.classes.resolvers.Resolver;
import com.jetbrains.plugin.structure.classes.utils.PropertyBundleUtilsKt;
import com.jetbrains.pluginverifier.results.location.Location;
import com.jetbrains.pluginverifier.results.problems.MissingPropertyReferenceProblem;
import com.jetbrains.pluginverifier.usages.properties.DeprecatedPropertyUsageWarning;
import com.jetbrains.pluginverifier.usages.properties.PropertyChecker;
import com.jetbrains.pluginverifier.verifiers.VerificationContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.PropertyResourceBundle;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lcom/jetbrains/pluginverifier/usages/properties/DefaultPropertyChecker;", "Lcom/jetbrains/pluginverifier/usages/properties/PropertyChecker;", "()V", "checkProperty", "", "resourceBundleName", "", "propertyKey", "context", "Lcom/jetbrains/pluginverifier/verifiers/VerificationContext;", "usageLocation", "Lcom/jetbrains/pluginverifier/results/location/Location;", "verifier-intellij"})
@SourceDebugExtension(value={"SMAP\nPropertyChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PropertyChecker.kt\ncom/jetbrains/pluginverifier/usages/properties/DefaultPropertyChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,67:1\n766#2:68\n857#2,2:69\n*S KotlinDebug\n*F\n+ 1 PropertyChecker.kt\ncom/jetbrains/pluginverifier/usages/properties/DefaultPropertyChecker\n*L\n45#1:68\n45#1:69,2\n*E\n"})
public final class DefaultPropertyChecker
implements PropertyChecker {
    @NotNull
    public static final DefaultPropertyChecker INSTANCE = new DefaultPropertyChecker();

    private DefaultPropertyChecker() {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void checkProperty(@NotNull String resourceBundleName, @NotNull String propertyKey, @NotNull VerificationContext context, @NotNull Location usageLocation) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Intrinsics.checkNotNullParameter(resourceBundleName, "resourceBundleName");
        Intrinsics.checkNotNullParameter(propertyKey, "propertyKey");
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(usageLocation, "usageLocation");
        if (!Intrinsics.areEqual(resourceBundleName, PropertyBundleUtilsKt.getBundleBaseName(resourceBundleName))) {
            return;
        }
        Resolver resolver = context.getClassResolver();
        Locale locale = Locale.ROOT;
        Intrinsics.checkNotNullExpressionValue(locale, "ROOT");
        ResolutionResult<PropertyResourceBundle> resolutionResult = resolver.resolveExactPropertyResourceBundle(resourceBundleName, locale);
        if (!(resolutionResult instanceof ResolutionResult.Found)) {
            return;
        }
        PropertyResourceBundle resourceBundle = (PropertyResourceBundle)((ResolutionResult.Found)resolutionResult).getValue();
        if (resourceBundle.containsKey(propertyKey)) {
            return;
        }
        Iterable iterable = context.getClassResolver().getAllBundleNameSet().getBaseBundleNames();
        boolean $i$f$filter = false;
        void var10_10 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            if (!StringsKt.endsWith$default(it, "DeprecatedMessagesBundle", false, 2, null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List deprecatedBundleNames = (List)destination$iv$iv;
        for (String deprecatedBundleName : deprecatedBundleNames) {
            PropertyResourceBundle deprecatedBundle;
            Resolver resolver2 = context.getClassResolver();
            Locale locale2 = Locale.ROOT;
            Intrinsics.checkNotNullExpressionValue(locale2, "ROOT");
            ResolutionResult<PropertyResourceBundle> resolution = resolver2.resolveExactPropertyResourceBundle(deprecatedBundleName, locale2);
            if (!(resolution instanceof ResolutionResult.Found) || !(deprecatedBundle = (PropertyResourceBundle)((ResolutionResult.Found)resolution).getValue()).containsKey(propertyKey)) continue;
            context.getWarningRegistrar().registerCompatibilityWarning(new DeprecatedPropertyUsageWarning(propertyKey, resourceBundleName, deprecatedBundleName, usageLocation));
            return;
        }
        context.getProblemRegistrar().registerProblem(new MissingPropertyReferenceProblem(propertyKey, resourceBundleName, usageLocation));
    }
}

