/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.intellij.plugin;

import com.jetbrains.plugin.structure.base.problems.UnableToReadDescriptor;
import com.jetbrains.plugin.structure.intellij.beans.PluginBean;
import com.jetbrains.plugin.structure.intellij.extractor.PluginBeanExtractor;
import com.jetbrains.plugin.structure.intellij.plugin.PluginDescriptorParserKt;
import com.jetbrains.plugin.structure.intellij.plugin.ValidationContext;
import com.jetbrains.plugin.structure.intellij.problems.XIncludeResolutionErrors;
import com.jetbrains.plugin.structure.intellij.resources.ResourceResolver;
import com.jetbrains.plugin.structure.intellij.xinclude.XIncluder;
import com.jetbrains.plugin.structure.intellij.xinclude.XIncluderException;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jdom2.Document;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u0001\u0015B\u0005\u00a2\u0006\u0002\u0010\u0002J>\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J(\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002JB\u0010\u0013\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/plugin/structure/intellij/plugin/PluginDescriptorParser;", "", "()V", "parse", "Lcom/jetbrains/plugin/structure/intellij/plugin/PluginDescriptorParser$ParseResult;", "descriptorPath", "", "pluginFileName", "originalDocument", "Lorg/jdom2/Document;", "documentPath", "Ljava/nio/file/Path;", "documentName", "pathResolver", "Lcom/jetbrains/plugin/structure/intellij/resources/ResourceResolver;", "validationContext", "Lcom/jetbrains/plugin/structure/intellij/plugin/ValidationContext;", "readDocumentIntoXmlBean", "document", "resolveXIncludesOfDocument", "presentablePath", "ParseResult", "structure-intellij"})
public final class PluginDescriptorParser {
    @NotNull
    public final ParseResult parse(@NotNull String descriptorPath, @NotNull String pluginFileName, @NotNull Document originalDocument, @NotNull Path documentPath, @NotNull String documentName, @NotNull ResourceResolver pathResolver, @NotNull ValidationContext validationContext) {
        Intrinsics.checkNotNullParameter(descriptorPath, "descriptorPath");
        Intrinsics.checkNotNullParameter(pluginFileName, "pluginFileName");
        Intrinsics.checkNotNullParameter(originalDocument, "originalDocument");
        Intrinsics.checkNotNullParameter(documentPath, "documentPath");
        Intrinsics.checkNotNullParameter(documentName, "documentName");
        Intrinsics.checkNotNullParameter(pathResolver, "pathResolver");
        Intrinsics.checkNotNullParameter(validationContext, "validationContext");
        Document document = this.resolveXIncludesOfDocument(descriptorPath, pluginFileName, originalDocument, documentName, pathResolver, documentPath, validationContext);
        if (document == null) {
            return ParseResult.InvalidXml.INSTANCE;
        }
        Document document2 = document;
        return this.readDocumentIntoXmlBean(descriptorPath, pluginFileName, document2, validationContext);
    }

    private final ParseResult readDocumentIntoXmlBean(String descriptorPath, String pluginFileName, Document document, ValidationContext validationContext) {
        ParseResult parseResult;
        try {
            PluginBean bean = PluginBeanExtractor.INSTANCE.extractPluginBean(document);
            parseResult = new ParseResult.Parsed(document, bean);
        }
        catch (Exception e) {
            validationContext.plusAssign(new UnableToReadDescriptor(descriptorPath, e.getLocalizedMessage()));
            PluginDescriptorParserKt.access$getLOG$p().info("Unable to read plugin descriptor " + descriptorPath + " of " + pluginFileName, e);
            parseResult = new ParseResult.InvalidBean(document);
        }
        return parseResult;
    }

    private final Document resolveXIncludesOfDocument(String descriptorPath, String pluginFileName, Document document, String presentablePath, ResourceResolver pathResolver, Path documentPath, ValidationContext validationContext) {
        Document document2;
        try {
            document2 = XIncluder.Companion.resolveXIncludes(document, presentablePath, pathResolver, documentPath);
        }
        catch (XIncluderException e) {
            PluginDescriptorParserKt.access$getLOG$p().info("Unable to resolve <xi:include> elements of descriptor '" + descriptorPath + "' from '" + pluginFileName + "'", e);
            validationContext.plusAssign(new XIncludeResolutionErrors(descriptorPath, e.getMessage()));
            document2 = null;
        }
        return document2;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0003\u0003\u0004\u0005B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u0082\u0001\u0003\u0006\u0007\b\u00a8\u0006\t"}, d2={"Lcom/jetbrains/plugin/structure/intellij/plugin/PluginDescriptorParser$ParseResult;", "", "()V", "InvalidBean", "InvalidXml", "Parsed", "Lcom/jetbrains/plugin/structure/intellij/plugin/PluginDescriptorParser$ParseResult$InvalidBean;", "Lcom/jetbrains/plugin/structure/intellij/plugin/PluginDescriptorParser$ParseResult$InvalidXml;", "Lcom/jetbrains/plugin/structure/intellij/plugin/PluginDescriptorParser$ParseResult$Parsed;", "structure-intellij"})
    public static abstract class ParseResult {
        private ParseResult() {
        }

        public /* synthetic */ ParseResult(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/plugin/structure/intellij/plugin/PluginDescriptorParser$ParseResult$InvalidBean;", "Lcom/jetbrains/plugin/structure/intellij/plugin/PluginDescriptorParser$ParseResult;", "document", "Lorg/jdom2/Document;", "(Lorg/jdom2/Document;)V", "getDocument", "()Lorg/jdom2/Document;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "structure-intellij"})
        public static final class InvalidBean
        extends ParseResult {
            @NotNull
            private final Document document;

            public InvalidBean(@NotNull Document document) {
                Intrinsics.checkNotNullParameter(document, "document");
                super(null);
                this.document = document;
            }

            @NotNull
            public final Document getDocument() {
                return this.document;
            }

            @NotNull
            public final Document component1() {
                return this.document;
            }

            @NotNull
            public final InvalidBean copy(@NotNull Document document) {
                Intrinsics.checkNotNullParameter(document, "document");
                return new InvalidBean(document);
            }

            public static /* synthetic */ InvalidBean copy$default(InvalidBean invalidBean, Document document, int n, Object object) {
                if ((n & 1) != 0) {
                    document = invalidBean.document;
                }
                return invalidBean.copy(document);
            }

            @NotNull
            public String toString() {
                return "InvalidBean(document=" + this.document + ")";
            }

            public int hashCode() {
                return this.document.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof InvalidBean)) {
                    return false;
                }
                InvalidBean invalidBean = (InvalidBean)other;
                return Intrinsics.areEqual(this.document, invalidBean.document);
            }
        }

        @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/jetbrains/plugin/structure/intellij/plugin/PluginDescriptorParser$ParseResult$InvalidXml;", "Lcom/jetbrains/plugin/structure/intellij/plugin/PluginDescriptorParser$ParseResult;", "()V", "structure-intellij"})
        public static final class InvalidXml
        extends ParseResult {
            @NotNull
            public static final InvalidXml INSTANCE = new InvalidXml();

            private InvalidXml() {
                super(null);
            }
        }

        @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/plugin/structure/intellij/plugin/PluginDescriptorParser$ParseResult$Parsed;", "Lcom/jetbrains/plugin/structure/intellij/plugin/PluginDescriptorParser$ParseResult;", "document", "Lorg/jdom2/Document;", "bean", "Lcom/jetbrains/plugin/structure/intellij/beans/PluginBean;", "(Lorg/jdom2/Document;Lcom/jetbrains/plugin/structure/intellij/beans/PluginBean;)V", "getBean", "()Lcom/jetbrains/plugin/structure/intellij/beans/PluginBean;", "getDocument", "()Lorg/jdom2/Document;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "structure-intellij"})
        public static final class Parsed
        extends ParseResult {
            @NotNull
            private final Document document;
            @NotNull
            private final PluginBean bean;

            public Parsed(@NotNull Document document, @NotNull PluginBean bean) {
                Intrinsics.checkNotNullParameter(document, "document");
                Intrinsics.checkNotNullParameter(bean, "bean");
                super(null);
                this.document = document;
                this.bean = bean;
            }

            @NotNull
            public final Document getDocument() {
                return this.document;
            }

            @NotNull
            public final PluginBean getBean() {
                return this.bean;
            }

            @NotNull
            public final Document component1() {
                return this.document;
            }

            @NotNull
            public final PluginBean component2() {
                return this.bean;
            }

            @NotNull
            public final Parsed copy(@NotNull Document document, @NotNull PluginBean bean) {
                Intrinsics.checkNotNullParameter(document, "document");
                Intrinsics.checkNotNullParameter(bean, "bean");
                return new Parsed(document, bean);
            }

            public static /* synthetic */ Parsed copy$default(Parsed parsed, Document document, PluginBean pluginBean, int n, Object object) {
                if ((n & 1) != 0) {
                    document = parsed.document;
                }
                if ((n & 2) != 0) {
                    pluginBean = parsed.bean;
                }
                return parsed.copy(document, pluginBean);
            }

            @NotNull
            public String toString() {
                return "Parsed(document=" + this.document + ", bean=" + this.bean + ")";
            }

            public int hashCode() {
                int result2 = this.document.hashCode();
                result2 = result2 * 31 + this.bean.hashCode();
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Parsed)) {
                    return false;
                }
                Parsed parsed = (Parsed)other;
                if (!Intrinsics.areEqual(this.document, parsed.document)) {
                    return false;
                }
                return Intrinsics.areEqual(this.bean, parsed.bean);
            }
        }
    }
}

