/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.intellij.resources;

import com.jetbrains.plugin.structure.base.utils.Deletable;
import com.jetbrains.plugin.structure.base.utils.FileUtilKt;
import com.jetbrains.plugin.structure.intellij.plugin.IdePlugin;
import com.jetbrains.plugin.structure.intellij.plugin.dependencies.DependenciesKt;
import java.io.Closeable;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000  2\u00020\u00012\u00020\u0002:\u0001 B)\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\n\u0010\u0006\u001a\u00060\u0007j\u0002`\b\u0012\u0006\u0010\t\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\nJ\b\u0010\u0011\u001a\u00020\u0012H\u0016J\t\u0010\u0013\u001a\u00020\u0004H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0004H\u00c6\u0003J\r\u0010\u0015\u001a\u00060\u0007j\u0002`\bH\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0007H\u00c6\u0003J5\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u00042\f\b\u0002\u0010\u0006\u001a\u00060\u0007j\u0002`\b2\b\b\u0002\u0010\t\u001a\u00020\u0007H\u00c6\u0001J\b\u0010\u0018\u001a\u00020\u0012H\u0016J\u0013\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u00d6\u0003J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001J\t\u0010\u001f\u001a\u00020\u0007H\u00d6\u0001R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0015\u0010\u0006\u001a\u00060\u0007j\u0002`\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\t\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000f\u00a8\u0006!"}, d2={"Lcom/jetbrains/plugin/structure/intellij/resources/PluginArchiveResource;", "Ljava/io/Closeable;", "Lcom/jetbrains/plugin/structure/base/utils/Deletable;", "artifactPath", "Ljava/nio/file/Path;", "extractedPath", "id", "", "Lcom/jetbrains/plugin/structure/intellij/plugin/dependencies/PluginId;", "version", "(Ljava/nio/file/Path;Ljava/nio/file/Path;Ljava/lang/String;Ljava/lang/String;)V", "getArtifactPath", "()Ljava/nio/file/Path;", "getExtractedPath", "getId", "()Ljava/lang/String;", "getVersion", "close", "", "component1", "component2", "component3", "component4", "copy", "delete", "equals", "", "other", "", "hashCode", "", "toString", "Companion", "structure-intellij"})
public final class PluginArchiveResource
implements Closeable,
Deletable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Path artifactPath;
    @NotNull
    private final Path extractedPath;
    @NotNull
    private final String id;
    @NotNull
    private final String version;

    public PluginArchiveResource(@NotNull Path artifactPath, @NotNull Path extractedPath, @NotNull String id, @NotNull String version) {
        Intrinsics.checkNotNullParameter(artifactPath, "artifactPath");
        Intrinsics.checkNotNullParameter(extractedPath, "extractedPath");
        Intrinsics.checkNotNullParameter(id, "id");
        Intrinsics.checkNotNullParameter(version, "version");
        this.artifactPath = artifactPath;
        this.extractedPath = extractedPath;
        this.id = id;
        this.version = version;
    }

    @NotNull
    public final Path getArtifactPath() {
        return this.artifactPath;
    }

    @NotNull
    public final Path getExtractedPath() {
        return this.extractedPath;
    }

    @NotNull
    public final String getId() {
        return this.id;
    }

    @NotNull
    public final String getVersion() {
        return this.version;
    }

    @Override
    public void close() {
    }

    @Override
    public void delete() {
        Path path = this.extractedPath.getParent();
        Intrinsics.checkNotNullExpressionValue(path, "extractedPath.parent");
        FileUtilKt.deleteLogged(path);
    }

    @NotNull
    public final Path component1() {
        return this.artifactPath;
    }

    @NotNull
    public final Path component2() {
        return this.extractedPath;
    }

    @NotNull
    public final String component3() {
        return this.id;
    }

    @NotNull
    public final String component4() {
        return this.version;
    }

    @NotNull
    public final PluginArchiveResource copy(@NotNull Path artifactPath, @NotNull Path extractedPath, @NotNull String id, @NotNull String version) {
        Intrinsics.checkNotNullParameter(artifactPath, "artifactPath");
        Intrinsics.checkNotNullParameter(extractedPath, "extractedPath");
        Intrinsics.checkNotNullParameter(id, "id");
        Intrinsics.checkNotNullParameter(version, "version");
        return new PluginArchiveResource(artifactPath, extractedPath, id, version);
    }

    public static /* synthetic */ PluginArchiveResource copy$default(PluginArchiveResource pluginArchiveResource, Path path, Path path2, String string, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            path = pluginArchiveResource.artifactPath;
        }
        if ((n & 2) != 0) {
            path2 = pluginArchiveResource.extractedPath;
        }
        if ((n & 4) != 0) {
            string = pluginArchiveResource.id;
        }
        if ((n & 8) != 0) {
            string2 = pluginArchiveResource.version;
        }
        return pluginArchiveResource.copy(path, path2, string, string2);
    }

    @NotNull
    public String toString() {
        return "PluginArchiveResource(artifactPath=" + this.artifactPath + ", extractedPath=" + this.extractedPath + ", id=" + this.id + ", version=" + this.version + ")";
    }

    public int hashCode() {
        int result2 = ((Object)this.artifactPath).hashCode();
        result2 = result2 * 31 + ((Object)this.extractedPath).hashCode();
        result2 = result2 * 31 + this.id.hashCode();
        result2 = result2 * 31 + this.version.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof PluginArchiveResource)) {
            return false;
        }
        PluginArchiveResource pluginArchiveResource = (PluginArchiveResource)other;
        if (!Intrinsics.areEqual(this.artifactPath, pluginArchiveResource.artifactPath)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.extractedPath, pluginArchiveResource.extractedPath)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.id, pluginArchiveResource.id)) {
            return false;
        }
        return Intrinsics.areEqual(this.version, pluginArchiveResource.version);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u0005J\u001a\u0010\u000e\u001a\u00020\u000f*\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u0005R\u0018\u0010\u0003\u001a\u00020\u0004*\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/plugin/structure/intellij/resources/PluginArchiveResource$Companion;", "", "()V", "version", "", "Lcom/jetbrains/plugin/structure/intellij/plugin/IdePlugin;", "getVersion", "(Lcom/jetbrains/plugin/structure/intellij/plugin/IdePlugin;)Ljava/lang/String;", "of", "Lcom/jetbrains/plugin/structure/intellij/resources/PluginArchiveResource;", "pluginArtifactPath", "Ljava/nio/file/Path;", "extractedPluginPath", "plugin", "matches", "", "structure-intellij"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final PluginArchiveResource of(@NotNull Path pluginArtifactPath, @NotNull Path extractedPluginPath, @NotNull IdePlugin plugin) {
            Intrinsics.checkNotNullParameter(pluginArtifactPath, "pluginArtifactPath");
            Intrinsics.checkNotNullParameter(extractedPluginPath, "extractedPluginPath");
            Intrinsics.checkNotNullParameter(plugin, "plugin");
            return new PluginArchiveResource(pluginArtifactPath, extractedPluginPath, DependenciesKt.getId(plugin), this.getVersion(plugin));
        }

        public final boolean matches(@NotNull PluginArchiveResource $this$matches, @NotNull Path pluginArtifactPath, @NotNull IdePlugin plugin) {
            Intrinsics.checkNotNullParameter($this$matches, "<this>");
            Intrinsics.checkNotNullParameter(pluginArtifactPath, "pluginArtifactPath");
            Intrinsics.checkNotNullParameter(plugin, "plugin");
            return Intrinsics.areEqual($this$matches.getArtifactPath(), pluginArtifactPath) && Intrinsics.areEqual($this$matches.getId(), DependenciesKt.getId(plugin)) && Intrinsics.areEqual($this$matches.getVersion(), this.getVersion(plugin));
        }

        private final String getVersion(IdePlugin $this$version) {
            String string = $this$version.getPluginVersion();
            if (string == null) {
                string = "0";
            }
            return string;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

