/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.intellij.plugin;

import com.jetbrains.plugin.structure.intellij.plugin.PluginArchiveManager;
import com.jetbrains.plugin.structure.intellij.resources.DefaultResourceResolver;
import com.jetbrains.plugin.structure.intellij.resources.ResourceResolver;
import com.jetbrains.plugin.structure.jar.JarFileSystemProvider;
import com.jetbrains.plugin.structure.jar.SingletonCachingJarFileSystemProvider;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001:\u0001\u000fB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/plugin/structure/intellij/plugin/IdePluginManagerConfiguration;", "", "pluginArchiveManager", "Lcom/jetbrains/plugin/structure/intellij/plugin/PluginArchiveManager;", "resourceResolver", "Lcom/jetbrains/plugin/structure/intellij/resources/ResourceResolver;", "fileSystemProvider", "Lcom/jetbrains/plugin/structure/jar/JarFileSystemProvider;", "(Lcom/jetbrains/plugin/structure/intellij/plugin/PluginArchiveManager;Lcom/jetbrains/plugin/structure/intellij/resources/ResourceResolver;Lcom/jetbrains/plugin/structure/jar/JarFileSystemProvider;)V", "getFileSystemProvider", "()Lcom/jetbrains/plugin/structure/jar/JarFileSystemProvider;", "getPluginArchiveManager", "()Lcom/jetbrains/plugin/structure/intellij/plugin/PluginArchiveManager;", "getResourceResolver", "()Lcom/jetbrains/plugin/structure/intellij/resources/ResourceResolver;", "Builder", "structure-intellij"})
public final class IdePluginManagerConfiguration {
    @NotNull
    private final PluginArchiveManager pluginArchiveManager;
    @NotNull
    private final ResourceResolver resourceResolver;
    @NotNull
    private final JarFileSystemProvider fileSystemProvider;

    public IdePluginManagerConfiguration(@NotNull PluginArchiveManager pluginArchiveManager, @NotNull ResourceResolver resourceResolver, @NotNull JarFileSystemProvider fileSystemProvider) {
        Intrinsics.checkNotNullParameter(pluginArchiveManager, "pluginArchiveManager");
        Intrinsics.checkNotNullParameter(resourceResolver, "resourceResolver");
        Intrinsics.checkNotNullParameter(fileSystemProvider, "fileSystemProvider");
        this.pluginArchiveManager = pluginArchiveManager;
        this.resourceResolver = resourceResolver;
        this.fileSystemProvider = fileSystemProvider;
    }

    @NotNull
    public final PluginArchiveManager getPluginArchiveManager() {
        return this.pluginArchiveManager;
    }

    @NotNull
    public final ResourceResolver getResourceResolver() {
        return this.resourceResolver;
    }

    @NotNull
    public final JarFileSystemProvider getFileSystemProvider() {
        return this.fileSystemProvider;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u001b\u001a\u00020\u001cR\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001c\u0010\t\u001a\u0004\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001c\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001c\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001a\u00a8\u0006\u001d"}, d2={"Lcom/jetbrains/plugin/structure/intellij/plugin/IdePluginManagerConfiguration$Builder;", "", "()V", "extractDirectory", "Ljava/nio/file/Path;", "getExtractDirectory", "()Ljava/nio/file/Path;", "setExtractDirectory", "(Ljava/nio/file/Path;)V", "fileSystemProvider", "Lcom/jetbrains/plugin/structure/jar/JarFileSystemProvider;", "getFileSystemProvider", "()Lcom/jetbrains/plugin/structure/jar/JarFileSystemProvider;", "setFileSystemProvider", "(Lcom/jetbrains/plugin/structure/jar/JarFileSystemProvider;)V", "pluginArchiveManager", "Lcom/jetbrains/plugin/structure/intellij/plugin/PluginArchiveManager;", "getPluginArchiveManager", "()Lcom/jetbrains/plugin/structure/intellij/plugin/PluginArchiveManager;", "setPluginArchiveManager", "(Lcom/jetbrains/plugin/structure/intellij/plugin/PluginArchiveManager;)V", "resourceResolver", "Lcom/jetbrains/plugin/structure/intellij/resources/ResourceResolver;", "getResourceResolver", "()Lcom/jetbrains/plugin/structure/intellij/resources/ResourceResolver;", "setResourceResolver", "(Lcom/jetbrains/plugin/structure/intellij/resources/ResourceResolver;)V", "build", "Lcom/jetbrains/plugin/structure/intellij/plugin/IdePluginManagerConfiguration;", "structure-intellij"})
    public static final class Builder {
        @Nullable
        private PluginArchiveManager pluginArchiveManager;
        @Nullable
        private Path extractDirectory;
        @Nullable
        private ResourceResolver resourceResolver;
        @Nullable
        private JarFileSystemProvider fileSystemProvider;

        @Nullable
        public final PluginArchiveManager getPluginArchiveManager() {
            return this.pluginArchiveManager;
        }

        public final void setPluginArchiveManager(@Nullable PluginArchiveManager pluginArchiveManager) {
            this.pluginArchiveManager = pluginArchiveManager;
        }

        @Nullable
        public final Path getExtractDirectory() {
            return this.extractDirectory;
        }

        public final void setExtractDirectory(@Nullable Path path) {
            this.extractDirectory = path;
        }

        @Nullable
        public final ResourceResolver getResourceResolver() {
            return this.resourceResolver;
        }

        public final void setResourceResolver(@Nullable ResourceResolver resourceResolver) {
            this.resourceResolver = resourceResolver;
        }

        @Nullable
        public final JarFileSystemProvider getFileSystemProvider() {
            return this.fileSystemProvider;
        }

        public final void setFileSystemProvider(@Nullable JarFileSystemProvider jarFileSystemProvider) {
            this.fileSystemProvider = jarFileSystemProvider;
        }

        @NotNull
        public final IdePluginManagerConfiguration build() {
            JarFileSystemProvider jarFileSystemProvider;
            ResourceResolver resourceResolver;
            ResourceResolver resourceResolver2;
            PluginArchiveManager pluginArchiveManager;
            if (this.extractDirectory == null && this.pluginArchiveManager == null) {
                throw new IllegalArgumentException("Either a plugin archive manager or an extract directory must be specified");
            }
            PluginArchiveManager pluginArchiveManager2 = this.pluginArchiveManager;
            if (pluginArchiveManager2 == null) {
                Path path = this.extractDirectory;
                Intrinsics.checkNotNull(path);
                pluginArchiveManager2 = pluginArchiveManager = new PluginArchiveManager(path, false, 2, null);
            }
            if ((resourceResolver2 = this.resourceResolver) == null) {
                resourceResolver2 = resourceResolver = (ResourceResolver)DefaultResourceResolver.INSTANCE;
            }
            if ((jarFileSystemProvider = this.fileSystemProvider) == null) {
                jarFileSystemProvider = SingletonCachingJarFileSystemProvider.INSTANCE;
            }
            JarFileSystemProvider fileSystemProvider = jarFileSystemProvider;
            return new IdePluginManagerConfiguration(pluginArchiveManager, resourceResolver, fileSystemProvider);
        }
    }
}

