/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.intellij.classes.plugin;

import com.jetbrains.plugin.structure.base.utils.FileUtilKt;
import com.jetbrains.plugin.structure.base.utils.LanguageUtilsKt;
import com.jetbrains.plugin.structure.classes.resolvers.Resolver;
import com.jetbrains.plugin.structure.intellij.classes.locator.ClassesDirectoryKey;
import com.jetbrains.plugin.structure.intellij.classes.locator.JarPluginKey;
import com.jetbrains.plugin.structure.intellij.classes.locator.LibDirectoryKey;
import com.jetbrains.plugin.structure.intellij.classes.locator.LibModulesDirectoryKey;
import com.jetbrains.plugin.structure.intellij.classes.locator.LocationKey;
import com.jetbrains.plugin.structure.intellij.classes.plugin.ClassSearchContext;
import com.jetbrains.plugin.structure.intellij.classes.plugin.IdePluginClassesFinder;
import com.jetbrains.plugin.structure.intellij.classes.plugin.IdePluginClassesLocations;
import com.jetbrains.plugin.structure.intellij.plugin.IdePlugin;
import com.jetbrains.plugin.structure.intellij.plugin.PluginArchiveManager;
import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B-\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\"\u0010\u0010\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u00070\u00112\u0006\u0010\u0013\u001a\u00020\u000fH\u0002J\b\u0010\u0014\u001a\u00020\rH\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/plugin/structure/intellij/classes/plugin/IdePluginClassesFinder;", "", "idePlugin", "Lcom/jetbrains/plugin/structure/intellij/plugin/IdePlugin;", "readMode", "Lcom/jetbrains/plugin/structure/classes/resolvers/Resolver$ReadMode;", "locatorKeys", "", "Lcom/jetbrains/plugin/structure/intellij/classes/locator/LocationKey;", "archiveManager", "Lcom/jetbrains/plugin/structure/intellij/plugin/PluginArchiveManager;", "(Lcom/jetbrains/plugin/structure/intellij/plugin/IdePlugin;Lcom/jetbrains/plugin/structure/classes/resolvers/Resolver$ReadMode;Ljava/util/List;Lcom/jetbrains/plugin/structure/intellij/plugin/PluginArchiveManager;)V", "findInZip", "Lcom/jetbrains/plugin/structure/intellij/classes/plugin/IdePluginClassesLocations;", "pluginZip", "Ljava/nio/file/Path;", "findLocations", "", "Lcom/jetbrains/plugin/structure/classes/resolvers/Resolver;", "pluginFile", "findPluginClasses", "Companion", "structure-intellij-classes"})
@SourceDebugExtension(value={"SMAP\nIdePluginClassesFinder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IdePluginClassesFinder.kt\ncom/jetbrains/plugin/structure/intellij/classes/plugin/IdePluginClassesFinder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,134:1\n1855#2,2:135\n*E\n*S KotlinDebug\n*F\n+ 1 IdePluginClassesFinder.kt\ncom/jetbrains/plugin/structure/intellij/classes/plugin/IdePluginClassesFinder\n*L\n81#1,2:135\n*E\n"})
public final class IdePluginClassesFinder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final IdePlugin idePlugin;
    @NotNull
    private final Resolver.ReadMode readMode;
    @NotNull
    private final List<LocationKey> locatorKeys;
    @NotNull
    private final PluginArchiveManager archiveManager;
    @NotNull
    private static final List<LocationKey> MAIN_CLASSES_KEYS;

    private IdePluginClassesFinder(IdePlugin idePlugin, Resolver.ReadMode readMode, List<? extends LocationKey> locatorKeys, PluginArchiveManager archiveManager) {
        this.idePlugin = idePlugin;
        this.readMode = readMode;
        this.locatorKeys = locatorKeys;
        this.archiveManager = archiveManager;
    }

    private final IdePluginClassesLocations findPluginClasses() {
        IdePluginClassesLocations idePluginClassesLocations;
        Path pluginFile = this.idePlugin.getOriginalFile();
        if (pluginFile == null) {
            return new IdePluginClassesLocations(this.idePlugin, findPluginClasses.1.INSTANCE, MapsKt.emptyMap());
        }
        if (!FileUtilKt.exists(pluginFile)) {
            throw new IllegalArgumentException("Plugin file doesn't exist " + pluginFile);
        }
        if (!(FileUtilKt.isDirectory(pluginFile) || FileUtilKt.isJar(pluginFile) || FileUtilKt.isZip(pluginFile))) {
            throw new IllegalArgumentException("Incorrect plugin file type " + pluginFile + ": expected a directory, a .zip or a .jar archive");
        }
        if (FileUtilKt.isZip(pluginFile)) {
            idePluginClassesLocations = this.findInZip(pluginFile);
        } else {
            Map<LocationKey, List<Resolver>> locations = this.findLocations(pluginFile);
            idePluginClassesLocations = new IdePluginClassesLocations(this.idePlugin, findPluginClasses.2.INSTANCE, locations);
        }
        return idePluginClassesLocations;
    }

    private final IdePluginClassesLocations findInZip(Path pluginZip) throws IOException {
        PluginArchiveManager.Result archive = this.archiveManager.extractArchive(pluginZip);
        if (!(archive instanceof PluginArchiveManager.Result.Extracted)) {
            if (archive instanceof PluginArchiveManager.Result.Failed) {
                throw new IOException(((PluginArchiveManager.Result.Failed)archive).getProblem().getMessage());
            }
            throw new NoWhenBranchMatchedException();
        }
        return new IdePluginClassesLocations(this.idePlugin, findInZip.1.INSTANCE, this.findLocations(((PluginArchiveManager.Result.Extracted)archive).getExtractedPath()));
    }

    private final Map<LocationKey, List<Resolver>> findLocations(Path pluginFile) {
        HashMap locations = new HashMap();
        try {
            for (LocationKey locatorKey : this.locatorKeys) {
                LanguageUtilsKt.checkIfInterrupted();
                List<Resolver> resolvers = locatorKey.getLocator(this.readMode).findClasses(this.idePlugin, pluginFile);
                ((Map)locations).put(locatorKey, resolvers);
            }
        }
        catch (Throwable e) {
            for (List resolvers : locations.values()) {
                Intrinsics.checkNotNullExpressionValue(resolvers, "resolvers");
                Iterable $this$forEach$iv = resolvers;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Resolver it = (Resolver)element$iv;
                    boolean bl = false;
                    LanguageUtilsKt.closeLogged((Closeable)it);
                }
            }
            throw e;
        }
        return locations;
    }

    public /* synthetic */ IdePluginClassesFinder(IdePlugin idePlugin, Resolver.ReadMode readMode, List locatorKeys, PluginArchiveManager archiveManager, DefaultConstructorMarker $constructor_marker) {
        this(idePlugin, readMode, locatorKeys, archiveManager);
    }

    static {
        LocationKey[] locationKeyArray = new LocationKey[]{JarPluginKey.INSTANCE, ClassesDirectoryKey.INSTANCE, LibDirectoryKey.INSTANCE, LibModulesDirectoryKey.INSTANCE};
        MAIN_CLASSES_KEYS = CollectionsKt.listOf(locationKeyArray);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J.\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J,\u0010\u0011\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u000f\u001a\u00020\u0010J\u001e\u0010\u0011\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u000e\b\u0002\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004J&\u0010\u0011\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u000e\b\u0002\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u000f\u001a\u00020\u0010J$\u0010\u0013\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u000f\u001a\u00020\u0010R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/plugin/structure/intellij/classes/plugin/IdePluginClassesFinder$Companion;", "", "()V", "MAIN_CLASSES_KEYS", "", "Lcom/jetbrains/plugin/structure/intellij/classes/locator/LocationKey;", "getMAIN_CLASSES_KEYS", "()Ljava/util/List;", "find", "Lcom/jetbrains/plugin/structure/intellij/classes/plugin/IdePluginClassesLocations;", "idePlugin", "Lcom/jetbrains/plugin/structure/intellij/plugin/IdePlugin;", "explicitLocations", "readMode", "Lcom/jetbrains/plugin/structure/classes/resolvers/Resolver$ReadMode;", "searchContext", "Lcom/jetbrains/plugin/structure/intellij/classes/plugin/ClassSearchContext;", "findPluginClasses", "additionalKeys", "fullyFindPluginClassesInExplicitLocations", "locations", "structure-intellij-classes"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<LocationKey> getMAIN_CLASSES_KEYS() {
            return MAIN_CLASSES_KEYS;
        }

        @NotNull
        public final IdePluginClassesLocations findPluginClasses(@NotNull IdePlugin idePlugin, @NotNull List<? extends LocationKey> additionalKeys) {
            Intrinsics.checkNotNullParameter(idePlugin, "idePlugin");
            Intrinsics.checkNotNullParameter(additionalKeys, "additionalKeys");
            return this.find(idePlugin, CollectionsKt.plus((Collection)this.getMAIN_CLASSES_KEYS(), (Iterable)additionalKeys), Resolver.ReadMode.FULL, ClassSearchContext.Companion.getDEFAULT());
        }

        public static /* synthetic */ IdePluginClassesLocations findPluginClasses$default(Companion companion, IdePlugin idePlugin, List list, int n, Object object) {
            if ((n & 2) != 0) {
                list = CollectionsKt.emptyList();
            }
            return companion.findPluginClasses(idePlugin, list);
        }

        @NotNull
        public final IdePluginClassesLocations findPluginClasses(@NotNull IdePlugin idePlugin, @NotNull List<? extends LocationKey> additionalKeys, @NotNull ClassSearchContext searchContext) {
            Intrinsics.checkNotNullParameter(idePlugin, "idePlugin");
            Intrinsics.checkNotNullParameter(additionalKeys, "additionalKeys");
            Intrinsics.checkNotNullParameter(searchContext, "searchContext");
            return this.find(idePlugin, CollectionsKt.plus((Collection)this.getMAIN_CLASSES_KEYS(), (Iterable)additionalKeys), Resolver.ReadMode.FULL, searchContext);
        }

        public static /* synthetic */ IdePluginClassesLocations findPluginClasses$default(Companion companion, IdePlugin idePlugin, List list, ClassSearchContext classSearchContext, int n, Object object) {
            if ((n & 2) != 0) {
                list = CollectionsKt.emptyList();
            }
            return companion.findPluginClasses(idePlugin, list, classSearchContext);
        }

        @NotNull
        public final IdePluginClassesLocations findPluginClasses(@NotNull IdePlugin idePlugin, @NotNull Resolver.ReadMode readMode, @NotNull List<? extends LocationKey> additionalKeys, @NotNull ClassSearchContext searchContext) {
            Intrinsics.checkNotNullParameter(idePlugin, "idePlugin");
            Intrinsics.checkNotNullParameter((Object)readMode, "readMode");
            Intrinsics.checkNotNullParameter(additionalKeys, "additionalKeys");
            Intrinsics.checkNotNullParameter(searchContext, "searchContext");
            return this.find(idePlugin, CollectionsKt.plus((Collection)this.getMAIN_CLASSES_KEYS(), (Iterable)additionalKeys), readMode, searchContext);
        }

        @NotNull
        public final IdePluginClassesLocations fullyFindPluginClassesInExplicitLocations(@NotNull IdePlugin idePlugin, @NotNull List<? extends LocationKey> locations, @NotNull ClassSearchContext searchContext) {
            Intrinsics.checkNotNullParameter(idePlugin, "idePlugin");
            Intrinsics.checkNotNullParameter(locations, "locations");
            Intrinsics.checkNotNullParameter(searchContext, "searchContext");
            return this.find(idePlugin, locations, Resolver.ReadMode.FULL, searchContext);
        }

        private final IdePluginClassesLocations find(IdePlugin idePlugin, List<? extends LocationKey> explicitLocations, Resolver.ReadMode readMode, ClassSearchContext searchContext) {
            return new IdePluginClassesFinder(idePlugin, readMode, explicitLocations, searchContext.getArchiveManager(), null).findPluginClasses();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

