/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.ide;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VersionComparatorUtil {
    private static final Pattern WORDS_SPLITTER = Pattern.compile("\\d+|[^\\d]+");
    private static final VersionTokenType[] VALUES = VersionTokenType.values();
    public static final Comparator<String> COMPARATOR = VersionComparatorUtil::compare;

    private VersionComparatorUtil() {
    }

    public static String max(String v1, String v2) {
        return VersionComparatorUtil.compare(v1, v2) > 0 ? v1 : v2;
    }

    public static String min(String v1, String v2) {
        return VersionComparatorUtil.compare(v1, v2) < 0 ? v1 : v2;
    }

    private static List<String> splitVersionString(String ver) {
        StringTokenizer st = new StringTokenizer(ver.trim(), "()._-;:/, +~");
        ArrayList<String> result2 = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            Matcher matcher = WORDS_SPLITTER.matcher(st.nextToken());
            while (matcher.find()) {
                result2.add(matcher.group());
            }
        }
        return result2;
    }

    public static int compare(@Nullable String ver1, @Nullable String ver2) {
        if (ver1 == null) {
            return ver2 == null ? 0 : -1;
        }
        if (ver2 == null) {
            return 1;
        }
        ver1 = ver1.toLowerCase();
        ver2 = ver2.toLowerCase();
        List<String> s1 = VersionComparatorUtil.splitVersionString(ver1);
        List<String> s2 = VersionComparatorUtil.splitVersionString(ver2);
        VersionComparatorUtil.padWithNulls(s1, s2);
        int res = 0;
        for (int i = 0; i < s1.size(); ++i) {
            VersionTokenType t2;
            String e1 = s1.get(i);
            String e2 = s2.get(i);
            VersionTokenType t1 = VersionTokenType.lookup(e1);
            if (!t1.equals((Object)(t2 = VersionTokenType.lookup(e2)))) {
                res = VersionComparatorUtil.comparePriorities(t1, t2);
            } else if (t1 == VersionTokenType._WORD) {
                res = e1.compareTo(e2);
            } else if (t1 == VersionTokenType._DIGITS) {
                res = VersionComparatorUtil.compareNumbers(e1, e2);
            }
            if (res == 0) continue;
            return res;
        }
        return 0;
    }

    private static int comparePriorities(VersionTokenType t1, VersionTokenType t2) {
        return Integer.signum(t1.getPriority() - t2.getPriority());
    }

    private static int compareNumbers(String n1, String n2) {
        int n2len;
        while (!((String)n1).isEmpty() && !((String)n2).isEmpty() && ((String)n1).charAt(0) == '0' && ((String)n2).charAt(0) == '0') {
            n1 = ((String)n1).substring(1);
            n2 = ((String)n2).substring(1);
        }
        if (!((String)n1).isEmpty() && ((String)n1).charAt(0) == '0') {
            return -1;
        }
        if (!((String)n2).isEmpty() && ((String)n2).charAt(0) == '0') {
            return 1;
        }
        int n1len = ((String)n1).length();
        if (n1len > (n2len = ((String)n2).length())) {
            n2 = VersionComparatorUtil.repeatSymbol('0', n1len - n2len) + (String)n2;
        } else if (n2len > n1len) {
            n1 = VersionComparatorUtil.repeatSymbol('0', n2len - n1len) + (String)n1;
        }
        return ((String)n1).compareTo((String)n2);
    }

    @NotNull
    private static String repeatSymbol(char aChar, int count) {
        char[] buffer = new char[count];
        Arrays.fill(buffer, aChar);
        return new String(buffer);
    }

    private static void padWithNulls(Collection<String> s1, Collection<String> s2) {
        if (s1.size() != s2.size()) {
            while (s1.size() < s2.size()) {
                s1.add(null);
            }
            while (s1.size() > s2.size()) {
                s2.add(null);
            }
        }
    }

    public static enum VersionTokenType {
        SNAP(10),
        SNAPSHOT(10),
        M(20),
        EAP(25),
        PRE(25),
        PREVIEW(25),
        ALPHA(30),
        A(30),
        BETA(40),
        BETTA(40),
        B(40),
        RC(50),
        _WS(60),
        SP(70),
        REL(80),
        RELEASE(80),
        R(80),
        FINAL(80),
        _WORD(90),
        _DIGITS(100),
        BUNDLED(666);

        private final int myPriority;

        private VersionTokenType(int priority) {
            this.myPriority = priority;
        }

        @NotNull
        public static VersionTokenType lookup(String str) {
            if (str == null) {
                return _WS;
            }
            if ((str = str.trim()).isEmpty()) {
                return _WS;
            }
            for (VersionTokenType token : VALUES) {
                String name = token.name();
                if (name.charAt(0) == '_' || !name.equalsIgnoreCase(str)) continue;
                return token;
            }
            if (str.matches("0+")) {
                return _WS;
            }
            if (str.matches("\\d+")) {
                return _DIGITS;
            }
            return _WORD;
        }

        public int getPriority() {
            return this.myPriority;
        }
    }
}

