/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugin.structure.ide;

import com.jetbrains.plugin.structure.base.utils.FileUtilKt;
import com.jetbrains.plugin.structure.ide.AbstractIdeManager;
import com.jetbrains.plugin.structure.ide.Ide;
import com.jetbrains.plugin.structure.ide.IdeImpl;
import com.jetbrains.plugin.structure.ide.IntelliJPlatformProduct;
import com.jetbrains.plugin.structure.ide.InvalidIdeException;
import com.jetbrains.plugin.structure.intellij.plugin.IdePlugin;
import com.jetbrains.plugin.structure.intellij.resources.JarsResourceResolver;
import com.jetbrains.plugin.structure.intellij.resources.ResourceResolver;
import com.jetbrains.plugin.structure.intellij.version.IdeVersion;
import com.jetbrains.plugin.structure.jar.JarFileSystemProvider;
import com.jetbrains.plugin.structure.jar.SingletonCachingJarFileSystemProvider;
import java.io.Closeable;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 \u00192\u00020\u0001:\u0002\u0019\u001aB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u001a\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016J*\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\nH\u0002J&\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\f0\u00122\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\nH\u0002J&\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\f0\u00122\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\nH\u0002J\u0010\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bH\u0002J<\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\f0\u00122\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\b0\u00122\u0006\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\nH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/jetbrains/plugin/structure/ide/IdeManagerImpl;", "Lcom/jetbrains/plugin/structure/ide/AbstractIdeManager;", "()V", "jarFileSystemProvider", "Lcom/jetbrains/plugin/structure/jar/SingletonCachingJarFileSystemProvider;", "createIde", "Lcom/jetbrains/plugin/structure/ide/Ide;", "idePath", "Ljava/nio/file/Path;", "version", "Lcom/jetbrains/plugin/structure/intellij/version/IdeVersion;", "readBundledPlugin", "Lcom/jetbrains/plugin/structure/intellij/plugin/IdePlugin;", "pluginFile", "pathResolver", "Lcom/jetbrains/plugin/structure/intellij/resources/ResourceResolver;", "ideVersion", "readBundledPlugins", "", "product", "Lcom/jetbrains/plugin/structure/ide/IntelliJPlatformProduct;", "platformResourceResolver", "readIdeVersion", "readPlatformPlugins", "jarFiles", "Companion", "PlatformResourceResolver", "structure-ide"})
@SourceDebugExtension(value={"SMAP\nIdeManagerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IdeManagerImpl.kt\ncom/jetbrains/plugin/structure/ide/IdeManagerImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,188:1\n1#2:189\n1#2:206\n2624#3,3:190\n766#3:193\n857#3,2:194\n1603#3,9:196\n1855#3:205\n1856#3:207\n1612#3:208\n*E\n*S KotlinDebug\n*F\n+ 1 IdeManagerImpl.kt\ncom/jetbrains/plugin/structure/ide/IdeManagerImpl\n*L\n160#1:206\n144#1,3:190\n159#1:193\n159#1,2:194\n160#1,9:196\n160#1:205\n160#1:207\n160#1:208\n*E\n"})
public final class IdeManagerImpl
extends AbstractIdeManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SingletonCachingJarFileSystemProvider jarFileSystemProvider = SingletonCachingJarFileSystemProvider.INSTANCE;
    private static final Logger LOG = LoggerFactory.getLogger(IdeManagerImpl.class);
    @NotNull
    public static final String PLATFORM_PLUGIN_XML = "PlatformLangPlugin.xml";

    @Override
    @NotNull
    public Ide createIde(@NotNull Path idePath) {
        Intrinsics.checkNotNullParameter(idePath, "idePath");
        return this.createIde(idePath, null);
    }

    @Override
    @NotNull
    public Ide createIde(@NotNull Path idePath, @Nullable IdeVersion version) {
        IdeVersion readIdeVersion2;
        IdeVersion ideVersion;
        IntelliJPlatformProduct intelliJPlatformProduct;
        Intrinsics.checkNotNullParameter(idePath, "idePath");
        if (!FileUtilKt.isDirectory(idePath)) {
            throw new IOException("Specified path does not exist or is not a directory: " + idePath);
        }
        if (!Companion.isDistributionIde(idePath)) {
            throw new InvalidIdeException(idePath, "IDE directory content is invalid");
        }
        IdeVersion ideVersion2 = version;
        if (ideVersion2 == null) {
            ideVersion2 = this.readIdeVersion(idePath);
        }
        if ((intelliJPlatformProduct = IntelliJPlatformProduct.Companion.fromIdeVersion(ideVersion = this.resolveProductSpecificVersion(idePath, readIdeVersion2 = ideVersion2))) == null) {
            intelliJPlatformProduct = IntelliJPlatformProduct.IDEA;
        }
        IntelliJPlatformProduct product = intelliJPlatformProduct;
        List<IdePlugin> bundledPlugins = this.readBundledPlugins(idePath, product, ideVersion);
        return new IdeImpl(idePath, ideVersion, bundledPlugins);
    }

    private final List<IdePlugin> readBundledPlugins(Path idePath, IntelliJPlatformProduct product, IdeVersion ideVersion) {
        PlatformResourceResolver platformResourceResolver = PlatformResourceResolver.Companion.of(idePath, this.jarFileSystemProvider);
        List<IdePlugin> bundledPlugins = this.readBundledPlugins(idePath, platformResourceResolver, ideVersion);
        List<IdePlugin> platformPlugins = this.readPlatformPlugins(idePath, product, platformResourceResolver.getPlatformJarFiles(), platformResourceResolver, ideVersion);
        return CollectionsKt.plus((Collection)bundledPlugins, (Iterable)platformPlugins);
    }

    private final IdeVersion readIdeVersion(Path idePath) {
        Object v0;
        List<Path> locations;
        block2: {
            Path[] pathArray = new Path[]{idePath.resolve("build.txt"), idePath.resolve("Resources").resolve("build.txt"), idePath.resolve("community").resolve("build.txt"), idePath.resolve("ultimate").resolve("community").resolve("build.txt")};
            locations = CollectionsKt.listOf(pathArray);
            Iterable iterable = locations;
            for (Object t2 : iterable) {
                Path it = (Path)t2;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue(it, "it");
                if (!FileUtilKt.exists(it)) continue;
                v0 = t2;
                break block2;
            }
            v0 = null;
        }
        Path path = v0;
        if (path == null) {
            throw new InvalidIdeException(idePath, "Build number is not found in the following files relative to " + idePath + ": " + CollectionsKt.joinToString$default(locations, null, null, null, 0, null, new Function1<Path, CharSequence>(idePath){
                final /* synthetic */ Path $idePath;
                {
                    this.$idePath = $idePath;
                    super(1);
                }

                @NotNull
                public final CharSequence invoke(Path it) {
                    return "'" + this.$idePath.relativize(it) + "'";
                }
            }, 31, null));
        }
        Path buildTxtFile2 = path;
        return this.readBuildNumber(buildTxtFile2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final List<IdePlugin> readPlatformPlugins(Path idePath, IntelliJPlatformProduct product, List<? extends Path> jarFiles, ResourceResolver platformResourceResolver, IdeVersion ideVersion) {
        boolean bl;
        List<String> descriptorPaths;
        ArrayList platformPlugins;
        block13: {
            platformPlugins = new ArrayList();
            String[] stringArray = new String[]{"plugin.xml", product.getPlatformPrefix() + "Plugin.xml", PLATFORM_PLUGIN_XML};
            descriptorPaths = CollectionsKt.listOf(stringArray);
            for (Path path : jarFiles) {
                Closeable closeable = FileSystems.newFileSystem(path, IdeManagerImpl.class.getClassLoader());
                Throwable throwable = null;
                try {
                    Object v1;
                    Object jarFs;
                    block11: {
                        jarFs = (FileSystem)closeable;
                        boolean bl2 = false;
                        Iterable iterable = descriptorPaths;
                        for (Object t2 : iterable) {
                            String it = (String)t2;
                            boolean bl3 = false;
                            Path path2 = ((FileSystem)jarFs).getPath("META-INF", new String[0]).resolve(it);
                            Intrinsics.checkNotNullExpressionValue(path2, "jarFs.getPath(IdePluginM\u2026ger.META_INF).resolve(it)");
                            if (!FileUtilKt.exists(path2)) continue;
                            v1 = t2;
                            break block11;
                        }
                        v1 = null;
                    }
                    jarFs = v1;
                }
                catch (Throwable jarFs) {
                    throwable = jarFs;
                    throw jarFs;
                }
                finally {
                    CloseableKt.closeFinally(closeable, throwable);
                }
                Object descriptorPath = jarFs;
                if (descriptorPath == null) continue;
                ((Collection)platformPlugins).add(this.createBundledPluginExceptionally(idePath, path, platformResourceResolver, (String)descriptorPath, ideVersion));
            }
            Iterable $this$none$iv = platformPlugins;
            boolean bl2 = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    IdePlugin it = (IdePlugin)element$iv;
                    boolean bl4 = false;
                    if (!Intrinsics.areEqual(it.getPluginId(), "com.intellij")) continue;
                    bl = false;
                    break block13;
                }
                bl = true;
            }
        }
        if (bl) {
            throw new InvalidIdeException(idePath, "Platform plugins are not found. They must be declared in one of " + CollectionsKt.joinToString$default(descriptorPaths, null, null, null, 0, null, null, 63, null));
        }
        return platformPlugins;
    }

    /*
     * WARNING - void declaration
     */
    private final List<IdePlugin> readBundledPlugins(Path idePath, ResourceResolver platformResourceResolver, IdeVersion ideVersion) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Path path = idePath.resolve("plugins");
        Intrinsics.checkNotNullExpressionValue(path, "idePath\n      .resolve(\"plugins\")");
        Iterable iterable = FileUtilKt.listFiles(path);
        boolean $i$f$filter = false;
        void var6_6 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Path it = (Path)element$iv$iv;
            boolean bl = false;
            if (!FileUtilKt.isDirectory(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$filterTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            IdePlugin it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            Path it = (Path)element$iv$iv;
            boolean bl2 = false;
            if (this.readBundledPlugin(idePath, it, platformResourceResolver, ideVersion) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final IdePlugin readBundledPlugin(Path idePath, Path pluginFile, ResourceResolver pathResolver, IdeVersion ideVersion) {
        IdePlugin idePlugin;
        try {
            idePlugin = this.createBundledPluginExceptionally(idePath, pluginFile, pathResolver, "plugin.xml", ideVersion);
        }
        catch (InvalidIdeException e) {
            LOG.warn("Failed to read bundled plugin '" + idePath.relativize(pluginFile) + "': " + e.getReason());
            idePlugin = null;
        }
        return idePlugin;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bR\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/jetbrains/plugin/structure/ide/IdeManagerImpl$Companion;", "", "()V", "LOG", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "PLATFORM_PLUGIN_XML", "", "isDistributionIde", "", "ideaDir", "Ljava/nio/file/Path;", "structure-ide"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final boolean isDistributionIde(@NotNull Path ideaDir) {
            Intrinsics.checkNotNullParameter(ideaDir, "ideaDir");
            Path path = ideaDir.resolve("lib");
            Intrinsics.checkNotNullExpressionValue(path, "ideaDir.resolve(\"lib\")");
            if (!FileUtilKt.isDirectory(path)) return false;
            Path path2 = ideaDir.resolve(".idea");
            Intrinsics.checkNotNullExpressionValue(path2, "ideaDir.resolve(\".idea\")");
            if (FileUtilKt.isDirectory(path2)) return false;
            return true;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B)\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0004H\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/plugin/structure/ide/IdeManagerImpl$PlatformResourceResolver;", "Lcom/jetbrains/plugin/structure/intellij/resources/ResourceResolver;", "platformJarFiles", "", "Ljava/nio/file/Path;", "platformModuleJarFiles", "jarFileSystemProvider", "Lcom/jetbrains/plugin/structure/jar/JarFileSystemProvider;", "(Ljava/util/List;Ljava/util/List;Lcom/jetbrains/plugin/structure/jar/JarFileSystemProvider;)V", "jarFilesResourceResolver", "Lcom/jetbrains/plugin/structure/intellij/resources/JarsResourceResolver;", "getPlatformJarFiles", "()Ljava/util/List;", "resolveResource", "Lcom/jetbrains/plugin/structure/intellij/resources/ResourceResolver$Result;", "relativePath", "", "basePath", "Companion", "structure-ide"})
    public static final class PlatformResourceResolver
    implements ResourceResolver {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final List<Path> platformJarFiles;
        @NotNull
        private final JarsResourceResolver jarFilesResourceResolver;

        public PlatformResourceResolver(@NotNull List<? extends Path> platformJarFiles, @NotNull List<? extends Path> platformModuleJarFiles, @NotNull JarFileSystemProvider jarFileSystemProvider) {
            Intrinsics.checkNotNullParameter(platformJarFiles, "platformJarFiles");
            Intrinsics.checkNotNullParameter(platformModuleJarFiles, "platformModuleJarFiles");
            Intrinsics.checkNotNullParameter(jarFileSystemProvider, "jarFileSystemProvider");
            this.platformJarFiles = platformJarFiles;
            this.jarFilesResourceResolver = new JarsResourceResolver(CollectionsKt.plus((Collection)this.platformJarFiles, (Iterable)platformModuleJarFiles), jarFileSystemProvider);
        }

        @NotNull
        public final List<Path> getPlatformJarFiles() {
            return this.platformJarFiles;
        }

        @Override
        @NotNull
        public ResourceResolver.Result resolveResource(@NotNull String relativePath, @NotNull Path basePath) {
            Intrinsics.checkNotNullParameter(relativePath, "relativePath");
            Intrinsics.checkNotNullParameter(basePath, "basePath");
            ResourceResolver.Result resolveResult = this.jarFilesResourceResolver.resolveResource(relativePath, basePath);
            if (!(resolveResult instanceof ResourceResolver.Result.NotFound)) {
                return resolveResult;
            }
            if (basePath.startsWith("META-INF")) {
                Path metaInf = basePath;
                while (!metaInf.endsWith("META-INF")) {
                    Intrinsics.checkNotNullExpressionValue(metaInf.getParent(), "metaInf.parent");
                }
                ResourceResolver.Result metaInfResult = this.jarFilesResourceResolver.resolveResource(relativePath, metaInf);
                if (!(metaInfResult instanceof ResourceResolver.Result.NotFound)) {
                    return metaInfResult;
                }
            }
            if (!StringsKt.startsWith$default(relativePath, "/", false, 2, null)) {
                return this.jarFilesResourceResolver.resolveResource("/META-INF/" + relativePath, basePath);
            }
            return ResourceResolver.Result.NotFound.INSTANCE;
        }

        @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Lcom/jetbrains/plugin/structure/ide/IdeManagerImpl$PlatformResourceResolver$Companion;", "", "()V", "of", "Lcom/jetbrains/plugin/structure/ide/IdeManagerImpl$PlatformResourceResolver;", "idePath", "Ljava/nio/file/Path;", "jarFileSystemProvider", "Lcom/jetbrains/plugin/structure/jar/JarFileSystemProvider;", "structure-ide"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final PlatformResourceResolver of(@NotNull Path idePath, @NotNull JarFileSystemProvider jarFileSystemProvider) {
                Intrinsics.checkNotNullParameter(idePath, "idePath");
                Intrinsics.checkNotNullParameter(jarFileSystemProvider, "jarFileSystemProvider");
                Path path = idePath.resolve("lib");
                Intrinsics.checkNotNullExpressionValue(path, "idePath.resolve(\"lib\")");
                List<Path> platformJarFiles = FileUtilKt.listJars(path);
                Path path2 = idePath.resolve("lib").resolve("modules");
                Intrinsics.checkNotNullExpressionValue(path2, "idePath.resolve(\"lib\").resolve(\"modules\")");
                List<Path> platformModuleJarFiles = FileUtilKt.listJars(path2);
                return new PlatformResourceResolver(platformJarFiles, platformModuleJarFiles, jarFileSystemProvider);
            }

            public static /* synthetic */ PlatformResourceResolver of$default(Companion companion, Path path, JarFileSystemProvider jarFileSystemProvider, int n, Object object) {
                if ((n & 2) != 0) {
                    jarFileSystemProvider = SingletonCachingJarFileSystemProvider.INSTANCE;
                }
                return companion.of(path, jarFileSystemProvider);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

