/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.alg.flow;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jgrapht.Graph;
import org.jgrapht.GraphTests;
import org.jgrapht.Graphs;
import org.jgrapht.alg.flow.PushRelabelMFImpl;
import org.jgrapht.alg.interfaces.MaximumFlowAlgorithm;
import org.jgrapht.alg.interfaces.MinimumSTCutAlgorithm;
import org.jgrapht.graph.DefaultWeightedEdge;
import org.jgrapht.graph.SimpleWeightedGraph;

public class GusfieldEquivalentFlowTree<V, E>
implements MaximumFlowAlgorithm<V, E> {
    private final int n;
    private final MinimumSTCutAlgorithm<V, E> minimumSTCutAlgorithm;
    private List<V> vertexList = new ArrayList<V>();
    private Map<V, Integer> indexMap = new HashMap<V, Integer>();
    private int[] p;
    private int[] neighbors;
    private double[][] flowMatrix = null;
    private V lastInvokedSource = null;
    private V lastInvokedTarget = null;

    public GusfieldEquivalentFlowTree(Graph<V, E> network) {
        this(network, 1.0E-9);
    }

    public GusfieldEquivalentFlowTree(Graph<V, E> network, double epsilon) {
        this(network, new PushRelabelMFImpl<V, E>(network, epsilon));
    }

    public GusfieldEquivalentFlowTree(Graph<V, E> network, MinimumSTCutAlgorithm<V, E> minimumSTCutAlgorithm) {
        GraphTests.requireUndirected(network);
        this.n = network.vertexSet().size();
        if (this.n < 2) {
            throw new IllegalArgumentException("Graph must have at least 2 vertices");
        }
        this.minimumSTCutAlgorithm = minimumSTCutAlgorithm;
        this.vertexList.addAll(network.vertexSet());
        for (int i = 0; i < this.vertexList.size(); ++i) {
            this.indexMap.put((Integer)this.vertexList.get(i), i);
        }
    }

    private void calculateEquivalentFlowTree() {
        this.flowMatrix = new double[this.n][this.n];
        this.p = new int[this.n];
        this.neighbors = new int[this.n];
        for (int s2 = 1; s2 < this.n; ++s2) {
            int i;
            int t2;
            this.neighbors[s2] = t2 = this.p[s2];
            double flowValue = this.minimumSTCutAlgorithm.calculateMinCut(this.vertexList.get(s2), this.vertexList.get(t2));
            Set<V> sourcePartition = this.minimumSTCutAlgorithm.getSourcePartition();
            for (i = s2; i < this.n; ++i) {
                if (!sourcePartition.contains(this.vertexList.get(i)) || this.p[i] != t2) continue;
                this.p[i] = s2;
            }
            double d = flowValue;
            this.flowMatrix[t2][s2] = d;
            this.flowMatrix[s2][t2] = d;
            for (i = 0; i < s2; ++i) {
                if (i == t2) continue;
                double d2 = Math.min(this.flowMatrix[s2][t2], this.flowMatrix[t2][i]);
                this.flowMatrix[i][s2] = d2;
                this.flowMatrix[s2][i] = d2;
            }
        }
    }

    public SimpleWeightedGraph<V, DefaultWeightedEdge> getEquivalentFlowTree() {
        if (this.p == null) {
            this.calculateEquivalentFlowTree();
        }
        SimpleWeightedGraph<V, DefaultWeightedEdge> equivalentFlowTree = new SimpleWeightedGraph<V, DefaultWeightedEdge>(DefaultWeightedEdge.class);
        Graphs.addAllVertices(equivalentFlowTree, this.vertexList);
        for (int i = 1; i < this.n; ++i) {
            DefaultWeightedEdge e = (DefaultWeightedEdge)equivalentFlowTree.addEdge(this.vertexList.get(i), this.vertexList.get(this.neighbors[i]));
            equivalentFlowTree.setEdgeWeight(e, this.flowMatrix[i][this.neighbors[i]]);
        }
        return equivalentFlowTree;
    }

    @Override
    public MaximumFlowAlgorithm.MaximumFlow<E> getMaximumFlow(V source2, V sink2) {
        throw new UnsupportedOperationException("Flows calculated via Equivalent Flow trees only provide a maximum flow value, not the exact flow per edge/arc.");
    }

    @Override
    public double getMaximumFlowValue(V source2, V sink2) {
        assert (this.indexMap.containsKey(source2) && this.indexMap.containsKey(sink2));
        this.lastInvokedSource = source2;
        this.lastInvokedTarget = sink2;
        if (this.p == null) {
            this.calculateEquivalentFlowTree();
        }
        return this.flowMatrix[this.indexMap.get(source2)][this.indexMap.get(sink2)];
    }

    @Override
    public Map<E, Double> getFlowMap() {
        throw new UnsupportedOperationException("Flows calculated via Equivalent Flow trees only provide a maximum flow value, not the exact flow per edge/arc.");
    }

    @Override
    public V getFlowDirection(E e) {
        throw new UnsupportedOperationException("Flows calculated via Equivalent Flow trees only provide a maximum flow value, not the exact flow per edge/arc.");
    }
}

