/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.pluginverifier.plugin;

import com.jetbrains.plugin.structure.base.utils.FileUtilKt;
import com.jetbrains.pluginverifier.plugin.PluginFileProvider;
import com.jetbrains.pluginverifier.plugin.PluginFilesBank;
import com.jetbrains.pluginverifier.repository.PluginInfo;
import com.jetbrains.pluginverifier.repository.PluginRepository;
import com.jetbrains.pluginverifier.repository.cleanup.DiskSpaceSetting;
import com.jetbrains.pluginverifier.repository.cleanup.LruFileSizeSweepPolicy;
import com.jetbrains.pluginverifier.repository.downloader.DownloadProvider;
import com.jetbrains.pluginverifier.repository.downloader.DownloadStatistics;
import com.jetbrains.pluginverifier.repository.downloader.UrlDownloader;
import com.jetbrains.pluginverifier.repository.files.AvailableFile;
import com.jetbrains.pluginverifier.repository.files.FileRepository;
import com.jetbrains.pluginverifier.repository.files.FileRepositoryResult;
import com.jetbrains.pluginverifier.repository.files.IdleFileLock;
import com.jetbrains.pluginverifier.repository.repositories.marketplace.MarketplaceRepository;
import com.jetbrains.pluginverifier.repository.repositories.marketplace.UpdateInfo;
import java.io.File;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.apache.commons.io.FileUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B7\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0014\u0010\u0005\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0006\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\t\u00a2\u0006\u0002\u0010\nJ\u0012\u0010\u000f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00110\u0010J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0004H\u0016R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0005\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/pluginverifier/plugin/PluginFilesBank;", "Lcom/jetbrains/pluginverifier/plugin/PluginFileProvider;", "fileRepository", "Lcom/jetbrains/pluginverifier/repository/files/FileRepository;", "Lcom/jetbrains/pluginverifier/repository/PluginInfo;", "urlProvider", "Lkotlin/Function1;", "Ljava/net/URL;", "downloadProvider", "Lcom/jetbrains/pluginverifier/repository/downloader/DownloadProvider;", "(Lcom/jetbrains/pluginverifier/repository/files/FileRepository;Lkotlin/jvm/functions/Function1;Lcom/jetbrains/pluginverifier/repository/downloader/DownloadProvider;)V", "downloadStatistics", "Lcom/jetbrains/pluginverifier/repository/downloader/DownloadStatistics;", "getDownloadStatistics", "()Lcom/jetbrains/pluginverifier/repository/downloader/DownloadStatistics;", "getAvailablePluginFiles", "", "Lcom/jetbrains/pluginverifier/repository/files/AvailableFile;", "getPluginFile", "Lcom/jetbrains/pluginverifier/plugin/PluginFileProvider$Result;", "pluginInfo", "Companion", "verifier-repository"})
public final class PluginFilesBank
implements PluginFileProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FileRepository<PluginInfo> fileRepository;
    @NotNull
    private final Function1<PluginInfo, URL> urlProvider;
    @NotNull
    private final DownloadProvider<PluginInfo> downloadProvider;

    public PluginFilesBank(@NotNull FileRepository<PluginInfo> fileRepository, @NotNull Function1<? super PluginInfo, URL> urlProvider2, @NotNull DownloadProvider<? super PluginInfo> downloadProvider2) {
        Intrinsics.checkNotNullParameter(fileRepository, "fileRepository");
        Intrinsics.checkNotNullParameter(urlProvider2, "urlProvider");
        Intrinsics.checkNotNullParameter(downloadProvider2, "downloadProvider");
        this.fileRepository = fileRepository;
        this.urlProvider = urlProvider2;
        this.downloadProvider = downloadProvider2;
    }

    @NotNull
    public final DownloadStatistics getDownloadStatistics() {
        return this.downloadProvider.getDownloadStatistics();
    }

    @Override
    @NotNull
    public PluginFileProvider.Result getPluginFile(@NotNull PluginInfo pluginInfo) {
        PluginFileProvider.Result result2;
        Intrinsics.checkNotNullParameter(pluginInfo, "pluginInfo");
        URL uRL = this.urlProvider.invoke(pluginInfo);
        if (uRL == null) {
            return new PluginFileProvider.Result.NotFound("Cannot find plugin " + pluginInfo);
        }
        URL downloadUrl = uRL;
        if (Intrinsics.areEqual(downloadUrl.getProtocol(), "file")) {
            PluginFileProvider.Result result3;
            File file = FileUtils.toFile(downloadUrl);
            if (file.exists()) {
                Path path = file.toPath();
                Intrinsics.checkNotNullExpressionValue(path, "file.toPath()");
                result3 = new PluginFileProvider.Result.Found(new IdleFileLock(path));
            } else {
                result3 = new PluginFileProvider.Result.NotFound("Plugin file doesn't exist: " + file);
            }
            return result3;
        }
        FileRepositoryResult $this$getPluginFile_u24lambda_u240 = this.fileRepository.getFile(pluginInfo);
        boolean bl = false;
        FileRepositoryResult fileRepositoryResult = $this$getPluginFile_u24lambda_u240;
        if (fileRepositoryResult instanceof FileRepositoryResult.Found) {
            result2 = new PluginFileProvider.Result.Found(((FileRepositoryResult.Found)$this$getPluginFile_u24lambda_u240).getLockedFile());
        } else if (fileRepositoryResult instanceof FileRepositoryResult.NotFound) {
            result2 = new PluginFileProvider.Result.NotFound(((FileRepositoryResult.NotFound)$this$getPluginFile_u24lambda_u240).getReason());
        } else if (fileRepositoryResult instanceof FileRepositoryResult.Failed) {
            result2 = new PluginFileProvider.Result.Failed(((FileRepositoryResult.Failed)$this$getPluginFile_u24lambda_u240).getReason(), ((FileRepositoryResult.Failed)$this$getPluginFile_u24lambda_u240).getError());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return result2;
    }

    @NotNull
    public final List<AvailableFile<PluginInfo>> getAvailablePluginFiles() {
        return this.fileRepository.getAvailableFiles();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002J\u001e\u0010\f\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0010J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u001e\u0010\u0015\u001a\u0010\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u0017\u0018\u00010\u00162\u0006\u0010\u0018\u001a\u00020\u0006H\u0002\u00a8\u0006\u0019"}, d2={"Lcom/jetbrains/pluginverifier/plugin/PluginFilesBank$Companion;", "", "()V", "addAlreadyDownloadedPlugins", "", "pluginsDir", "Ljava/nio/file/Path;", "pluginRepository", "Lcom/jetbrains/pluginverifier/repository/repositories/marketplace/MarketplaceRepository;", "fileRepository", "Lcom/jetbrains/pluginverifier/repository/files/FileRepository;", "Lcom/jetbrains/pluginverifier/repository/PluginInfo;", "create", "Lcom/jetbrains/pluginverifier/plugin/PluginFilesBank;", "Lcom/jetbrains/pluginverifier/repository/PluginRepository;", "diskSpaceSetting", "Lcom/jetbrains/pluginverifier/repository/cleanup/DiskSpaceSetting;", "getFileNameForMarketplacePlugin", "", "pluginInfo", "Lcom/jetbrains/pluginverifier/repository/repositories/marketplace/UpdateInfo;", "getPluginIdAndUpdateIdByPath", "Lkotlin/Pair;", "", "path", "verifier-repository"})
    @SourceDebugExtension(value={"SMAP\nPluginFilesBank.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PluginFilesBank.kt\ncom/jetbrains/pluginverifier/plugin/PluginFilesBank$Companion\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,150:1\n126#2:151\n153#2,3:152\n*S KotlinDebug\n*F\n+ 1 PluginFilesBank.kt\ncom/jetbrains/pluginverifier/plugin/PluginFilesBank$Companion\n*L\n99#1:151\n99#1:152,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final PluginFilesBank create(@NotNull PluginRepository pluginRepository, @NotNull Path pluginsDir, @NotNull DiskSpaceSetting diskSpaceSetting) {
            Intrinsics.checkNotNullParameter(pluginRepository, "pluginRepository");
            Intrinsics.checkNotNullParameter(pluginsDir, "pluginsDir");
            Intrinsics.checkNotNullParameter(diskSpaceSetting, "diskSpaceSetting");
            LruFileSizeSweepPolicy sweepPolicy = new LruFileSizeSweepPolicy(diskSpaceSetting);
            Function1 urlProvider2 = create.urlProvider.1.INSTANCE;
            UrlDownloader urlDownloader2 = new UrlDownloader(urlProvider2);
            DownloadProvider downloadProvider2 = new DownloadProvider(pluginsDir, urlDownloader2, create.downloadProvider.1.INSTANCE);
            FileRepository<PluginInfo> fileRepository = new FileRepository<PluginInfo>(downloadProvider2, sweepPolicy, "downloaded-plugins", null, 8, null);
            if (pluginRepository instanceof MarketplaceRepository) {
                this.addAlreadyDownloadedPlugins(pluginsDir, (MarketplaceRepository)pluginRepository, fileRepository);
            }
            return new PluginFilesBank(fileRepository, urlProvider2, downloadProvider2);
        }

        private final String getFileNameForMarketplacePlugin(UpdateInfo pluginInfo) {
            return pluginInfo.getPluginIntId() + "_" + pluginInfo.getUpdateId();
        }

        private final Pair<Integer, Integer> getPluginIdAndUpdateIdByPath(Path path) {
            String fileName = FileUtilKt.getNameWithoutExtension(path);
            Integer n = StringsKt.toIntOrNull(StringsKt.substringBefore(fileName, "_", ""));
            if (n == null) {
                return null;
            }
            int pluginId = n;
            Integer n2 = StringsKt.toIntOrNull(StringsKt.substringAfter(fileName, "_", ""));
            if (n2 == null) {
                return null;
            }
            int updateId = n2;
            return TuplesKt.to(pluginId, updateId);
        }

        /*
         * WARNING - void declaration
         */
        private final void addAlreadyDownloadedPlugins(Path pluginsDir, MarketplaceRepository pluginRepository, FileRepository<PluginInfo> fileRepository) {
            void $this$mapTo$iv$iv;
            HashMap pathToPluginIdAndUpdateId = new HashMap();
            for (Path path : FileUtilKt.listFiles(pluginsDir)) {
                Pair<Integer, Integer> pluginIdAndUpdateId = this.getPluginIdAndUpdateIdByPath(path);
                if (pluginIdAndUpdateId != null) {
                    ((Map)pathToPluginIdAndUpdateId).put(path, pluginIdAndUpdateId);
                    continue;
                }
                FileUtilKt.deleteLogged(path);
            }
            Map map = pathToPluginIdAndUpdateId;
            MarketplaceRepository marketplaceRepository = pluginRepository;
            boolean $i$f$map = false;
            Map map2 = map;
            Collection destination$iv$iv = new ArrayList(map.size());
            boolean $i$f$mapTo = false;
            Iterator iterator2 = $this$mapTo$iv$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                void it;
                Map.Entry item$iv$iv;
                Map.Entry entry = item$iv$iv = iterator2.next();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add((Pair)it.getValue());
            }
            Map<Integer, UpdateInfo> updateIdToUpdateInfo = marketplaceRepository.getPluginInfosForManyPluginIdsAndUpdateIds((List)destination$iv$iv);
            for (Map.Entry entry : ((Map)pathToPluginIdAndUpdateId).entrySet()) {
                Path path3 = (Path)entry.getKey();
                Pair pluginIdAndUpdateId = (Pair)entry.getValue();
                UpdateInfo updateInfo2 = updateIdToUpdateInfo.get(pluginIdAndUpdateId.getSecond());
                if (updateInfo2 != null) {
                    fileRepository.add(updateInfo2, path3);
                    continue;
                }
                FileUtilKt.deleteLogged(path3);
            }
        }

        public static final /* synthetic */ String access$getFileNameForMarketplacePlugin(Companion $this, UpdateInfo pluginInfo) {
            return $this.getFileNameForMarketplacePlugin(pluginInfo);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

